var socket;

$(document).ready(function () {
  $("#btnSearch").click(function() {btnSearchClick();});
});

function btnSearchClick() {
  if(!(/^([a-z0-9]([\-a-z0-9]*[a-z0-9])?\.)*[a-z]{2,4}$/i).test($("#queryName").val())) {
    alert("Please enter valid domain name.");
    return;
  }
  
  if($("#dnsServer").val() != "" && !(/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/).test($("#dnsServer").val())) {
    alert("Please enter valid dns server ip address.");
    return;
  }
  
  if($("#queryType option:selected").val() == 0) {
    alert("Please select query type.");
    return;
  }
  
  var queryName = $("#queryName").val();
  var queryType = $("#queryType option:selected").val();
  var dnsServer = $("#dnsServer").val() == "" ? "208.67.222.222" : $("#dnsServer").val();
  $("#msg").html("");
  
  socket = navigator.mozTCPSocket.open(dnsServer, 53, {binaryType: "arraybuffer"});
  
  socket.onerror = function (event) {
    console.log("Error event: " + event.data);
  }
  
  socket.onopen = function (event) {
    sendQuery(queryName, queryType);
  }
  
  socket.onclose = function (event) {
    console.log("socket close");
  }
  
  socket.ondata = function (event) {
    viewRespond(event.data);
  }
}

function sendQuery(queryName, queryType) {
  var buffer = new ArrayBuffer(20 + queryName.length);
  var bufferView = new Uint8Array(buffer);
  var countBits = 0;
  
  // Dlzka paketu ked je to cez TCP posielane
  htons(bufferView, countBits, buffer.byteLength-2);
  countBits += 2;

  // Identification
  htons(bufferView, countBits, new Date().getMilliseconds());
  countBits += 2;
  
  // Nastavenia v poradi Rcode, CD, AD, Z, RA, RD, TC, AA, Opcode, QR
  // Vsetko nastavene na 0 okrem RD
  htons(bufferView, countBits, 0x100);
  countBits += 2;

  // Total Questions
  htons(bufferView, countBits, 1);
  countBits += 2;
  
  // Total Answer RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Total Authority RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Total Additional RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Query Name
  var nameParts = queryName.split(".");
  for (var i = 0; i < nameParts.length; i++) {
    bufferView[countBits++] = nameParts[i].length;
    for (var j = 0; j < nameParts[i].length; j++)
      bufferView[countBits++] = nameParts[i].charCodeAt(j);
  }
  bufferView[countBits++] = 0;

  // Query Type
  htons(bufferView, countBits, queryType);
  countBits += 2;
  
  // Query Class
  htons(bufferView, countBits, 1);
  
  socket.send(buffer);
}

function viewRespond(data) {
  var bufferView = new Uint8Array(data, 2); // prve 2 bajty je length - len pri TCP pakete
  var lengthView = new Uint8Array(data, 0, 2); // length
  var countBits = 0;
  
  var dnsHeaderDiv = "<div data-role=\"collapsible\" data-mini=\"true\" id=\"dnsHeader\"><h4>Full DNS Header</h4>";
  dnsHeaderDiv += "Length: " + ntohs(lengthView, 0);
    
  dnsHeaderDiv += "<br />ID: " + ntohs(bufferView, countBits);
  countBits += 2;
  
  dnsHeaderDiv += "<br />Flags:";
  var flags = ntohs(bufferView, countBits);
  countBits += 2;
  
  var QR = (((flags & 0x8000) >> 15) == 0) ? "Query" : "Response";
  dnsHeaderDiv += "<br />Message is: " + QR;
  
  var OpCode = (((flags & 0x7800) >> 11) == 0) ? "Standard query" : "Inverse query";
  dnsHeaderDiv += "<br />OpCode: " + OpCode;
  
  var AA = (((flags & 0x400) >> 10) == 0) ? "Not authoritative" : "Is authoritative";
  dnsHeaderDiv += "<br />AA flag: " + AA;
  var TC = (((flags & 0x200) >> 9) == 0) ? "Not truncated" : "Message truncated";
  dnsHeaderDiv += "<br />TC flag: " + TC;
  var RD = (((flags & 0x100) >> 8) == 0) ? "Recursion not desired" : "Recursion desired";
  dnsHeaderDiv += "<br />RD flag: " + RD;
  var RA = (((flags & 0x80) >> 7) == 0) ? "Recursive query support not available" : "Recursive query support available";
  dnsHeaderDiv += "<br />RA flag: " + RA;
  var Z = (((flags & 0x40) >> 6) == 0) ? "false" : "true";
  dnsHeaderDiv += "<br />Z flag: " + Z;
  var AD = (((flags & 0x20) >> 5) == 0) ? "false" : "true";
  dnsHeaderDiv += "<br />AD flag: " + AD;
  var CD = (((flags & 0x10) >> 4) == 0) ? "false" : "true";
  dnsHeaderDiv += "<br />CD flag: " + CD;
  var Rcode = GetRcode(flags & 0x0F);
  dnsHeaderDiv += "<br />Return code: " + Rcode;
  
  $("#msg").append(dnsHeaderDiv + "</div>").trigger("create");
  
  var TotalQuestions = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("Total Questions: " + TotalQuestions);
  
  var TotalAnswerRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Answer RRs: " + TotalAnswerRRs);
  
  var AuthorityRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Authority RRs: " + AuthorityRRs);
  
  var AdditionalRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Additional RRs: " + AdditionalRRs);
  
  $("#msg").append("<br /><br />Questions:");
  
  $("<div/>", {
    id: "questions",
    style: "padding-left:10px;"
  }).appendTo("#msg");
  
  var LabelLength;
  for (var i = 0; i < TotalQuestions; i++) {
    $("#questions").append("Query Name: ");
    
    while ((LabelLength = bufferView[countBits++]) != 0) {
      for (var j = 0; j < LabelLength; j++)
        $("#questions").append(String.fromCharCode(bufferView[countBits++]));

      $("#questions").append(".");
    }
    
    $("#questions").append("<br />Type: " + GetType(ntohs(bufferView, countBits)));
    countBits += 2;
    
    $("#questions").append("<br />Class: " + GetClass(ntohs(bufferView, countBits)));
    countBits += 2;
  }
  
  var objPar = {bufferView: bufferView, countBits: countBits, IsPointer: false}; // javascript nema predanie parametrov funkcii refenciou, treba zapuzdrit do objektu
  ReadRRs(TotalAnswerRRs, objPar, "Answer RRs", "answers");
  
  ReadRRs(AuthorityRRs, objPar, "Authority RRs", "authority");
  
  ReadRRs(AdditionalRRs, objPar, "Additional RRs", "additional");
  
  socket.close();
}

function ReadRRs(length, objPar, name, idName) {
  //objPar.bufferView;
  //objPar.countBits;
  //objPar.IsPointer;
  var type;
  var RdataLength;
  
  if (length == 0)
    return;
  
  $("#msg").append("<br />" + name + ":");
  
  $("<div/>", {
    id: idName,
    style: "padding-left:10px;"
  }).appendTo("#msg");
            
  for (var i = 0; i < length; i++) {
    $("#" + idName).append("Name: " + ReadName(objPar));
    type = GetType(ntohs(objPar.bufferView, objPar.countBits));
    objPar.countBits += 2;
    $("#" + idName).append("<br />Type: " + type);
    $("#" + idName).append("<br />Class: " + GetClass(ntohs(objPar.bufferView, objPar.countBits)));
    objPar.countBits += 2;
    $("#" + idName).append("<br />TTL: " + ntohi(objPar.bufferView, objPar.countBits));
    objPar.countBits += 4;
    RdataLength = ntohs(objPar.bufferView, objPar.countBits);
    objPar.countBits += 2;
    $("#" + idName).append("<br />Rdata Length: " + RdataLength);

    $("#" + idName).append("<br />Rdata:");
    
    $("<div/>", {
      id: "Rdata" + i + idName,
      style: "padding-left:10px;"
    }).appendTo("#" + idName);
    
    switch (type) {
      case "A, IPv4 address":
        $("#Rdata" + i + idName).append("Address: " + byteArrayToIPv4Addr(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        break;
      case "NS, Authoritative name server":
        $("#Rdata" + i + idName).append("Name server: " + ReadName(objPar));
        break;
      case "CNAME, Canonical name for an alias":
        $("#Rdata" + i + idName).append("Canonical name for an alias: " + ReadName(objPar));
        break;
      case "PTR, Domain name pointer":
        $("#Rdata" + i + idName).append("Domain name pointer: " + ReadName(objPar));
        break;
      case "HINFO, Host information":
        $("#Rdata" + i + idName).append("Host information: " + byteArrayToAscii(objPar.bufferView, objPar.countBits, RdataLength));
        objPar.countBits += RdataLength;
        break;
      case "MX, Mail exchange":
        $("#Rdata" + i + idName).append("Mail exchange name: " + ntohs(objPar.bufferView, objPar.countBits));
        objPar.countBits += 2;    
        $("#Rdata" + i + idName).append(" " + ReadName(objPar));
        break;
      case "TXT, Text strings":
        $("#Rdata" + i + idName).append("Text strings: " + byteArrayToAscii(objPar.bufferView, objPar.countBits, RdataLength));
        objPar.countBits += RdataLength;
        break;
      case "SOA, Marks the start of a zone of authority":
        $("#Rdata" + i + idName).append("Primary name server: " + ReadName(objPar));
        $("#Rdata" + i + idName).append("<br />Responsible authority's mailbox: " + ReadName(objPar));
        $("#Rdata" + i + idName).append("<br />Serial number: " + ntohi(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        $("#Rdata" + i + idName).append("<br />Refresh interval: " + ntohi(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        $("#Rdata" + i + idName).append("<br />Retry interval: " + ntohi(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        $("#Rdata" + i + idName).append("<br />Expiration limit: " + ntohi(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        $("#Rdata" + i + idName).append("<br />Minimum TTL: " + ntohi(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        break;
      case "AAAA, IPv6 Address":
        $("#Rdata" + i + idName).append("Address: " + byteArrayToIPv6Addr(objPar.bufferView, objPar.countBits));
        objPar.countBits += 16;
        break;
      default:
        $("#Rdata" + i + idName).append("Type " + type + "is not supported");
        objPar.countBits += RdataLength;
        break;
    }
    $("#" + idName).append("<br />");
  }
}

function ReadName(objPar) {
  var Name = "";
  var LastPosition;
  objPar.IsPointer = false;
  //objPar.bufferView;
  //objPar.countBits;
  
  var pointer = ntohs(objPar.bufferView, objPar.countBits);
  objPar.countBits += 2;

  if (((pointer & 0xC000) >> 14) == 3) {
    LastPosition = objPar.countBits;
    pointer = pointer & 0x3FFF;
    objPar.countBits = pointer;
    while (true) {
      objPar.IsPointer = false;
      Name += ReadLabel(objPar);
      if (objPar.IsPointer) {
        pointer = ntohs(objPar.bufferView, objPar.countBits);
        objPar.countBits += 2;
        pointer = pointer & 0x3FFF;
        objPar.countBits = pointer;
      }
      else
        break;
    }
  }
  else {
    objPar.countBits -= 2;

    Name = ReadLabel(objPar);
    if (objPar.IsPointer) {
      pointer = ntohs(objPar.bufferView, objPar.countBits);
      objPar.countBits += 2;
      LastPosition = objPar.countBits;
      pointer = pointer & 0x3FFF;
      objPar.countBits = pointer;
      while (true) {
        objPar.IsPointer = false;
        Name += ReadLabel(objPar);
        if (objPar.IsPointer) {
          pointer = ntohs(objPar.bufferView, objPar.countBits);
          objPar.countBits += 2;
          pointer = pointer & 0x3FFF;
          objPar.countBits = pointer;
        }
        else
          break;
      }
    }
    else
      LastPosition = objPar.countBits;
  }
  
  objPar.countBits = LastPosition;

  return Name;
}

function ReadLabel(objPar) {
  var LabelLength;
  var Label = "";
  //objPar.bufferView;
  //objPar.countBits;
  //objPar.IsPointer;

  while ((LabelLength = objPar.bufferView[objPar.countBits++]) != 0) {
    if (((LabelLength & 0xC0) >> 6) == 3) {
      objPar.IsPointer = true;
      objPar.countBits--;
      break;
    }

    for (var j = 0; j < LabelLength; j++)
      Label += String.fromCharCode(objPar.bufferView[objPar.countBits++]);

    Label += ".";
  }
  
  return Label;
}

function GetRcode(rcode) {
  switch (rcode) {
    case 0: return "No error";
    case 1: return "Format error";
    case 2: return "Server failure";
    case 3: return "Name Error";
    case 4: return "Not Implemented";
    case 5: return "Refused";
    case 6: return "Name Exists when it should not";
    case 7: return "RR Set Exists when it should not";
    case 8: return "RR Set that should exist does not";
    case 9: return "Server Not Authoritative for zone";
    case 10: return "Name not contained in zone";
    case 16: return "Bad OPT Version || TSIG Signature Failure";
    case 17: return "Key not recognized";
    case 18: return "Signature out of time window";
    case 19: return "Bad TKEY Mode";
    case 20: return "Duplicate key name";
    case 21: return "Algorithm not supported";
  }
  return rcode;
}

function GetType(type) {
  switch (type) {
    case 1: return "A, IPv4 address";
    case 2: return "NS, Authoritative name server";
    case 5: return "CNAME, Canonical name for an alias";
    case 6: return "SOA, Marks the start of a zone of authority";
    case 12: return "PTR, Domain name pointer";
    case 13: return "HINFO, Host information";
    case 15: return "MX, Mail exchange";
    case 16: return "TXT, Text strings";
    case 28: return "AAAA, IPv6 Address";
    case 43: return "DS, Delegation signer";
    case 46: return "RRSIG, DNSSEC signature";
    case 47: return "NSEC, Next-Secure record";
    case 48: return "DNSKEY, DNS Key record";
    case 50: return "NSEC3, Next-Secure record v.3";
    case 51: return "NSEC3PARAM, NSEC3 parameters";
    case 255: return "ANY";
  }
  return type;
}

function GetClass(Class) {
  switch (Class) {
    case 1: return "IN, Internet";
    case 3: return "CH, Chaos";
    case 4: return "HS, Hesiod";
  }
  return Class;
}

function htons(b, i, v) {
  b[i] = (0xff & (v >> 8));
  b[i + 1] = (0xff & (v));
}

function ntohs(b, i) {
  return ((0xff & b[i]) << 8) | ((0xff & b[i + 1]));
}
                    
function ntohi(b, i) {
  return ((0xff & b[i]) << 24) | ((0xff & b[i + 1]) << 16) | ((0xff & b[i + 2]) << 8) | ((0xff & b[i + 3]));
}

function byteArrayToIPv4Addr(b, i) {
  return b[i] + "." + b[i + 1] + "." + b[i + 2] + "." + b[i + 3];
}

function byteArrayToIPv6Addr(b, i) {
  var addr = "";
  var twoOctet;
  
  for(var j=i; j < i+16; j+=4) {
    twoOctet = ntohi(b, j);
    addr += (twoOctet >> 16).toString(16).toUpperCase() + ":";
    addr += (twoOctet & 0xFFFF).toString(16).toUpperCase() + (j < i+12 ? ":" : "");
  }
  
  return addr;
}

function byteArrayToAscii(b, i, l) {
  var text = "";
  
  for (var j = i; j < i+l; j++)
    text += String.fromCharCode(b[j]);
  
  return text;
}