var socket;

$(document).ready(function () {
  $("#btnSearch").click(function() {btnSearchClick();});
});

function btnSearchClick() {
  if(!(/^([a-z0-9]([\-a-z0-9]*[a-z0-9])?\.)*[a-z]{2,4}$/i).test($("#queryName").val())) {
    alert("Please enter valid domain name.");
    return;
  }
  
  if($("#queryType option:selected").val() == 0) {
    alert("Please select query type.");
    return;
  }
  
  var queryName = $("#queryName").val();
  var queryType = $("#queryType option:selected").val();
  var dnsServer = "208.67.222.222";
  $("#msg").html("");
  
  socket = navigator.mozTCPSocket.open(dnsServer, 53, {binaryType: "arraybuffer"});
  
  socket.onerror = function (event) {
    console.log("Error event: " + event.data);
  }
  
  socket.onopen = function (event) {
    sendQuery(queryName, queryType);
  }
  
  socket.onclose = function (event) {
    console.log("socket close");
  }
  
  socket.ondata = function (event) {
    viewRespond(event.data);
  }
}

function sendQuery(queryName, queryType) {
  var buffer = new ArrayBuffer(20 + queryName.length);
  var bufferView = new Uint8Array(buffer);
  var countBits = 0;
  
  // Dlzka paketu ked je to cez TCP posielane
  htons(bufferView, countBits, buffer.byteLength-2);
  countBits += 2;

  // Identification
  htons(bufferView, countBits, new Date().getMilliseconds());
  countBits += 2;
  
  // Nastavenia v poradi Rcode, CD, AD, Z, RA, RD, TC, AA, Opcode, QR
  // Vsetko nastavene na 0 okrem RD
  htons(bufferView, countBits, 0x100);
  countBits += 2;

  // Total Questions
  htons(bufferView, countBits, 1);
  countBits += 2;
  
  // Total Answer RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Total Authority RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Total Additional RRs
  htons(bufferView, countBits, 0);
  countBits += 2;
  
  // Query Name
  var nameParts = queryName.split(".");
  for (var i = 0; i < nameParts.length; i++) {
    bufferView[countBits++] = nameParts[i].length;
    for (var j = 0; j < nameParts[i].length; j++)
      bufferView[countBits++] = nameParts[i].charCodeAt(j);
  }
  bufferView[countBits++] = 0;

  // Query Type
  htons(bufferView, countBits, queryType);
  countBits += 2;
  
  // Query Class
  htons(bufferView, countBits, 1);
  
  socket.send(buffer);
}

function viewRespond(data) {
  var bufferView = new Uint8Array(data, 2); // prve 2 bajty je length - len pri TCP pakete
  var countBits = 4; // zaciname pri Total Questions
  
  var TotalQuestions = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("Total Questions: " + TotalQuestions);
  
  var TotalAnswerRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Answer RRs: " + TotalAnswerRRs);
  
  var AuthorityRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Authority RRs: " + AuthorityRRs);
  
  var AdditionalRRs = ntohs(bufferView, countBits);
  countBits += 2;
  $("#msg").append("<br />Total Additional RRs: " + AdditionalRRs);
  
  $("#msg").append("<br /><br />Questions:");
  
  $("<div/>", {
    id: "questions",
    style: "padding-left:10px;"
  }).appendTo("#msg");
  
  var LabelLength;
  for (var i = 0; i < TotalQuestions; i++) {
    $("#questions").append("Query Name: ");
    
    while ((LabelLength = bufferView[countBits++]) != 0) {
      for (var j = 0; j < LabelLength; j++)
        $("#questions").append(String.fromCharCode(bufferView[countBits++]));

      $("#questions").append(".");
    }
    
    $("#questions").append("<br />Type: " + GetType(ntohs(bufferView, countBits)));
    countBits += 2;
    
    $("#questions").append("<br />Class: " + GetClass(ntohs(bufferView, countBits)));
    countBits += 2;
  }
  
  var objPar = {bufferView: bufferView, countBits: countBits, IsPointer: false}; // javascript nema predanie parametrov funkcii refenciou, treba zapuzdrit do objektu
  ReadRRs(TotalAnswerRRs, objPar, "Answer RRs", "answers");
  
  ReadRRs(AuthorityRRs, objPar, "Authority RRs", "authority");
  
  ReadRRs(AdditionalRRs, objPar, "Additional RRs", "additional");
  
  socket.close();
}

function ReadRRs(length, objPar, name, idName) {
  //objPar.bufferView;
  //objPar.countBits;
  //objPar.IsPointer;
  var type;
  var RdataLength;
  
  if (length == 0)
    return;
  
  $("#msg").append("<br />" + name + ":");
  
  $("<div/>", {
    id: idName,
    style: "padding-left:10px;"
  }).appendTo("#msg");
            
  for (var i = 0; i < length; i++) {
    $("#" + idName).append("Name: " + ReadName(objPar));
    type = GetType(ntohs(objPar.bufferView, objPar.countBits));
    objPar.countBits += 2;
    $("#" + idName).append("<br />Type: " + type);
    $("#" + idName).append("<br />Class: " + GetClass(ntohs(objPar.bufferView, objPar.countBits)));
    objPar.countBits += 2;
    $("#" + idName).append("<br />TTL: " + ntohi(objPar.bufferView, objPar.countBits));
    objPar.countBits += 4;
    RdataLength = ntohs(objPar.bufferView, objPar.countBits);
    objPar.countBits += 2;
    $("#" + idName).append("<br />Rdata Length: " + RdataLength);

    $("#" + idName).append("<br />Rdata:");
    
    $("<div/>", {
      id: "Rdata" + i + idName,
      style: "padding-left:10px;"
    }).appendTo("#" + idName);
    
    switch (type) {
      case "A, IPv4 address":
        $("#Rdata" + i + idName).append("Address: " + byteArrayToIPv4Addr(objPar.bufferView, objPar.countBits));
        objPar.countBits += 4;
        break;
      case "AAAA, IPv6 Address":
        $("#Rdata" + i + idName).append("Address: " + byteArrayToIPv6Addr(objPar.bufferView, objPar.countBits));
        objPar.countBits += 16;
        break;
      default:
        $("#Rdata" + i + idName).append("Type " + type + "is not supported");
        objPar.countBits += RdataLength;
        break;
    }
    $("#" + idName).append("<br />");
  }
}

function ReadName(objPar) {
  var Name = "";
  var LastPosition;
  objPar.IsPointer = false;
  //objPar.bufferView;
  //objPar.countBits;
  
  var pointer = ntohs(objPar.bufferView, objPar.countBits);
  objPar.countBits += 2;

  if (((pointer & 0xC000) >> 14) == 3) {
    LastPosition = objPar.countBits;
    pointer = pointer & 0x3FFF;
    objPar.countBits = pointer;
    while (true) {
      objPar.IsPointer = false;
      Name += ReadLabel(objPar);
      if (objPar.IsPointer) {
        pointer = ntohs(objPar.bufferView, objPar.countBits);
        objPar.countBits += 2;
        pointer = pointer & 0x3FFF;
        objPar.countBits = pointer;
      }
      else
        break;
    }
  }
  else {
    objPar.countBits -= 2;

    Name = ReadLabel(objPar);
    if (objPar.IsPointer) {
      pointer = ntohs(objPar.bufferView, objPar.countBits);
      objPar.countBits += 2;
      LastPosition = objPar.countBits;
      pointer = pointer & 0x3FFF;
      objPar.countBits = pointer;
      while (true) {
        objPar.IsPointer = false;
        Name += ReadLabel(objPar);
        if (objPar.IsPointer) {
          pointer = ntohs(objPar.bufferView, objPar.countBits);
          objPar.countBits += 2;
          pointer = pointer & 0x3FFF;
          objPar.countBits = pointer;
        }
        else
          break;
      }
    }
    else
      LastPosition = objPar.countBits;
  }
  
  objPar.countBits = LastPosition;

  return Name;
}

function ReadLabel(objPar) {
  var LabelLength;
  var Label = "";
  //objPar.bufferView;
  //objPar.countBits;
  //objPar.IsPointer;

  while ((LabelLength = objPar.bufferView[objPar.countBits++]) != 0) {
    if (((LabelLength & 0xC0) >> 6) == 3) {
      objPar.IsPointer = true;
      objPar.countBits--;
      break;
    }

    for (var j = 0; j < LabelLength; j++)
      Label += String.fromCharCode(objPar.bufferView[objPar.countBits++]);

    Label += ".";
  }
  
  return Label;
}

function GetType(type) {
  switch (type) {
    case 1: return "A, IPv4 address";
    case 28: return "AAAA, IPv6 Address";
  }
  return type;
}

function GetClass(Class) {
  switch (Class) {
    case 1: return "IN, Internet";
    case 3: return "CH, Chaos";
    case 4: return "HS, Hesiod";
  }
  return Class;
}

function htons(b, i, v) {
  b[i] = (0xff & (v >> 8));
  b[i + 1] = (0xff & (v));
}

function ntohs(b, i) {
  return ((0xff & b[i]) << 8) | ((0xff & b[i + 1]));
}
                    
function ntohi(b, i) {
  return ((0xff & b[i]) << 24) | ((0xff & b[i + 1]) << 16) | ((0xff & b[i + 2]) << 8) | ((0xff & b[i + 3]));
}

function byteArrayToIPv4Addr(b, i) {
  return b[i] + "." + b[i + 1] + "." + b[i + 2] + "." + b[i + 3];
}

function byteArrayToIPv6Addr(b, i) {
  var addr = "";
  var twoOctet;
  
  for(var j=i; j < i+16; j+=4) {
    twoOctet = ntohi(b, j);
    addr += (twoOctet >> 16).toString(16).toUpperCase() + ":";
    addr += (twoOctet & 0xFFFF).toString(16).toUpperCase() + (j < i+12 ? ":" : "");
  }
  
  return addr;
}