






		(function() {
			if ('serviceWorker' in navigator) {
				navigator.serviceWorker.register('/serviceworker.cache.js').then(function(registration) {
					// Registration was successful
					console.log('ServiceWorker registration successful with scope: ', registration.scope);
				}).catch(function(err) {
					// registration failed :(
					console.log('ServiceWorker registration failed: ', err);
				});
			}
		})();


// async after window.onload to improve page speed and good score in google-page-speed
// (will instantly show splash page, before starting to load heavy scripts/css)
(function() {
	var domready = function(win, fn) {
		var done = false, top = true,

		doc = win.document,
		root = doc.documentElement,
		modern = doc.addEventListener,

		add = modern ? 'addEventListener' : 'attachEvent',
		rem = modern ? 'removeEventListener' : 'detachEvent',
		pre = modern ? '' : 'on',

		init = function(e) {
			if (e.type == 'readystatechange' && doc.readyState != 'complete') return;
			(e.type == 'load' ? win : doc)[rem](pre + e.type, init, false);
			if (!done && (done = true)) fn.call(win, e.type || e);
		},

		poll = function() {
			try { root.doScroll('left'); } catch(e) { setTimeout(poll, 50); return; }
			init('poll');
		};

		if (doc.readyState == 'complete') fn.call(win, 'lazy');
		else {
			if (!modern && root.doScroll) {
				try { top = !win.frameElement; } catch(e) { }
				if (top) poll();
			}
			doc[add](pre + 'DOMContentLoaded', init, false);
			doc[add](pre + 'readystatechange', init, false);
			win[add](pre + 'load', init, false);
		}
	};

	var raf = window.requestAnimationFrame ||
		window.mozRequestAnimationFrame ||
		window.webkitRequestAnimationFrame ||
		window.msRequestAnimationFrame ||
		window.oRequestAnimationFrame ||
		function(cb) { setTimeout(cb, 16); }

	var css = {"80":{"media":"all and (min-width: 0px) and (max-width: 359px) and (min-height: 0px), all and (min-width: 359px) and (min-height: 0px) and (max-height: 359px)","href":"style-80.css?v=1.4.8"},"90":{"media":"all and (min-width: 360px) and (max-width: 399px) and (min-height: 360px), all and (min-width: 399px) and (min-height: 360px) and (max-height: 399px)","href":"style-90.css?v=1.4.8"},"100":{"media":"all and (min-width: 400px) and (min-height: 400px)","href":"style-100.css?v=1.4.8"}};

	var hideSplash = function() {
		var splash = document.getElementById('splash');
		splash.parentNode.removeChild(splash);
	};

	var bootstrap = function() {
		var head = document.getElementsByTagName('head')[ 0 ];
		var isAndroid = (/Android/g).test(navigator.userAgent) ? true : false;

		
		var loadJs = function() {
			var el = document.createElement("script");

			

			el.src = 'bundle.js?v=1.4.8';
			head.appendChild(el);
		};

		// load css first
		var setScaleLoaded = function(data) {
			if(data.loaded) {
				return;
			}

			data.loaded = true;
			console.log('css loaded ' + data.href);

			var loaded = Object.keys(css).filter(function(key) {
				return !css[ key ].loaded;
			}).length === 0;

			if(!loaded) {
				return;
			}

			loadJs();
		};

		Object.keys(css).forEach(function(key) {
			var data = css[ key ];

			var link = document.createElement('link');
			link.rel = 'stylesheet';
			link.type = 'text/css';
			link.media = data.media;
			link.href = data.href;

			// on android 4.0 didnt work
			if (isAndroid || !("onload" in link)) {
				setTimeout(function() {
					setScaleLoaded(data)
				}, 100);
			}

			link.onload = function() {
				setScaleLoaded(data);
			};

			head.appendChild(link);
		});
	};

	
		domready(window, function() {
			raf(bootstrap);
		});
	
})();
