if (!Cache.prototype.add) {
  Cache.prototype.add = function add(request) {
    return this.addAll([request]);
  };
}

if (!Cache.prototype.addAll) {
  Cache.prototype.addAll = function addAll(requests) {
    var cache = this;

    // Since DOMExceptions are not constructable:
    function NetworkError(message) {
      this.name = 'NetworkError';
      this.code = 19;
      this.message = message;
    }
    NetworkError.prototype = Object.create(Error.prototype);

    return Promise.resolve().then(function() {
      if (arguments.length < 1) throw new TypeError();
      
      // Simulate sequence<(Request or USVString)> binding:
      var sequence = [];

      requests = requests.map(function(request) {
        if (request instanceof Request) {
          return request;
        }
        else {
          return String(request); // may throw TypeError
        }
      });

      return Promise.all(
        requests.map(function(request) {
          if (typeof request === 'string') {
            request = new Request(request);
          }

          var scheme = new URL(request.url).protocol;

          if (scheme !== 'http:' && scheme !== 'https:') {
            throw new NetworkError("Invalid scheme");
          }

          console.log('addAll', request.clone().url);

          return fetch(request.clone());
        })
      );
    }).then(function(responses) {
      // TODO: check that requests don't overwrite one another
      // (don't think this is possible to polyfill due to opaque responses)
      return Promise.all(
        responses.map(function(response, i) {
          return cache.put(requests[i], response);
        })
      );
    }).then(function() {
      return undefined;
    });
  };
}

if (!CacheStorage.prototype.match) {
  // This is probably vulnerable to race conditions (removing caches etc)
  CacheStorage.prototype.match = function match(request, opts) {
    var caches = this;

    return this.keys().then(function(cacheNames) {
      var match;

      return cacheNames.reduce(function(chain, cacheName) {
        return chain.then(function() {
          return match || caches.open(cacheName).then(function(cache) {
            return cache.match(request, opts);
          }).then(function(response) {
            match = response;
            return match;
          });
        });
      }, Promise.resolve());
    });
  };
}

console.log('serviceworker location', location.protocol+'//'+location.hostname+(location.port ? ':'+location.port: ''));

// generate new cache name, each emery startup
var cacheName = 'cache-1004008-1448553828093';
var debug = false;

var cacheNames = [
	cacheName
];

var urlsToCache = [
'index.js?v=1.4.8',
'bundle.js?v=1.4.8',
'index.html',
'index-cordova.html',
'index-winjs.html',
'index-chrome.html',
'index.js',
'webmanifest.json',
'manifest.json',
'manifest.webapp',
'chrome.background.js',
'chrome.webview.html',
'config.xml',
'apple-app-site-association',
'style-80.css?v=1.4.8',
'style-90.css?v=1.4.8',
'style-100.css?v=1.4.8',
'res/fonts/museo-sans/MuseoSans_300-webfont.eot',
'res/fonts/museo-sans/MuseoSans_300-webfont.svg',
'res/fonts/museo-sans/MuseoSans_300-webfont.ttf',
'res/fonts/museo-sans/MuseoSans_300-webfont.woff',
'res/fonts/museo-sans/MuseoSans_300-webfont.woff2',
'res/dominoes/audio/draw0.wav',
'res/dominoes/audio/draw1.wav',
'res/dominoes/audio/draw2.wav',
'res/dominoes/audio/draw3.wav',
'res/dominoes/audio/draw4.wav',
'res/dominoes/audio/move0.wav',
'res/dominoes/audio/move1.wav',
'res/dominoes/audio/move2.wav',
'res/dominoes/audio/move3.wav',
'res/dominoes/audio/sounds.action.mp3',
'res/dominoes/audio/sounds.action.ogg',
'res/dominoes/images/game/bone-yard@10x.png',
'res/dominoes/images/game/bone-yard@12x.png',
'res/dominoes/images/game/bone-yard@14x.png',
'res/dominoes/images/game/bone-yard@16x.png',
'res/dominoes/images/game/bone-yard@18x.png',
'res/dominoes/images/game/bone-yard@1x.png',
'res/dominoes/images/game/bone-yard@20x.png',
'res/dominoes/images/game/bone-yard@2x.png',
'res/dominoes/images/game/bone-yard@3x.png',
'res/dominoes/images/game/bone-yard@4x.png',
'res/dominoes/images/game/bone-yard@5x.png',
'res/dominoes/images/game/bone-yard@6x.png',
'res/dominoes/images/game/bone-yard@7x.png',
'res/dominoes/images/game/bone-yard@8x.png',
'res/dominoes/images/game/bone-yard@9x.png',
'res/dominoes/images/game/bones-sprite-bw@10x.png',
'res/dominoes/images/game/bones-sprite-bw@11x.png',
'res/dominoes/images/game/bones-sprite-bw@12x.png',
'res/dominoes/images/game/bones-sprite-bw@13x.png',
'res/dominoes/images/game/bones-sprite-bw@14x.png',
'res/dominoes/images/game/bones-sprite-bw@15x.png',
'res/dominoes/images/game/bones-sprite-bw@16x.png',
'res/dominoes/images/game/bones-sprite-bw@17x.png',
'res/dominoes/images/game/bones-sprite-bw@18x.png',
'res/dominoes/images/game/bones-sprite-bw@19x.png',
'res/dominoes/images/game/bones-sprite-bw@1x.png',
'res/dominoes/images/game/bones-sprite-bw@20x.png',
'res/dominoes/images/game/bones-sprite-bw@2x.png',
'res/dominoes/images/game/bones-sprite-bw@3x.png',
'res/dominoes/images/game/bones-sprite-bw@4x.png',
'res/dominoes/images/game/bones-sprite-bw@5x.png',
'res/dominoes/images/game/bones-sprite-bw@6x.png',
'res/dominoes/images/game/bones-sprite-bw@7x.png',
'res/dominoes/images/game/bones-sprite-bw@8x.png',
'res/dominoes/images/game/bones-sprite-bw@9x.png',
'res/dominoes/images/game/bones-sprite@10x.png',
'res/dominoes/images/game/bones-sprite@11x.png',
'res/dominoes/images/game/bones-sprite@12x.png',
'res/dominoes/images/game/bones-sprite@13x.png',
'res/dominoes/images/game/bones-sprite@14x.png',
'res/dominoes/images/game/bones-sprite@15x.png',
'res/dominoes/images/game/bones-sprite@16x.png',
'res/dominoes/images/game/bones-sprite@17x.png',
'res/dominoes/images/game/bones-sprite@18x.png',
'res/dominoes/images/game/bones-sprite@19x.png',
'res/dominoes/images/game/bones-sprite@1x.png',
'res/dominoes/images/game/bones-sprite@20x.png',
'res/dominoes/images/game/bones-sprite@2x.png',
'res/dominoes/images/game/bones-sprite@3x.png',
'res/dominoes/images/game/bones-sprite@4x.png',
'res/dominoes/images/game/bones-sprite@5x.png',
'res/dominoes/images/game/bones-sprite@6x.png',
'res/dominoes/images/game/bones-sprite@7x.png',
'res/dominoes/images/game/bones-sprite@8x.png',
'res/dominoes/images/game/bones-sprite@9x.png',
'res/dominoes/images/game/hat-basecap-128.png',
'res/dominoes/images/game/hat-basecap-256.png',
'res/dominoes/images/game/hat-chef-128.png',
'res/dominoes/images/game/hat-chef-256.png',
'res/dominoes/images/game/hat-classic-128.png',
'res/dominoes/images/game/hat-classic-256.png',
'res/dominoes/images/game/hat-king-128.png',
'res/dominoes/images/game/hat-king-256.png',
'res/dominoes/images/game/hat-magic-128.png',
'res/dominoes/images/game/hat-magic-256.png',
'res/dominoes/images/game/hat-mexican-128.png',
'res/dominoes/images/game/hat-mexican-256.png',
'res/dominoes/images/game/hat-winter-128.png',
'res/dominoes/images/game/hat-winter-256.png',
'res/dominoes/images/game/ic_back.png',
'res/dominoes/images/game/ic_back@2x.png',
'res/dominoes/images/game/ic_bone_avatar_vertical@2x.png',
'res/dominoes/images/game/ic_bone_avatar.png',
'res/dominoes/images/game/ic_bone_avatar@2x.png',
'res/dominoes/images/game/ic_chat.png',
'res/dominoes/images/game/ic_chat@2x.png',
'res/dominoes/images/game/ic_end_blocked.png',
'res/dominoes/images/game/ic_end_blocked@2x.png',
'res/dominoes/images/game/ic_end_domino.png',
'res/dominoes/images/game/ic_end_domino@2x.png',
'res/dominoes/images/game/ic_mscore@1x.png',
'res/dominoes/images/game/ic_mscore@2x.png',
'res/dominoes/images/game/ic_mscore@3x.png',
'res/dominoes/images/game/ic_mscore@4x.png',
'res/dominoes/images/game/ic_prefs.png',
'res/dominoes/images/game/ic_prefs@2x.png',
'res/dominoes/images/game/ic_star_nopad.png',
'res/dominoes/images/game/ic_star_nopad@2x.png',
'res/dominoes/images/game/ic_star_nopad@4x.png',
'res/dominoes/images/game/player-avatar-default-128.png',
'res/dominoes/images/tutorial/tutorial_board.jpg',
'res/dominoes/images/tutorial/tutorial_drawblockyard.jpg',
'res/dominoes/images/tutorial/tutorial_drawing.jpg',
'res/dominoes/images/tutorial/tutorial_hand.jpg',
'res/dominoes/images/tutorial/tutorial_mugginsscore.jpg',
'res/dominoes/images/tutorial/tutorial_mugginsspinner.jpg',
'res/dominoes/images/tutorial/tutorial_rating.jpg',
'res/dominoes/images/tutorial/tutorial_roundend.jpg',
'res/dominoes/images/tutorial/tutorial_score.jpg',
'res/index/background.jpg',
'res/h5client/avatar_server.png',
'res/h5client/avatar_server@2x.png',
'res/h5client/avatar_server@4x.png',
'res/h5client/avatar-default/large/default-0.jpg',
'res/h5client/avatar-default/large/default-1.jpg',
'res/h5client/avatar-default/large/default-10.jpg',
'res/h5client/avatar-default/large/default-11.jpg',
'res/h5client/avatar-default/large/default-12.jpg',
'res/h5client/avatar-default/large/default-13.jpg',
'res/h5client/avatar-default/large/default-14.jpg',
'res/h5client/avatar-default/large/default-15.jpg',
'res/h5client/avatar-default/large/default-16.jpg',
'res/h5client/avatar-default/large/default-17.jpg',
'res/h5client/avatar-default/large/default-18.jpg',
'res/h5client/avatar-default/large/default-19.jpg',
'res/h5client/avatar-default/large/default-2.jpg',
'res/h5client/avatar-default/large/default-20.jpg',
'res/h5client/avatar-default/large/default-3.jpg',
'res/h5client/avatar-default/large/default-4.jpg',
'res/h5client/avatar-default/large/default-5.jpg',
'res/h5client/avatar-default/large/default-6.jpg',
'res/h5client/avatar-default/large/default-7.jpg',
'res/h5client/avatar-default/large/default-8.jpg',
'res/h5client/avatar-default/large/default-9.jpg',
'res/h5client/avatar-default/medium/default-0.jpg',
'res/h5client/avatar-default/medium/default-1.jpg',
'res/h5client/avatar-default/medium/default-10.jpg',
'res/h5client/avatar-default/medium/default-11.jpg',
'res/h5client/avatar-default/medium/default-12.jpg',
'res/h5client/avatar-default/medium/default-13.jpg',
'res/h5client/avatar-default/medium/default-14.jpg',
'res/h5client/avatar-default/medium/default-15.jpg',
'res/h5client/avatar-default/medium/default-16.jpg',
'res/h5client/avatar-default/medium/default-17.jpg',
'res/h5client/avatar-default/medium/default-18.jpg',
'res/h5client/avatar-default/medium/default-19.jpg',
'res/h5client/avatar-default/medium/default-2.jpg',
'res/h5client/avatar-default/medium/default-20.jpg',
'res/h5client/avatar-default/medium/default-3.jpg',
'res/h5client/avatar-default/medium/default-4.jpg',
'res/h5client/avatar-default/medium/default-5.jpg',
'res/h5client/avatar-default/medium/default-6.jpg',
'res/h5client/avatar-default/medium/default-7.jpg',
'res/h5client/avatar-default/medium/default-8.jpg',
'res/h5client/avatar-default/medium/default-9.jpg',
'res/h5client/avatar-default/small/default-0.jpg',
'res/h5client/avatar-default/small/default-1.jpg',
'res/h5client/avatar-default/small/default-10.jpg',
'res/h5client/avatar-default/small/default-11.jpg',
'res/h5client/avatar-default/small/default-12.jpg',
'res/h5client/avatar-default/small/default-13.jpg',
'res/h5client/avatar-default/small/default-14.jpg',
'res/h5client/avatar-default/small/default-15.jpg',
'res/h5client/avatar-default/small/default-16.jpg',
'res/h5client/avatar-default/small/default-17.jpg',
'res/h5client/avatar-default/small/default-18.jpg',
'res/h5client/avatar-default/small/default-19.jpg',
'res/h5client/avatar-default/small/default-2.jpg',
'res/h5client/avatar-default/small/default-20.jpg',
'res/h5client/avatar-default/small/default-3.jpg',
'res/h5client/avatar-default/small/default-4.jpg',
'res/h5client/avatar-default/small/default-5.jpg',
'res/h5client/avatar-default/small/default-6.jpg',
'res/h5client/avatar-default/small/default-7.jpg',
'res/h5client/avatar-default/small/default-8.jpg',
'res/h5client/avatar-default/small/default-9.jpg',
'res/h5client/game-avatar/hat-classic-128.png',
'res/h5client/ic_back.png',
'res/h5client/ic_back@2x.png',
'res/h5client/ic_back@4x.png',
'res/h5client/ic_bell-128.png',
'res/h5client/ic_chat.png',
'res/h5client/ic_chat@2x.png',
'res/h5client/ic_chat@4x.png',
'res/h5client/ic_check.png',
'res/h5client/ic_check@2x.png',
'res/h5client/ic_check@4x.png',
'res/h5client/ic_circle_select.png',
'res/h5client/ic_circle_selected.png',
'res/h5client/ic_contacts_empty-128.png',
'res/h5client/ic_controller-128.png',
'res/h5client/ic_controller-64.png',
'res/h5client/ic_create.png',
'res/h5client/ic_create@2x.png',
'res/h5client/ic_create@4x.png',
'res/h5client/ic_exit-64.png',
'res/h5client/ic_forward_nopad-128.png',
'res/h5client/ic_games_empty-128.png',
'res/h5client/ic_group_nopad@2x.png',
'res/h5client/ic_group-128.png',
'res/h5client/ic_group-64.png',
'res/h5client/ic_help.png',
'res/h5client/ic_help@2x.png',
'res/h5client/ic_help@4x.png',
'res/h5client/ic_info-64.png',
'res/h5client/ic_more.png',
'res/h5client/ic_more@2x.png',
'res/h5client/ic_more@4x.png',
'res/h5client/ic_notifications.png',
'res/h5client/ic_notifications@2x.png',
'res/h5client/ic_notifications@4x.png',
'res/h5client/ic_person.png',
'res/h5client/ic_person@2x.png',
'res/h5client/ic_person@4x.png',
'res/h5client/ic_plus.png',
'res/h5client/ic_poll.png',
'res/h5client/ic_poll@2x.png',
'res/h5client/ic_poll@4x.png',
'res/h5client/ic_ranking-64.png',
'res/h5client/ic_refresh.png',
'res/h5client/ic_remove-128.png',
'res/h5client/ic_remove-64.png',
'res/h5client/ic_settings-64.png',
'res/h5client/ic_settings.png',
'res/h5client/ic_settings@2x.png',
'res/h5client/ic_settings@4x.png',
'res/h5client/ic_share-128.png',
'res/h5client/ic_star_nopad.png',
'res/h5client/ic_star_nopad@2x.png',
'res/h5client/ic_star_nopad@4x.png',
'res/h5client/ic_star.png',
'res/h5client/ic_star@2x.png',
'res/h5client/ic_star@4x.png',
'res/h5client/ic_time_nopad.png',
'res/h5client/ic_time_nopad@2x.png',
'res/h5client/ic_time_nopad@4x.png',
'res/h5client/ic_time-64.png',
'res/h5client/menu/ic_facebook-128.png',
'res/h5client/menu/ic_gplus-128.png',
'res/h5client/menu/ic_speaker_off-128.png',
'res/h5client/menu/ic_speaker_on-128.png',
'res/h5client/menu/ic_world-128.png',
'res/h5client/menu/menu_bg-1024.jpg',
'res/h5client/menu/menu_bg-1800.jpg',
'res/h5client/menu/menu_bg-512.jpg',
'res/h5client/profile/ic_add-64.png',
'res/h5client/profile/ic_remove_outline-128.png',
'res/h5client/profile/ic_remove_outline-64.png',
'res/h5client/profile/ic_remove-64.png',
'res/h5client/share-facebook.png',
'res/h5client/menu/menu-bg.jpg',
'res/h5client/menu/menu-bg@0,5x.jpg',
'res/h5client/menu/menu-bg@1,5x.jpg',
'res/icons/ic_ios_76@2x.png',
'res/icons/ic_launcher_128.png',
'res/icons/ic_launcher_128@2x.png',
'res/icons/ic_launcher_128@4x.png',
'res/icons/ic_launcher_48.png',
'res/icons/ic_launcher_48@1,5x.png',
'res/icons/ic_launcher_48@2x.png',
'res/icons/ic_launcher_48@3x.png',
'res/icons/ic_launcher_48@4x.png',
'res/icons/ic_ubuntu.png',
'res/icons/windows-159.png',
'res/icons/windows-99.png'

];

self.addEventListener('install', function(event) {
  console.log('install');

	// Perform install steps
	event.waitUntil(caches.open(cacheName)
		.then(function(cache) {
			console.log('Opened cache');
			return cache.addAll(urlsToCache);
		}));
});

self.addEventListener('fetch', function(event) {
  // do not serve from cache in debug mode
  if(debug) {
    return;
  }

  // http://stackoverflow.com/questions/28371358/any-workaround-for-chrome-m40-redirect-bug-for-service-workers
  // fetch() service is currently buggy, redirect will result in error
  // if url is not in cache, abort here (no respondWidth, so browser request sent as normal)
  var url = event.request.url;
  var tryCache = false;

  for (var i = urlsToCache.length - 1; i >= 0; i--) {
    var cacheUrl = urlsToCache[ i ];

    if(url.indexOf(cacheUrl, url.length - cacheUrl.length) !== -1) {
      tryCache = true;
      break;
    }
  }

  if(!tryCache) {
    console.log('skip cache for ' + url);
    return;
  }


  event.respondWith(caches.match(event.request).then(function(response) {
    var url = event.request.url;

    console.log('checked cache for: ' + url);
    console.log('response: ' + (response && response.status));

    if(response) {
      return response;
    } else {
      return fetch(event.request.clone()).then(function(response) {
        console.log('cache not found ' + url);
        console.log('fetch result', response);

        return response;
      });
    }
  }).catch(function(err) {
    console.error('error in cache:', err);
    throw error;
  }));


});

// A new ServiceWorker is now active
// clear up old caches
self.addEventListener("activate", function (event) {
	console.log('activate');

  event.waitUntil(caches.keys()
  	.then(function (allCaches) {
        return Promise.all(allCaches.map(function(cacheName) {
            if (cacheNames.indexOf(cacheName) === -1) {
              return caches.delete(cacheName);
            }
          })
        );
      })
  );
});