function Util() {
var en_table = { 'app_name': 'Dot By Dot',
    '1player': '1 Player',
    '2players': '2 Players',
    'ranking': 'Ranking',
    'options': 'Options',
    'player': 'Player',
    'opponent': 'Opponent',
    'back': 'Back',
    'save': 'Save',
    'clean': 'Clean',
    'restart': 'Restart',
    'ok': 'Ok',
    'close': 'Close',
    'board': 'Board',
    'name': 'Name',
    'score': 'Score',
    'warning': 'Warning!',
    'quitMessage': 'Do you want to quit the game?',
    'yes': 'Yes',
    'no': 'No',
    'playerColor': 'Player Color',
    'opponentColor': 'Opponent Color',
    'firstMove': 'First Move',
    'difficulty': 'Difficulty',
    'normal': 'Normal',
    'hard': 'Hard',
    'red': 'Red',
    'green': 'Green',
    'blue': 'Blue',   
    'cancel': 'Cancel',
    'youWin': 'You win!',
    'youLose': 'You lose!',
    'p1Win': 'Player 1 win!',
    'p2Win': 'Player 2 win!',
    'draw': 'Draw.',
    'lineUsed': 'Line already used.',
    'error': 'Error not defined, contact the developer.',
    'equalColors': 'Player color and opponent color can\'t be equal.',
    'cleanRanking': 'You are about to clean the score tables.\u003cbr\u003eDo you confirm this operation?',    
    'top5': 'You won and now you are in the TOP 5 ranking, type your name: \u003cbr\u003eScore: {1}\u003cbr\u003e(Boxes X Difficulty factor)',
    'gameOver': 'Game over, start other game.',	
    'version': 'Version 1.1.2',
    'programmers': 'Programmers',
    'logo': 'dot.png' };
    
var pt_table = { 'app_name': 'Ponto a Ponto',
    '1player': '1 Jogador',
    '2players': '2 Jogadores',
    'ranking': 'Ranking',
    'options': 'Opes',
    'player': 'Jogador',
    'opponent': 'Oponente',
    'back': 'Voltar',
    'save': 'Salvar',
    'clean': 'Limpar',
    'restart': 'Reiniciar',
    'ok': 'Ok',
    'close': 'Fechar',
    'board': 'Tabuleiro',
    'name': 'Nome',
    'score': 'Pontos',   
    'warning': 'Ateno!',    
    'quitMessage': 'Quer realmente sair do jogo?',
    'yes': 'Sim',
    'no': 'No',
    'playerColor': 'Cor do Jogador',
    'opponentColor': 'Cor do Oponente',
    'firstMove': 'Primeira Jogada',
    'difficulty': 'Dificuldade',    
    'normal': 'Normal',
    'hard': 'Difcil',
    'red': 'Vermelho',
    'green': 'Verde',
    'blue': 'Azul', 
    'cancel': 'Cancelar',
    'youWin': 'Voc ganhou!',
    'youLose': 'Voc perdeu!',
    'p1Win': 'Jogador 1 ganhou!',
    'p2Win': 'Jogador 2 ganhou!',
    'draw': 'Empate.',
    'lineUsed': 'Linha j utilizada.',
    'error': 'Erro no previsto, contate o desenvolvedor.',
    'equalColors': 'Cores do jogador e oponente no podem ser iguais.',
    'cleanRanking': 'Voc est prestes a limpar as tabelas de pontuao\u003cbr\u003eDeseja confirmar essa operao?',    
    'top5': 'Voc ganhou e est no TOP 5 de pontuao, digite seu nome: \u003cbr\u003ePontuao: {1}\u003cbr\u003e(Quadrados X Fator de dificuldade)',
    'gameOver': 'Jogo acabou, inicie outra partida.',
    'version': 'Verso 1.1.2',
    'programmers': 'Programadores',
    'logo': 'ponto.png' };
    
    var nativeUtil = window.nativeUtil;

    this.getStringFromKey = getStringFromKey;
	function getStringFromKey(key) {
		if (nativeUtil) {	
        	return nativeUtil.getStringFromKey(key) + '';
       	}
        
        var code = navigator.language.toString(); 
        var defaultLocale = true;
        
        if( code ) {
            code = code.toUpperCase();
            
            if(code === 'PT-BR') {
                defaultLocale = false;
            }
        }
        
        if(!defaultLocale) {
            return pt_table[key];
        }
        
        return en_table[key];
    }
}
