// Load the file and generate a preview


var loader = {
	
				course: new Object(),
				
				getFile: function(){            //      Default function for getting zip binaries
					 var zipfile = document.getElementById('zipload').files[0];      // Obtain the zipfile
         var zipblob = new Object();					 
					 
					try{
					   zipblob = new Blob([zipfile], {"type" : "application/zip" });  // Convert to binary for zip.js					 
			  	}  catch(e){    // Couldn't build a blob
					 
					    window.BlobBuilder = window.BlobBuilder || 
                         window.WebKitBlobBuilder || 
                         window.MozBlobBuilder || 
                         window.MSBlobBuilder;
		                         
		        if(e.name == 'TypeError' && window.BlobBuilder){     // Older browsers that require blob builder to instantiate blobs
		             var bb = new BlobBuilder();
		              bb.append([zipfile]);
		              zipblob = bb.getBlob("application/zip");
		         }
					    else{
					         x.error.report("Browser doesn't support blobs ")
					    }
					
					}
					 zipblob.name = zipfile.name;
					 loader.open(zipblob);
					},		
		
				open: function(zipblob){	
				    		    
										x.file.view();                                                    // Switch file panel to view mode
										x.file.setTitle(zipblob.name);

										var files = new Array();
										zip.createReader(new zip.BlobReader(zipblob), function(reader) {    // Open zip file with zip.js
					       				
					   
											   reader.getEntries(function(entries) {                              // Get the entries from the zip file
												  entries.forEach(function(entry){
												  files[entry.filename] = entry;
															});      
			
												  if(files['course.json']){
												  	    
												  	   var coursefile = files['course.json'];						  	   
													   	coursefile.getData(new zip.BlobWriter("text/plain"), function(data){        										// Obtain course string
													   	
	
																		   	  var freader = new FileReader();
																					  freader.readAsText(data);
																					  
																					  freader.onload = function(){					  	
																					  var text = freader.result;
					
																						var course =  JSON.parse(text);                                              // Objectify the string
							  											
													  								loader.course = course;
													  								
													  								loader.showProgress();                                                  // Show file progress
										  															
																					 var metaFields = ["author", "locales", "subjects", "pre-requisites"];               // Meta Fields to show	
																					 																				 	
                                 loader.showMeta(metaFields);																					 	
		  											
																						var size =Math.round(zipblob.size/1048576);
																																  											
										  											x.file.setInfo(g.n('file-size') + ": " + size + 'MB');
										  											
																						if(files[course.image]){						
																						     										
																									files[course.image].getData(new zip.Data64URIWriter(mime(course.image)), function(imageuri) {
																											x.file.zip.preview(course.name, course.description, imageuri);
						
																											 reader.close(function() {               // Once finished - enable the button
																																			loader.enable(zipblob);
       																											 });
																							}, function(current, total){});
																					  } else {
																					  	
																					  	x.file.zip.preview(course.name, course.description);
																					  					 reader.close(function() {               // Once finished
				                                               loader.enable(zipblob);
       																											 });
																					  	} 										  															  					
										       							   	}
										       							   	
										       							   freader.onerror = function(){
																		         x.error.report(g.n('error-file-read'));
																		         console.log('Text reader had a problem reading the file');
																 			      }	
										       							 
										       							  }, function(current, total) {});			
										       							 										       							  										
																	} else {               
																					 x.error.report(zipfile.filename + g.n('error-file-type'));            // If no course.json file found

																						}			
											 		});
													}, function(error){  
													x.error.report(g.n('error-file-read'));			
													console.log('Zip.js had a problem reading the file');
													console.log(error);						
												 });	
					},
				
				showProgress: function(){
					
			  				var progress = g.n('new');				 
  							 switch(user.progress.course.get(loader.course.id)){
												case 1:
														progress = g.n('in-progress');
														break;
												case 2:
														progress = g.n('complete')													  							 	
  													break;
  							 	}  							 	
  							 	x.file.zip.setProgress(progress);
					},		
							
				showMeta: function(metaFields){
				
				 var course = loader.course;				 
					metaFields.forEach(function(field){
																					 													 		
																					 	if (course[field]){
																					 		
																					 		if(field == 'locales'){
																							  	var fieldstring = g.n('language') + ": ";																												
																							}	 else{								
																					     	var fieldstring = g.n(field) + ": ";
																					   }
																					 	
																						if(typeof course[field] == "string"){																					 	
																					 																				
                                   	fieldstring = fieldstring + course[field];								
									 																																							 																						 	
																					 		} else{
																					 				course[field].forEach(function(fielditem, index){
																					 					
																												if(field == 'locales'){
																												
																														fielditem = g.n(fielditem);																													
																													}																					 					
																					 					
																							 			  if (index ==0){
																							 		    fieldstring = fieldstring + fielditem;	
																							 		    }
																							 		    else {
		                                       fieldstring = fieldstring + ", " + fielditem;																					 		    	
																							 		    	}
																					 			});
																					 		
																					 		}
																					 	x.file.zip.addMeta(fieldstring);
																					 	}																					 																		 	
																					 	});				  						
					},
					
				enable: function(blob){
					x.file.open.style.backgroundImage = "url('icons/green.png')";
					x.file.open.style.cursor = 'pointer';
					x.file.open.onclick = function(){loader.load(blob)};					
					},
				
				disable: function(){
        x.file.open.style.backgroundImage = "url('icons/gray.png')";
        x.file.open.style.cursor = 'default';
					x.file.open.onclick = function(){};									
					},
				
				load: function(blob){
						
							var course = loader.course;
           var toload =0;       // Files to be uploaded
           var loaded =0;					// Counter for files uploaded files
					    var missing = new Array();       // Keep track of any files missing from zip archive
           loader.disable();					   
					    
							zip.createReader(new zip.BlobReader(blob), function(reader) {    // Open zip file with zip.js
             
             var files = new Array();						
						    reader.getEntries(function(entries) {                              // Get the entries from the zip file
							   entries.forEach(function(entry){
							   files[entry.filename] = entry;	  
									});
									
									if(files[course.image]){                                          // Get each course image
																toload++;
										 						files[course.image].getData(new zip.BlobWriter(mime(course.image)), function(data) {
																							course.image = data;
																							loaded++;
																							}, function(current, total){});
										}
										else {
											  missing.push(course.image || 'Course Image');
											}										
									var L = course.lessons.length;
	            for (var l=0; l<L; l++){       // for each lesson
			            (function(l){  					       
			            
			            if(files[course.lessons[l].image]){                                    // Get lesson image
			            						toload++;
			            						files[course.lessons[l].image].getData(new zip.BlobWriter(mime(course.lessons[l].image)), function(data){					
									 	          	course.lessons[l].image = data;
									 	          	loaded++;
									 	          	});
			            	}
			            	else {
			            		missing.push(course.lessons[l].image || ('Lesson ' + l + ' image'));
			            		}			            	
			           var I = course.lessons[l].items.length;                          
                for (var i=0; i<I; i++){                                                  // Get each item in each lesson
                (function(i){
                				if (files[course.lessons[l].items[i].location]){
                							toload++;
                							files[course.lessons[l].items[i].location].getData(new zip.BlobWriter(mime(course.lessons[l].items[i].location)), function(data){					
									 	          	course.lessons[l].items[i].file = data;
									 	          	loaded++;
									 	          	x.file.setInfo(g.n('loading') + ": " + loaded  + '/ ' + toload + ' ' + g.n('files') + ' ' + g.n('loaded')); 
									 	          	if(loaded == toload){                                    // All files uploaded
									 	          	     x.file.reset();
									 	          	     player.load(course);
									 	          		}									 	          	
									 	          	});
                					} else{
                         missing.push(course.lessons[l].items[i].location || ('Item '+ i + ' in ' + 'Lesson ' + l));                						
                						}
                	})(i);} 
										 })(l);									      
								}
							});
							}, function(error){});
					},			
				
				initialize: function(){
										x.file.input.onchange = loader.getFile;
					},

}



var mimeKey = {
  'txt': 'text/plain',
  'html': 'text/html',
  'srt': 'text/plain',
  'jpg': 'image/jpeg',
  'png': 'image/png',
  'mp3': 'audio/mpeg',
  'wav': 'audio/wav',
  'mp4': 'video/mp4',
  'ogg': 'video/ogg'
}


function mime(filename){
	var ext = filename.split('.').pop();
	var type = mimeKey[ext];
	return type;		
	}



