// UI.js is the low level interface for manipulating the DOM elements

var x = {                  //Master UI variable

					menu: {
							file: document.getElementById("add-file"),
					 		store: document.getElementById("store"),
							button: document.getElementById("show-side-menu"),
						  side: document.getElementById("side-menu"),
						  options: document.getElementById("options-button"),
						  about: document.getElementById("about-button"),
						  languages: document.getElementById('languages-button'),
		  			  install: document.getElementById('install-button'),		
		  			 				  
						  toggle: function(){
						  						var side = x.menu.side;
											  	if(side.style.visibility =='hidden'){
																side.style.visibility = 'visible';}
													else if (side.style.visibility =='visible') {
														    side.style.visibility = 'hidden';}
											  	}
					},
	
					file: {
							panel: document.getElementById("file-panel"),
							title: document.getElementById("file-panel-title"),
							close: document.getElementById("file-panel-close"),
							menu: document.getElementById("file-menu"),
							open: document.getElementById("file-open-button"),
							upload: document.getElementById("file-upload-button"),
							preview: document.getElementById("file-preview"),
							form: document.getElementById("fileuploadform"),
							input: document.getElementById("zipload"),
							info: document.getElementById("file-info"),
							select: document.getElementById("file-select"),
							viewDetails: document.getElementById('view-details'),
							previewFile: document.getElementById('preview-file'),
							screens: {
										 left: function(){
										 	 x.file.menu.style.zIndex = 20;			 	
										 	},
										 	right: function(){					 		
										 		x.file.menu.style.zIndex = 5;
										 		},
										 	toggle: function(){
										 		if (x.file.menu.style.zIndex > 15){
														x.file.screens.right();			
										 			}
										 			else{
														x.player.screens.left();										 				
										 				}
										 		}									
								},
							zip: {
										title: document.getElementById("zip-course-title"),
										description:document.getElementById("zip-course-description"),
										image: document.getElementById("zip-photo-preview"),
										progress: document.getElementById('zip-course-progress'),
										preview: function(title, description, image) {
														image = image || "icons/unknown-lesson.png";
														x.file.zip.title.innerHTML = "";
														x.file.zip.description.innerHTML = "";			
														x.file.zip.image.innerHTML = "";			
												   
												   x.file.zip.title.appendChild(document.createTextNode(title));
												   x.file.zip.description.appendChild(document.createTextNode(description));
												   var img = document.createElement("img");											
												   img.alt = "";
												   img.src =image;
														img.className = 'preview';	
														var h = x.file.preview.clientHeight;
														var w = x.file.preview.clientWidth;														
														
																if (img.width*h*.35 > img.height*w*.8){						
																			img.width = w*.8;																			 	  													 	  
																	} else {
																			img.height = h*.35;													 		
																}							   
												   x.file.zip.image.appendChild(img);
											},
											addMeta: function(text)	{
													var lesson = document.createElement("div");
													lesson.className = "meta-info-box";
													lesson.appendChild(document.createTextNode(text));
													x.file.menu.appendChild(lesson);																	
												},
											setProgress: function(text){
													x.file.zip.progress.innerHTML = "";
													x.file.zip.progress.appendChild(document.createTextNode(text));
											}			
								},
							setInfo: function(text){
								 x.file.info.innerHTML = "";
								 x.file.info.appendChild(document.createTextNode(text));
								
								},
							 setTitle: function(text){
								 x.file.title.innerHTML = "";
								 x.file.title.appendChild(document.createTextNode(text));
								
								},			
							show: function(){
								   x.file.panel.style.visibility = "visible";
								   x.file.panel.style.display = "block";
								},
							hide: function(){
										x.file.panel.style.visibility = "hidden";
										x.file.panel.style.display = "none";
										x.file.upload.style.visibility = "inherit";
										x.file.preview.style.visibility = "hidden";
								},
							view: function(){
											x.file.upload.style.visibility = "hidden";
											x.file.preview.style.visibility = "visible";
								},
							 reset: function(){
                x.file.form.reset();
                x.file.menu.style.zIndex = 15;
                x.file.menu.innerHTML = "";		
                x.file.info.innerHTML = "";		
                	x.file.title.innerHTML = g.n('file-open');
										 x.file.hide();
											
								}
														
									
						},
					
					error: {
								panel: document.getElementById("error-screen"),
						   close: document.getElementById("error-close"),
						   title: document.getElementById("error-title"),
						   message: document.getElementById("error-message"),
						   hide: function(){
									x.error.panel.style.visibility = "hidden";
									x.error.panel.style.display ='none';		   	
						   	},
						   report: function(msg){
						   	 x.home();
						   		x.error.panel.style.visibility = "visible";
						   		x.error.panel.style.display = 'block';				
						   		x.error.message.innerHTML = "";
						   		x.error.message.appendChild(document.createTextNode(msg));
						   		
						   	}
						},
						
					dialogue: {
									panel: document.getElementById('dialogue-panel'),
									title: document.getElementById('dialogue-title'),
									text: document.getElementById('dialogue-text'),
									yes: document.getElementById('dialogue-yes'),
									no: document.getElementById('dialogue-no'),
									
									show: function(){
									x.dialogue.panel.style.visibility = 'visible';
									x.dialogue.panel.style.display = 'block';		
									},
									
									hide: function(){
									x.dialogue.panel.style.visibility = 'hidden';
									x.dialogue.panel.style.display = 'none';	
									},
									
								 ask: function(question, yes, no){
									
									no = no || x.dialogue.hide;
									 
								 	x.dialogue.text.innerHTML = '';
								 	x.dialogue.text.appendChild(document.createTextNode(question));
								 	
								 	x.dialogue.yes.onclick =  yes;
								  x.dialogue.no.onclick = no;
								 	
								 	x.dialogue.show();
								 	}
						
						},
													
					player: {
							panel: document.getElementById("play-panel"),
							title: document.getElementById("player-title"),
							close: document.getElementById("player-close-button"),
							start: document.getElementById("lesson-start"),
							reset: document.getElementById("player-reset"),
							lessons: document.getElementById("play-list"),
							preview: document.getElementById("play-preview"),
							viewer: document.getElementById("play-viewer"),
							controls: document.getElementById("play-controls"),
							itemLabel: document.getElementById("item-label"),
							item: document.getElementById("play-item"),
							viewLessons: document.getElementById('view-lessons'),
							control: {
								    menu: document.getElementById("control-return"),
								    refresh: document.getElementById("control-refresh"),
								    back: document.getElementById("control-back"),
								    forward: document.getElementById("control-forward"),
								    resize: document.getElementById('control-resize')
								},
							screens: {
										 right: function(){
										 	 x.player.preview.style.zIndex = 20;			 	
										 	},
										 	left: function(){					 		
										 		x.player.preview.style.zIndex = 5;
										 		},
										 	toggle: function(){
										 		if (x.player.preview.style.zIndex > 15){
														x.player.screens.left();			
										 			}
										 			else{
														x.player.screens.right();										 				
										 				}
										 		}									
								},
							
							size: {
										 setBig: function(){
										 			x.player.panel.style.width = '700px';
										 			x.player.panel.style.height = '475px';
										 		  x.player.item.style.width = '480px';
										 			x.player.item.style.height = '360px';
										 			x.player.size.size = 'big';
										 	},
										 	
										 	setSmall: function(){
										 		
										 			x.player.panel.style.width = '500px';
										 			x.player.panel.style.height = '350px';
										 	  	x.player.item.style.width = '320px';
										 			x.player.item.style.height = '240px';

										 		x.player.size.size = 'small';
		
										 	},
										 	
										 	toggle: function(){
										 		if (x.player.size.size == 'small'){
														x.player.size.setBig();										 			
										 			} else{
										 				x.player.size.setSmall();
										 			}
										 		
										 	},
										 size: 'small',
										 

								},
							status: {
										lessonLabel: document.getElementById("status-lesson-label"),
										lesson: document.getElementById("status-lesson-index"),
										progressLabel: document.getElementById("status-progress-label"),
										item: document.getElementById("status-item-index"),
										itemTotal: document.getElementById("status-item-total"),
										bar:  document.getElementById("play-status")
								},
	         lesson: {
	         					image: document.getElementById("player-lesson-image"),
	         					title: document.getElementById("player-lesson-title"),
	         					description: document.getElementById("player-lesson-description")
	         	},
	         	
	         setItem: function(div){
            x.player.item.innerHTML = "";
            x.player.item.appendChild(div);	         	
	         	},
							
							setTitle: function(title){
							x.player.title.innerHTML = "";
							x.player.title.appendChild(document.createTextNode(title));
								},
							setMenu: function(lessons, progress){
								     
							        x.player.lessons.innerHTML = "";
							        lessons.forEach(function(title, index){
											        	var lesson = document.createElement("div");
																	lesson.className = "lesson-box";
																	lesson.appendChild(document.createTextNode(title));
																	lesson.id = "lb" + index;
																	lesson.onclick = function(){
																  x.player.screens.right();
																	player.setLesson(index);	
																	}
																 
																 lesson = x.player.addProgress(lesson, progress[index]);
																	
																	x.player.lessons.appendChild(lesson);
							        	});	
								},
							addProgress: function(lesson, progress){
								  		
								  						if (progress > 0){																						  								
								  								var status = document.createElement('div');
																	status.className = 'lesson-status';
                          var icon = document.createElement('img');
                          icon.width = '24';
                          icon.height = '24';
																	if(progress==1){
																		icon.src = 'icons/inprogress.png';					
																		}
																	else if (progress==2){
																		icon.src = 'icons/tick.png';	
																	} 
																	status.appendChild(icon);
																	lesson.appendChild(status);
															}					
																return lesson;
								},
									
								
							setLesson: function(lesson){
									x.player.status.lesson.innerHTML ="";
			      	  x.player.status.lesson.appendChild(document.createTextNode(lesson));
			
								},
								
						  setLength: function(items){
									x.player.status.itemTotal.innerHTML ="";
			      	  x.player.status.itemTotal.appendChild(document.createTextNode(items));
			
								},
								
			      setProgress:  function(item){
			      	  x.player.status.item.innerHTML ="";
			      	  x.player.status.item.appendChild(document.createTextNode(item));
			      	},				
			      	
			      setItemLabel: function(text){
			      	  x.player.itemLabel.innerHTML ="";
			      	  x.player.itemLabel.appendChild(document.createTextNode(text));
			      	
			      	},	
							setPreview: function(title, description, image){

								         image = image || "icons/unknown-lesson.png";
														x.player.lesson.title.innerHTML = "";
														x.player.lesson.description.innerHTML = "";			
														x.player.lesson.image.innerHTML = "";			
												   
												   x.player.lesson.title.appendChild(document.createTextNode(title));
												   x.player.lesson.description.appendChild(document.createTextNode(description));
												   var img = document.createElement("img");											
												   img.alt = "";
												   img.src = window.URL.createObjectURL(image);
												    img.onload = function(e) {
                       window.URL.revokeObjectURL(this.src);
                       }
                     img.className =  'preview'; 
														var h = x.player.preview.clientHeight;
														var w = x.player.preview.clientWidth;														
														
																if (img.width*h*.35 > img.height*w*.8){						
																			img.width = w*.8;																			 	  													 	  
																	} else {
																			img.height = h*.35;													 		
																}					
												   x.player.lesson.image.appendChild(img);
								
								},
							hide: function(){
											x.player.panel.style.visibility = "hidden";			
											x.player.panel.style.display = "none";
									   x.player.preview.style.visibility = "inherit";
								    x.player.lessons.style.visibility = "inherit";
								    x.player.reset.style.visibility = "inherit";	
								    x.player.start.style.visibility = "inherit";		
								    x.player.controls.style.visibility = "hidden";
								    x.player.viewer.style.visibility = "hidden";
								    x.player.status.bar.style.visibility = "hidden";				
								}	,
							show: function(){
											x.player.panel.style.visibility = "visible";		
								    x.player.panel.style.display = "block";
								    x.player.screens.left();
								},
							view: function(){
								    x.player.preview.style.visibility = "hidden";
								    x.player.lessons.style.visibility = "hidden";
								    x.player.controls.style.visibility = "visible";
								    x.player.viewer.style.visibility = "visible";			
								    x.player.reset.style.visibility = "hidden";	
								    x.player.start.style.visibility = "hidden";
								    x.player.status.bar.style.visibility = "visible";							
								}	,
							menu: function(){
								    x.player.preview.style.visibility = "visible";
								    x.player.lessons.style.visibility = "visible";
								    x.player.controls.style.visibility = "hidden";
								    x.player.viewer.style.visibility = "hidden";
								    x.player.reset.style.visibility = "visible";	
								    x.player.start.style.visibility = "visible";
								    x.player.status.bar.style.visibility = "hidden";												
								}			
					},
					
					welcome: {
								screen: document.getElementById("welcome-screen"),
								panel: document.getElementById("welcome-box"),
								languages: document.getElementById("welcome-languages"),
								button: document.getElementById("welcome-go"),
								show: function(){
								x.welcome.screen.style.visibility = "visible";
								},
								
								hide: function(){
								x.welcome.screen.style.visibility = "hidden";
								x.welcome.button.style.visibility = "hidden";	
								}
								
					},						
					
					home: function(){
								x.file.reset();
								x.player.hide();
								x.options.hide();
								x.install.hide();
								x.about.hide();
								x.dialogue.hide();
						},
						
					about: {
								panel: document.getElementById('about-panel'),
								title: document.getElementById('about-title'),
								close: document.getElementById('about-close'),
								text: document.getElementById('about-text'),
								
								show: function(){
									x.about.panel.style.visibility = 'visible';	
									x.about.panel.style.display = 'block';												
									},
								hide: function(){
									x.about.panel.style.visibility = 'hidden';
									x.about.panel.style.display = 'none';			
								}
									
						
						},
						
					options: {
								panel: document.getElementById('options-panel'),
								title: document.getElementById('options-title'),
								close: document.getElementById('options-close'),
								deleteUser: {
											text: document.getElementById('delete-user-text')	,
											button: document.getElementById('delete-user-button')								
									},
								show: function(){
									x.options.panel.style.visibility = 'visible';
											x.options.panel.style.display = 'block';													
									},
								hide: function(){
									x.options.panel.style.visibility = 'hidden';
									x.options.panel.style.display = 'none';			
								}
						
						},
						
						
					install: {
							panel: document.getElementById('install-panel'),
							title: document.getElementById('install-title'),
							close: document.getElementById('install-close'),
							availability: document.getElementById('availability-text'),
							
							show: function(){
							 x.install.panel.style.visibility = 'visible';
							 x.install.panel.style.display = 	'block';						
							},
							
							hide: function(){
							 x.install.panel.style.visibility = 'hidden';
							 x.install.panel.style.display = 	'none';					
							}
						
						
						},
														
					initialize: function(){              		
       
						x.file.panel.style.visibility = "hidden";
						x.file.preview.style.visibility = "hidden";
						x.error.panel.style.visibility = "hidden";                             
						x.player.panel.style.visibility = "hidden";
						x.player.viewer.style.visibility = "hidden";
	        x.player.controls.style.visibility = "hidden";
	        x.player.status.bar.style.visibility = "hidden";			
	        x.welcome.screen.style.visibility = "hidden";	
	        x.about.panel.style.visibility = "hidden";	
	        x.options.panel.style.visibility = "hidden";
	        x.menu.side.style.visibility = "hidden";
						x.dialogue.panel.style.visibility = "hidden";
						x.install.panel.style.visibility ='hidden';
												
						
						x.file.panel.style.display = "none";
						x.error.panel.style.display = "none";                             
						x.player.panel.style.display = "none";
	        x.about.panel.style.display = "none";	
	        x.options.panel.style.display = "none";
						x.dialogue.panel.style.display = "none";                          		 	
						x.install.panel.style.display  = 'none';                     		                     
													                     		                     
						                     		                     
						x.menu.button.onclick = x.menu.toggle;	  
						x.menu.file.onclick = x.file.show;		
					 x.menu.about.onclick = x.about.show;		
					 x.menu.side.onclick = x.menu.toggle;
					 x.menu.options.onclick = x.options.show;
					 x.menu.install.onclick = x.install.show;
					 		
						x.file.close.onclick = x.file.reset;						
						x.error.close.onclick = x.error.hide;			
						x.player.close.onclick = x.player.hide;

					  x.about.close.onclick = x.about.hide;
					  x.options.close.onclick = x.options.hide;
         x.install.close.onclick = x.install.hide;
         x.player.viewLessons.onclick = x.player.screens.left;
         x.file.viewDetails.onclick = x.file.screens.left;
         x.file.previewFile.onclick = x.file.screens.right;
					},
					
				localize: function(){
						
					x.menu.options.innerHTML = "";
					var img1 = document.createElement("img");
			   img1.src = "icons/gear.png";
		  		img1.height = '20';
					x.menu.options.appendChild(img1);
					x.menu.options.appendChild(document.createTextNode("  "+g.n('options')));					
					
					x.menu.about.innerHTML = "";
					var img2 = document.createElement("img");
	  			img2.src = "icons/qmark.png";
	  			img2.height = '20';
		  		x.menu.about.appendChild(img2);
					x.menu.about.appendChild(document.createTextNode("  "+ g.n('about')));				
					
					x.menu.languages.innerHTML = "";
					var img3 = document.createElement("img");
	 			 img3.src = "icons/globe.png";
	  		 img3.height = '20';
	  	  	x.menu.languages.appendChild(img3);
					x.menu.languages.appendChild(document.createTextNode("  "+g.locale));		
							
			
					x.menu.install.innerHTML = "";
					var img4 = document.createElement("img");
	 			 img4.src = "icons/android.png";
	  		 img4.height = '20';
	  		 x.menu.install.appendChild(img4);
					x.menu.install.appendChild(document.createTextNode("  "+g.n('get-app')));				
			
			
					
					x.file.title.innerHTML = g.n('file-open');
					x.file.select.innerHTML = g.n('file-select');
					x.file.open.innerHTML = g.n('open');
					
					x.player.start.innerHTML = g.n('start');
					x.player.reset.innerHTML = g.n('reset');
					x.player.status.lessonLabel.innerHTML = g.n('lesson');
					x.player.status.progressLabel.innerHTML = g.n('progress');
					
					x.about.title.innerHTML = g.n('about');
					x.about.text.innerHTML = g.n('about-text');
					
					x.options.title.innerHTML = g.n('options');
					x.options.deleteUser.text.innerHTML = g.n('delete-user');
					x.options.deleteUser.button.innerHTML = g.n('delete');
					
					x.dialogue.title.innerHTML = g.n('dialogue');
					x.dialogue.yes.innerHTML = g.n('yes');
					x.dialogue.no.innerHTML = g.n('no');
					
					
					x.error.title.innerHTML = g.n('error');

					x.install.title .innerHTML = g.n('install');
					x.install.availability.innerHTML = g.n('can-download');
					
					
					

					}						

	}




