_slugify_strip_re = /[^\w\s-]/g;
_slugify_hyphenate_re = /[-\s]+/g;
function slugify(s) {
  s = s.replace(_slugify_strip_re, '').trim().toLowerCase();
  s = s.replace(_slugify_hyphenate_re, '-');
  return s;
}

function youtube_parser(url){
    var regExp = /^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/;
    var match = url.match(regExp);
    if (match&&match[7].length==11){
        return match[7];
    }else{
        return '';
    }
}

function check(url, clase) {
	var videoid =  youtube_parser(url);
	if(videoid == '') {
		$("."+clase).addClass('ui-disabled');			
	} else {
		$("."+clase).removeClass('ui-disabled');
	}
}

function checkSearchTerm(query) {
	if(query == '') {
		$(".search_main").addClass('ui-disabled');			
	} else {
		$(".search_main").removeClass('ui-disabled');
	}
}

function getfilenamesecure(string, ext) {
     var fn_base = slugify(string);
	 var fn_full = fn_base + ext;
	 var filename = fn_full;
	 var i = 2;
	 while (videofilenames.indexOf(filename) != -1) {
	      filename = fn_base + '-' + i + ext;
		  i++;
	 }
	 return filename;
}

/************************************************* DOWNLOAD VIDEO*************/
function updateProgress (oEvent, percentSelector, loadedSelector, totalSelector, oReq) {
	var keonlimits = localStorage.getItem('keonlimits');

	if ((keonlimits == 'yes') && (oEvent.total > 29360128)) {
		oReq.abort();
		$.mobile.changePage( "#maxsize", { transition: "none", changeHash: true });
	} else {
		if (oEvent.lengthComputable) {
			var percentComplete = Math.floor(100*(oEvent.loaded / oEvent.total));
			if (percentComplete > 99) {
				percentComplete = 99;
			}
			/* Mejor que .html() usamos innerHTML */ 
			//percentSelector.html(percentComplete);
			percentSelector.innerHTML = percentComplete;

			var loaded_size = oEvent.loaded / 1048576;
			var total_size = oEvent.total / 1048576;

			//loadedSelector.html(loaded_size.toFixed(0));
			loadedSelector.innerHTML = loaded_size.toFixed(0);
			//totalSelector.html(total_size.toFixed(0) + 'Mb');
			totalSelector.innerHTML = total_size.toFixed(0) + 'Mb';
		} else {
			// Unable to compute progress information since the total size is unknown
			var loaded_size = oEvent.loaded / 1048576;
			var total_size = '<i>unknow</i>';
			loadedSelector.html(loaded_size.toFixed(0) + 'Mb');
			totalSelector.html(total_size);
		}
	}
}

function transferFailed(evt) {
	$.mobile.loading('hide');
	$("div#download-progress").hide();
	$("div#download div#icono-err").show();
	$('div#download p#resultado').html('An error occurred while transferring the file.');
	$('div#download a.canceldownload').hide();
	$('div#download a.aceptar').show();
}

function transferCanceled(evt) {
	$.mobile.loading('hide');
	$("div#download-progress").hide();
	$("div#download div#icono-err").show();
	$('div#download p#resultado').html('The transfer has been canceled by the user.');
	$('div#download a.canceldownload').hide();
	$('div#download a.aceptar').show();
}

function downloadpage(url, filename){
        $.mobile.changePage( "#download", { transition: "fade", changeHash: true });
        $('input#download-url').val(url);
		$('input#filename').val(filename);
}

function downloadfromsearch(id){
       // $('ul#response_youtube').html('');
	   // $('#searchword').val('');
	   localStorage.setItem('method','youtube');
	   getformats(id);
}


function downloadvideo(url, filename){
		
		var urldownload = atob(url);
		
		var oReq = new XMLHttpRequest({ mozSystem: true });
		
		/*oReq.addEventListener("progress", updateProgress, false);*/
		//var percentSelector = $("div#download-progress span#porcentaje");
		var percentSelector =  document.getElementById("porcentaje");
		//var loadedSelector = $('span#loaded_download');
		var loadedSelector =  document.getElementById("loaded_download");
		//var totalSelector = $('span#total_download');
		var totalSelector =  document.getElementById("total_download");
		
		oReq.addEventListener("progress", function(oEvent){ updateProgress(oEvent, percentSelector, loadedSelector,totalSelector,oReq);}, false);
		
		oReq.addEventListener("error", transferFailed, false);
		oReq.addEventListener("abort", transferCanceled, false);
			
		oReq.open("GET",urldownload, true);
		oReq.responseType = "blob";	

		
		oReq.onload = function(oEvent) {
			var videoBlob = oReq.response;
			var videos = navigator.getDeviceStorage("videos");
			var request = videos.addNamed(videoBlob, filename);
			
			request.onsuccess = function () {
				$.mobile.loading('hide');
				$("div#download-progress").hide();
				$("div#download div#icono-ok").show();
				$("div#download p#resultado").html('Video has been downloaded and saved successfully on Videos.');
				$('div#download a.canceldownload').hide();
				$('div#download a.aceptar').show();
				
			
                if (document.hidden) {
                   var notification = navigator.mozNotification.createNotification("Downtube","Video has been downloaded");
				   notification.show();
                }
				
			}

			request.onerror = function () {
				console.warn('No se ha podido guardar el archivo: ' + this.error);
				$.mobile.loading('hide');
				$("div#download-progress").hide();
				$("div#download div#icono-err").show();
				$("div#download p#resultado").html('Sorry, an error has occurred when saving the video.');
				$('div#download a.canceldownload').hide();
				$('div#download a.aceptar').show();
			}
		}
		
		$('a.canceldownload').click(function() { 
			  oReq.abort();
		});
		
		oReq.send();
}


/************************************************* GET FORMATS (DOWNLOAD LINKS)*************/
function getformats(videoid) {

	var method = localStorage.getItem('method');
	
	if (!navigator.onLine) {
	    $.mobile.changePage( "#nointernet", { transition: "fade", changeHash: true });
	} else {
	
		if(videoid == '') {
			 alert('Incorrect URL');
		} else {
			$.mobile.loading('show', {
				text: "Getting video info",
				textVisible: true
			});
		
			url = 'http://www.youtube.com/get_video_info?video_id=' + videoid;
		 
			var videoinfo = new Array();
			var avail_formats = new Array();
			var xhr = new XMLHttpRequest({ mozSystem: true });
			 
			// Use the xhr object as usual ...
			xhr.open("GET", url, true); 
			xhr.send();
			 
			// When checking for the result, you'll look for response status 200 OR (AND THIS IS IMPORTANT) 0
			xhr.onload = function(e) {
					if (xhr.status === 200 || xhr.status === 0) {
							parse_str(xhr.responseText, videoinfo);
							filename = videoinfo['title'];
												   
							if (videoinfo.hasOwnProperty('url_encoded_fmt_stream_map')) {
									var mystr = videoinfo['url_encoded_fmt_stream_map'];
									var my_formats_array = mystr.split(",");
									var length = my_formats_array.length;
									
									if (length > 0) {	
											for (var i = 0; i < length; i++) {
													var formatinfo = new Array();
													parse_str(my_formats_array[i],formatinfo);
													var avail_format = new Array();
													avail_format['itag'] = formatinfo['itag'];
													avail_format['quality'] = formatinfo['quality']; 
													var mystr = formatinfo['type'];
													var typearr = mystr.split(";");
													avail_format['type'] = typearr[0];

													if (formatinfo.hasOwnProperty('stereo3d')) {
														avail_format['stereo3d'] = ' 3D';
													} else {
														avail_format['stereo3d'] = '';
													}
													
													var fileext;
													if (avail_format['type'] == 'video/webm') {
														fileext = '.webm';
													} else {
														fileext = '.mp4';
													}
												  
													var filenamesecured = getfilenamesecure(filename + '-' + avail_format['quality']  + avail_format['stereo3d'], fileext);
												  
													avail_format['url'] = decodeURIComponent(formatinfo['url']) + '&signature=' + formatinfo['sig'];
										  
													var formatinfo2 = new Array();
													parse_str(decodeURIComponent(formatinfo['url']),formatinfo2);
													
													var dt = new Date(formatinfo2['expire'] * 1000);
													avail_format['expires'] = dt.getHours() + ':' + dt.getMinutes() + ':' + dt.getSeconds();
													  
													avail_format['ipbits'] = formatinfo2['ipbits'];
													avail_format['ip'] = formatinfo2['ip'];
													avail_format['filename'] = filenamesecured;
													avail_formats[i] = avail_format;
											}
										
											$.mobile.changePage( "#formatos", { transition: "fade", changeHash: true });
											$('img#thumbnail').attr("src",videoinfo['thumbnail_url']); 
											$('span#title').html(videoinfo['title']); 
											$('div.infovideo').show();
											$('ul#response').append('<li data-role="divider" data-theme="e">Choose video format</li>').listview('refresh');
							
											var count_formats = 0;
											for (var i = 0; i < length; i++) {   
												 var keonlimits = localStorage.getItem('keonlimits');
												if (keonlimits == 'yes') {
													if (((avail_formats[i]['type'] == 'video/webm') || (avail_formats[i]['type'] == 'video/mp4') || (avail_formats[i]['type'] == 'video/3gpp')) && (avail_formats[i]['quality'] != 'hd720') && (avail_formats[i]['quality'] != 'hd1080')) {
														//$('ul#response').append('<li><a class="urldescarga" href="#" onclick="downloadpage(\'' + btoa(avail_formats[i]['url']) + '\',\'' + avail_formats[i]['filename'] + '\');">' + avail_formats[i]['type'] + ' <small>[' + avail_formats[i]['quality'] + avail_formats[i]['stereo3d'] + ']</small></a></li>').listview('refresh');
														$('ul#response').append('<li><a class="urldescarga" href="#" url="' + btoa(avail_formats[i]['url']) + '" filename="' + avail_formats[i]['filename'] + '">' + avail_formats[i]['type'] + ' <small>[' + avail_formats[i]['quality'] + avail_formats[i]['stereo3d'] + ']</small></a></li>').listview('refresh');
														count_formats++;
													} 
												} else {
														//$('ul#response').append('<li><a class="urldescarga" href="#" onclick="downloadpage(\'' + btoa(avail_formats[i]['url']) + '\',\'' + avail_formats[i]['filename'] + '\');">' + avail_formats[i]['type'] + ' <small>[' + avail_formats[i]['quality'] + avail_formats[i]['stereo3d'] + ']</small></a></li>').listview('refresh');
														$('ul#response').append('<li><a class="urldescarga" href="#" url="' + btoa(avail_formats[i]['url']) + '" filename="' + avail_formats[i]['filename'] + '">' + avail_formats[i]['type'] + ' <small>[' + avail_formats[i]['quality'] + avail_formats[i]['stereo3d'] + ']</small></a></li>').listview('refresh');
														count_formats++;
												}		
											}
											
											$.mobile.loading('hide');
											if (count_formats == 0) {
												 $('ul#response').append('<li>No supported formats found</li>');
											}
									
									} else {
											$.mobile.loading('hide');
											$("p#resultado-error").html('Sorry, no download link found.');
											$.mobile.changePage( "#error", { transition: "fade", changeHash: true });							
									}
							} else {
									$.mobile.loading('hide');
									if (method == 'youtube') {
									        $("p#resultado-error").html('Requested video cannot be downloaded (probably not available for mobile devices).');
									} else {
											$("p#resultado-error").html('Video not found. Please, check if URL or video id are correct and try again.');
									}
									$.mobile.changePage( "#error", { transition: "fade", changeHash: true });
							}
					} else {
							$.mobile.loading('hide');
							$("p#resultado-error").html('Error accesing to video info.');
							$.mobile.changePage( "#error", { transition: "fade", changeHash: true });
					}		
			}	
		}
	}
}


function mainSearch(q) {
	localStorage.setItem('method','mainsearch');
	$.mobile.changePage( "#youtube", { transition: "fade", changeHash: true });
	$('#searchword').val(q);
    $("form#youtubesearch").submit();
	
}

/************************************************* CONEXION A INTERNET *************/
/*
function updateOnlineStatus(event) {
		if (navigator.onLine) {
			$.mobile.changePage( "#inicio", { transition: "fade", changeHash: true });
		} else {
			$.mobile.changePage( "#nointernet", { transition: "fade", changeHash: true });
		}
}
*/

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

$(function() { 

	
	$( "body" ).delegate( "a.urldescarga", "click", function() {
		var url = $(this).attr('url');
		var filename = $(this).attr('filename')
		downloadpage(url, filename);
	});
	
	$( "body" ).delegate( "a.downloadfromsearch", "click", function() {
		downloadfromsearch($(this).attr('youtubeid'));
	});
	
	
	/*
	document.addEventListener('online',  updateOnlineStatus);
    document.addEventListener('offline', updateOnlineStatus);	
	*/
	var keonlimits = localStorage.getItem('keonlimits');
	$('select#flip-1').val(keonlimits);	
	
	$('select#flip-1').change(function () {
		localStorage.setItem('keonlimits',this.value);	
	}).trigger('click');	 
	
	$("form#byurl").bind("keypress", function(e) {
            if (e.keyCode == 13) {
				$('a.download').focus();
				$('a.download').focusout();
				var videoid =  youtube_parser($('input#url').val());
				if(videoid != '') {
					localStorage.setItem('method','direct');
					getformats(videoid);		
				} 
				return false;
			}
    });
	  
	$("form#byid").bind("keypress", function(e) {
            if (e.keyCode == 13) {
				$('a.download-id').focus();
				$('a.download-id').focusout();
				var url =  'http://www.youtube.com/watch?v=' + $('input#videoid').val();
				var videoid =  youtube_parser(url);
				if(videoid != '') {
					localStorage.setItem('method','direct');
					getformats(videoid);		
				} 
				return false;
			}
    });
	
	
	$("form#mainsearch").bind("keypress", function(e) {
            if (e.keyCode == 13) {
				$('a.search_main').focus();
				$('a.search_main').focusout();
				var q = $('input#q').val();
				if(q != '') {
					mainSearch(q);
				} 
				return false;
			}
    });
	  
	$('input#radio-searchby-url').change(function () {
			if(this.checked) {
				localStorage.setItem('searchby','url');	
			}
	}).trigger('change');	

	
	$('input#radio-searchby-id').change(function () {
			 if(this.checked) {
				localStorage.setItem('searchby','id');	
			 }
	}).trigger('change');	
	 
	 
	$('input#url').change(function() { 
			var url = $(this).val();
			check(url,'download');
	}); 
	
	
	$('input#url').keyup(function() {
			var url = $(this).val();
			check(url,'download');
	});

	
	$('input#videoid').change(function() { 
			var url =  'http://www.youtube.com/watch?v=' + $(this).val();
			check(url,'download-id');
	}); 

	 
	 $('input#videoid').keyup(function() { 
	        var url =  'http://www.youtube.com/watch?v=' + $(this).val();
			check(url,'download-id');
	 }); 
	 
	 
	 $('input#q').change(function() { 
			var q = $(this).val();
			checkSearchTerm(q);
	 }); 
	
	
	$('input#q').keyup(function() {
			var q = $(this).val();
			checkSearchTerm(q);
	});
	
	
	$(".download").click(function() { 
			var url = $('input#url').val();			
			var videoid =  youtube_parser(url);
			localStorage.setItem('method','direct')
			getformats(videoid);
	}); 
	
	
	$(".download-id").click(function() { 
	      var videoid = $('input#videoid').val();
		  localStorage.setItem('method','direct')
		  getformats(videoid);
	}); 
		
	$(".search_main").click(function() { 
	      var q = $('input#q').val();
		  mainSearch(q);
	}); 
	
	$("a.cancel").click(function() { 
	       var method = localStorage.getItem('method');
		   if (method == 'youtube') {
		        $.mobile.changePage( "#youtube", { transition: "none", changeHash: true });
		   } else if (method == 'direct') {
		         $.mobile.changePage( "#direct", { transition: "none", changeHash: true });
		   } else {
				 $.mobile.changePage( "#inicio", { transition: "none", changeHash: true });
		   }
		   $('div.infovideo').hide();
		   $('ul#response').html('');
	}); 
	
	$("a.aceptar").click(function() { 
		   var method = localStorage.getItem('method');  
		  if (method == 'youtube') {
		        $.mobile.changePage( "#youtube", { transition: "none", changeHash: true });
		   } else if (method == 'direct') {
		         $.mobile.changePage( "#direct", { transition: "none", changeHash: true });
		   } else {
				 $.mobile.changePage( "#inicio", { transition: "none", changeHash: true });
		   }
		   $('div.infovideo').hide();
		   $('ul#response').html('');
	}); 
	
	$("a.checkstorage").click(function() { 
	       $.mobile.changePage( "#inicio", { transition: "none", changeHash: true });
	}); 
	
	$("a.checkinternet").click(function() { 
	       $.mobile.changePage( "#inicio", { transition: "none", changeHash: true });
	}); 
	
	$("a.backtoformats").click(function() { 
	       $.mobile.changePage( "#formatos", { transition: "none", changeHash: true });
	}); 
	
	$("form#youtubesearch").submit(function() {
	    
		var q = $('#searchword').val();
		
		if (q) {
		    $('ul#response_youtube').html(''); 
			$.mobile.loading('show', {
					text: "Searching on Youtube",
					textVisible: true
			});
			
			//var q = $('#searchword').val();
			
			
			var oReq = new XMLHttpRequest({ mozSystem: true });
			oReq.open('GET', 'http://www.palasaka.com/index.php?q='+q+'&maxResults=15&view=youtube&option=com_profiles&Itemid=77&format=raw&tpl=json', true); 
		
			oReq.onload = function(oEvent) {
				var data = jQuery.parseJSON(oReq.responseText);
				var content = "";
					for (var x = 0; x < data.length; x++) {
						//$('ul#response_youtube').append('<li data-icon="false"><a href="#" onclick="downloadfromsearch(\''+data[x].id+'\')"><img style="height:80px;overflow: hidden;" src="'+data[x].thumbnail+'"><h2>'+data[x].title+'</h2><p>'+data[x].description+'</p></a></li>').listview('refresh');
					    $('ul#response_youtube').append('<li data-icon="false"><a class="downloadfromsearch" href="#" youtubeid="'+data[x].id+'"><img style="height:80px;overflow: hidden;" src="'+data[x].thumbnail+'"><h2>'+data[x].title+'</h2><p>'+data[x].description+'</p></a></li>').listview('refresh');
					}
				$.mobile.loading('hide');				
			}
			oReq.send();
		 }
			return false;
		}); 
	
}); 