"use strict";

/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/



var BattleLayerTag = 0;
var BattleLayerTagBack1			= BattleLayerTag++;
var BattleLayerTagDino1			= BattleLayerTag++;
var BattleLayerTagDino2			= BattleLayerTag++;
var BattleLayerTagDino3			= BattleLayerTag++;
var BattleLayerTagWall2			= BattleLayerTag++;
var BattleLayerTagDino4			= BattleLayerTag++;
var BattleLayerTagDino5			= BattleLayerTag++;
var BattleLayerTagDino6			= BattleLayerTag++;
var BattleLayerTagWall3			= BattleLayerTag++;
var BattleLayerTagDino7			= BattleLayerTag++;
var BattleLayerTagDino8			= BattleLayerTag++;
var BattleLayerTagDino9			= BattleLayerTag++;
var BattleLayerTagWall4			= BattleLayerTag++;
var BattleLayerTagCountDown		= BattleLayerTag++;
var BattleLayerTagScoreTitle	= BattleLayerTag++;
var BattleLayerTagScoreNum		= BattleLayerTag++;
var BattleLayerTagTimeTitle		= BattleLayerTag++;
var BattleLayerTagTimeNum		= BattleLayerTag++;
var BattleLayerTagInfo			= BattleLayerTag++;
var BattleLayerTagStart			= BattleLayerTag++;



var BattleLayer = NASView.extend({
	labelCountDown:null,
	labelTimeNum:null,
	labelScoreNum:null,
	
	dino1:null,
	dino2:null,
	dino3:null,
	dino4:null,
	dino5:null,
	dino6:null,
	dino7:null,
	dino8:null,
	dino9:null,

	spriteBack1:null,
	buttonWall2:null,
	buttonWall3:null,
	buttonWall4:null,
	
	spriteInfo:null,
	buttonStart:null,
	
	count:30, //### time limit
	countdown:5,
	score:0,
	
	plusnum:0,
	minusnum:0,

    init:function () {

        //////////////////////////////
        // 1. super init first
        this._super();

        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();

		this.labelCountDown = cc.LabelTTF.create("", "Impact", 30);
    	this.labelCountDown.setPosition(cc.p(size.width/2, size.height/2));
        this.addChild(this.labelCountDown, BattleLayerTagCountDown, BattleLayerTagCountDown);
    	
		this.labelTimeNum = cc.LabelTTF.create(this.count.toFixed(2), "Impact", 20);
    	this.labelTimeNum.setAnchorPoint(cc.p(0.0, 1.0));
    	this.labelTimeNum.setPosition(cc.p(size.width-60, size.height-5));
        this.addChild(this.labelTimeNum, BattleLayerTagTimeNum, BattleLayerTagTimeNum);

		this.labelScoreNum = cc.LabelTTF.create(this.score, "Impact", 20);
    	this.labelScoreNum.setAnchorPoint(cc.p(1.0, 1.0));
    	this.labelScoreNum.setPosition(cc.p(size.width-70, size.height-36));
        this.addChild(this.labelScoreNum, BattleLayerTagScoreNum, BattleLayerTagScoreNum);

    	var h = size.height;
    	
    	this.spriteBack1 = cc.Sprite.create(s_BattleBG1);
    	this.spriteBack1.setPosition(cc.p(size.width/2, h-this.spriteBack1.getContentSize().height/2));
    	this.addChild(this.spriteBack1, BattleLayerTagBack1, BattleLayerTagBack1);
		h = h - this.spriteBack1.getContentSize().height;
    	
    	this.dino1 = DinoView.create(this);
    	this.dino1.setPosition(cc.p(28, 235));
    	this.addChild(this.dino1, BattleLayerTagDino1, BattleLayerTagDino1);
    	
    	this.dino2 = DinoView.create(this);
    	this.dino2.setPosition(cc.p(125, 235));
    	this.addChild(this.dino2, BattleLayerTagDino2, BattleLayerTagDino2);
    	
    	this.dino3 = DinoView.create(this);
    	this.dino3.setPosition(cc.p(230, 235));
    	this.addChild(this.dino3, BattleLayerTagDino3, BattleLayerTagDino3);
    	
    	this.buttonWall2 = NASButtonView.buttonWithFile(s_BattleBG2, this);
    	this.buttonWall2.setPosition(cc.p(0, h-this.buttonWall2.getContentSize().height+40));
    	this.buttonWall2.setTouchDownEffectEnable(false);
    	this.addChild(this.buttonWall2, BattleLayerTagWall2, BattleLayerTagWall2);
		h = h - this.buttonWall2.getContentSize().height + 40;
    	
    	this.dino4 = DinoView.create(this);
    	this.dino4.setPosition(cc.p(28, 100));
    	this.addChild(this.dino4, BattleLayerTagDino4, BattleLayerTagDino4);
    	
    	this.dino5 = DinoView.create(this);
    	this.dino5.setPosition(cc.p(125, 100));
    	this.addChild(this.dino5, BattleLayerTagDino5, BattleLayerTagDino5);
    	
    	this.dino6 = DinoView.create(this);
    	this.dino6.setPosition(cc.p(230, 100));
    	this.addChild(this.dino6, BattleLayerTagDino6, BattleLayerTagDino6);
    	
    	this.buttonWall3 = NASButtonView.buttonWithFile(s_BattleBG3, this);
    	this.buttonWall3.setPosition(cc.p(0, h-this.buttonWall3.getContentSize().height+45));
    	this.buttonWall3.setTouchDownEffectEnable(false);
    	this.addChild(this.buttonWall3, BattleLayerTagWall3, BattleLayerTagWall3);
		h = h - this.buttonWall3.getContentSize().height + 45;
    	
    	this.dino7 = DinoView.create(this);
    	this.dino7.setPosition(cc.p(28, -30));
    	this.addChild(this.dino7, BattleLayerTagDino7, BattleLayerTagDino7);
    	
    	this.dino8 = DinoView.create(this);
    	this.dino8.setPosition(cc.p(125, -30));
    	this.addChild(this.dino8, BattleLayerTagDino8, BattleLayerTagDino8);
    	
    	this.dino9 = DinoView.create(this);
    	this.dino9.setPosition(cc.p(230, -30));
    	this.addChild(this.dino9, BattleLayerTagDino9, BattleLayerTagDino9);
    	
    	this.buttonWall4 = NASButtonView.buttonWithFile(s_BattleBG4, this);
    	this.buttonWall4.setPosition(cc.p(0, 0));
    	this.buttonWall4.setTouchDownEffectEnable(false);
    	this.addChild(this.buttonWall4, BattleLayerTagWall4, BattleLayerTagWall4);
		
		this.spriteInfo = cc.Sprite.create(s_HelpInfo);
		this.spriteInfo.setPosition(cc.p(size.width/2, size.height/2));
		this.addChild(this.spriteInfo, BattleLayerTagInfo, BattleLayerTagInfo);
		
		this.buttonStart = NASButtonView.buttonWithFile(s_HelpNext, this);
    	this.buttonStart.setPosition(cc.p(size.width/2-this.buttonStart.getContentSize().width/2, 20));
    	this.addChild(this.buttonStart, BattleLayerTagStart, BattleLayerTagStart);
		
        return true;
    },

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();
		if (tag == BattleLayerTagStart)
		{
			if(event == NASButtonViewEventTouchUpInside)
			{
				this.buttonStart.setTouchEnable(false);
				this.spriteInfo.runAction(cc.FadeOut.create(0.5));
				this.buttonStart.getSprite().runAction(cc.FadeOut.create(0.5));
				this.countDownTimer();
    			this.schedule(this.countDownTimer, 1.0);
			}
		}
	},
	
	onDinoEventPush:function(dino)
	{
		this.score += dino.getPoint();
		this.labelScoreNum.setString(this.score);
	},
	
	onDinoEventAction:function(dino)
	{
		if(0 < dino.getPoint())
		{
			this.plusnum--;
		}
	},
	
	countDownTimer:function(dt)
	{
		this.countdown--;
		
		this.labelCountDown.setScale(9.0);
		
		var arrAction = new Array();
        arrAction.push(cc.ScaleTo.create(0.2,1.0));
        arrAction.push(cc.ScaleTo.create(0.05,1.2));
        arrAction.push(cc.ScaleTo.create(0.05,1.0));
		
		if(this.countdown <= 0)
		{
			arrAction.push(cc.DelayTime.create(0.1));
			arrAction.push(cc.FadeOut.create(0.1));
			arrAction.push(cc.CallFunc.create(this.labelCountDown.removeFromParent, this.labelCountDown, true));
			
			this.labelCountDown.setString("START");
			this.unschedule(this.countDownTimer);
			
			this.startGame();
		}
		else if(this.countdown <= 3)
		{
			this.labelCountDown.setString(this.countdown);
		}
		this.labelCountDown.runAction(cc.Sequence.create(arrAction));
	},
	
	startGame:function()
	{
		this.schedule(this.countTimer);
		this.schedule(this.check);
	},
	
	countTimer:function(dt)
	{
		this.labelTimeNum.setString(this.count.toFixed(2));
		this.count-=dt;
		if(this.count < 0)
		{
			this.labelTimeNum.setString("0.00");
			this.unschedule(this.countTimer);
			this.unschedule(this.check);
			
			var arrAction = new Array();
			arrAction.push(cc.DelayTime.create(2.0));
			arrAction.push(cc.CallFunc.create(this.endGame, this));
			this.runAction(cc.Sequence.create(arrAction));
		}
	},
	
	check:function(dt)
	{
		var max = 1;
		if(this.count < 20) max = 3;
		if(this.count < 10) max = 7;
		
		if(this.plusnum < max)
		{
			var arrDinos = new Array();
			
			if(this.dino1.getPoint() == 0) arrDinos.push(this.dino1);
			if(this.dino2.getPoint() == 0) arrDinos.push(this.dino2);
			if(this.dino3.getPoint() == 0) arrDinos.push(this.dino3);
			if(this.dino4.getPoint() == 0) arrDinos.push(this.dino4);
			if(this.dino5.getPoint() == 0) arrDinos.push(this.dino5);
			if(this.dino6.getPoint() == 0) arrDinos.push(this.dino6);
			if(this.dino7.getPoint() == 0) arrDinos.push(this.dino7);
			if(this.dino8.getPoint() == 0) arrDinos.push(this.dino8);
			if(this.dino9.getPoint() == 0) arrDinos.push(this.dino9);
			
			if(0 < arrDinos.length)
			{
				var n = Math.floor( Math.random() * arrDinos.length );
				var dinotarget = arrDinos[n];
				dinotarget.showDino();
				if(0 < dinotarget.getPoint())
				{
					this.plusnum++;
				}
			}
		}
	},
	
	endGame:function()
	{
		
		var highscore = cc.UserDefault.getInstance().getIntegerForKey("score", 0);
		if(highscore < this.score)
		{
			cc.UserDefault.getInstance().setIntegerForKey("score", this.score);
		}
		
		var tran = cc.TransitionFade.create(0.3, NameLayer.sceneWithScore(this.score));
		cc.Director.getInstance().replaceScene(tran);

	}

});


BattleLayer.scene = function(){
	var scene = cc.Scene.create();
    var layer = new BattleLayer();
	if (layer)
	{
		layer.init();
		scene.addChild(layer);
	}
    return scene;
}

var BattleScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new BattleLayer();
        this.addChild(layer);
        layer.init();
    }
});



