"use strict";

/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/



var DinoViewTag = 0;
var DinoViewTagDino			= DinoViewTag++;



var DinoView = NASView.extend({
	buttonDino:null,
	m_delegate:null,
	m_point:0,



	init:function (delegate) {

		//////////////////////////////
        // 1. super init first
        this._super();

        this.m_delegate = delegate;
        
        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        this.buttonDino = NASButtonView.buttonWithFile(s_BattleDinoU1, this);
        this.buttonDino.setTouchDownEffectEnable(false);
        this.addChild(this.buttonDino, DinoViewTagDino, DinoViewTagDino);
        
        return true;
    },

    showDino:function()
    {
    	this.buttonDino.setTouchEnable(true);
    	
    	var type = Math.floor( Math.random() * 10 );
    	
    	var arrAction = new Array();
    	
    	if (0 <= type && type <= 4)
    	{
    		this.m_point = 10;
    		
			arrAction.push(cc.MoveTo.create(0.2, cc.p(0, 85)));
			arrAction.push(cc.DelayTime.create(1.0));
			arrAction.push(cc.MoveTo.create(0.2, cc.p(0, 0)));
			arrAction.push(cc.DelayTime.create(0.5));
    		
    		this.buttonDino.setBackgroundWithFile(s_BattleDinoU1);
    	}
    	else if (5 <= type && type <= 7)
    	{
    		this.m_point = 30;
    		
			arrAction.push(cc.MoveTo.create(0.15, cc.p(0, 85)));
			arrAction.push(cc.DelayTime.create(0.66));
			arrAction.push(cc.MoveTo.create(0.15, cc.p(0, 0)));
			arrAction.push(cc.DelayTime.create(0.75));
    		
			this.buttonDino.setBackgroundWithFile(s_BattleDinoU2);
		}
    	else if (type == 8)
    	{
    		this.m_point = 50;
    		
			arrAction.push(cc.MoveTo.create(0.1, cc.p(0, 85)));
			arrAction.push(cc.DelayTime.create(0.33));
			arrAction.push(cc.MoveTo.create(0.1, cc.p(0, 0)));
			arrAction.push(cc.DelayTime.create(1.0));
    		
			this.buttonDino.setBackgroundWithFile(s_BattleDinoU3);
    	}
    	else
    	{
    		this.m_point = -50;
    		
			arrAction.push(cc.MoveTo.create(0.2, cc.p(0, 80)));
			arrAction.push(cc.DelayTime.create(0.5));
			arrAction.push(cc.MoveTo.create(0.2, cc.p(0, 0)));
			arrAction.push(cc.DelayTime.create(0.5));
    		
			this.buttonDino.setBackgroundWithFile(s_BattleDinoD1);
    	}
    	
		arrAction.push(cc.CallFunc.create(this.compAction, this));

		this.buttonDino.runAction(cc.Sequence.create(arrAction));
    	
    	return this.m_point;
    },
    
	compAction:function()
	{
		this.m_delegate.onDinoEventAction(this);
		this.m_point = 0;
	},
	
	getPoint:function()
	{
		return this.m_point;
	},
	
    //************************************************************
    // NASButtonViewDelegate
    //************************************************************
    buttonEvent:function(button, event, touch)
    {
        var tag = button.getTag();
        if (tag == DinoViewTagDino)
        {
            if(event == NASButtonViewEventTouchUpInside)
            {
                this.m_delegate.onDinoEventPush(this);
            	this.buttonDino.setTouchEnable(false);
            	
            	var spriteattack = cc.Sprite.create(s_BattleAttack);
            	spriteattack.setPosition((this.buttonDino.getContentSize().width / 2), (this.buttonDino.getContentSize().height / 2) + this.buttonDino.getPosition().y);
            	this.addChild(spriteattack);
            	
            	this.buttonDino.stopAllActions();
            	this.buttonDino.setPosition(cc.p(0, 0));
            	
            	var arrAction2 = new Array();
            	arrAction2.push(cc.FadeOut.create(0.5));
            	arrAction2.push(cc.CallFunc.create(spriteattack.removeFromParent, spriteattack));
            	spriteattack.runAction(cc.Sequence.create(arrAction2));
            	
            	var arrAction = new Array();
            	arrAction.push(cc.DelayTime.create(0.2));
            	arrAction.push(cc.CallFunc.create(this.compAction, this));
				this.buttonDino.runAction(cc.Sequence.create(arrAction));
				
				cc.AudioEngine.getInstance().playEffect(s_SoundHit);
            }
        }
    },

});



DinoView.create = function(delegate){
    var view = new DinoView();
    return (view.init(delegate)) ? view : null;
}



