"use strict";

/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/




var NameLayer = NASView.extend({
	editBox:null,
	_score:0,

    init:function (score) {

        //////////////////////////////
        // 1. super init first
        this._super();
        
        this._score = score;

		var size = cc.Director.getInstance().getWinSize();
		
		var spriteBG = cc.Sprite.create(s_NameBG);
		spriteBG.setPosition(size.width/2, size.height/2);
		this.addChild(spriteBG);

//		var labelScore = cc.LabelTTF.create("SCORE : "+score, "Impact", 20);
//    	labelScore.setAnchorPoint(cc.p(0.0, 0.5));
//    	labelScore.setPosition(cc.p(30, 255));
//        this.addChild(labelScore);


		var scale = cc.Director.getInstance().getContentScaleFactor();
		
		var nickname = cc.UserDefault.getInstance().getStringForKey("nickname", "AAA");

    	this.editBox = cc.EditBox.create(cc.size(260, 30));
		this.editBox.setBorderWidth(0);
		this.editBox.setText(nickname);
        this.editBox.setPosition(30*scale, 250*scale);
        this.editBox.setFontColor(new cc.Color3B(255, 255, 255));
        this.editBox.setMaxLength(3);
    	this.editBox.setDelegate(this);
        this.addChild(this.editBox);

		var buttonNext = NASButtonView.buttonWithFile(s_NameNext, this);
    	buttonNext.setPosition(cc.p(size.width/2-buttonNext.getContentSize().width/2, 40));
    	buttonNext.setTag(1);
    	this.addChild(buttonNext);
    	
    	
    	
        return true;
    },

	endScoreRegist:function(ret, ranklist)
	{
		this.editBox.removeFromParent(true);
	
		var tran = cc.TransitionFade.create(0.3, ResultLayer.sceneWithResult(ret, ranklist));
		cc.Director.getInstance().replaceScene(tran);
	},

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();
		if (tag == 1)
		{
			if(event == NASButtonViewEventTouchUpInside)
			{
				button.setTouchEnable(false);
				
				cc.UserDefault.getInstance().setStringForKey("nickname", this.editBox.getText());
				
				var api = new ranking_api();
				
				var target = this;
				
				api.append(this.editBox.getText(), this._score, "normal", function(obj, error) {
					target.endScoreRegist(obj.result, obj.list);
			    });
			}
		}
	}
});



NameLayer.sceneWithScore = function(score){
	var scene = cc.Scene.create();
    var layer = new NameLayer();
	if (layer)
	{
		layer.init(score);
		scene.addChild(layer);
	}
    return scene;
}
