/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

var rankingdata = function(){
	this.name = "";
	this.score = 0;
}

var rankingList = new Array()

var RankingLayer = NASView.extend({
    backgroundview:null,
    titleview:null,
    title:null,
    buttonview:null,
    titlebutton:null,
    scoreview:null,
    rankingno:null,
    rankingname:null,
    rankingscore:null,
    spriteloading:null,

    init:function () {

        //////////////////////////////
        // 1. super init first
        this._super();


        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();
		
		// base
		this.backgroundview = NASView.create();
		this.backgroundview.setPosition(0, 0);
		this.addChild(this.backgroundview, 1);
		
		this.background = cc.Sprite.create(s_RankingFrame);
		this.background.ignoreAnchorPointForPosition(true);
		this.background.setAnchorPoint(cc.p(0, 0));
		this.backgroundview.addChild(this.background, 1);
		
		
		// button
		this.buttonview = NASView.create();
		this.buttonview.setPosition(0, 0);
		this.addChild(this.buttonview, 2);
		
		this.titlebutton = NASButtonView.buttonWithFile(s_RankingTop, this);
		this.titlebutton.setTag(1);
		this.titlebutton.setPosition(20, 20);
		this.buttonview.addChild(this.titlebutton, 1);
		
		
		// score
		this.scoreview = NASView.create();
		this.scoreview.setPosition(0, 0);
		this.addChild(this.scoreview, 3);
		
		this.spriteloading = cc.Sprite.create(s_RankingLoading);
		this.spriteloading.setPosition(cc.p(size.width/2, size.height/2));
		this.addChild(this.spriteloading, 99);
		
		var arrAction = new Array();
		arrAction.push(cc.DelayTime.create(1.0));
		arrAction.push(cc.CallFunc.create(this.updateRank, this));
		this.runAction(cc.Sequence.create(arrAction));
		
//		var that = this;
//		var api = new ranking_api
//		api.list("normal", function(obj, error){
//			if (obj != null) {
//				// 何かしらの返答あり
//				var sStatus = obj["status_code"];
//				if (sStatus == 200) {
//					// 正常系
//						var result = obj["result"];
//						for (var i = 0; i < 5; i++)
//						{
//							var data = result[i];
//							
//							// 順位
//							that.rankingno = cc.LabelTTF.create(data["rank"], "Lucida Console", 30);
//							that.rankingno.setHorizontalAlignment(cc.TEXT_ALIGNMENT_RIGHT);
//							that.rankingno.setAnchorPoint(cc.p(1, 0));
//							that.rankingno.setPosition(size.width / 10, size.height - (size.height / 7) + 5 - (60 * (i+1)));
//							that.scoreview.addChild(that.rankingno, 1);
//							
//							// 名前
//							that.rankingname = cc.LabelTTF.create(data["name"], "Lucida Console", 30);
//							that.rankingname.setAnchorPoint(cc.p(1, 0));
//							that.rankingname.setPosition(170, size.height - (size.height / 7) + 5 - (60 * (i+1)));
//							that.scoreview.addChild(that.rankingname, 2);
//							
//							// スコア
//							that.rankingscore = cc.LabelTTF.create("：" + data["score"] + "点", "Lucida Console", 30);
//							that.rankingscore.setAnchorPoint(cc.p(0, 0));
//							that.rankingscore.setPosition(170, size.height - (size.height / 7) + 5 - (60 * (i+1)));
//							that.scoreview.addChild(that.rankingscore, 2);
//						}
//				} else {
//					// 異常の状態が返ってきた
//				}
//			} else {
//				if (error != null) {
//					// 正常に通信したけど値無し
//				} else {
//					// エラー系
//				}
//			}
//		});
		
		
        return true;
    },

	updateRank:function()
	{
		var size = cc.Director.getInstance().getWinSize();
		var that = this;
		var api = new ranking_api
		api.list("normal", function(obj, error){
			if (obj != null) {
				// 何かしらの返答あり
				var sStatus = obj["status_code"];
				if (sStatus == 200) {
					// 正常系
						var result = obj["result"];
						for (var i = 0; i < 5; i++)
						{
							var data = result[i];
							
							// 順位
							that.rankingno = cc.LabelTTF.create(data["rank"], "Lucida Console", 30);
							that.rankingno.setHorizontalAlignment(cc.TEXT_ALIGNMENT_RIGHT);
							that.rankingno.setAnchorPoint(cc.p(1, 0));
							that.rankingno.setPosition(size.width / 10, size.height - (size.height / 7) + 5 - (60 * (i+1)));
							that.scoreview.addChild(that.rankingno, 1);
							
							// 名前
							that.rankingname = cc.LabelTTF.create(data["name"], "Lucida Console", 30);
							that.rankingname.setAnchorPoint(cc.p(1, 0));
							that.rankingname.setPosition(170, size.height - (size.height / 7) + 5 - (60 * (i+1)));
							that.scoreview.addChild(that.rankingname, 2);
							
							// スコア
							that.rankingscore = cc.LabelTTF.create("：" + data["score"] + "点", "Lucida Console", 30);
							that.rankingscore.setAnchorPoint(cc.p(0, 0));
							that.rankingscore.setPosition(170, size.height - (size.height / 7) + 5 - (60 * (i+1)));
							that.scoreview.addChild(that.rankingscore, 2);
						}
						
						var arrAction = new Array();
						arrAction.push(cc.DelayTime.create(0.2));
						arrAction.push(cc.FadeOut.create(0.5));
						arrAction.push(cc.CallFunc.create(that.spriteloading.removeFromParent, that.spriteloading));
						that.spriteloading.runAction(cc.Sequence.create(arrAction));
						
				} else {
					// 異常の状態が返ってきた
				}
			} else {
				if (error != null) {
					// 正常に通信したけど値無し
				} else {
					// エラー系
				}
			}
		});
	},
	
	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var nextScene;
		
		var tag = button.getTag();
		if (event == NASButtonViewEventTouchUpInside)
		{
			if (tag == 1)
			{
				// タイトルへ戻る
				nextScene = new TitleScene();
			}
			var tran = cc.TransitionFade.create(0.3, nextScene);
			cc.Director.getInstance().replaceScene(tran);
		}
	},
});


var RankingScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new RankingLayer();
        this.addChild(layer);
        layer.init();
    }
});
