"use strict";

/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/



var ResultLayer = NASView.extend({
	
    init:function (result, ranklist) {

        //////////////////////////////
        // 1. super init first
        this._super();
		
		var size = cc.Director.getInstance().getWinSize();
		
		var spriteBG = cc.Sprite.create(s_ResultBG);
		spriteBG.setPosition(size.width/2, size.height/2);
		this.addChild(spriteBG);
		
    	var labeltest = cc.LabelTTF.create(result.score, "Impact", 20);
    	labeltest.setAnchorPoint(cc.p(1.0, 1.0));
    	labeltest.setPosition(cc.p(240, 363));
        this.addChild(labeltest);
        
        var nickname = cc.UserDefault.getInstance().getStringForKey("nickname", "AAA");
        
        var labelName = cc.LabelTTF.create(nickname, "Arial", 20);
    	labelName.setAnchorPoint(cc.p(0.0, 1.0));
    	labelName.setPosition(cc.p(20, 261));
        this.addChild(labelName);
        
    	var labeltest = cc.LabelTTF.create(result.rank, "Impact", 24);
    	labeltest.setAnchorPoint(cc.p(1.0, 1.0));
    	labeltest.setPosition(cc.p(170, 175));
        this.addChild(labeltest);
    	
		var buttonNext = NASButtonView.buttonWithFile(s_ResultNext, this);
    	buttonNext.setPosition(cc.p(size.width/2-buttonNext.getContentSize().width/2, 40));
    	buttonNext.setTag(1);
    	this.addChild(buttonNext);
    	
        return true;
    },

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();
		if (tag == 1)
		{
			if(event == NASButtonViewEventTouchUpInside)
			{
				button.setTouchEnable(false);
				
				var tran = cc.TransitionFade.create(0.3, new RankingScene());
				cc.Director.getInstance().replaceScene(tran);
			}
		}
	}



});



ResultLayer.sceneWithResult = function(result, ranklist)
{
	var scene = cc.Scene.create();
    var layer = new ResultLayer();
	if (layer)
	{
		layer.init(result, ranklist);
		scene.addChild(layer);
	}
    return scene;
}

