/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

var TitleLayer = NASView.extend({
    backgroundview:null,
    background:null,
    titleview:null,
    title:null,
    buttonview:null,
    gamebutton:null,
    rankingbutton:null,
    scoreview:null,
    score:null,
    normalscore:null,
    hardscore:null,

    init:function () {

        //////////////////////////////
        // 1. super init first
        this._super();
		
        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();
		
		// base
		this.backgroundview = NASView.create();
		this.backgroundview.setPosition(0, 0);
		this.addChild(this.backgroundview, 1);
		
		this.background = cc.Sprite.create(s_TopFrame);
		this.background.ignoreAnchorPointForPosition(true);
		this.background.setAnchorPoint(cc.p(0, 0));
		this.backgroundview.addChild(this.background, 1);
		
		
		// button
		this.buttonview = NASView.create();
		this.buttonview.setPosition(0, 0);
		this.addChild(this.buttonview, 2);
		
		this.gamebutton = NASButtonView.buttonWithFile(s_TopStart, this);
		this.gamebutton.setTag(1);
		this.gamebutton.setPosition(20, 100);
		this.buttonview.addChild(this.gamebutton, 1);
		
		this.rankingbutton = NASButtonView.buttonWithFile(s_TopRanking, this);
		this.rankingbutton.setTag(2);
		this.rankingbutton.setPosition(20, 10);
		this.buttonview.addChild(this.rankingbutton, 1);
		
		
		// score
		this.scoreview = NASView.create();
		this.scoreview.setPosition(0, 195);
		this.addChild(this.scoreview, 3);
		
		this.score = cc.LabelTTF.create("ハイスコア：" + this.getHighScore("score") + "点", "Impact", 15);
		this.score.setAnchorPoint(cc.p(0.5, 0));
		this.score.setPosition(size.width - (size.width / 3), 0);
		this.scoreview.addChild(this.score, 2);
		
		var selfPointer = this;
		this.adjustSizeForWindow();
		window.addEventListener("resize", function (event) {
			selfPointer.adjustSizeForWindow();
		});
		
        return true;
    },
    
	adjustSizeForWindow:function ()
	{
		var xScale = 0.0;
		var yScale = 0.0;
		var query = location.search;
	    if (typeof query !== undefined && query !== "") {
			this.m_bFrame = true;
	        var array = query.split("&");
	        for (var i = 0; i < array.length; i++) {
	            if (array[i].indexOf("w") > -1) {
					xScale = array[i].split("=")[1] / cc.originalCanvasSize.width;
//					alert("w:"+array[i].split("=")[1] + " ("+xScale+")");
	            }
	            if (array[i].indexOf("h") > -1) {
					yScale = array[i].split("=")[1] / cc.originalCanvasSize.height;
//					alert("h:"+array[i].split("=")[1] + " ("+yScale+")");
	            }
	        }
	    }
        var margin = document.documentElement.clientWidth - document.body.clientWidth;
        
        cc.canvas.width = document.documentElement.clientWidth - margin;
        cc.canvas.height = document.documentElement.clientHeight - margin;

		if (xScale == 0)
		{
	        xScale = cc.canvas.width / cc.originalCanvasSize.width;
	    }
	    if (yScale == 0)
	    {
	        yScale = cc.canvas.height / cc.originalCanvasSize.height;
	    }

        if (xScale > yScale) {
            xScale = yScale;
        }
        cc.canvas.width = cc.originalCanvasSize.width * xScale;
        cc.canvas.height = cc.originalCanvasSize.height * xScale;
        var parentDiv = document.getElementById("Cocos2dGameContainer");
        if (parentDiv) {
            parentDiv.style.width = cc.canvas.width + "px";
            parentDiv.style.height = cc.canvas.height + "px";
        }
        
        cc.renderContext.translate(0, cc.canvas.height);
        cc.renderContext.scale(xScale, xScale);
        cc.Director.getInstance().setContentScaleFactor(xScale);
    },

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var nextScene;
		
		var tag = button.getTag();
		if (event == NASButtonViewEventTouchUpInside)
		{
			if (tag == 1)
			{
				// game start
				nextScene = BattleLayer.scene();
			}
			else if (tag == 2)
			{
				// ranking
				nextScene = new RankingScene();
			}
			
			var tran = cc.TransitionFade.create(0.3, nextScene);
			cc.Director.getInstance().replaceScene(tran);
		}
	},
	
	
	//**************************************************
	// ハイスコアを取得
	//**************************************************
	getHighScore:function(Key)
	{
		return cc.UserDefault.getInstance().getIntegerForKey(Key, 0);
	}
});



var TitleScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new TitleLayer();
        this.addChild(layer);
        layer.init();
    }
});
