/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011      Zynga Inc.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

var MyLayer = NASView.extend({
    isMouseDown:false,
    helloImg:null,
    helloLabel:null,
    circle:null,
    sprite:null,
    sampleview:null,
	helloLabel2:null,
	samplebutton:null,
	samplebutton2:null,

    init:function () {

        //////////////////////////////
        // 1. super init first
        this._super();

        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask director the window size
        var size = cc.Director.getInstance().getWinSize();

		this.sampleview = NASView.create();
		this.sampleview.setPosition(size.width / 2, size.height/2);
		this.addChild(this.sampleview, 2);

        this.helloLabel = cc.LabelTTF.create("Ranking - normal -", "Arial", 24);
        this.helloLabel.setPosition(cc.p(size.width / 2, size.height - 40));
        this.addChild(this.helloLabel, 5);

        // 乱数で点数をつける
        score = Math.floor(Math.random() * 200 + 1);

        // 初期登録
        var api = new ranking_api();
        var list = null;
        var result = null;

        list = [
                {"name": "1", "score": 10, "uid": "1"},
                {"name": "2", "score":  9, "uid": "2"},
                {"name": "3", "score":  8, "uid": "3"},
                {"name": "4", "score":  7, "uid": "4"},
                {"name": "5", "score":  6, "uid": "5"}
            ]
/*
        api.append("AAA", score, "normal", function(obj, error) {
            result = obj.result;
            list = obj.list;
        });
*/

        list.forEash(function(item, i) {

        });

/*
        // ランキング表示
        var api = new ranking_api();
        var rank_list = "Rank\n";
        var name_list = "Name\n";
        var score_list = "Score\n";
        api.list('normal', function(obj, error) {
            var results = obj.result;
            results.forEach(function(item, i) {
                rank_list  += item.rank  + '\n';
                name_list  += item.name  + '\n';
                score_list += item.score + '\n';
            });
        });

        this.rankLabel = cc.LabelTTF.create(rank_list, "Arial", 24);
        this.rankLabel.setPosition(cc.p(size.width / 5, 220));
        this.addChild(this.rankLabel, 6);

        this.nameLabel = cc.LabelTTF.create(name_list, "Arial", 24);
        this.nameLabel.setPosition(cc.p(size.width / 2, 220));
        this.addChild(this.nameLabel, 7);

        this.scoreLabel = cc.LabelTTF.create(score_list, "Arial", 24);
        this.scoreLabel.setPosition(cc.p(size.width - 50, 220));
        this.addChild(this.scoreLabel, 8);
*/

//        lazyLayer.addChild(this.sprite, 0);
//      var api = new ranking_api();
//      var xhr = api.append('AAA', 100, 'normal', function(obj, error) {
//          var result = obj.result;
//          alert(result.uid);
//      });

        return true;
    },

	//************************************************************
	// NASButtonViewDelegate
	//************************************************************
	buttonEvent:function(button, event, touch)
	{
		var tag = button.getTag();
		if (tag == 1)
		{
			if(event == NASButtonViewEventTouchUpInside)
			{
				var scene = new MyScene();
				var tran = cc.TransitionFade.create(0.3, scene);
				cc.Director.getInstance().replaceScene(tran);
			}
		}
		else if (tag == 2)
		{
			if(event == NASButtonViewEventTouchUpInside)
			{
//				this.helloLabel2.setString("!on 12!");
                var api = new ranking_api();
                var uid = null;
                var name = null;
                uid = prompt('please input uid.', '');
                if ( uid != null )
                {
                    name = prompt('please input name.', 'AAA');
                    if (name != null)
                    {
                        api.rename(uid, name, function(obj, error) {
                            if (obj.status_code == 200)
                            {
                                alert('OKOK');
                            } else {
                                alert('NGNG');
                            }
                        });
                    }
                }

                api.list('normal', function(obj, error) {
                    var results = obj.result;
                    var list = "";
                    results.forEach(function(item, i) {
                        list += "Rank : " + item.rank + "\tName : " + item.name + "\tScore : " + item.score + "\n";
                    });

                    alert(list);
                });
			}
		}
	}
});



var MyScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new MyLayer();
        this.addChild(layer);
        layer.init();
    }
});



