
var RANKING_API_GET  = "GET";
var RANKING_API_POST = "POST";
var RANKING_API_PUST = "PUT";

var RANKING_API_URL = "http://gm-ranking-api.herokuapp.com/"

// 追加
var RANKING_API_APPEND = RANKING_API_URL;

// 名前変更
var RANKING_API_RENAME = RANKING_API_URL;

// ランキングリスト
var RANKING_API_LIST = RANKING_API_URL + "list/"


var ranking_api = cc.Class.extend ({
  _createHttpRequest: function() {
    var obj = null;
    try { // Safari, Mozilla, Opera, IE7 ~
      obj = new XMLHttpRequest();
    }
    catch(e) {
      try { // IE6
        obj = new ActiveXObject("Msxml2.XMLHTTP");
      }
      catch(e) {
        try { // IE5, 5.5
          obj = new ActiveXObject("Microsoft.XMLHTTP");
        }
        catch(e)
        {
        }
      }
    }
    return obj;
  },
  append: function(name, score, mode, callback) {
    var data = JSON.stringify({'name': name, 'score': score, 'mode': mode});
    var xhr = this._createHttpRequest();
    if (xhr != null)
    {
      xhr.open("POST", RANKING_API_APPEND, false);
      xhr.setRequestHeader("Content-Type", "application/json; charset=UTF-8");

      xhr.onreadystatechange = function() {
        var obj = null;
        var error = null;

        if (xhr.readyState == 4)
        {
          if (xhr.status == 200 || xhr.status == 201)
          {
            if (xhr.responseText)
            {
              obj = JSON.parse(xhr.responseText);
            }
          } else {
            // エラーを取得しなきゃダメ
            error = new ranking_api_error();
          }
          callback(obj, error);
        }
      }
      xhr.send(data);
    } else {
      // エラーを取得しなきゃダメ
      error = new ranking_api_error();
    }
    return xhr;
  },
  rename: function(uid, name, callback) {
    var data = JSON.stringify({'name': name, 'uid': uid});
    var xhr = this._createHttpRequest();
    if (xhr != null)
    {
      xhr.open("PUT", RANKING_API_RENAME, false);
      xhr.setRequestHeader("Content-Type", "application/json; charset=UTF-8");

      xhr.onreadystatechange = function() {
        var obj = null;
        var error = null;

        if (xhr.readyState == 4)
        {
          if (xhr.status == 200 || xhr.status == 201)
          {
            if (xhr.responseText)
            {
              obj = JSON.parse(xhr.responseText);
            }
          } else {
            // エラーを取得しなきゃダメ
            error = new ranking_api_error();
          }
          callback(obj, error);
        }
      }
      xhr.send(data);
    } else {
      // エラーを取得しなきゃダメ
      error = new ranking_api_error();
    }
  },
  list: function(mode, callback) {
    var xhr = this._createHttpRequest();
    if (xhr != null)
    {
      xhr.open("GET", RANKING_API_LIST + mode, false);

      xhr.onreadystatechange = function() {
        var obj = null;
        var error = null;

        if (xhr.readyState == 4)
        {
          if (xhr.status == 200 || xhr.status == 201)
          {
            if (xhr.responseText)
            {
              obj = JSON.parse(xhr.responseText);
            }
          } else {
            // エラーを取得しなきゃダメ
            error = new ranking_api_error();
          }
          callback(obj, error);
        }
      }
      xhr.send();
    } else {
      // エラーを取得しなきゃダメ
      error = new ranking_api_error();
    }
  }
});



// ***
// ranking_api_error
// ***
var ranking_api_error = cc.Class.extend({
  init: function() {

  }
})
