# App 

> The Open DRadio App - [https://opendradio.org](https://opendradio.org).

[![Build Status: Linux](https://img.shields.io/travis/opendradio/app.svg?branch=master&style=flat-square)](https://travis-ci.org/opendradio/app)
[![Node.JS Dependency Status](https://www.versioneye.com/user/projects/5506fc6366e5616353000147/badge.svg?style=flat-square)](https://www.versioneye.com/user/projects/5506fc6366e5616353000147)
[![JavaScript Dependency Status](https://www.versioneye.com/user/projects/5506ffb366e561bb9b000177/badge.svg?style=flat-square)](https://www.versioneye.com/user/projects/5506ffb366e561bb9b000177)
[![License](https://img.shields.io/badge/license-AGPL--3.0-blue.svg?style=flat-square)](https://www.gnu.org/licenses/agpl-3.0.html)

---

## Features

With the app, you can:

* Listen to live-streams (webstream or fm radio)
* View latest/or archived broadcast information
* Read news, reports, interviews and press reviews
* Get detailed background information on the shows
* Create radio alarm clocks
* Find radio frequencies near you (GPS)
* Recieve push notifications for current events
* SSL secured API
* Customize your in-app experience

## Languages

The app currently supports the following languages [`ISO 639`](http://www.loc.gov/standards/iso639-2/php/code_list.php]):  
German deutsch `de-DE`, **English (U.S.)** `en-US` (default), polski `pl`.

#### Translations

Please feel free to join the translations team at [OneSky](http://ostsacf.oneskyapp.com/collaboration/project?id=24084).  
It's very simple and free.

## Screenshot

![Screenshot](https://raw.githubusercontent.com/opendradio/app/master/screenshot.png)

## Architecture

[![JavaScript](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/javascript/javascript-short-flat.png)](http://www.w3.org/standards/webdesign/script.html)
[![Backbone](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/backbone/backbone-short-flat.png)](http://backbonejs.org/)
[![Lodash](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/lo-dash/lodash-short-flat.png)](https://lodash.com/)
[![Mustache](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/mustache/mustache-short-flat.png)](https://mustache.github.io/)

[![Uses HTML5 Technology](http://www.w3.org/html/logo/badge/html5-badge-h-connectivity-css3-device-graphics-multimedia-performance-semantics-storage.png)](http://www.w3.org/html/logo/)

This app is built using a [HTML5](https://en.wikipedia.org/wiki/HTML5) + [REST](https://en.wikipedia.org/wiki/Representational_state_transfer) approach and is mainly written in JavaScript with [AMD](http://en.wikipedia.org/wiki/Asynchronous_module_definition) (Asynchronous Module Definition) and [MVVM](http://en.wikipedia.org/wiki/Model_View_ViewModel) (Model View ViewModel) patterns.

It is based on top of [Chaplin JS](http://chaplinjs.org/), backed up by [Backbone JS](http://backbonejs.org/) where the magic happens.

## Build the app

[![Grunt](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/grunt/grunt-long-flat.png)](http://gruntjs.com/)
[![Built with Bower](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/bower/bower-long-flat.png)](http://bower.io/)
[![JSHint](https://raw.githubusercontent.com/pixel-cookers/built-with-badges/master/jshint/jshint-long-flat.png)](http://jshint.com/)

### Getting Started

You need node `>=0.10` to work predictably.

#### Preparing your system

Running the build and deploy processes to compile the source code requires [Grunt](http://gruntjs.com/) `>=0.4.5` and [Bower](http://bower.io/) `>=1.3.9` to install the dependencies.

* **npm** - *Package manager for node*  
`npm` is installed as part of node.
* **Grunt** - *The leading task runner for node*  
Installing [Grunt](http://gruntjs.com/) is simple when you have `npm`:

        $ npm install -g grunt-cli
    
    If you haven't used [Grunt](http://gruntjs.com/) before, be sure to check out the [Getting Started](http://gruntjs.com/getting-started) guide. Once you're familiar with that processes, you may continue.
* **Bower** - *An web package manager*  
Before installing [Bower](http://bower.io/), make sure that `git` is installed:

        $ npm install -g bower
    
    If you haven't used [Bower](http://bower.io/) before, be sure to read the [Getting Started](http://bower.io/#getting-started) guide.
* **GraphicsMagick** - *An image processing system*  
In order to resize images automatically during the build & deploy tasks, you'll need to install the latest version of [GraphicsMagick](http://www.graphicsmagick.org/).
      
    Fedora:

        $ sudo yum install GraphicsMagick
    
    Ubuntu:

        $ sudo apt-get install graphicsmagick
    
    Mac:

        $ brew install graphicsmagick

### Targeted Platforms

The app currently supports the following platforms (devices) for now:

* [Android](https://www.android.com/) `32` (Blink)
* [Firefox OS](https://www.mozilla.org/en-US/firefox/os/) `1.3` (equal to Firefox/Gecko `27`)
* [Google Chrome](https://chrome.google.com/) `42` (Blink)

> Please notice:  
> iOS is not supported atm. However, due to the lack of an iPhone device and additional funds to pay the developer program ($99 / Year), I am not able to test the functionalities.  
> Donations are welcome.

### Usage

#### Install the dependencies

1. Change to the top-level project directory.
2. Run the install task. This will install `bower` dependencies to `src/vendor` (you can find a list of dependencies [here](http://opendradio.org/docs/app/dependencies)).  

        $ npm install

Your environment is now ready for app deployment. Open `src/index.html` in your browser.

### Building

Builds the app for the targeted platform:

```sh
$ grunt build:<platform>
```

* `chrome` for [Google Chrome](https://chrome.google.com/)
* `firefox-os` for [Firefox OS](https://www.mozilla.org/en-US/firefox/os/)

Final builds are stored in the `build/platform/<platform>/.deploy` directory.

**Parameters**

| Name              | Type        | Description |
| ----------------- | ----------- | ----------- |
| `--api-key`       | `option`    | The API key. |
| `--mapbox-map-id` | `option`    | The [mapbox.js](https://www.mapbox.com/mapbox.js/api/) API ID of the map you want to display. |
| `--mapbox-token`  | `option`    | The [mapbox.js](https://www.mapbox.com/mapbox.js/api/) API access token for the web services API. |
| `--gcm-sender-id` | `option`    | The [Google Cloud Messaging](https://developers.google.com/cloud-messaging/) sender id (only for Android and Google Chrome). |
| `--debug-mode`    | `flag`      | Prevent stripping of `console`, `alert` and `debugger` statements. |
| `--skip-jshint`   | `flag`      | Skip the `jshint` task. |

**Mapbox**

> To obtain the map id and an access token, sign in to [Mapbox](https://www.mapbox.com/account/apps/) and visit the *Account Apps* page.

### Deploying

Deploys the build for the targeted platform:

```sh
$ grunt deploy:<platform>
```

* `chrome` - Packages to `.zip`.
* `firefox-os` - Packages to `.zip`.

Deployable builds are stored in the `dist/<platform>/<version>` directory.

**Parameters**

| Name              | Type        | Description |
| ----------------- | ----------- | ----------- |
| `--use-version`   | `option`    | Overwrite the version of the deployment. |
| `--build`         | `flag`      | Run the `build` task *before* the deploying. |

## Testing

### Unit Tests

This app aims to be fully unit-tested. At the moment most of the modules are covered by [Mocha](http://mochajs.org/) and powered by [PhantomJS](http://phantomjs.org/) tests.

From the filesystem directory that contains the `tests` directory,

How to run the tests:

1. Follow the steps for [prepare your environment](#usage).
2. Run unit tests - Change to the top-level project directory.
3. Start the test runner.

        $ npm test

Note that you can now additionally open `test/index.html` to run the tests in your browser (instead of in node).

**Parameters**

| Name              | Type        | Description |
| ----------------- | ----------- | ----------- |
| `--skip-bower`    | `flag`      | Skip the `bower update` task. |

### Browser Tests

This app aims to be runned under Firefox/Gecko `>=28` ([Gecko](https://wiki.mozilla.org/Releases#Based_on_Gecko_28)) and Google Chrome `>=38`.

> Before testing in Google Chrome:  
> Google Chrome does not support `localhost` XMLHttpRequests (RequireJS). Don't panic.  
> By using the `--allow-file-access-from-files` option you should be able to run your tests in Google Chrome with no hassles.
>  
> See [Issue 4197: Further restrict access of file URL](https://code.google.com/p/chromium/issues/detail?id=4197&can=1&q=allow-file-access-from-files&colspec=ID%20Stars%20Pri%20Area%20Feature%20Type%20Status%20Summary%20Modified%20Owner%20Mstone%20OS)

## Roadmap

Our [roadmap](https://docs.google.com/a/opendradio.org/document/d/1lckCB_e27t1TnPuvIF202oWKG5T97xUSwfqSrDMKv0E) gives you a glimpse of upcoming features and how we want to take the project forward.

### Summary

**Features**

* [Add support for WebFM API](opendradio/app#2)  
    
      > Expected completion Q2/Q3 2015
* [Add press reviews from Deutschlandfunk and Deutschlandradio Kultur](opendradio/app#3)  
    
      > Expected completion Q2/Q3 2015

**Platforms**

* [BlackBerry](opendradio/app#18)  
    
      > Expected completion Q2/Q3 2015
* [Windows Phone](opendradio/app#19)  
    
      > Expected completion Q3/Q4 2015
* [Fire OS](opendradio/app#21)  
    
      > Expected completion Q3/Q4 2015
* [Tizen](opendradio/app#20)  
    
      > Expected completion Q3/Q4 2015

**Translations**

* Hebrew עברית `he` (General *Right-to-left* `CSS` direction support)
* Russian ру́сский `ru`
* Spanish español `es`
* Italian italiano `it`
* French français `fr`

## License

[Open DRadio](https://opendradio.org/) is an non-profit, open source project.

This code is open-sourced software licensed under the [AGPL-3.0 license](http://www.gnu.org/licenses/agpl-3.0.html).

## Disclaimer

#### European Union / United States

> This software is not supported or endorsed in any way by the service providers it interoperates with. It neither tries to mimic or replace any software originally conceived by those services' owners.
> 
> In the same manner, any third party's trademark or intellectual property that may appear in this software must be understood as a strictly illustrative reference to the service provider it represents, and will never be used in any way that may lead to confusion, so no abuse is intended.
>
> - Deutschlandradio, Deutschlandfunk, Deutschlandradio Kultur and DRadio Wissen are either registered trademarks or trademarks of the Deutschlandradio Service GmbH, Raderberggürtel 40, 50968 Köln, Germany.
> - Android and Google Chrome are either registered trademarks or trademarks of Google Inc in the U.S. and/or other countries.
> - BlackBerry is a registered trademark of Research In Motion Limited in the U.S. and/or other countries.
> - Firefox OS, Firefox and Mozilla are registered trademarks of the Mozilla Foundation.
> - IOS is a trademark or registered trademark of Cisco in the U.S. and/or other countries and is used under license of Apple Inc.
> - Tizen is a registered trademark of The Linux Foundation in the U.S. and/or other countries.
> - Windows Phone are either registered trademarks or trademarks of Microsoft Corporation in the U.S. and/or other countries.
> 
> According to Article 6 of the 1991 EU Computer Programs Directive and Sec. 103(f) of the DMCA, any technological measures circumvention that might be carried out for the creation of this software is totally legitimate as its purpose is "enabling interoperability of an independently created computer program with other programs" and "indispensable to obtain the necessary information to achieve the interoperability of an independently created program with other programs [...] to make it possible to connect all components of a computer system, including those of different manufacturers, so that they can work together". The public release of information acquired by those means is also permitted "solely for the purpose of enabling interoperability of an independently created computer program with other programs".
