
function createOptionScreen(list) {
    if(list != undefined) {
        hideImages(list, false);    
    }
    
    var bg = Crafty.e("2D, Canvas, Image, Mouse").attr({x:0,y:0,w:480,h:280}).image('images/menu_bg.png');

    var optionBg = Crafty.e("2D, Canvas, Image, Mouse").image('images/option_back.png');
    optionBg.x = bg._x+130; optionBg.y = bg._y+30;
    
    var optionTag = Crafty.e("2D, Canvas, Image, Mouse").image("images/options_button.png");
    optionTag.x = optionBg._x+60; optionTag.y = optionBg._y+20;
    
    var soundTag = Crafty.e("2D, Canvas, Image, Mouse").image("images/sound.png");
    soundTag.x = optionBg._x+60; soundTag.y = optionBg._y+100;
    
    var offBtn = Crafty.e("2D, Canvas, Image, Mouse, SoundOff1");
    offBtn.x = optionBg._x+65;  offBtn.y = optionBg._y+140;
    offBtn.originX = offBtn._x;
    
    var onBtn = Crafty.e("2D, Canvas, Image, Mouse, SoundOn1");
    onBtn.x = optionBg._x+65;   onBtn.y = optionBg._y+140;
    onBtn.originX = onBtn._x;
    
    var backBtnHover = Crafty.e("2D, Canvas, Image, Mouse, BackBtn2");
    backBtnHover.x = bg._x+418;   backBtnHover.y = bg._y+225;   
    
    var backBtn = Crafty.e("2D, Canvas, Image, Mouse, BackBtn1");
    backBtn.x = bg._x+418;   backBtn.y = bg._y+225;    

    
	if(getAudioIsMuted()) {
        offBtn.visible = true;
        onBtn.visible = false;
        onBtn.x = -1000;
    }
	else {
        offBtn.visible = false;
        onBtn.visible = true;
        offBtn.x = -1000;
    }
            
    offBtn.bind("MouseDown", function(e) {
        console.log("menu off btn clicked");
        setAudioIsMuted(false)
        onBtn.visible = true;
        offBtn.visible = false;
        offBtn.x = -1000;
        onBtn.x = onBtn.originX
        soundDown = false;
        playBgMusic("BgmMenu")
            
	});

	onBtn.bind("MouseDown", function(e) {
        console.log("menu on btn clicked");
        setAudioIsMuted(true)
        offBtn.visible = true;
        onBtn.visible = false;
        offBtn.x = offBtn.originX
        onBtn.x = -1000;
        soundDown = true;
        Crafty.audio.stop();
        setBgMusicPlaying();
    });
    
    
    bg.bind("MouseUp", function(e) {
        backBtn.alpha = 1;
    });
    optionBg.bind("MouseUp", function(e) {
        backBtn.alpha = 1;
    });
       
    
    backBtn.bind("MouseDown", function(e) {
        backBtn.alpha = 0.01;
    });
    backBtn.bind("MouseUp", function(e) {
        backBtn.alpha = 1;
        deleteImages([bg, optionBg, backBtnHover, optionTag, offBtn, onBtn, backBtn, soundTag]);
    });
 
}

