var reset = true;
var dessin = new jsDraw.Dessin();
var colorPicker = new jsDraw.ColorPicker(function() {
  dessin.color(this.color);
});

function handleClick(evt) {
  var buttonId = evt.target.id;
  if (buttonId == 'bNew') {
    dessin.clearUndo();
    dessin.fill(new jsDraw.Color({
      r: 255, g: 255, b: 255
    }));
  } else if (buttonId == 'bOpen') {
    if (window.MozActivity) {
      // FirefoxOS
      var activity = new MozActivity({
        name: 'pick',
        data: {
           type: 'image/*'
        }
      });
      activity.onsuccess = function() {
        dessin.clearUndo();
        var blob = this.result.blob;
        var img = new Image();
        img.src = window.URL.createObjectURL(blob);
        img.addEventListener('load', handleLoadImage, false);
      }
      activity.onerror = function() {
        var error = this.error.name;
        if (error.toLowerCase().indexOf('cancel') < 0) {
          alert('Unable to load the file: ' + error);
        }
      }
    } else {
      // PC
      var input = document.createElement('input');
      input.type = 'file';
      input.accept = 'image/*';
      setTimeout(function() {
        input.click();
      }, 100);
      input.addEventListener('change', handleSelectFile, false);
    }
  } else if (buttonId == 'bSave') {
    reset = false;
    var image = new Image();
    image.addEventListener('load', handleSaveImage, false);
    image.src = dessin.canvas.toDataURL();
  } else if (buttonId == 'bPencil') {
    dessin.mode(jsDraw.CRAYON);
  } else if (buttonId == 'bErase') {
    dessin.mode(jsDraw.GOMME);
  } else if (buttonId == 'bColor') {
    colorPicker.show();
  } else if (buttonId == 'bFill') {
    dessin.mode(jsDraw.REMPLIR);
  } else if (buttonId == 'bUndo') {
    dessin.undo();
  } else if (buttonId == 'bRedo') {
    dessin.redo();
  }
}

function handleSelectFile(evt) {
  var files = evt.target.files;
  for (var i = 0, f; f = files[i]; i++) {
    dessin.clearUndo();
    // IMAGE
    var image = new Image();
    image.addEventListener('load', handleLoadImage, false);
    var reader = new FileReader();
    reader.readAsDataURL(f);
    image.src = reader.result;
  }
}

function handleLoadImage(evt) {
  dessin.load(evt.target);
}

function saveAndSend(blob, file) {
  var dest = navigator.getDeviceStorage('pictures');
  var request = dest.addNamed(blob, file);
  request.onsuccess = function () {
    var sharingImage = new MozActivity({
      name: 'share',
      data: {
        type: 'image/*',
        number: 1,
        blobs: [blob],
        filenames: [file],
        filepaths: [file]
      }
    });
    reset = true;
  }
  request.onerror = function () {
    alert('Unable to write the file: ' + this.error.name);
    reset = true;
  }
}

function handleSaveImage(evt) {
  var name = window.prompt('Nom de l\'image', 'sans_titre');
  var file = name + '.png';
  if (name.indexOf('.png') > 0) {
    file = name;
  }
  var canvas = dessin.canvas;
  if(window.MozActivity) {
    // FirefoxOS
    canvas.toBlob(function(blob) {
      saveAndSend(blob, file)
    });
  } else {
    var url = canvas.toDataURL('image/png');
    var lien = document.createElement('a');
    document.body.appendChild(lien);
    lien.href = url;
    lien.target = '_blank';
    lien.download = file;
    lien.click();
    document.body.removeChild(lien);
    reset = true;
  }
}

function drawPoint(canvas, x , y) {
  var ctx = canvas.getContext('2d');
  var max = 40;
  if (canvas.height > canvas.width && y > max && y < canvas.height - max) {
    var width = y * max / canvas.height;
    dessin.size(width);
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = '#222222';
    ctx.beginPath();
    ctx.arc(canvas.width / 2, y, width, 0, 2 * Math.PI, false);
    ctx.closePath();
    ctx.fill();
  } else if (canvas.width > canvas.height && x > max && x < canvas.width - max) {
    var width = x * max / canvas.width;
    dessin.size(width);
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = '#222222';
    ctx.beginPath();
    ctx.arc(x, canvas.height / 2, width, 0, 2 * Math.PI, false);
    ctx.closePath();
    ctx.fill();
  }
}

function handleEditSize(evt) {
  evt.preventDefault();
  var editor = document.getElementById('dEditSize');
  editor.style.display = 'block';
  var canvas = document.getElementById('cEditSize');
  canvas.width = editor.clientWidth;
  canvas.height = editor.clientHeight;
  drawPoint(canvas, 0, 0);
}

function handleChangeSize(evt) {
  evt.preventDefault();
  var canvas = evt.target;
  var position = jsDraw.locate(canvas, evt);
  drawPoint(canvas, position.x, position.y);
}

function handleRemove(evt) {
  var editor = document.getElementById('dEditSize');
  editor.style.display = 'none';
}

function init() {

  var menu = document.getElementById('dMenu');

  var buttons = document.getElementsByTagName('button');

  var marge = menu.clientHeight * 0.2;
  
  for (var i = 0; i < buttons.length; i++) {
    if (buttons[i].parentElement.id == 'dMenu') {
      buttons[i].style.marginTop = marge + 'px';
      buttons[i].style.marginLeft = marge / 4 + 'px';
      buttons[i].style.marginBottom = marge + 'px';
      buttons[i].style.width = menu.clientHeight * 0.55 + 'px';
      buttons[i].style.height = menu.clientHeight * 0.55 + 'px';
      buttons[i].addEventListener('click', handleClick, false);
    }
  }
  document.getElementById('bSize').addEventListener('click', handleEditSize, false);

  if (reset) {
    dessin.resize(document.body.clientWidth * 0.99, document.body.clientHeight * 0.89);
    dessin.fill(new jsDraw.Color({
      r: 255, g: 255, b: 255
    }));
  }
  
  colorPicker.resize();

  var editor = document.getElementById('dEditSize');
  var canvas = document.getElementById('cEditSize');
  canvas.width = editor.clientWidth;
  canvas.height = editor.clientHeight;

  // FirefoxOS
  canvas.addEventListener('touchmove', handleChangeSize, false);
  canvas.addEventListener('touchend', handleRemove, false);

  // PC
  canvas.addEventListener('mousemove', handleChangeSize, false);
  canvas.addEventListener('mousedown', handleRemove, false);
}

window.onload = init;
window.onresize = init;
