
// Experimental version, just prototyping

paper.install(window);
var tool_line, tool_circle;

window.onload = function() {
    var canvas = document.getElementById('myCanvas');
    canvas.width = 312;
    canvas.height = 393;
    tool_line = new Tool();
    tool_circle = new Tool();
    paper.setup(canvas);
    var compoundedPath;
    var paths = new Array();
    var path = new Path();
    var rotate_degrees = [2,3,4,-2,-3,-4];
    var counter = 0;
    var current_index = 0;
    var isRotate = false;


    var colors = [
        new RgbColor(241/255, 196/255, 15/255),
        new RgbColor(211/255, 84/255, 0/255),
        new RgbColor(192/255, 57/255, 43/255),
        new RgbColor(127/255, 140/255, 141/255),
        new RgbColor(52/255, 73/255, 94/255),
        new RgbColor(236/255, 240/255, 241/255),
        new RgbColor(39/255, 174/255, 96/255),
        new RgbColor(22/255, 160/255, 133/255)
    ];
    var cssColors = [
        "rgb(241, 196, 15) ",
        "rgb(211, 84, 0)   ",
        "rgb(192, 57, 43)  ",
        "rgb(127, 140, 141)",
        "rgb(52, 73, 94)   ",
        "rgb(236, 240, 241) ",
        "rgb(39, 174, 96)  " ,
        "rgb(22, 160, 133)"
    ];
    var colorsIndex = 0;
    var strokeIndex = 1;
    $("#go-color").css("color", cssColors[colorsIndex]);
    currentColor = colorsIndex[0];
    currentStroke = 1;
    tool_line.activate();
    function get_random_float(min, max) {
        return Math.random() * (max - min) + min;
    }
    function get_random_color() {
        var a = get_random_float(0.0,1.0);
        var b = get_random_float(0.0,1.0);
        var c = get_random_float(0.0,1.0);

        return new RgbColor(a,b,c);
    }
    function onMouseDown(event) {
        path = new Path();

        //rotate_degrees.push(get_random_float(-5,5));
        path.strokeColor = colors[colorsIndex];
        path.strokeWidth = currentStroke;
        current_index = counter;
        path.add(event.point);
        paths.push(path);
        counter++;
    }

    function onMouseUp(event) {
        paths[current_index].simplify();

    }

    function go_stroke_handler(e){
        strokeIndex = 1 + (strokeIndex)%(6);
        $("#go-stroke").html(strokeIndex);
        currentStroke = strokeIndex;
    }

    function go_color_handler(e){
        colorsIndex++;
        if(colorsIndex === colors.length){
            colorsIndex = 0;
        }
        $("#go-color").css("color", cssColors[colorsIndex]);
        currentColor = colors[colorsIndex];
    }
    function go_rotate_handler(e){
        isRotate = !isRotate;
    }
    function go_clear_handler(e){
        for (var i = paths.length - 1; i >= 0; i--) {
            paths[i].removeSegments();
        };
        paths = new Array();
        current_index = 0;
        counter = 0;
    }
    function go_save_handler(e){
        //isRotate = !isRotate;
        drawYeahDB.indexedDB.addDrawing( document.getElementById('myCanvas').toDataURL());
    }
    function bindEvents(){
        tool_line.onMouseDown = onMouseDown;
        tool_circle.onMouseDown = onMouseDown;
        tool_line.onMouseUp = onMouseUp;
        tool_line.onMouseDrag = function(event) {
            paths[current_index].add(event.point);
        }
        tool_circle.onMouseDrag = function(event) {
            paths[current_index].arcTo(event.point);
        }

        $("#go-stroke").on("click", go_stroke_handler);
        $("#go-color").on("click", go_color_handler);
        $("#go-rotate").on("click", go_rotate_handler);
        $("#go-clear").on("click", go_clear_handler);
        $("#go-save").on("click", go_save_handler);

    }
    bindEvents();
    view.onFrame = function(event){
        if (isRotate === true){
            compoundedPath = new CompoundPath(paths);
        }
        for (var i = paths.length - 1; i >= 0; i--) {
            if (isRotate === true){
                compoundedPath.rotate(rotate_degrees[0]);
            }
            //paths[i].strokeColor.hue += 0.2;
        };
    }
    view.draw();
}