function onBodyLoad() {
    // are we running in native app or in a browser?
    window.isphone = false;
    var isPhone = false;
    if(document.URL.indexOf("http://") !== -1 
        && document.URL.indexOf("https://") !== -1
        && document.URL.indexOf("localhost") != 7) {
        console.log('setting phone to true');
        window.isphone = true;
        isPhone = true;
    }
    

    console.log('all together:' + (document.URL.indexOf("http://") !== -1 
        && document.URL.indexOf("https://") !== -1
        && document.URL.indexOf("localhost") != 7));
    
    console.log('onBodyLoad, window.isphone:' + window.isphone);
    console.log('onBodyLoad, isPhone:' + isPhone);

    if(window.isphone ) {
        console.log('adding eventListener deviceready');
        document.addEventListener("deviceready", onDeviceReady, false);
    } else {
        console.log('running onDeviceReady()');
        onDeviceReady();
    }
};

function onDeviceReady() {

    var storage = window.localStorage;
    //remove 200ms delay on tap (globally)
    $.mobile.buttonMarkup.hoverDelay = 0;
    
    /**
    *  ====== Home page =====
    */ 
   
    resetStorage();  
   
    function resetStorage() {
        console.log('reset storage:' + storage.getItem('beers'));
        // if(!storage.getItem('installed')) {
        //storage.setItem('beers', '{}');
        // }
    }  
    
    var beerCount = getBeerCount();
    var shotCount = getShotCount();
    //view - Beer|Shots
    var view = 'Beer';
    //Days|Months|Years
    var graphView = 'Days';
    updateBeerCount(beerCount);
    updateShotCount(shotCount);
    
    var startedAt = new Date;
    var nextVibration = new Date;
    var lastDrinkAddedAt;
    
    //on page load set next vibration
    setNextVibration(nextVibration);
    
    setInterval(function() {
        var now = new Date;

        //set now time 5 hour less, so it's reseted at 5 AM no at midnight
        now.setHours(now.getHours() - 5);
        if(startedAt.getDate() < now.getDate() || startedAt.getMonth() < now.getMonth()) {
            startedAt = new Date;
            startedAt.setDate(startedAt.getDate() + 1);
            beerCount = 0;
            updateBeerCount(beerCount);
            shotCount = 0;
            updateShotCount(shotCount);
            alert('Beer count was reseted due to new "Drinking day". You can view your count of beers in history when you press "Done drinking"');
        }
    }, 5000);
    
    //check every minute if phone should vibrate
    setInterval(function() {
      var now = new Date();
      if(shouldVibrate() && (beerCount || shotCount) && nextVibration < now) {
        var interval = getVibrationInterval();
        if(navigator.notification) {
          navigator.notification.vibrate(3000);
        }
        if(interval) {
          if(confirm("It's time for a drink! \n\nWarning: If you click cancel, vibration notification will be turned off.")) {
            //continue drinking and set next vibration interval
            setNextVibration(nextVibration);
          } else {
            //stop vibrations
            turnOffVibrations();
          }
        }
      }
    }, 60000);
    
    //show shots
    $('.shot-menu-btn').off('vclick').on('vclick', function(e) {
      $('.beer-wrapper').addClass('hidden');
      $('.shot-wrapper').removeClass('hidden');
      view = 'Shots';
      
      if($('#stats').is(':visible')) {
          if(graphView == 'Days') {
            renderDayStats();
          }
          if(graphView == 'Months') {
            renderMonths();
          }
          if(graphView == 'Years') {
            renderYears();
          }
      }
      
      $('.view-name').text(view);
      $('.beer-menu-btn').removeClass('ui-btn-active');
      $('.shot-menu-btn').addClass('ui-btn-active');
      $('#shots-stats-chart').removeClass('hidden');
      $('#beer-stats-chart').addClass('hidden');
    });
    
    //show beers
    $('.beer-menu-btn').off('vclick').on('vclick', function(e) {
      $('.beer-wrapper').removeClass('hidden');
      $('.shot-wrapper').addClass('hidden');
      view = 'Beer';
      
      if($('#stats').is(':visible')) {
          if(graphView == 'Days') {
            renderDayStats();
          }
          if(graphView == 'Months') {
            renderMonths();
          }
          if(graphView == 'Years') {
            renderYears();
          }
      }
      
      $('.view-name').text(view);
      $('.beer-menu-btn').addClass('ui-btn-active');
      $('.shot-menu-btn').removeClass('ui-btn-active');
      $('#shots-stats-chart').addClass('hidden');
      $('#beer-stats-chart').removeClass('hidden');
    });
    
    $('.plus-beer').off('vclick').on('vclick', function(e) {
        e.preventDefault();
        e.originalEvent && e.originalEvent.preventDefault();
        beerCount++;
        var beers = {};
        lastDrinkAddedAt = new Date();
        
        if(storage.getItem('beers'))
            beers = JSON.parse(storage.getItem('beers'));  
        
        var now = new Date;
        var date = formatDate(now);
        
        if(!(beers && beers[date])) {
            //add beer to existing date
            beers[date] = {};
        }
                                     
        if(typeof beers[date].count != 'undefined') {
          beers[date].count++;
        } else {
          beers[date].count = 1;
        }
        
        //set next vibration time
        setNextVibration(nextVibration);
        
        storage.setItem('beers', JSON.stringify(beers));
        updateBeerCount(beerCount);
    });
    
    $('.plus-shot').off('vclick').on('vclick', function(e) {
        e.preventDefault();
        e.originalEvent && e.originalEvent.preventDefault();
        shotCount++;
        var shots = {};
        lastDrinkAddedAt = new Date();
        
        if(storage.getItem('shots'))
            shots = JSON.parse(storage.getItem('shots'));  
        
        var now = new Date;
        var date = formatDate(now);
        
        if(!(shots && shots[date])) {
            //add beer to existing date
            shots[date] = {};
        }
                       
        if(typeof shots[date].count != 'undefined') {                                     
            shots[date].count++;
        } else {
            shots[date].count = 1;
        }
        
        //set next vibration time
        setNextVibration(nextVibration);
        
        storage.setItem('shots', JSON.stringify(shots));
        updateShotCount(shotCount);
    });
   
    $('.minus-beer').off('vclick').on('vclick', function(e) {
        e.preventDefault();
        if(beerCount > 0) {
            beerCount--;
            
            var beers = {};
            
            if(storage.getItem('beers'))
                beers = JSON.parse(storage.getItem('beers'));
            
            var now = new Date;
            var date = formatDate(now);
            
            if(beers && beers[date]) {
                //subtract beer
                if(beers[date].count && beers[date].count >= 1) {
                    beers[date].count--;
                } else {
                    //subtract yesterday's beer
                    now.setDate(now.getDate() - 1);
                    date = formatDate(now);
                    if(beers[date].count) {
                        beers[date].count--;
                    }
                }
            }
            storage.setItem('beers', JSON.stringify(beers));
            
            //set next vibration time
            setNextVibration(nextVibration);
            updateBeerCount(beerCount);
        }
    });
    
    $('.minus-shot').off('vclick').on('vclick', function(e) {
        e.preventDefault();
        if(shotCount > 0) {
            shotCount--;
            
            var shots = {};
            
            if(storage.getItem('shots'))
                shots = JSON.parse(storage.getItem('shots'));
            
            var now = new Date;
            var date = formatDate(now);
            
            if(shots && shots[date]) {
                //subtract beer
                if(shots[date].count && shots[date].count >= 1) {
                    shots[date].count--;
                } else {
                    //subtract yesterday's beer
                    now.setDate(now.getDate() - 1);
                    date = formatDate(now);
                    if(shots[date].count) {
                        shots[date].count--;
                    }
                }
            }
            storage.setItem('shots', JSON.stringify(shots));
            
            //set next vibration time
            setNextVibration(nextVibration);
            updateShotCount(shotCount);
        }
    });
   
    function getBeerCount() {
        var beers = {};
        
        if(storage.getItem('beers'))
            beers = JSON.parse(storage.getItem('beers'));
        
        var date = formatDate(new Date);
        
        if(beers && beers[date]) {
            return beers[date].count;
        }
        
        return 0;   
    }
    
    function getShotCount() {
        var shots = {};
        
        if(storage.getItem('shots'))
            shots = JSON.parse(storage.getItem('shots'));
        
        var date = formatDate(new Date);
        
        if(shots && shots[date]) {
            return shots[date].count;
        }
        
        return 0;   
    }
   
    function updateBeerCount(beerCount) {
        $('.beer-count-big').text(beerCount);
        if(beerCount > 9) {
            $('.beer-count-big').addClass('two-ciphers');
        } else {
            $('.beer-count-big').removeClass('two-ciphers');
        }
        if(beerCount == 1) {
            $('.beer-count').text(beerCount + ' beer');
        } else {
            $('.beer-count').text(beerCount + ' beers');
        }
    }
    
    function updateShotCount(shotCount) {
        $('.shot-count-big').text(shotCount);
        if(shotCount > 9) {
            $('.shot-count-big').addClass('two-ciphers');
        } else {
            $('.shot-count-big').removeClass('two-ciphers');
        }
        if(beerCount == 1) {
            $('.shot-count').text(shotCount + ' shot');
        } else {
            $('.shot-count').text(shotCount + ' shots');
        }
    }
    
    $('.done-drinking').on('click', function(e) {
    
    });
    
    function formatDate(date) {
        var formatted = '';
        formatted += date.getDate() + '/';
        formatted += (date.getMonth() + 1) + '/';
        formatted += date.getFullYear();
        return formatted;
    }
    
    /**
    * ======= Stats page =======
    */     
    var months = ["January","February","March","April","May","June","July","August","September","October","November","December"];
    var days = ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"];
    var shortDays = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    
    //day stats variables
    var DayStats = {};
    DayStats.daysLimitDefault = 7;
    DayStats.daysLimit = DayStats.daysLimitDefault;
    DayStats.daysSkip = 0;
    DayStats.currentMonth = new Date().getMonth();
    DayStats.currentYear = new Date().getFullYear();
    
    $('#period-select').off('change').on('change', function(e) {
        console.log($(this).val());
        if($(this).val() == 'years') {
            graphView = 'Years';
            $('.days-stuff').addClass('hidden');
        	renderYears();
        } else if($(this).val() == 'months') {
            graphView = 'Months';
            $('.days-stuff').addClass('hidden');
			renderMonths();        
        } else if($(this).val() == 'days') {
            graphView = 'Days';
            $('.days-stuff').removeClass('hidden');
        	var now = new Date;
        	renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
        }
    });
    
    $(document).on("pageshow", '#stats', function(e, jqData) {
        //renderMonths();
        $('#period-select').val('days');
        $('#period-select').trigger('change');
        renderDayStats();
    });
    
    function renderDayStats() {
        var now = new Date;
        
        if(DayStats.daysSkip == 0) {
            DayStats.daysSkip += now.getDate() - 2;
        }
        renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
    }
    
    $('.month-prev').on('vclick', function(e) {
        e.preventDefault();
        var now = new Date;
        now.setMonth(DayStats.currentMonth - 1);
        console.log('now BEFORE setting a year:', now);
        if(now.getMonth() == 11) {
            DayStats.currentYear--;
        }
        now.setFullYear(DayStats.currentYear);
        console.log('now after setting a year:', now);
        console.log('currentYear:', DayStats.currentYear);
        setDayStatsDefaults(now);
        var daysInMonth = getDaysInMonth(now.getFullYear(), now.getMonth());        
        renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
    }); 
    
    $('.month-next').on('vclick', function(e) {
        e.preventDefault();
        var now = new Date;
        now.setMonth(DayStats.currentMonth + 1);
        if(now.getMonth() === 0) {
            DayStats.currentYear++;
            console.log('setting currentYear: ', DayStats.currentYear);
        }
        now.setFullYear(DayStats.currentYear);
        console.log('now:', now);
        console.log('currentYear:', DayStats.currentYear);
        setDayStatsDefaults(now);
        var daysInMonth = getDaysInMonth(now.getFullYear(), now.getMonth());
        console.log('daysInMonth: ' + daysInMonth);
        renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
    }); 
    
    $('.days-next').on('vclick', function(e) {
        e.preventDefault();
        var now = new Date;
        now.setMonth(DayStats.currentMonth);
        var daysInMonth = getDaysInMonth(now.getFullYear(), now.getMonth());
        console.log('daysInMonth: ' + daysInMonth);
        
        if(DayStats.daysSkip + DayStats.daysLimit < daysInMonth) { 
            DayStats.daysSkip += DayStats.daysLimit;
            console.log('days-month-next DayStats.daysSkip: ' + DayStats.daysSkip);
            renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
        } else {
            alert('End of the month, select next month please');
        }
    }); 
    
    $('.days-prev').on('vclick', function(e) {
        e.preventDefault();
        
        if(DayStats.daysSkip + DayStats.daysLimit > DayStats.daysLimit) {
            DayStats.daysSkip -= DayStats.daysLimit;
            var now = new Date;
            now.setMonth(DayStats.currentMonth);
            renderDays(now.getFullYear(), now.getMonth(), DayStats.daysSkip, DayStats.daysLimit);
        } else {
            alert('End of the month, select previous month please');
        }
        
    }); 
    
    $('#vibrations-switch').on('change', function(e) {
      console.log('checked:' + $(this).is(':checked'));
      if($(this).is(':checked')) {
        turnOnVibrations();
      } else {
        turnOffVibrations();
      }
    });
    
    $('#vibration-interval').on('blur', function(e) {
      var interval = parseFloat($(this).val());
      if(isNaN(interval)) {
        alert('Interval must be a number');
      } else {
        localStorage.setItem('vibrationInterval', interval);
        setNextVibration(nextVibration);
        $('.next-notification-text').text('Next notification: ' + nextVibration.toLocaleString());
      }
    });
    
    $('#settings-form').on('submit', function(e) {
      e.preventDefault();
      console.log('submit settings');
      $.mobile.navigate('#home');
    });
    
    $(document).on("pageshow", '#settings', function(e, jqData) {
      $('#vibrations-switch').attr('checked', shouldVibrate());
      $('#vibrations-switch').checkboxradio('refresh');
      $('#vibration-interval').val(getVibrationInterval());
      $('.next-notification-text').text('Next notification: ' + nextVibration.toLocaleString());
    });
    
    function turnOnVibrations() {
      localStorage.setItem('vibrate', true);
    }
    
    function turnOffVibrations() {
      localStorage.setItem('vibrate', false);
    }
    
    function shouldVibrate() {
      return JSON.parse(localStorage.getItem('vibrate'));
    }
    
    function getVibrationInterval() {
      return JSON.parse(localStorage.getItem('vibrationInterval'));
    }
    
    function setNextVibration(nextVibration) {
      var vibrInterval = getVibrationInterval();
      console.log('vibrInterval: ', vibrInterval);
      var now = new Date;
      nextVibration.setTime(now.getTime());
      nextVibration.setMinutes(nextVibration.getMinutes() + vibrInterval);
    }
    
    function renderDays(year, month, skip, limit) {
    	skip = skip || 0;
        if(skip < 0) {
            skip = 0;
        }
    	limit = limit || 10;
    	var daysInMonth = getDaysInMonth(year, month);
        var maxDays;
    	
    	if(daysInMonth < limit) {
    		limit = daysInMonth;
    	}
    	
    	if(daysInMonth <= skip + limit) {
    		maxDays = daysInMonth;
    	} else {
            maxDays = skip + limit;
        }
    	
    	var items = getItems();
            
        var daysLabels = [];
        var daysNum = {};
        var daysNumArr = [];
        var max = 0;
        var currentMonth = month;
        
        $('.days-month-text').text(months[month] + ' ' + year);
        
    	for(var prop in items) {
            if(items.hasOwnProperty(prop)) {
            	//splitted[0] - day, 1 - month, 2 - year
                var splitted = prop.split('/');
                var splittedMonth = splitted[1];
                
                if(splittedMonth == currentMonth + 1) {
                	var count = items[prop].count;
                	daysNum[splitted[0]] = count;
                	
                	if(max < count) {
                		max = count;
                	}
                }
            }
        }
        
        for(var i = skip + 1; i <= maxDays; i++) {
        	daysNum[i] = daysNum[i] || 0;
        	daysNumArr.push(daysNum[i]);
        	var currDate = new Date(year, month, i);
        	daysLabels.push(shortDays[currDate.getDay()] + ' ' + i + '/' + (month + 1) + '/' + year);
        }
        
        var ctx = getGraphContext();
        var data = {
        	labels : daysLabels,
        	datasets : [
        		{
        			fillColor : "rgba(220,220,220,0.5)",
        			strokeColor : "rgba(220,220,220,1)",
        			pointColor : "rgba(220,220,220,1)",
        			pointStrokeColor : "#fff",
        			data : daysNumArr
        		}
        	]
        }
        var steps = 5;
        var options = {
            scaleOverride: true,
            scaleSteps: steps,
            scaleStepWidth: Math.ceil(max / steps),
            animation: false
        }
        var statsChart = new Chart(ctx).Line(data, options);
        
        return true;
    }
    
    /**
    * @param JSON beers
    */     
    function renderMonths() {
    	var items = getItems();
            
        var monthsNum = {};
        var max = 0;
        //init monthsNum
        for(var i =0; i <= 11; i++) {
            monthsNum[i] = 0;
        }
        
        for(var prop in items) {
            if(items.hasOwnProperty(prop)) {
                //splitted[0] - day, 1 - month, 2 - year
                var splitted = prop.split('/');
                //total monthly count of beers
                monthsNum[splitted[1] - 1] += items[prop].count;
                
                if(max < monthsNum[splitted[1] - 1]) {
                    max = monthsNum[splitted[1] - 1];
                }
                
                //test if month name contains "("
                if(/\(/.test(months[splitted[1] - 1])) {
                    //just update beer count
                    months[splitted[1] - 1] = months[splitted[1] - 1].replace(/(\d+)/, monthsNum[splitted[1] - 1]);
                } else {
                    //append beer count
                    months[splitted[1] - 1] += ' (' + items[prop].count + ')';
                } 
            }
        }
        
        var ctx = getGraphContext();
        var data = {
        	labels : months,
        	datasets : [
        		{
        			fillColor : "rgba(220,220,220,0.5)",
        			strokeColor : "rgba(220,220,220,1)",
        			pointColor : "rgba(220,220,220,1)",
        			pointStrokeColor : "#fff",
        			data : [monthsNum[0],monthsNum[1],monthsNum[2],monthsNum[3],monthsNum[4],monthsNum[5],monthsNum[6],
                      monthsNum[7], monthsNum[8], monthsNum[9], monthsNum[10], monthsNum[11]]
        		}
        	]
        }
        var steps = 10;
        var options = {
            scaleOverride: true,
            scaleSteps: steps,
            scaleStepWidth: Math.ceil(max / steps),
            animation: false
        }
        var statsChart = new Chart(ctx).Line(data, options);
    }
    
    function getBeersFromStorage() {
      var beers = {};
      if(storage.getItem('beers'))
        beers = JSON.parse(storage.getItem('beers'));
      return beers;
    }
    
    function getShotsFromStorage() {
      var shots = {};
      if(storage.getItem('shots'))
        shots = JSON.parse(storage.getItem('shots'));
      return shots;
    }
    
    function getItems() {
      var items;
      if(view == 'Beer') {
        items = getBeersFromStorage();
      } else {
        items = getShotsFromStorage();
      }
      return items;
    }
    
    function renderYears() {
        var items = getItems();            
            
    	var yearsNum = {};
    	var yearsLabels = [];
    	var graphData = [];
    	var max = 0;
    	
    	for(var prop in items) {
            if(items.hasOwnProperty(prop)) {
            	//splitted[0] - day, 1 - month, 2 - year
                var splitted = prop.split('/');
                var year = splitted[2];
                
                if(typeof yearsNum[year] == 'undefined') {
                	yearsNum[year] = 0;
                	yearsLabels.push(year);
                }
                
                yearsNum[year] += items[prop].count;
                
                if(max < yearsNum[year]) {
                    max = yearsNum[year];
                }
            }
        }
        
        //add graph data
        for(var i = 0; i < yearsLabels.length; i++) {
        	graphData.push(yearsNum[yearsLabels[i]]);
        	
        	yearsLabels[i] += ' (' + yearsNum[yearsLabels[i]] + ')';
        }
        
        if(yearsLabels.length < 3) {
        	var now = new Date;
        	
        	if(yearsLabels.length == 1) {
        		yearsLabels.unshift(now.getFullYear() - 1);
	        	graphData.unshift(0);
        	}
        	
        	//add two labels with last year and this year
        	if(yearsLabels.length == 0) {
	        	yearsLabels.push(now.getFullYear() - 1);
	        	graphData.push(0);
	        	
	        	yearsLabels.push(now.getFullYear());
	        	graphData.push(0);
			}	        	
        }      
        
        var ctx = getGraphContext();
        var data = {
        	labels : yearsLabels,
        	datasets : [
        		{
        			fillColor : "rgba(220,220,220,0.5)",
        			strokeColor : "rgba(220,220,220,1)",
        			pointColor : "rgba(220,220,220,1)",
        			pointStrokeColor : "#fff",
        			data : graphData
        		}
        	]
        }
        
        var steps = 15;
        var options = {
            scaleOverride: true,
            scaleSteps: steps,
            scaleStepWidth: Math.ceil(max / steps),
            animation: false
        }
        var statsChart = new Chart(ctx).Line(data, options);
    }
    
    function getGraphContext() {
      var ctx;
      if(view == 'Beer') {
        ctx = document.getElementById("beer-stats-chart").getContext("2d");
      } else {
        ctx = document.getElementById("shots-stats-chart").getContext("2d");
      }
      return ctx;
    }
    
    function getDaysInMonth(year, month) {
	    return new Date(year, month + 1, 0).getDate();
	}
    
    function setDayStatsDefaults(date) {
        DayStats.currentMonth = date.getMonth();
        DayStats.currentYear = date.getFullYear();
        console.log('setDayStatsDefaults() currentYear:', DayStats.currentYear);
        DayStats.daysSkip = 0;
        DayStats.daysLimit = DayStats.daysLimitDefault;
    }
    
    /**
    * @param dateString eg: "8/4/2014"
    * @returns null|Date   
    */     
    function parseDate(dateString) {
        var date = null;
        if(dateString) {
            var splitted = dateString.split('/');
            var day = splitted[0];
            var month = splitted[1];
            var year = splitted[2];
            return new Date(year, month - 1, day);
        }
        return date;
    }
    
    $(document).on("pagehide", '#stats', function(e, data) {
    
    });
  
}