ig.module(
	'game.entities.coin'
).
requires(
	'impact.entity'
).
defines(function () {
    EntityCoin = ig.Entity.extend({
        size: {
            x: 15,
            y: 15
        },
        zIndex: -1,
        type: ig.Entity.TYPE.NONE,
        checkAgainst: ig.Entity.TYPE.A,
        collides: ig.Entity.COLLIDES.NEVER,
        collect: new ig.Sound('media/sounds/coin.*', true),
        animSheet: new ig.AnimationSheet('media/sprites/coin.png', 15, 15),
        init: function (x, y, settings) {
            this.parent(x, y, settings);
            
            this.addAnim('idle', 0.07, [0, 1, 2, 3, 4, 5, 6]);
        },
        check: function (other) {
            this.kill();
            if (!ig.ua.mobile) 
            {
				this.collect.play();
            }
            ig.game.coinCount++;
        },
        update: function () {
            this.currentAnim.update();
        }
    });
});