ig.module(
	'game.entities.loading'
)
.requires(
	'impact.entity',
	'impact.font'
)
.defines(function(){
	
EntityLoading = ig.Entity.extend({
	animSheet: new ig.AnimationSheet( 'media/sprites/loading.png', 48, 48 ),
	font: new ig.Font( 'media/font-calypso.png' ),
	
	visible: true,
	text: "",
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.addAnim('idle', 0.05, [0, 1, 2, 3, 4, 5]);
		
		this.size.x = this.animSheet.width;
		this.size.y = this.animSheet.height;
		
		this.alignToCenter();
	},
	
	alignToCenter: function() {
		this.pos.x -= Math.floor(this.size.x / 2);
		this.pos.y -= Math.floor(this.size.y / 2);
	},
	
	update: function() {
		this.currentAnim.update();
	},
	
	draw: function() {
		if (this.visible) {
			this.parent();
			
			this.font.draw(this.text, this.pos.x + this.size.x / 2, this.pos.y + this.size.y + 7, ig.Font.ALIGN.CENTER);
		}
	}
});

});

