ig.module(
	'game.joystick'
)
.requires(
	'impact.animation'
)
.defines(function(){
	
Joystick = ig.Class.extend({
	visible: true,
	
	// anims: {},
	// animSheet: new ig.AnimationSheet('media/sprites/joystick.png', 228, 125),
	// currentAnim: null,

	animRightSheet: new ig.AnimationSheet('media/sprites/pad-right.png',93, 93),
	animRight: {},
	animRightCurrent: null,

	animLeftSheet: new ig.AnimationSheet('media/sprites/pad-left.png', 93, 93),
	animLeft: {},
	animLeftCurrent: null,
	
	x: 0,
	y: 0,
	
	width: 0,
	height: 0,
	
	actions: {
		left: false,
		right: false,
		jump: false
	},
	
	init: function() {
		// this.addAnim('idle', 1, [0]);
		// this.addAnim('left', 1, [1]);
		// this.addAnim('upleft', 1, [2]);
		// this.addAnim('up', 1, [3]);
		// this.addAnim('upright', 1, [4]);
		// this.addAnim('right', 1, [5]);
		
		// this.width = this.animSheet.width;
		// this.height = this.animSheet.height;

		this.animRight['off'] = new ig.Animation(this.animRightSheet, 1, [0]);
		this.animRight['on'] = new ig.Animation(this.animRightSheet, 1, [1]);
		this.animRightCurrent = this.animRight['off'];

		this.animLeft['off'] = new ig.Animation(this.animLeftSheet, 1, [0]);
		this.animLeft['on'] = new ig.Animation(this.animLeftSheet, 1, [1]);
		this.animLeftCurrent = this.animLeft['off'];
	},
	
	// addAnim: function( name, frameTime, sequence, stop ) {
	// 	if( !this.animSheet ) {
	// 		throw( 'No animSheet to add the animation '+name+' to.' );
	// 	}
	// 	var a = new ig.Animation( this.animSheet, frameTime, sequence, stop );
	// 	this.anims[name] = a;
	// 	if( !this.currentAnim ) {
	// 		this.currentAnim = a;
	// 	}
		
	// 	return a;
	// },
	
	// alignToCenter: function() {
	// 	this.pos.x -= Math.floor(this.size.x / 2);
	// 	this.pos.y -= Math.floor(this.size.y / 2);
	// },
	
 //    isMouseHover: function(x, y) {
 //    	var w = 48;
 //    	var h = 48;
    	
	//     return (
	//         (this.x + x <= ig.input.mouse.x && ig.input.mouse.x < this.x + x + w) &&
	//         (this.y + y <= ig.input.mouse.y && ig.input.mouse.y < this.y + y + h)
	//     );
	// },
	
	update: function() {
		this.actions['left'] = false;
		this.actions['right'] = false;
		this.actions['jump'] = true;

		this.animLeftCurrent = this.animLeft['off'];
		this.animRightCurrent = this.animRight['off'];

		if (ig.input.state('mouse1')) {
			if (ig.input.mouse.x < ig.system.width / 2) {
				this.actions['left'] = true;
				this.animLeftCurrent = this.animLeft['on'];
			} else {
				this.actions['right'] = true;
				this.animRightCurrent = this.animRight['on'];
			}
		}

		// this.currentAnim = this.anims.idle;
		// if (ig.input.state('mouse1')) {
		// 	if (this.isMouseHover(0, 77)) {
		// 		this.actions['left'] = true;
		// 		this.currentAnim = this.anims.left;
		// 	} else if (this.isMouseHover(27, 16)) {
		// 		this.actions['left'] = true;
		// 		this.actions['jump'] = true;
		// 		this.currentAnim = this.anims.upleft;
		// 	} else if (this.isMouseHover(91, 0)) {
		// 		this.actions['jump'] = true;
		// 		this.currentAnim = this.anims.up;
		// 	} else if (this.isMouseHover(154, 16)) {
		// 		this.actions['right'] = true;
		// 		this.actions['jump'] = true;
		// 		this.currentAnim = this.anims.upright;
		// 	} else if (this.isMouseHover(180, 77)) {
		// 		this.actions['right'] = true;
		// 		this.currentAnim = this.anims.right;
		// 	}
		// }
		






		/*if (this.currentAnim == this.anims.active) {
			if (this.currentAnim.loopCount) {
				this.currentAnim = this.anims.hover.rewind();
			}
		} else {
			this.currentAnim = this.isMouseHover() ? this.anims.hover : this.anims.idle;
		}
		
		if (ig.input.pressed('mouse1') && this.isMouseHover() && this.visible) {
			this.click.play();
			
			this.clicked();
			
			this.currentAnim = this.anims.active.rewind();
		}*/
		
		this.animLeftCurrent.update();
		this.animRightCurrent.update();
	},
	
	draw: function() {
		if( this.animRightCurrent ) {
			this.animRightCurrent.draw(
				ig.system.width - this.animRightSheet.width - 1,
				ig.system.height - this.animRightSheet.height - 20
			);
		}

		if( this.animLeftCurrent ) {
			this.animLeftCurrent.draw(
				1,
				ig.system.height - this.animLeftSheet.height - 20
			);
		}
	},
	
	state: function( action ) {
		return this.actions[action];
	}
});

});

