ig.module(
	'game.scores-submit'
)
.requires(
	'impact.game',
	'impact.font',
	
	// Entities
	'game.entities.button',
	'game.entities.loading'
)
.defines(function(){
	
ScoresSubmit = ig.Game.extend({
	font: new ig.Font( 'media/font-calypso.png' ),
	font2: new ig.Font( 'media/font-calypso-x2.png' ),
	
	loading: null,
	inputName: null,
	
	clearColor: '#18182A',
	
	message: null,
	
	init: function() {
		this.parent();
		
		if (!ScoresSubmit.initialized) {

            ScoresSubmit.initialized = true;
		}
		
		this.loading = this.spawnEntity( EntityLoading, ig.system.width / 2, ig.system.height / 2 );
		this.loading.text = "Processing...";
		this.loading.visible = false;
		
		this.spawnEntity( ScoresSubmitEntityButtonScores, ig.system.width / 2 - 50, ig.system.height - 35 );
		this.spawnEntity( ScoresSubmitEntityButtonSubmit, ig.system.width / 2 + 50, ig.system.height - 35 );
		
		// if (!ScoresSubmit.lastScore)
		//	ig.system.switchGame(Scores);
		
		var offset = this.getCumulativeOffset(ig.system.canvas);
		
		var inputX = offset.x + (ig.system.width - 184) / 2;
		var inputY = offset.y + ig.system.height / 2 + 10;

		this.inputName = document.createElement("input");
		this.inputName.id = "inputName";
		this.inputName.type = "text";
		this.inputName.setAttribute("maxlength", "12");
		this.inputName.setAttribute("style", "width: 170px; height: 30px; position: absolute; left: " + inputX + "px; top: " + inputY + "px; background-color: #000; color: #fff; border: 2px solid #fff; padding-left: 5px; padding-right: 5px; font: bold 15px Tahoma, sans-serif;");
		document.body.appendChild(this.inputName);

		ig.localyticsSession.tagScreen("Score Submit");
	},
	
	hide: function() {
		this.parent();
		
		document.body.removeChild(this.inputName);
	},
	
	update: function() {
		this.parent();
	},
	
	draw: function() {
		ig.system.clear( this.clearColor );
		
		this.font2.draw("Submit Score", ig.system.width / 2, 15, ig.Font.ALIGN.CENTER);
		
		var score = ScoresSubmit.lastScore;
		if (!score)
			score = 0;
		this.font2.draw(score + "", ig.system.width / 2, 50, ig.Font.ALIGN.CENTER);
		
		if (this.message) {
			this.font.draw(this.message, ig.system.width / 2, ig.system.height / 2 - this.font.height / 2, ig.Font.ALIGN.CENTER);
		} else if (this.loading.visible) {
			// 
		} else {
			this.font.draw("Enter Name:", ig.system.width / 2, ig.system.height / 2 - 20, ig.Font.ALIGN.CENTER);
		}
		
		for( var i = 0; i < this.entities.length; i++ ) {
			this.entities[i].draw();
		}
	},
	
	submitScore: function() {
		if (this.loading.visible || this.message)
			return;
		
		var name = this.inputName.value;
		if (name.length < 1)
			return;
		
		this.inputName.style.visibility = "hidden";
		this.loading.visible = true;
		
		try {
			Playtomic.Leaderboards.Submit({ Name: name, Points: ScoresSubmit.lastScore }, "HighScore", this.submitComplete.bind(this), { highest: true });
		} catch (e) {
			if (window.console && window.console.log)
				window.console.log(e);
		}
	},
	
	submitComplete: function(answer) {
		// window.console.log("Submit complete!", answer.Success);
		
		this.loading.visible = false;
		if (!answer.Success)
		{
			this.message = "Error occurred while submitting your score.";
		}
		else 
		{
			this.message = "Your score has been successfully submitted.";
		}
	},
	
	getCumulativeOffset: function (obj) {
	    var left, top;
	    left = top = 0;
	    if (obj.offsetParent) {
	        do {
	            left += obj.offsetLeft;
	            top  += obj.offsetTop;
	        } while (obj = obj.offsetParent);
	    }
	    return {
	        x : left,
	        y : top
	    };
	}
});

ScoresSubmitEntityButtonScores = EntityButton.extend({
	name: "scores",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-scores.png', 75, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.alignToCenter();
	},
	
	clicked: function() {
		ig.system.switchGame(Scores);
	}
});

ScoresSubmitEntityButtonSubmit = EntityButton.extend({
	name: "submit",
	animSheet: new ig.AnimationSheet( 'media/sprites/button-submit.png', 75, 38 ),
	
	init: function( x, y, settings ) {
		this.parent(x, y, settings);
		
		this.alignToCenter();
	},
	
	clicked: function() {
		ig.game.submitScore();
	}
});

});