function ColorPicker(colorDisplay, colorChooser) {
    this.CELL_CLASS_NAME = 'colorChooserCell';
    this.initialized = false;
    //
    this.display = colorDisplay;
    this.chooser = colorChooser;
    this.color = '#efffc2';
    this.colors = new Array('efffc2', '0088E1', 'E10088', 'FF8000', '18A618');
}
ColorPicker.prototype.initialize = function() {
    //
    if (this.initialized)
        return;
    //
    this.display.bind('click', {root: this}, function(event) {
        event.data.root.chooser.toggle();
    });
    //
    this.chooser.hide();
    for (var i = 0; i < this.colors.length; i++) {
        var cell = $("<div class='" + this.CELL_CLASS_NAME + "' id='" + this.colors[i] + "'/>");
        cell.css({
            'float': 'left',
            'backgroundColor': '#' + this.colors[i]
        });
        this.chooser.append(cell);
        cell.bind('click', {root: this}, function(event) {
            var color = '#' + $(event.currentTarget).attr('id');
            event.data.root.color = color;
            event.data.root.display.css('backgroundColor', color);
            event.data.root.chooser.hide();
        });
    }
    this.initialized = true;
};
ColorPicker.prototype.setColor = function(value)
{
    this.color = value;
    this.display.css('backgroundColor', this.color);

};
ColorPicker.prototype.getColor = function()
{
    return this.color;
};
