function ShoppingLists(listsObjectArr) {
    //this.numLists = listsObjectArr.length;
    this.lists = new Array();

    var shoppingList;
    var shoppingListObj;
    for (var i = 0; i < listsObjectArr.length; i++) {
        shoppingListObj = listsObjectArr[i];
        shoppingList = new ShoppingList(shoppingListObj);
        this.lists.push(shoppingList);
    }
}
ShoppingLists.prototype.addList = function(list) {
    /*
     var l;
     for (var i=0; i<this.lists.length; i++) {
     l = this.lists[i];
     if (l.id == list.id) {
     alert('list already exists');
     }
     }
     */
    this.lists.push(list);
}
ShoppingLists.prototype.getFirstAvailableList = function()
{
    var shoppingList;
    for (var i = this.lists.length - 1; i >= 0; i--) {
        shoppingList = this.lists[i];
        if (shoppingList.completed == false) {
            return shoppingList;
        }
    }
    return null;
}
ShoppingLists.prototype.getFirsCompletedList = function()
{
    var shoppingList;
    for (var i = this.lists.length - 1; i >= 0; i--) {
        shoppingList = this.lists[i];
        return shoppingList;
    }
    return null;
}
ShoppingLists.prototype.getListById = function(id)
{
    var shoppingList;
    for (var i = 0; i < this.lists.length; i++) {
        shoppingList = this.lists[i];
        if (shoppingList.id == id) {
            return shoppingList;
        }
    }
    return null;
}
ShoppingLists.prototype.removeListById = function(id)
{
    var shoppingList;
    for (var i = 0; i < this.lists.length; i++) {
        shoppingList = this.lists[i];
        if (shoppingList.id == id) {
            this.lists.splice(i, 1);
            return;
        }
    }
}

ShoppingLists.prototype.toObjectArray = function() {
    var arr = new Array();
    var shoppingList;
    for (var i = 0; i < this.lists.length; i++) {
        shoppingList = this.lists[i];
        arr.push(shoppingList.toObject());
    }
    return arr;
}


function ShoppingList(shoppingListObj) {
    //this.numItems = shoppingListObj.length;
    this.items = new Array();
    this.id = shoppingListObj.id;
    this.name = shoppingListObj.name;
    this.selected = shoppingListObj.selected;
    this.color = shoppingListObj.color;
    this.completed = shoppingListObj.completed;
    this.data = shoppingListObj.data;
    var items = jQuery.parseJSON(shoppingListObj.items);
    var item;
    var itemObj;
    for (var i = 0; i < items.length; i++) {
        itemObj = items[i];
        item = new ShoppingListItem(itemObj);
        this.items.push(item);
    }
}
ShoppingList.prototype.addItem = function(item) {
    this.items.push(item);
}
/*
 ShoppingList.prototype.moveItemToBack = function( id ) {
 this.items.push( this.items.splice( this.items.getIndexOf(this.get), 1 )[0] );
 }
 */
ShoppingList.prototype.getItemById = function(id)
{
    var item;
    for (var i = 0; i < this.items.length; i++) {
        item = this.items[i];
        if (item.id == id)
            return item;
    }
    return null;
}
ShoppingList.prototype.removeItemById = function(id)
{
    var item;
    for (var i = 0; i < this.items.length; i++) {
        item = this.items[i];
        if (item.id == id)
            this.items.splice(i, 1);
    }
}
ShoppingList.prototype.toObject = function() {
    var obj = new Object();
    obj.id = this.id;
    obj.name = this.name;
    obj.selected = this.selected;
    obj.color = this.color;
    obj.completed = this.completed;
    obj.data = this.data;
    obj.items = JSON.stringify(this.items);
    return obj;
}




function ShoppingListItem(itemObj) {
    this.id = itemObj.id;
    this.name = itemObj.name;
    this.selected = itemObj.selected;
    this.color = itemObj.color;
    this.completed = itemObj.completed;
    this.data = itemObj.data;
}

ShoppingListItem.prototype.toObject = function() {
    var obj = new Object();
    obj.id = this.id;
    obj.name = this.name;
    obj.selected = this.selected;
    obj.color = this.color;
    obj.completed = this.completed;
    obj.data = this.data;
    return obj;
}