﻿var newsCounter = 0;
var newsKeyword = "";

var restaurantCounter = 0;
var restaurantKeyword = "";

var videoCounter = 0;
var videoKeyword = "";

var dealsCounter = 0;
var dealsKeyword = "";


var musicCounter = 0;
var musicKeyword = "";


var jobCounter = 0;
var jobKeyword = "";

var ebayCounter = 0;
var ebayKeyword = "";

var sportsCounter = 0;
var sportsKeyword = "";

var hotelCounter = 0;
var hotelKeyword = "";

var contentCounter = 0;
var contentKeyword = "";

var businessCounter = 0;
var businessKeyword = "";

var amazonCounter = 0;
var amazonKeyword = "";

var infoCounter = 0;
var infoKeyword = "";

var facebookCounter = 0;
var facebookKeyword = "";

var dataService = new function () {
    
   
    /////////////////////////// NEWS FUNCTIONS ///////////////////////////////////////////

    // function to get news results (Provider : times of india, feedzilla)
    getNewsResults = function (callback) {
        try{
            var tags = getLocalStorageItem("newsTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                newsKeyword = getDefaultKeyword('news');
            }
            else {
                var tagsArray = JSON.parse(tags);
                newsKeyword = tagsArray[newsCounter];
                newsCounter++;
                if (newsCounter > tagsArray.length - 1) {
                    newsCounter = 0;
                }

            }
        }
        catch (ex) {
            newsKeyword = getDefaultKeyword('news');
        }
        //this.getNewsResultsTimes(callback);
        this.getNewsResultsFeedzilla(callback);
    },

    // function to get news results : Times of india
     getNewsResultsTimes = function (callback) {
         var url = getUrlForTOINews();
         
         $.ajax({
             url: url,
             type: 'GET',
             dataType: 'xml',
             timeout: 20000,
             complete: function () {
                 //dataService.getNewsResultsFeedzilla(callback);
                 if (callback != "") {
                     window[callback]();//callback();
                 }
             },
             success: function (data, textStatus, xhr) {
                 $(data).find('item').each(function () {
                     var title = "";
                     var desc = "";
                     var url = "";

                     try {
                         title = ($(this).find('title').text());
                     } catch (err) {
                         title = "";
                     }

                     try {
                         desc = ($(this).find('description').text());
                         //alert(desc);
                         desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");
                         //alert(desc);
                     } catch (err) {
                         desc = "";
                     }

                     try {
                         url = ($(this).find('link').text());
                     } catch (err) {
                         url = "#";
                     }


                     var newsElement = new FeedzillaNewsResultClass();
                     newsElement.title = title;
                     newsElement.desc = desc;
                     newsElement.url = url;
                     newsElement.providerImage = 'es_img/images/provider-TOI.png';
                     newsElement.keyword = '';

                     try {
                         newsResultsTiles.push(newsElement);
                     }
                     catch (err) {

                     }

                 });

                 

             }, // end of success function
             error: function (XMLHttpRequest, textStatus, errorThrown) {
                 //dataService.getNewsResultsFeedzilla(callback);
                 if (callback != "") {
                     window[callback]();//callback();
                 }
             }
         });
     },

    // function to get news results : Feedzilla
    getNewsResultsFeedzilla = function (callback) {
        var isLoadMoreClicked = false;
        var keyword = "";
        //var url = "http://api.feedzilla.com/v1/articles/search.json?order=date&count=20&culture_code=" + getCultureCode();
        var url = "http://api.feedzilla.com/v1/articles/search.json?q=" + encodeURIComponent(newsKeyword) + "&order=date&count=20&culture_code=" + getCultureCode();
        
        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            timeout: 20000,
            complete: function () {
                /*if (callback != "") {
                    window[callback]();//callback();
                }*/

                dataService.getNewsResultsTimes(callback);
            },
            success: function (data, textStatus, xhr) {
                var totalObj = 0;
                try {
                    totalObj = data.articles.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var desc = "";
                    var url_feed = "";

                    try {
                        title = data.articles[itr].title;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        desc = data.articles[itr].summary;
                    } catch (err) {
                        desc = "";
                    }

                    try {
                        url_feed = data.articles[itr].url;
                    } catch (err) {
                        url_feed = "#";
                    }

                    var feedzillaContentArrElement = new FeedzillaNewsResultClass();
                    feedzillaContentArrElement.title = title;
                    feedzillaContentArrElement.desc = desc;
                    feedzillaContentArrElement.url = url_feed;
                    feedzillaContentArrElement.providerImage = 'es_img/images/provider-feedzilla.png';
                    feedzillaContentArrElement.keyword = newsKeyword;

                    try {
                        newsResultsTiles.push(feedzillaContentArrElement);
                    }
                    catch (err) {

                    }
                } // end of for loop

            }, // end of success function
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                /*if (callback != "") {
                    window[callback]();//callback();
                }*/

                dataService.getNewsResultsTimes(callback);
            }
        });
    },

    /////////////////////////// END OF NEWS FUNCTIONS ///////////////////////////////////////////


    /////////////////////////// RESTAURANT FUNCTIONS ///////////////////////////////////////////
    // function to get restaurant results (Provider : zomato)
    getRestaurantsResults = function (callback) {
        try {
            var tags = getLocalStorageItem("restaurantsTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                restaurantKeyword = getDefaultKeyword('restaurants');
            }
            else {
                var tagsArray = JSON.parse(tags);
                restaurantKeyword = tagsArray[restaurantCounter];
                restaurantCounter++;
                if (restaurantCounter > tagsArray.length - 1) {
                    restaurantCounter = 0;
                }

            }
        }
        catch (ex) {
            restaurantKeyword = getDefaultKeyword('restaurants');
        }

        dataService.getRestauarantsResultsZomato(callback);
    },

    getRestauarantsResultsZomato = function (callback) {
        //console.log('inside zomato function');
        isLoadMoreClicked = false;
        isLocationSearch = true;
        keyword = "";
        searchtype = 16;

        if (isValidCountryForZomato()) {
            if (CITY == "") {
                dataService.getZomatoRestResults(keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback);
            } else {
                if (zomatoCityArr != null && zomatoCityArr.length > 0) {
                    dataService.getZomatoCityResults(keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback);
                } else {
                    dataService.getZomatoCityResults(keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback);
                }
            }
        } else {
            //window[callback]();//callback();
            if (isValidCountryForYelp()) {
                dataService.getRestauarantsResultsYelp(callback);
            }
            else {
                if (callback != "") {
                    window[callback]();//callback();
                }

            }
        }
    },

    getZomatoCityResults = function (keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback) {
        //console.log('inside zomato city function');
        url = "https://api.zomato.com/v1/cities.json";
        dataType = "json";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,

            beforeSend: function (xhr) {
                xhr.setRequestHeader("X-Zomato-API-Key", ZOMATO_KEY);
            },

            complete: function () {
                dataService.getZomatoRestResults(keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback);
            },

            success: function (data, textStatus, xhr) {
                var result = data.cities;

                var totalObj = 0;
                try {
                    totalObj = result.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var id = "";
                    var title = "";

                    try {
                        id = result[itr].city.id;
                    } catch (err) {
                        id = "0";
                    }

                    try {
                        title = result[itr].city.name;
                    } catch (err) {
                        title = "";
                    }

                    var zomatoCityArrElement = new ZomatoCityClass();
                    zomatoCityArrElement.id = id;
                    zomatoCityArrElement.title = title;

                    try {
                        zomatoCityArr.push(zomatoCityArrElement);
                    } catch (err) {
                    }
                }
            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //console.log("inside zomato city error");
            }
        });
    },

    getZomatoRestResults = function (keyword, searchtype, isLocationSearch, isLoadMoreClicked, callback) {
        //console.log('inside zomato rest function');
        if (zomatoCityArr != null && zomatoCityArr.length > 0 && ZOMATO_CITY_ID.trim() != "") {
            var len = zomatoCityArr.length;
            for (var itr = 0; itr < len; itr++) {
                var temp = zomatoCityArr[itr].title;

                if (CITY.toLowerCase() == temp.toLowerCase()) {
                    ZOMATO_CITY_ID = zomatoCityArr[itr].id;
                }
            }
        }

        var zomatoRestResponse = "";
        var loadmore = false;

        /*if (isLocationSearch == true) {
            url = "https://api.zomato.com/v1/search.json/near?lat=" + LATITUDE + "&lon=" + LONGITUDE;
            //url = "https://api.zomato.com/v1/search.json/near?lat=18.5236&lon=73.8478";
        } else {
            url = "https://api.zomato.com/v1/search.json?q=" + encodeURIComponent(keyword);
            if (ZOMATO_CITY_ID.trim() != "") {
                url += "&city_id=" + ZOMATO_CITY_ID;
            } else {
                url += "&lat=" + LATITUDE + "&lon=" + LONGITUDE;
                // url += "&lat=18.5236&lon=73.8478";
                // 18.5236
            }
        }*/

        var url = "https://api.zomato.com/v1/search.json?q=" + encodeURIComponent(restaurantKeyword);
        if (ZOMATO_CITY_ID.trim() != "") {
            url += "&city_id=" + ZOMATO_CITY_ID;
        } else {
            url += "&lat=" + LATITUDE + "&lon=" + LONGITUDE;
            // url += "&lat=18.5236&lon=73.8478";
            // 18.5236
        }
        url += "&start=" + zomatoRestPageNumber;
        dataType = "json";

        //console.log("ZOMATO REST URL = " + url);

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,

            beforeSend: function (xhr) {
                xhr.setRequestHeader("X-Zomato-API-Key", ZOMATO_KEY);
            },

            complete: function () {
                if (isValidCountryForYelp()) {
                    dataService.getRestauarantsResultsYelp(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }

                }
            },

            success: function (data, textStatus, xhr) {

                var result = data.results;
                var totalResult = data.resultsFound;

                var totalObj = 0;
                try {
                    totalObj = result.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var id = '';
                    var title = '';
                    var address = '';
                    var cuisines = '';
                    var rating = '';
                    var costfortwo = '';

                    try {
                        id = result[itr].result.id;
                    } catch (err) {
                        id = "";
                    }
                    //  console.log("id : " + id);

                    try {
                        title = result[itr].result.name;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        address = result[itr].result.address;
                    } catch (err) {
                        address = "";
                    }


                    //console.log("locality : " + result[itr].result.locality);
                    var locality = result[itr].result.locality;
                    var titleOther = title.replace(/ {2,}/g, ' ');
                    titleOther = titleOther.replace(/[^\w\s]/gi, '');
                    //var url = "https://api.zomato.com/v1/restaurant.json/" + id;
                    var zomatoUrl = "http://www.zomato.com/" + result[itr].result.city + "/" + titleOther.replace(/\s+/g, '-') + "-" + locality.replace(/\s+/g, '-');
                    zomatoUrl = zomatoUrl.toLocaleLowerCase();

                    /* zomatoRestResponse += '<div class="result slide">';
                     zomatoRestResponse += '<a href="' + url + '" target="_blank"><p>' + title + '</p></a>';
                     zomatoRestResponse += '<p>Address' + address + '</p>';
                     zomatoRestResponse += '</div>';*/
                    var restaurantArrElement = new RestaurantTilesClass();
                    restaurantArrElement.title = title;
                    restaurantArrElement.address = address;
                    restaurantArrElement.url = zomatoUrl;
                    restaurantArrElement.imgPath = '';
                    restaurantArrElement.providerImage = 'es_img/images/provider-Zomato.png';
                    restaurantArrElement.keyword = restaurantKeyword;

                    try {
                        restaurantResultsTiles.push(restaurantArrElement);
                    } catch (err) {
                    }

                }


            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                // console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
                if (isValidCountryForYelp()) {
                    dataService.getRestauarantsResultsYelp(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }

                }
            }
        });
    },

    // function to get restaurant results (Provider : yelp)
    getRestauarantsResultsYelp = function (callback) {
        var auth = {
            consumerKey: "jLvHRs47MogGBBqW6Leemw",
            consumerSecret: "KowW_xtoc_8z5OfS_JbfqKrYyEE",
            accessToken: "oJ2E8dB4X7N-WeSkdQY8gfmItGdPEkdG",
            accessTokenSecret: "zfDIVgPUzcjgQFlE4GXu2TXXS-k",
            serviceProvider: {
                signatureMethod: "HMAC-SHA1"
            }
        };

        var terms = 'food';
        var near = CITY;

        var accessor = {
            consumerSecret: auth.consumerSecret,
            tokenSecret: auth.accessTokenSecret
        };
        parameters = [];
        parameters.push(['term', restaurantKeyword]);
        parameters.push(['location', near]);
        //parameters.push(['callback', 'cb']);
        parameters.push(['oauth_consumer_key', auth.consumerKey]);
        parameters.push(['oauth_consumer_secret', auth.consumerSecret]);
        parameters.push(['oauth_token', auth.accessToken]);
        parameters.push(['oauth_signature_method', 'HMAC-SHA1']);
        parameters.push(['category_filter', 'restaurants']);
        if (LATITUDE != "" && LONGITUDE != "") {
            var loatlongdata = LATITUDE + ',' + LONGITUDE;
            parameters.push(['li', loatlongdata]);
        }
        

        // parameters.push(['li', '37.7833,122.4167']); // coordinates for sanfrancisco

        var message = {
            'action': 'http://api.yelp.com/v2/search',
            'method': 'GET',
            'parameters': parameters
        };

        OAuth.setTimestampAndNonce(message);
        OAuth.SignatureMethod.sign(message, accessor);

        var parameterMap = OAuth.getParameterMap(message.parameters);

        var dataType = "json";
        var response = "";
        $.ajax({
            url: message.action,
            type: 'GET',
            data: parameterMap,
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {


                var totalResult = data.total;
                var totalObj = 0;
                try {
                    totalObj = data.businesses.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var address = "";
                    var imgPath = "";
                    var url = "";

                    try {
                        title = data.businesses[itr].name;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        address = data.businesses[itr].location.display_address[0];
                    } catch (err) {
                        address = "";
                    }



                    try {
                        imgPath = data.businesses[itr].image_url;
                    } catch (err) {
                        imgPath = "es_img/images/restaurants-sm.jpg";
                    }

                    try {
                        url = data.businesses[itr].url;
                    } catch (err) {
                        url = "#";
                    }


                    var restaurantArrElement = new RestaurantTilesClass();
                    restaurantArrElement.title = title;
                    restaurantArrElement.address = address;
                    restaurantArrElement.url = url;
                    restaurantArrElement.imgPath = imgPath;
                    restaurantArrElement.providerImage = 'es_img/images/provider-yelp.png';
                    restaurantArrElement.keyword = restaurantKeyword;

                    try {
                        restaurantResultsTiles.push(restaurantArrElement);
                    } catch (err) {
                    }
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF NEWS FUNCTIONS ///////////////////////////////////////////


    /////////////////////////// VIDEO FUNCTIONS ///////////////////////////////////////////
    // function to display video results (Provider : Youtube, times of india)
    getVideoResults = function (callback) {
        try{
            var tags = getLocalStorageItem("videoTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                //videoKeyword = getDefaultKeyword('video');
                videoKeyword = "";
            }
            else {
                var tagsArray = JSON.parse(tags);
                videoKeyword = tagsArray[videoCounter];
                videoCounter++;
                if (videoCounter > tagsArray.length - 1) {
                    videoCounter = 0;
                }

            }
        }
        catch (ex) {
            videoKeyword = "";
        }

        this.getVideoResultsYoutube(callback);
    },

    // function to get video results : youtube
    getVideoResultsYoutube = function (callback) {
        // var url = "https://gdata.youtube.com/feeds/api/standardfeeds/" + CONTRY_CODE.toUpperCase() + "/most_popular?v=2";

        if (videoKeyword != "") {
            var url = "https://www.googleapis.com/youtube/v3/search?part=snippet&maxResults=10&q=" + encodeURIComponent(videoKeyword) + "&regionCode=" + CONTRY_CODE.toUpperCase() + "&key=" + YOUTUBE_API_KEY;
        }
        else {
            var url = "https://www.googleapis.com/youtube/v3/videos?part=snippet&chart=mostPopular&regionCode=" + CONTRY_CODE.toUpperCase() + "&maxResults=10&key=" + YOUTUBE_API_KEY;
        }
        

        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            timeout: 20000,
            complete: function () {
                if (COUNTRY.toLowerCase() == "india") {
                    dataService.getVideoResultsToi(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }
                }
            },
            success: function (data, textStatus, xhr) {
                var totalObj = 0;
                try {
                    totalObj = data.items.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var desc = "";
                    var id = "";
                    var imgPath = "";
                    var url = "";
                    try {
                        id = data.items[itr].id;
                    } catch (err) {
                        id = "";
                    }

                    try {
                        title = data.items[itr].snippet.title;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        desc = data.items[itr].snippet.description;
                    } catch (err) {
                        desc = "";
                    }


                    try {
                        imgPath = data.items[itr].snippet.thumbnails.high.url;
                    } catch (err) {
						try{
							imgPath = data.items[itr].snippet.thumbnails.default.url;
						}
						catch(ex){
							imgPath = "es_img/images/video-sm.jpg";
						}
                        
                    }

                    if (videoKeyword != "") {
                        try {
                            url = "http://www.youtube.com/watch?v=" + data.items[itr].id.videoId;
                        } catch (err) {
                            url = "#";
                        }
                    }
                    else {
                        try {
                            url = "http://www.youtube.com/watch?v=" + data.items[itr].id;
                        } catch (err) {
                            url = "#";
                        }
                    }

                    if (title != "") {
                        var videoArrElement = new YouTubeResultClass();
                        videoArrElement.title = title;
                        videoArrElement.url = url;
                        videoArrElement.imgPath = imgPath;
                        videoArrElement.desc = desc;
                        videoArrElement.providerImage = "es_img/images/provider-YouTube.png";
                        videoArrElement.keyword = videoKeyword;

                        try {
                            videoResultsTiles.push(videoArrElement);
                        }
                        catch (err) {
                        }
                    }

                }

            },
            error: function (xhr, textStatus, errorThrown) {
                if (COUNTRY.toLowerCase() == "india") {
                    dataService.getVideoResultsToi(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }
                }
            }
        });
    },


    // function to get video results : times of india
    getVideoResultsToi = function (callback) {
        //console.log('inside function');
        var url = "http://timesofindia.feedsportal.com/c/33039/f/534012/index.rss";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'xml',
            timeout: 40000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {
                //console.log('inside success'); return;
                // console.log("inside toi video results fetch");
                $(data).find('item').each(function () {
                    var title = "";
                    var url = "";
                    var desc = "";
                    var imgPath = "es_img/images/video-sm.jpg";

                    try {
                        title = $(this).find('title').text();
                    } catch (err) {
                        title = "";
                    }

                    try {
                        url = $(this).find('link').text();
                    } catch (err) {
                        url = "#";
                    }

                    /*try {
                        desc = $(this).find('description').text();
                    } catch (err) {
                        desc = "";
                    }*/
                    desc = "";
                    if (title != "") {
                        var videoArrElement = new YouTubeResultClass();
                        videoArrElement.title = title;
                        videoArrElement.url = url;
                        videoArrElement.imgPath = imgPath;
                        videoArrElement.desc = desc;
                        videoArrElement.providerImage = "es_img/images/provider-TOI.png";
                        videoArrElement.keyword = "";

                        try {
                            videoResultsTiles.push(videoArrElement);
                        }
                        catch (err) {
                        }
                    }
                });

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //console.log("inside toi video results error");
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },


    /////////////////////////// END OF NEWS FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// DEALS FUNCTIONS ///////////////////////////////////////////

    // function to display deals results (Provider : deals)
    getDealsResults = function (callback) {

        try{
            var tags = getLocalStorageItem("dealsTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                dealsKeyword = getDefaultKeyword('deals');
                
            }
            else {
                var tagsArray = JSON.parse(tags);
                dealsKeyword = tagsArray[dealsCounter];
                dealsCounter++;
                if (dealsCounter > tagsArray.length - 1) {
                    dealsCounter = 0;
                }

            }
        }
        catch (ex) {
            dealsKeyword = getDefaultKeyword('deals');
        }

        this.getDealsResultsGroupon(callback);
    },

    // function to get deals results : groupon
    getDealsResultsGroupon = function (callback) {
		var url = "";
		if(CONTRY_CODE.toLowerCase() == "us" || CONTRY_CODE.toLowerCase() == "ca"){
			if (CITY != '' || CITY != null) {
				var tempcity = CITY.replace(" ", "-");
				url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE.toLowerCase() + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&division_id=" + tempcity.toLowerCase() + "&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
			}
			else {
				url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE.toLowerCase() + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
			}
		}
		else{
			if (CITY != '' || CITY != null) {
				url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE.toLowerCase() + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&division_id=" + CITY.toLowerCase() + "&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
			}
			else {
				url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE.toLowerCase() + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
			}
		}
      
        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'jsonp',
            timeout: 50000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {
		        var totalObj = 0;
                try {
                    totalObj = data.deals.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var location = "";
                    var name = "";
                    var value = "";
                    var price = "";
                    var discount = "";
                    var imgPath = "";
                    var url = "";

                    try {
                        title = data.deals[itr].announcementTitle;
                        if (title.trim() == "") {
                            title = data.deals[itr].title;
                        }
                    } catch (err) {
                        title = "";
                    }

                    
                    try {
                        location = data.deals[itr].redemptionLocation;
                    } catch (err) {
                        location = "";
                    }

                    try {
                        name = data.deals[itr].merchant.name;
                    } catch (err) {
                        name = "";
                    }

                    var temp = data.deals[itr].options;
                    try {
                        value = temp[temp.length - 1].value.formattedAmount;
                    } catch (err) {
                        value = "";
                    }

                    try {
                        price = temp[temp.length - 1].price.formattedAmount;
                    } catch (err) {
                        price = "";
                    }

                    try {
                        discount = temp[temp.length - 1].discount.formattedAmount;
                    } catch (err) {
                        discount = "";
                    }

                    try {
                        imgPath = data.deals[itr].mediumImageUrl;
                    } catch (err) {
                        imgPath = "es_img/images/deals-sm.jpg";
                    }

                    try {
                        url = data.deals[itr].dealUrl;
                    } catch (err) {
                        url = "#";
                    }


                    var dealArrElement = new GroupDealOnResultClass();
                    dealArrElement.title = title;
                    dealArrElement.imgPath = imgPath;
                    dealArrElement.url = url;
                    dealArrElement.value = value;
                    dealArrElement.price = price;
                    dealArrElement.providerImage = 'es_img/images/provider-groupon.png';

                    try {
                        dealsResultTiles.push(dealArrElement);
                    }
                    catch (err) {

                    }

                }

            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
		         if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
		
		
    },


    /////////////////////////// END OF DEALS FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// MUSIC FUNCTIONS ///////////////////////////////////////////

    // function to get music results (Provider : audioscrobbler)
    getMusicResults = function (callback) {


        try{
            var tags = getLocalStorageItem("musicTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                musicKeyword = "";
                
            }
            else {
                var tagsArray = JSON.parse(tags);
                musicKeyword = tagsArray[musicCounter];
                musicCounter++;
                if (musicCounter > tagsArray.length - 1) {
                    musicCounter = 0;
                }

            }
        }
        catch (ex) {
            musicKeyword = "";
        }

        var slidingMusic = document.getElementById('slidingMusic');

        
        if (musicKeyword != "") {
            var url = "http://ws.audioscrobbler.com/2.0/?method=track.search&api_key=2b6d2d9b6f7ec175e5ea8a4ac83013e4&format=json&track=" + encodeURIComponent(musicKeyword) + "&limit=20&page=1";

            var dataType = "json";

            $.ajax({
                url: url,
                type: 'GET',
                dataType: dataType,
                timeout: 20000,
                complete: function () {
                    if (callback != "") {
                        window[callback]();// callback();
                    }
                },
                success: function (data, textStatus, xhr) {
                    var totalResults = 0;
                    try {
                        totalResults = data.results['opensearch:totalResults'];
                    } catch (err) {
                        totalResults = 0;
                    }

                    var totalObj = 0;
                    try {
                        totalObj = data.results.trackmatches.track.length;
                    } catch (err) {
                        totalObj = 0;
                    }

                    for (var itr = 0; itr < totalObj; itr++) {
                        var title = "";
                        var url = "";

                        

                        try {
                            title = data.results.trackmatches.track[itr]['name'];
                        } catch (err) {
                            title = "Not Found";
                        }

                        try {
                            url = data.results.trackmatches.track[itr]['url'];
                        } catch (err) {
                            url = "#";
                        }



                        var musicArrElement = new MusicResultClass();
                        musicArrElement.name = title;
                        musicArrElement.url = url;
                        musicArrElement.providerImage = "es_img/images/provider-Last.png";
                        musicArrElement.keyword = musicKeyword;

                        try {
                            musicResultTiles.push(musicArrElement);
                        }
                        catch (err) {
                        }
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (callback != "") {
                        window[callback]();// callback();
                    }
                }
            });

        }
        else {
            //alert('inside else');
            var url = "http://ws.audioscrobbler.com/2.0/user/RJ/lovedtracks.rss";
            var dataType = "xml";
            var response = "";

            $.ajax({
                url: url,
                type: 'GET',
                dataType: dataType,
                timeout: 20000,
                complete: function () {
                    if (callback != "") {
                        window[callback]();// callback();
                    }
                },
                success: function (data, textStatus, xhr) {
                    //alert('inside success');
                    $(data).find('item').each(function () {
                        var title = "";
                        var desc = "";
                        var url = "";

                        try {
                            title = $(this).find('title').text();
                        } catch (err) {
                            title = "Not Found";
                        }

                       // alert(title);

                        try {
                            url = $(this).find('link').text();
                        } catch (err) {
                            url = "#";
                        }

                        var musicArrElement = new MusicResultClass();
                        musicArrElement.name = title;
                        musicArrElement.url = url;
                        musicArrElement.providerImage = "es_img/images/provider-Last.png";
                        musicArrElement.keyword = '';

                        try {
                            musicResultTiles.push(musicArrElement);
                        }
                        catch (err) {
                        }
                    });
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (callback != "") {
                        window[callback]();// callback();
                    }
                }
            });
        }
        
    },

    /////////////////////////// END OF MUSIC FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// JOB FUNCTIONS ///////////////////////////////////////////

    // function to display jobs results (Provider : Indeed, Monster)
    getJobResults = function (callback) {

        try {
            var tags = getLocalStorageItem("jobTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                jobKeyword = getDefaultKeyword('job');

            }
            else {
                var tagsArray = JSON.parse(tags);
                jobKeyword = tagsArray[jobCounter];
                jobCounter++;
                if (jobCounter > tagsArray.length - 1) {
                    jobCounter = 0;
                }

            }
        }
        catch (ex) {
            jobKeyword = getDefaultKeyword('job');
        }

        this.getJobResultsIndeed(callback);
    },


    // function to display job results : indeed
    getJobResultsIndeed = function (callback) {
        var keyword = "";
        var dataType = "xml";
        var url = "http://api.indeed.com/ads/apisearch?publisher=3749956632418418&q=" + encodeURIComponent(jobKeyword) + "&l=" + encodeURIComponent(CITY.toLowerCase()) + "&sort=date&radius=50&st=jobsite&jt=fulltime&start=" + indeedStart + "&limit=5&fromage=30&filter=1&latlong=0&co=" + COUNTRY.toLowerCase() + "&chnl=&userip=1.2.3.4&useragent=Mozilla/%2F4.0%28Firefox%29&v=2";
        var response = "";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                dataService.getJobResultsMonster(callback);
            },
            success: function (data, textStatus, xhr) {
                var totalResults = $(data).find('totalresults').text();

                if (indeedStart <= indeedResultsEnd) {
                    indeedStart += 5;
                }
                else {
                    indeedStart = 0;
                }
                $(data).find('result').each(function () {
                    var title = "";
                    var desc = "";
                    var url = "";

                    try {
                        title = $(this).find('jobtitle').text();
                    } catch (err) {
                        title = "Not Found";
                    }

                    try {
                        desc = $(this).find('snippet').text();
                    } catch (err) {
                        desc = "Not Found";
                    }

                    try {
                        url = $(this).find('url').text();
                    } catch (err) {
                        url = "#";
                    }

                    var jobsArrElement = new JobResultClass();
                    jobsArrElement.title = title;
                    jobsArrElement.desc = desc;
                    jobsArrElement.url = url;
                    jobsArrElement.providerImage = 'es_img/images/provider-indeed.png';
                    jobsArrElement.keyword = jobKeyword;

                    try {
                        jobResultsTiles.push(jobsArrElement);
                    }
                    catch (err) {

                    }
                });

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
               dataService.getJobResultsMonster(callback);
            }
        });
    },

    // function to display amazon results : Monster
    getJobResultsMonster = function (callback) {
        var slidingJobsElement = document.getElementById('slidingJob');

        var keyword = "";
        /*if (getLocalStorageItem("SEARCHKEYWORD") != '' && getLocalStorageItem("SEARCHKEYWORD") != 'null') {
            keyword = getLocalStorageItem("SEARCHKEYWORD");
            url = url = "http://rss.jobsearch.monster.com/rssquery.ashx?q=" + encodeURIComponent(keyword);;
        }
        else {
            url = url = "http://rss.jobsearch.monster.com/rssquery.ashx?cy=" +  CONTRY_CODE;
        }*/

        var url = "http://rss.jobsearch.monster.com/rssquery.ashx?q="+encodeURIComponent(jobKeyword)+"&cy=" + CONTRY_CODE;

        var dataType = "xml";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {
                $(data).find('item').each(function () {
                    var title = "";
                    var desc = "";
                    var url = "";

                    try {
                        title = $(this).find('title').text();
                    } catch (err) {
                        title = "Not Found";
                    }

                    try {
                        desc = $(this).find('description').text();
                    } catch (err) {
                        desc = "Not Found";
                    }

                    try {
                        url = $(this).find('link').text();
                    } catch (err) {
                        url = "#";
                    }

                    var jobsArrElement = new JobResultClass();
                    jobsArrElement.title = title;
                    jobsArrElement.desc = desc;
                    jobsArrElement.url = url;
                    jobsArrElement.providerImage = 'es_img/images/provider-Monster.png';
                    jobsArrElement.keyword = jobKeyword;

                    try {
                        jobResultsTiles.push(jobsArrElement);
                    }
                    catch (err) {

                    }

                });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },


    /////////////////////////// END OF JOB FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// EBAY FUNCTIONS ///////////////////////////////////////////

    // function to display amazon results (Provider : Ebay)
    getEbayResults = function (callback) {


        try {
            var tags = getLocalStorageItem("ebayTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                ebayKeyword = getDefaultKeyword('ebay');

            }
            else {
                var tagsArray = JSON.parse(tags);
                ebayKeyword = tagsArray[ebayCounter];
                ebayCounter++;
                if (ebayCounter > tagsArray.length - 1) {
                    ebayCounter = 0;
                }

            }
        }
        catch (ex) {
            ebayKeyword = getDefaultKeyword('ebay');
        }

        var slidingEbay = document.getElementById('slidingEbay');

        var url = url = "http://svcs.ebay.com/services/search/FindingService/v1?OPERATION-NAME=findItemsByKeywords&SERVICE-VERSION=1.0.0&SECURITY-APPNAME=VPacc3ee5-f863-4a2d-9f93-ca9c043f15b&RESPONSE-DATA-FORMAT=JSON&REST-PAYLOAD&keywords="+encodeURIComponent(ebayKeyword)+"&paginationInput.entriesPerPage=10&paginationInput.pageNumber=1&GLOBAL-ID=" + getEbayGlobalId();
        var dataType = "json";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            beforeSend: function (xhr) {
                xhr.setRequestHeader("Cache-Control", "no-cache");
                xhr.setRequestHeader("pragma", "no-cache");
            },
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {
                var items = data.findItemsByKeywordsResponse[0].searchResult[0].item || [];
                var pages = data.findItemsByKeywordsResponse[0].paginationOutput || [];


                var totalResults = 0;
                try {
                    totalResults = pages[0].totalEntries[0];
                } catch (err) {
                    totalResults = 0;
                }

                var totalObj = 0;
                try {
                    totalObj = items.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = '';
                    var price = '';
                    var countleft = '';
                    var timeleft = '';
                    var location = '';
                    var imgPath = '';
                    var url = '';

                    try {
                        title = items[itr].title[0];
                    } catch (err) {
                        title = "" + keyword;
                    }

                    try {
                        price = items[itr].sellingStatus[0].currentPrice[0]['__value__'] + " " + items[itr].sellingStatus[0].currentPrice[0]['@currencyId'];
                    } catch (err) {
                        price = "";
                    }

                    try {
                        countleft = items[itr].sellingStatus[0].bidCount[0];
                    } catch (err) {
                        countleft = "";
                    }

                    try {
                        location = items[itr].location[0];
                    } catch (err) {
                        location = "";
                    }

                    try {
                        imgPath = items[itr].galleryURL[0];
                    } catch (err) {
                        imgPath = "es_img/images/ebay-sm.jpg";
                    }

                    try {
                        url = items[itr].viewItemURL[0];
                    } catch (err) {
                        url = "#";
                    }

                    var ebayArrElement = new EBayResultClass();
                    ebayArrElement.title = title;
                    ebayArrElement.url = url;
                    ebayArrElement.imgPath = imgPath;
                    ebayArrElement.price = price;
                    ebayArrElement.countleft = countleft;
                    ebayArrElement.providerImage = 'es_img/images/provider-EBay_logo.png';
                    ebayArrElement.keyword = ebayKeyword;

                    try {
                        ebayResultsTiles.push(ebayArrElement);
                    }
                    catch (err) {
                    }
                }
            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF EBAY FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// SPORT FUNCTIONS ///////////////////////////////////////////

    // function to display video results (Provider : ESPN, times of india)
    getSportResults = function (callback) {

        try {
            var tags = getLocalStorageItem("sportTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                sportsKeyword = getDefaultKeyword('sport');

            }
            else {
                var tagsArray = JSON.parse(tags);
                sportsKeyword = tagsArray[sportsCounter];
                sportsCounter++;
                if (sportsCounter > tagsArray.length - 1) {
                    sportsCounter = 0;
                }

            }
        }
        catch (ex) {
            sportsKeyword = getDefaultKeyword('sport');
        }

        this.getSportResultsEspn(callback);
    },

    // function to get sports results : espn
    getSportResultsEspn = function (callback) {
        var slidingSportsElement = document.getElementById('slidingSport');

        var keyword = "";

        var url = "http://search.espn.go.com/rss/" + encodeURIComponent(sportsKeyword);;

        var dataType = "xml";
        var response = "";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                if (COUNTRY.toLowerCase() == "india") {
                    dataService.getSportResultsTimes(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }
                }
            },
            success: function (data, textStatus, xhr) {
                $(data).find('channel').each(function () {
                    $(data).find('item').each(function () {
                        var title = "";
                        var desc = "";
                        var pubdate = "";
                        var url = "";
                        var displayDate = "";

                        try {
                            title = ($(this).find('title').text());
                        } catch (err) {
                            title = "";
                        }

                        try {
                            desc = ($(this).find('description').text());
                        } catch (err) {
                            desc = "";
                        }


                        try {
                            url = ($(this).find('link').text());
                        } catch (err) {
                            url = "#";
                        }

                        desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");

                        var sportsArrElement = new SportResultClass();
                        sportsArrElement.title = title;
                        sportsArrElement.url = url;
                        sportsArrElement.desc = desc;
                        sportsArrElement.providerImage = 'es_img/images/provider-ESPN.png';
                        sportsArrElement.keyword = sportsKeyword;

                        try {
                            sportsResultsTiles.push(sportsArrElement);
                        }
                        catch (err) {
                        }
                    });
                });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (COUNTRY.toLowerCase() == "india") {
                    dataService.getSportResultsTimes(callback);
                }
                else {
                    if (callback != "") {
                        window[callback]();//callback();
                    }
                }
            }
        });
    },

    // function to get sports results : times of india
    getSportResultsTimes = function (callback) {
        var slidingSportsElement = document.getElementById('slidingSport');

        var keyword = "";

        var url = "http://timesofindia.feedsportal.com/c/33039/f/533921/index.rss";

        var dataType = "xml";
        var response = "";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {


                $(data).find('item').each(function () {
                    var title = "";
                    var desc = "";
                    var url = "";


                    try {
                        title = ($(this).find('title').text());
                    } catch (err) {
                        title = "";
                    }

                    try {
                        desc = ($(this).find('description').text());
                    } catch (err) {
                        desc = "";
                    }


                    try {
                        url = ($(this).find('link').text());
                    } catch (err) {
                        url = "#";
                    }

                    desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");

                    var sportsArrElement = new SportResultClass();
                    sportsArrElement.title = title;
                    sportsArrElement.url = url;
                    sportsArrElement.desc = desc;
                    sportsArrElement.providerImage = 'es_img/images/provider-TOI.png';
                    sportsArrElement.keyword = '';

                    try {
                        sportsResultsTiles.push(sportsArrElement);
                    }
                    catch (err) {
                    }
                });

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF SPORT FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// HOTEL FUNCTIONS ///////////////////////////////////////////
    // function to display Hotel results (Provider : Expedia)
    getHotelResults = function (callback) {
        var date1 = new Date();
        var date2 = new Date();
        var res = date2.setTime(date2.getTime() + (7 * 24 * 60 * 60 * 1000));
        date2 = new Date(res);

        var arrivalDate = (date1.getMonth() + 1) + '/' + date1.getDate() + '/' + date1.getFullYear();
        var departureDate = (date2.getMonth() + 1) + '/' + date2.getDate() + '/' + date2.getFullYear();

        var url = "http://dev.api.ean.com/ean-services/rs/hotel/v3/list?minorRev=4"
                + "&cid=" + EXPEDIA_CLIENTID
                + "&apiKey=" + EXPEDIA_API_KEY
                + "&locale=" + DEVICE_LANG
                + "&currencyCode=USD"
                + "&city=" + encodeURIComponent(CITY)
                + "&countryCode=" + encodeURIComponent(COUNTRY)
                + "&supplierCacheTolerance=MED"
                + "&arrivalDate=" + arrivalDate
                + "&departureDate=" + departureDate
                + "&numberOfResults=20&supplierCacheTolerance=MED_ENHANCED";


        var response = '';
        var slidingHotelElement = document.getElementById('slidingHotel');
        $.ajax({
            url: url,
            type: "GET",
            dataType: 'xml',
            timeout: 20000,
            beforeSend: function (xhr) {
                xhr.setRequestHeader("Cache-Control", "no-cache");
                xhr.setRequestHeader("pragma", "no-cache");
            },
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data) {
                cachekey = $(data).find('cacheKey').text();
                cacheloc = $(data).find('cacheLocation').text();

                $(data).find('HotelSummary').each(function () {
                    var hotelid = '';
                    var name = '';
                    var city = '';
                    var addr1 = '';
                    var rating = '';
                    var locdesc = '';
                    var shortdesc = '';
                    var highrate = '';
                    var lowrate = '';
                    var currency = '';
                    var imgPath = '';

                    try {
                        hotelid = $(this).find('hotelId').text();
                    } catch (err) {
                        hotelid = "";
                    }

                    try {
                        name = $(this).find('name').text();
                    } catch (err) {
                        name = "";
                    }

                    try {
                        city = $(this).find('city').text();
                    } catch (err) {
                        city = "";
                    }

                    try {
                        addr1 = $(this).find('address1').text();
                    } catch (err) {
                        addr1 = "";
                    }

                    try {
                        rating = $(this).find('hotelRating').text();
                    } catch (err) {
                        rating = "";
                    }

                    try {
                        locdesc = $(this).find('locationDescription').text();
                    } catch (err) {
                        locdesc = "";
                    }

                    try {
                        imgPath = "http://images.travelnow.com" + $(this).find('thumbNailUrl').text();
                    } catch (err) {
                        imgPath = "es_img/images/hotels-sm.jpg";
                    }

                    var desc = locdesc + ", " + addr1 + ", " + city;
                    var hotelUrl = "http://travel.ian.com/templates/410738/hotels/" + hotelid
                    + "/overview?checkin=" + arrivalDate
                    + "&lang=" + DEVICE_LANG
                    + "&checkout=" + departureDate
                    + "&currency=" + currency;

                    //console.log(hotelUrl);

                    var hotelArrElement = new ExpediaResultClass();
                    hotelArrElement.name = name;
                    hotelArrElement.locdesc = desc;
                    hotelArrElement.url = hotelUrl;
                    hotelArrElement.imgPath = imgPath;
                    hotelArrElement.providerImage = 'es_img/images/provider-expedia.png';
                    hotelArrElement.keyword = '';

                    try {
                        hotelResultTiles.push(hotelArrElement);
                    }
                    catch (err) {

                    }
                });
            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF HOTEL FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// CONTENT FUNCTIONS ///////////////////////////////////////////

    // function to get content results (Provider : imdb, hoopz)
    getContentResults = function (callback) {

        try {
            var tags = getLocalStorageItem("contentTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                contentKeyword = "";

            }
            else {
                var tagsArray = JSON.parse(tags);
                contentKeyword = tagsArray[contentCounter];
                contentCounter++;
                if (contentCounter > tagsArray.length - 1) {
                    contentCounter = 0;
                }

            }
        }
        catch (ex) {
            contentKeyword = "";
        }

        
        this.getContentResultsImdb(callback);
        //this.getContentResultsHoopz(callback);
    },

    // function to get content results : imdb
    getContentResultsImdb = function (callback) {
        isLoadMoreClicked = false;
        var tmdbContentResponse = "";
        var loadmore = false;

        var lang = DEVICE_LANG;

        if (lang == null || lang.trim() == "") {
            lang = "en";
        }
        lang = lang.replace("_", "-");
        keyword = "cricket";
        //url = "http://api.themoviedb.org/2.1/Movie.browse/" + lang + "/json/775772da896aaae174da37dac04f01af?order_by=title&order=asc&page=" + tmdbContentPageNumber + "&per_page=10";

        //var url = "http://api.themoviedb.org/3/movie/upcoming?api_key=1819ac51ad73a28b9567b91c8feb66be&query=" + encodeURIComponent(contentKeyword);;

        if (contentKeyword != "") {
            var url = "http://api.themoviedb.org/3/search/movie?api_key=1819ac51ad73a28b9567b91c8feb66be&query=" + encodeURIComponent(contentKeyword);
        }
        else {
            var url = "http://api.themoviedb.org/3/movie/upcoming?api_key=1819ac51ad73a28b9567b91c8feb66be";
        }
        dataType = "json";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                dataService.getContentResultsHoopz(callback);
            },
            success: function (data, textStatus, xhr) {
                var totalObj = 0;
                try {
                    totalObj = data.total_results;
                } catch (err) {
                    totalObj = 0;
                }

                if (totalObj >= 10) {
                    loadmore = true;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var desc = "";
                    var date = "";
                    var rating = "";
                    var imgPath = "";
                    var url = "";

                    try {
                        title = data.results[itr].title;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        date = data.results[itr].release_date;
                    } catch (err) {
                        date = "";
                    }

                    try {
                        rating = data.results[itr].popularity;
                    } catch (err) {
                        rating = "0.0";
                    }

                    try {
                        //imgPath = "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w500" + data.results[itr].poster_path;
						imgPath = "https://image.tmdb.org/t/p/w185" + data.results[itr].poster_path;
                    } catch (err) {
                        imgPath = "es_img/images/content-sm.jpg";
                    }

                    try {
                        //url = data.results[itr].url;
                        url = "http://www.themoviedb.org/movie/" + data.results[itr].id;
                    } catch (err) {
                        url = "#";
                    }

                    var contentArrElement = new ContentTilesClass();
                    contentArrElement.title = title;
                    contentArrElement.desc = "";
                    contentArrElement.date = date;
                    contentArrElement.rating = rating;
                    contentArrElement.imgPath = imgPath;
                    contentArrElement.url = url;
                    contentArrElement.provider = 'imdb';
                    contentArrElement.providerImage = 'es_img/images/provider-imdb.png';
                    contentArrElement.keyword = contentKeyword;

                    try {
                        if (title != "") {
                            contentResultTiles.push(contentArrElement);
                        }
                    }
                    catch (err) {

                    } // end of try catch

                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                dataService.getContentResultsHoopz(callback);
            }
        });
    },

    // function to get content results : hoopz
    getContentResultsHoopz = function (callback) {
        //console.log("inside content fetch for hoopz");
        var isLoadMoreClicked = false;
        var hoopzContentResponse = "";
        var loadmore = false;
        var url = BASE_URL + "AdvertiserService/fetchContent";

        var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
        var payload = "";
        payload += "<request>";
		payload += "<app>" +APPLICATION_TITLE + "</app>"
        payload += "<keywords>" + contentKeyword + "</keywords>";
        payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>";
        payload += "<modelName>" + MODEL_NAME + "</modelName>";
        payload += "<modelId>" + MODEL_ID + "</modelId>"
        payload += "<os>" + OS + "</os>"
        payload += "<deviceType>" + "phone" + "</deviceType>"
        payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
        payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
        payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
        payload += "<carrier>" + "" + "</carrier>"
        payload += "<adType>" + "2" + "</adType>"
        payload += "<imeiNumber>" + IMEI_NO + "</imeiNumber>"
        payload += "<mobileNo>" + "" + "</mobileNo>"
        payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
        payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
        payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
        payload += "<language>" + DEVICE_LANG + "</language>"
        payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
        payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
        payload += "<geoLocation>" + temp + "</geoLocation>"
        payload += "<pageNo>" + hoopzContentPageNumber + "</pageNo>"
        payload += "<clientId>" + CLIENT_ID + "</clientId>"
        payload += "</request>";

        //console.log("HOOPZ CONTENT REQUEST ================= " + payload);
        //$('#result').append(payload).listview("refresh"); return;

        $.ajax({
            url: url,
            type: "POST",
            data: payload,
            timeout: 70000,
            contentType: "application/xml",
            Cookie: "JSESSIONID=",

            beforeSend: function (xhr) {
                xhr.setRequestHeader("Cache-Control", "no-cache");
                xhr.setRequestHeader("pragma", "no-cache");

                //$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
                $('.mobile-loading').show();
            },

            complete: function () {
                if (callback != "") {
                    window[callback]();//
                    //callback();
                }

            },

            success: function (data) {
                //console.log("inside success");
                //$('#result').append('inside success').listview("refresh"); return;
                $(data).find('response').each(function () {
                    var status = $(this).find('status').text();

                    if (status == '1' || status == '3') {
                        loadmore = $(this).find('loadMore').text();

                        $(this).find('content').each(function () {
                            var title = '';
                            var desc = '';
                            var price = '';
                            var imgPath = '';
                            var url = '';

                            try {
                                title = $(this).find('title').text();
                            } catch (err) {
                                title = "";
                            }
                            try {
                                desc = $(this).find('description').text();
                            } catch (err) {
                                desc = "";
                            }

                            try {
                                imgPath = $(this).find('previewImage').text();
                                imgPath = decodeURIComponent(imgPath);
                            } catch (err) {
                                imgPath = "es_img/images/content-sm.jpg";
                            }
                            try {
                                url = $(this).find('clickURL').text();
                                url = decodeURIComponent(url);
                            } catch (err) {
                                url = "#";
                            }

                            var contentArrElement = new ContentTilesClass();
                            contentArrElement.title = title;
                            contentArrElement.desc = desc;
                            contentArrElement.price = price;
                            contentArrElement.imgPath = imgPath;
                            contentArrElement.url = url;
                            contentArrElement.provider = "hoopz";
                            contentArrElement.providerImage = 'es_img/images/provider-hoopz.png';
                            contentArrElement.keyword = contentKeyword;

                            try {
                                if (title != "") {
                                    contentResultTiles.push(contentArrElement);
                                }
                            } catch (err) {
                            }
                        });
                    }
                });


            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //console.log("inside failure");
                if (callback != "") {
                    window[callback]();//
                    //callback();
                }
            }
        });
    },

    /////////////////////////// END OF CONTENT FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// BUSINESS FUNCTIONS ///////////////////////////////////////////

    // function to get finance results (Provider : feedzilla, yahoo)
    getBusinessResults = function (callback) {

        try {
            var tags = getLocalStorageItem("businessTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                businessKeyword = '';//getDefaultKeyword('business');

            }
            else {
                var tagsArray = JSON.parse(tags);
                businessKeyword = tagsArray[businessCounter];
                businessCounter++;
                if (businessCounter > tagsArray.length - 1) {
                    businessCounter = 0;
                }

            }
        }
        catch (ex) {
            businessKeyword = '';//getDefaultKeyword('business');
        }

        //dataService.getBusinessResultsYahoo(callback);
        if (COUNTRY.toLowerCase() == "india") {
            dataService.getBusinessResultsToi(callback);
        }
        else {
            dataService.getBusinessResultsFeedzilla(callback)
        }
    },

    // function to get business results from toi
    getBusinessResultsToi = function (callback) {
        var url = "http://timesofindia.feedsportal.com/c/33039/f/533919/index.rss";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'xml',
            timeout: 40000,
            complete: function () {
                dataService.getBusinessResultsFeedzilla(callback);
            },
            success: function (data, textStatus, xhr) {
                //console.log('inside success'); return;
                //console.log("inside toi business results fetch");
                $(data).find('item').each(function () {
                    var title = "";
                    var url = "";
                    var desc = "";
                    
                    try {
                        title = $(this).find('title').text();
                    } catch (err) {
                        title = "";
                    }

                    try {
                        url = $(this).find('link').text();
                    } catch (err) {
                        url = "#";
                    }

                    try {
                        desc = $(this).find('description').text();
                        desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");
                    } catch (err) {
                        desc = "";
                    }

                    var financeArrElement = new FinanceNewsResultClass();
                    financeArrElement.title = title;
                    financeArrElement.desc = desc;
                    financeArrElement.url = url;
                    financeArrElement.providerImage = 'es_img/images/provider-TOI.png';
                    financeArrElement.keyword = businessKeyword;

                    try {
                        financeResults.push(financeArrElement);
                    }
                    catch (err) {
                    }
                });

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                dataService.getBusinessResultsFeedzilla(callback);
            }
        });
    },

    // function to get business results : Feedzilla
    getBusinessResultsFeedzilla = function (callback) {
        var url = "http://news.feedzilla.com/" + getCultureCode() + "/headlines/top-news/business.rss";
        var dataType = "xml";
        var response = "";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                dataService.getBusinessResultsYahoo(callback);
                
            },
            success: function (data, textStatus, xhr) {

                $(data).find('channel').each(function () {
                    $(data).find('item').each(function () {
                        var title = "";
                        var desc = "";
                        var url = "";
                        
                        try {
                            title = ($(this).find('title').text());
                        } catch (err) {
                            title = "";
                        }

                        try {
                            desc = ($(this).find('description').text());
                            desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");
                        } catch (err) {
                            desc = "";
                        }

                        try {
                            url = ($(this).find('link').text());
                        } catch (err) {
                            url = "#";
                        }


                        var financeArrElement = new FinanceNewsResultClass();
                        financeArrElement.title = title;
                        financeArrElement.desc = desc;
                        financeArrElement.url = url;
                        financeArrElement.providerImage = 'es_img/images/provider-feedzilla.png';
                        financeArrElement.keyword = businessKeyword;


                        try {
                            financeResults.push(financeArrElement);
                        }
                        catch (err) {
                        }

                    });
                });
            }, // end of success function
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                dataService.getBusinessResultsYahoo(callback);
            }
        });
    },

    // function to get business results : yahoo
    getBusinessResultsYahoo = function (callback) {
        url = "http://feeds.finance.yahoo.com/rss/2.0/headline?s=%5EDJI&region=US&lang=en-US";

        var dataType = "xml";
        var response = "";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {

                $(data).find('channel').each(function () {
                    $(data).find('item').each(function () {
                        var title = "";
                        var desc = "";
                        var pubdate = "";
                        var url = "";
                        var displayDate = "";

                        try {
                            title = ($(this).find('title').text());
                        } catch (err) {
                            title = "";
                        }

                        try {
                            desc = ($(this).find('description').text());
                            desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");
                        } catch (err) {
                            desc = "Not Found";
                        }

                        try {
                            pubdate = ($(this).find('pubDate').text());
                            var d = new Date(pubdate);
                            pubdate = d.toLocaleString();

                            var fmt = new DateFmt();
                            displayDate = fmt.format(new Date(pubdate), "(%n %d, %y - %H:%M:%S)");
                        } catch (err) {
                            pubdate = "";
                        }

                        try {
                            url = ($(this).find('link').text());
                        } catch (err) {
                            url = "#";
                        }


                        var financeArrElement = new FinanceNewsResultClass();
                        financeArrElement.title = title;
                        financeArrElement.desc = desc;
                        financeArrElement.url = url;
                        financeArrElement.providerImage = 'es_img/images/provider-yahoo.png';
                        financeArrElement.keyword = businessKeyword;

                        try {
                            financeResults.push(financeArrElement);
                        }
                        catch (err) {
                        }

                    });
                });
            }, // end of success function
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF BUSINESS FUNCTIONS ///////////////////////////////////////////
    
    /////////////////////////// AMAZON FUNCTIONS ///////////////////////////////////////////

    // function to display amazon results (Provider : Amazon)
    getAmazonResults = function (callback) {

        try {
            var tags = getLocalStorageItem("amazonTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                amazonKeyword = getDefaultKeyword('amazon');

            }
            else {
                var tagsArray = JSON.parse(tags);
                amazonKeyword = tagsArray[amazonCounter];
                amazonCounter++;
                if (amazonCounter > tagsArray.length - 1) {
                    amazonCounter = 0;
                }

            }
        }
        catch (ex) {
            amazonKeyword = getDefaultKeyword('amazon');
        }


        var slidingAmzon = document.getElementById('slidingAmazon');

        isLoadMoreClicked = false;
        var amazonResponse = "";
        var loadmore = false;
        var totalPages = 0;
        keyword = "deals";

        var url = "";
        url += "http://ecs.amazonaws." + getAmazonWSEndpoint() + "/onca/xml?";
        url += "Service=AWSECommerceService";
        url += "&Version=2011-08-01";
        url += "&Operation=ItemSearch";
        url += "&Keywords=" + encodeURIComponent(amazonKeyword);
        url += "&SearchIndex=All";
        url += "&AssociateTag=hoopz03-20";
        url += "&ResponseGroup=Small,OfferSummary,Images,ItemAttributes";
        url += "&ItemPage=1";

        url = signAmazonURL(url);
        dataType = "xml";

        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            beforeSend: function (xhr) {
                xhr.setRequestHeader("Cache-Control", "no-cache");
                xhr.setRequestHeader("pragma", "no-cache");
            },
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data, textStatus, xhr) {
                $(data).find('Items').each(function () {
                    totalPages = $(this).find('TotalPages').text();

                    var title = "";
                    var price = "";
                    var countleft = "";
                    var imgPath = "";
                    var url = "";

                    $(this).find('Item').each(function () {
                        try {
                            $(this).find('ItemAttributes').each(function () {
                                title = $(this).find('Title').text();
                            });
                        } catch (err) {
                            title = keyword;
                        }

                        try {
                            $(this).find('OfferSummary').each(function () {
                                countleft = $(this).find('TotalNew').text();
                                $(this).find('LowestNewPrice').each(function () {
                                    price = $(this).find('FormattedPrice').text();
                                });
                            });
                        } catch (err) {
                            price = "";
                            countleft = "";
                        }

                        try {
                            $(this).find('SmallImage').each(function () {
                                imgPath = $(this).find('URL').text();
                            });
                        } catch (err) {
                            imgPath = "es_img/images/amazon-sm.jpg";
                        }

                        try {
                            url = $(this).find('DetailPageURL').text();
                        } catch (err) {
                            url = "#";
                        }

                        var amazonArrElement = new AmazonResultClass();
                        amazonArrElement.title = title;
                        amazonArrElement.url = url;
                        amazonArrElement.imgPath = imgPath;
                        amazonArrElement.price = price;
                        amazonArrElement.providerImage = 'es_img/images/provider-amazon.png';
                        amazonArrElement.keyword = amazonKeyword;

                        try {
                            amazonResultsTiles.push(amazonArrElement);
                        }
                        catch (err) {
                        }
                    });
                });
            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    },

    /////////////////////////// END OF AMAZON FUNCTIONS ///////////////////////////////////////////
  

    /////////////////////////// INFO FUNCTIONS ///////////////////////////////////////////
    
    // function to display info results (Provider : feedzilla, yelp, hoopz)
    getInfoResults = function (callback) {

        try {
            var tags = getLocalStorageItem("infoTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                infoKeyword = getDefaultKeyword('info');

            }
            else {
                var tagsArray = JSON.parse(tags);
                infoKeyword = tagsArray[infoCounter];
                infoCounter++;
                if (infoCounter > tagsArray.length - 1) {
                    infoCounter = 0;
                }

            }
        }
        catch (ex) {
            infoKeyword = getDefaultKeyword('info');
        }

       // alert(infoKeyword);
        this.getInfoResultsFeedzilla(callback);
       // this.getInfoResultsYelp(callback);
    },

    // function to display info results : feedzilla
    getInfoResultsFeedzilla = function (callback) {
        var slidingNewsElement = document.getElementById('slidingInfo');
        var keyword;
        var url = "http://api.feedzilla.com/v1/articles/search.json?q=" + encodeURIComponent(infoKeyword) +"&order=relevance&count=10&culture_code=" + getCultureCode();
        //alert(url);
        var dataType = "json";
        var response = "";
        $.ajax({
            url: url,
            type: 'GET',
            dataType: dataType,
            timeout: 20000,
            complete: function () {

                if (isValidCountryForYelp()) {
                    dataService.getInfoResultsYelp(callback);
                }
                else {
                    dataService.getInfoResultsHoopz(callback);
                }
            },
            success: function (data, textStatus, xhr) {
                var totalObj = 0;
                try {
                    totalObj = data.articles.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var desc = "";
                    var url = "";

                    try {
                        title = data.articles[itr].title;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        desc = data.articles[itr].summary;
                    } catch (err) {
                        desc = "";
                    }

                    try {
                        url = data.articles[itr].url;
                    } catch (err) {
                        url = "#";
                    }

                    var infoArrElement = new InfoResultClass();
                    infoArrElement.title = title;
                    infoArrElement.desc = desc;
                    infoArrElement.url = url;
                    infoArrElement.imgPath = '';
                    infoArrElement.providerImage = 'es_img/images/provider-feedzilla.png';
                    infoArrElement.keyword = infoKeyword;

                    try {
                        infoResultTiles.push(infoArrElement);
                    }
                    catch (err) {

                    }
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (isValidCountryForYelp()) {
                    dataService.getInfoResultsYelp(callback);
                }
                else {
                    dataService.getInfoResultsHoopz(callback);
                }
            }
        });
    },

    // function to display info results : yelp
    getInfoResultsYelp = function (callback) {
        var auth = {
            consumerKey: "jLvHRs47MogGBBqW6Leemw",
            consumerSecret: "KowW_xtoc_8z5OfS_JbfqKrYyEE",
            accessToken: "oJ2E8dB4X7N-WeSkdQY8gfmItGdPEkdG",
            accessTokenSecret: "zfDIVgPUzcjgQFlE4GXu2TXXS-k",
            serviceProvider: {
                signatureMethod: "HMAC-SHA1"
            }
        };

        var terms = infoKeyword;
        var near = CITY;

        var accessor = {
            consumerSecret: auth.consumerSecret,
            tokenSecret: auth.accessTokenSecret
        };
        parameters = [];
        parameters.push(['term', terms]);
        parameters.push(['location', near]);
        //parameters.push(['callback', 'cb']);
        parameters.push(['oauth_consumer_key', auth.consumerKey]);
        parameters.push(['oauth_consumer_secret', auth.consumerSecret]);
        parameters.push(['oauth_token', auth.accessToken]);
        parameters.push(['oauth_signature_method', 'HMAC-SHA1']);
        if (LATITUDE != "" && LONGITUDE != "") {
            var loatlongdata = LATITUDE + ',' + LONGITUDE;
            parameters.push(['li', loatlongdata]);
        }
        //parameters.push(['li', '37.7833,122.4167']); // coordinates for sanfrancisco

       
        var message = {
            'action': 'http://api.yelp.com/v2/search',
            'method': 'GET',
            'parameters': parameters
        };
        
        OAuth.setTimestampAndNonce(message);
        //alert(OAuth);
        OAuth.SignatureMethod.sign(message, accessor);

        var parameterMap = OAuth.getParameterMap(message.parameters);
        
        var dataType = "json";
        var response = "";
        $.ajax({
            url: message.action,
            type: 'GET',
            data: parameterMap,
            dataType: dataType,
            timeout: 20000,
            complete: function () {
                dataService.getInfoResultsHoopz(callback);
            },
            success: function (data, textStatus, xhr) {
                
                var totalResult = data.total;
                var totalObj = 0;
                try {
                    totalObj = data.businesses.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    var address = "";
                    var imgPath = "";
                    var url = "";

                    try {
                        title = data.businesses[itr].name;
                    } catch (err) {
                        title = "";
                    }

                    try {
                        address = data.businesses[itr].location.display_address[0];
                    } catch (err) {
                        address = "";
                    }

                    

                    try {
                        imgPath = data.businesses[itr].image_url;
                    } catch (err) {
                        imgPath = "es_img/images/info-sm.jpg";
                    }

                    try {
                        url = data.businesses[itr].url;
                    } catch (err) {
                        url = "#";
                    }


                    var infoArrElement = new InfoResultClass();
                    infoArrElement.title = title;
                    infoArrElement.desc = address;
                    infoArrElement.url = url;
                    infoArrElement.imgPath = imgPath;
                    infoArrElement.providerImage = 'es_img/images/provider-yelp.png';
                    infoArrElement.keyword = infoKeyword;

                    try {
                        infoResultTiles.push(infoArrElement);
                    }
                    catch (err) {

                    }
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                dataService.getInfoResultsHoopz(callback);
            }
        });
    },

    // function to display info results : hoopz
    getInfoResultsHoopz = function (callback) {
        //console.log("inside info fetch for hoopz");
        var isLoadMoreClicked = false;
        var hoopzInfoResponse = "";
        var loadmore = false;
        var keyword = "";
        try {
            var tags = getLocalStorageItem("infoTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                keyword = "";
            }
            else {
                keyword = infoKeyword;
            }
        }
        catch (ex) {
            keyword = "";
        }


        var url = BASE_URL + "AdvertiserService/fetchInfo";

        var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
        var payload = "";
        payload += "<request>";
		payload += "<app>" +APPLICATION_TITLE + "</app>"
        payload += "<keywords>" + keyword + "</keywords>"
        payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>"
        payload += "<modelName>" + MODEL_NAME + "</modelName>"
        payload += "<modelId>" + MODEL_ID + "</modelId>"
        payload += "<os>" + OS + "</os>"
        payload += "<deviceType>" + "phone" + "</deviceType>"
        payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
        payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
        payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
        payload += "<carrier>" + "" + "</carrier>"
        payload += "<adType>" + "3" + "</adType>"
        payload += "<imeiNumber>" + IMEI_NO + "</imeiNumber>"
        payload += "<mobileNo>" + "" + "</mobileNo>"
        payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
        payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
        payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
        payload += "<language>" + DEVICE_LANG + "</language>"
        payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
        payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
        payload += "<geoLocation>" + temp + "</geoLocation>"
        payload += "<pageNo>" + hoopzInfoPageNumber + "</pageNo>"
        payload += "<clientId>" + CLIENT_ID + "</clientId>"
        payload += "</request>";

        //console.log("HOOPZ INFO REQUEST ================= " + payload);

        $.ajax({
            url: url,
            type: "POST",
            data: payload,
            timeout: 70000,
            contentType: "application/xml",
            Cookie: "JSESSIONID=",

            beforeSend: function (xhr) {
                xhr.setRequestHeader("Cache-Control", "no-cache");
                xhr.setRequestHeader("pragma", "no-cache");
            },

            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },

            success: function (data) {
                $(data).find('response').each(function () {
                    var status = $(this).find('status').text();

                    if (status == '1' || status == '3') {
                        loadmore = $(this).find('loadMore').text();

                        $(this).find('info').each(function () {
                            var title = '';
                            var desc = '';
                            var price = '';
                            var imgPath = '';
                            var url = '';

                            try {
                                title = $(this).find('title').text();
                            } catch (err) {
                                title = "";
                            }
                            try {
                                desc = $(this).find('description').text();
                            } catch (err) {
                                desc = "";
                            }
                            
                            try {
                                imgPath = $(this).find('previewImage').text();
                                imgPath = decodeURIComponent(imgPath);
                            } catch (err) {
                                imgPath = "es_img/images/info-sm.jpg";
                            }
                            try {
                                url = $(this).find('clickURL').text();
                                url = decodeURIComponent(url);
                            } catch (err) {
                                url = "#";
                            }

                            

                            var infoArrElement = new InfoResultClass();
                            infoArrElement.title = title;
                            infoArrElement.desc = desc;
                            infoArrElement.url = url;
                            infoArrElement.imgPath = imgPath;
                            infoArrElement.providerImage = 'es_img/images/provider-hoopz.png';
                            infoArrElement.keyword = infoKeyword;

                            try {
                                infoResultTiles.push(infoArrElement);
                            }
                            catch (err) {

                            }
                        });
                    }
                });

                if (loadmore == "1") {
                    hoopzInfoPageNumber = hoopzInfoPageNumber + 1;
                    hoopzInfoSeeMore = "YES";
                    INFO_SEEMORE_FLAG = true;
                } else {
                    hoopzInfoSeeMore = "NO";
                }
            },

            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    }

    /////////////////////////// END OF INFO FUNCTIONS ///////////////////////////////////////////

    /////////////////////////// FACEBOOK FUNCTIONS ///////////////////////////////////////////

     // function to get social results (Provider : facebook)
    getFacebookResults = function (callback) {

        try {
            var tags = getLocalStorageItem("facebookTags");
            if (tags == null || tags == undefined || tags == "") {
                // no tags saved get default keyword
                facebookKeyword = getDefaultKeyword('facebook');

            }
            else {
                var tagsArray = JSON.parse(tags);
                facebookKeyword = tagsArray[facebookCounter];
                facebookCounter++;
                if (facebookCounter > tagsArray.length - 1) {
                    facebookCounter = 0;
                }

            }
        }
        catch (ex) {
            facebookKeyword = getDefaultKeyword('facebook');
        }

		var isLoadMoreClicked = false;
        
        url = "https://graph.facebook.com/search?q=" + facebookKeyword + "&type=page&limit=20&access_token=" + encodeURIComponent(FACEBOOK_AUTH_KEY);
        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            timeout: 20000,
            complete: function () {
                if (callback != "") {
                    window[callback]();//callback();
                }
            },
            success: function (data1, textStatus, xhr) {
                var totalObj = 0;
                try {
                    totalObj = data1.data.length;
                } catch (err) {
                    totalObj = 0;
                }

                for (var itr = 0; itr < totalObj; itr++) {
                    var title = "";
                    //var profile_name = "";
                    var desc = "";
                    //var message = "";
                    //var caption = "";
                    //var story = "";
                    //var source = "";
                    //var type = "";
                    //var link = "";
                    //var likes = "";
                    var imgPath = "";
                    var url = "";

                    try {
                        title = data1.data[itr].name;
                    } catch (err) {
                        title = "";
                    }

                    /*try {
                        profile_name = data1.data[itr].from.name;
                    } catch (err) {
                        profile_name = "";
                    }*/

                    try {
                        desc = data1.data[itr].category;
                    } catch (err) {
                        desc = "";
                    }

                    /*try {
                        message = data1.data[itr].message;
                    } catch (err) {
                        message = "";
                    }

                    try {
                        caption = data1.data[itr].caption;
                    } catch (err) {
                        caption = "";
                    }

                    try {
                        story = data1.data[itr].story;
                    } catch (err) {
                        story = "";
                    }

                    try {
                        source = data1.data[itr].source;
                    } catch (err) {
                        source = "#";
                    }

                    try {
                        type = data1.data[itr].type;
                    } catch (err) {
                        type = "#";
                    }

                    try {
                        link = data1.data[itr].link;
                    } catch (err) {
                        link = "#";
                    }

                    try {
                        likes = data1.data[itr].likes.count;
                    } catch (err) {
                        likes = "";
                    }
					*/
                    try {
                        //imgPath = "https://graph.facebook.com/" + data1.data[itr].from.id + "/picture";
						imgPath = "https://graph.facebook.com/" + data1.data[itr].id + "/picture";
                    } catch (err) {
                        imgPath = "es_img/images/facebook-sm.jpg";
                    }

                    try {
                        url = "http://www.facebook.com/" + data1.data[itr].id;
                    } catch (err) {
                        url = "#";
                    }
					/*
                    var myTitle = "";
                    var myDesc = "";
                    var myMessage = "";
                    var mySource = "";

                    if (type.toLowerCase() == "video") {
                        myTitle = title;
                        myDesc = desc;
                        myMessage = "";
                        mySource = source;
                    } else if (type.toLowerCase() == "photo") {
                        if (story != null && story.trim() != "") {
                            myTitle = story;
                        } else {
                            myTitle = profile_name;
                        }
                        myDesc = caption;
                        myMessage = message;
                        mySource = "";
                    } else if (type.toLowerCase() == "link") {
                        myTitle = profile_name;
                        if (desc != null && desc.trim() != "") {
                            myDesc = desc;
                        } else {
                            myDesc = caption;
                        }
                        myMessage = message;
                        mySource = link;
                    } else if (type.toLowerCase() == "status") {
                        myTitle = profile_name;
                        myDesc = message;
                        myMessage = "";
                        mySource = "";
                    } else {
                        myTitle = profile_name;
                        myDesc = desc;
                    }

					*/
                    var fbPostArrElement = new FacebookPostClass();
                    fbPostArrElement.title = title;
                    //fbPostArrElement.profile_name = profile_name;
                    fbPostArrElement.desc = desc;
                    //fbPostArrElement.message = message;
                    //fbPostArrElement.caption = caption;
                    //fbPostArrElement.story = story;
                    //fbPostArrElement.source = source;
                    //fbPostArrElement.link = link;
                    //fbPostArrElement.likes = likes;
                    fbPostArrElement.imgPath = imgPath;
                    fbPostArrElement.url = url;
                    fbPostArrElement.providerImage = 'es_img/images/provider-facebook.png';
                    fbPostArrElement.keyword = facebookKeyword;

                    try {
                        facebookPostResult.push(fbPostArrElement);
                    }
                    catch (err) {
                        
                    } // end of try catch

                }// end of for loop

                
            }, // end of success method in ajax call

            error: function (XMLHttpRequest, textStatus, errorThrown) {
				if (callback != "") {
                    window[callback]();//callback();
                }
            }
        });
    }

    /////////////////////////// END OF FACEBOOK FUNCTIONS ///////////////////////////////////////////

    return {
        getFacebookResults  : getFacebookResults,

        getNewsResults: getNewsResults,
        getNewsResultsTimes: getNewsResultsTimes,
        getNewsResultsFeedzilla: getNewsResultsFeedzilla,

        getRestaurantsResults: getRestaurantsResults,
        getRestauarantsResultsZomato: getRestauarantsResultsZomato,
        getZomatoCityResults: getZomatoCityResults,
        getZomatoRestResults: getZomatoRestResults,
        getRestauarantsResultsYelp : getRestauarantsResultsYelp,


        getBusinessResults: getBusinessResults,
        getBusinessResultsToi : getBusinessResultsToi,
        getBusinessResultsFeedzilla: getBusinessResultsFeedzilla,
        getBusinessResultsYahoo: getBusinessResultsYahoo,

        getMusicResults     : getMusicResults,

        getVideoResults     : getVideoResults,
        getVideoResultsYoutube: getVideoResultsYoutube,
        getVideoResultsToi  : getVideoResultsToi,

        getSportResults: getSportResults,
        getSportResultsEspn: getSportResultsEspn,
        getSportResultsTimes : getSportResultsTimes,

        getAmazonResults    : getAmazonResults,
        getEbayResults      : getEbayResults,

        getJobResults: getJobResults,
        getJobResultsMonster: getJobResultsMonster,
        getJobResultsIndeed : getJobResultsIndeed,

        getDealsResults: getDealsResults,
        getDealsResultsGroupon : getDealsResultsGroupon,

        getContentResults: getContentResults,
        getContentResultsImdb : getContentResultsImdb,
        getContentResultsHoopz: getContentResultsHoopz,


        getHotelResults: getHotelResults,

        getInfoResults: getInfoResults,
        getInfoResultsFeedzilla: getInfoResultsFeedzilla,
        getInfoResultsYelp: getInfoResultsYelp,
        getInfoResultsHoopz: getInfoResultsHoopz
    };

}();