﻿function fetchImdb() {
    
    var slidingContent = document.getElementById('slidingContent');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingContent.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    isLoadMoreClicked = false;
    var tmdbContentResponse = "";
    var loadmore = false;

    var lang = DEVICE_LANG;

    if (lang == null || lang.trim() == "") {
        lang = "en";
    }
    lang = lang.replace("_", "-");
    keyword = "cricket";
    //url = "http://api.themoviedb.org/2.1/Movie.browse/" + lang + "/json/775772da896aaae174da37dac04f01af?order_by=title&order=asc&page=" + tmdbContentPageNumber + "&per_page=10";
    url = "http://api.themoviedb.org/3/movie/upcoming?api_key=1819ac51ad73a28b9567b91c8feb66be";
    //console.log("CONTENT URL : " + url);
    dataType = "json";


    $.ajax({
        url: url,
        type: 'GET',
        dataType: dataType,
        timeout: 20000,
        success: function (data, textStatus, xhr) {
            var totalObj = 0;
            try {
                totalObj = data.total_results;
            } catch (err) {
                totalObj = 0;
            }

            if (totalObj >= 10) {
                loadmore = true;
            }

            for (var itr = 0; itr < totalObj; itr++) {
                /*try {
                    if (data[itr].toLowerCase().indexOf("nothing") >= 0) {
                        continue;
                    }
                } catch (err) {

                }*/
                var title = "";
                var desc = "";
                var date = "";
                var rating = "";
                var imgPath = "";
                var url = "";

                try {
                    //title = data[itr].name;
                    title = data.results[itr].title;
                } catch (err) {
                    title = "";
                }

                try {
                    //desc = data[itr].overview;
                    desc = "";
                } catch (err) {
                    desc = "";
                }

                try {
                    //date = data[itr].released;
                    date = data.results[itr].release_date;
                } catch (err) {
                    date = "";
                }

                try {
                    //rating = data[itr].rating;
                    rating = data.results[itr].popularity;
                } catch (err) {
                    rating = "0.0";
                }

                try {
                    //imgPath = data[itr].posters[0].image.url;
                    imgPath = "http://d3gtl9l2a4fn1j.cloudfront.net/t/p/w500"+data.results[itr].poster_path;
                } catch (err) {
                    imgPath = "es_img/content.png";
                }

                try {
                    url = data[itr].url;
                } catch (err) {
                    url = "#";
                }

                tmdbContentResponse += '<div class="result slide">';
                tmdbContentResponse += '<a href="' + url + '" target="_blank">';
                tmdbContentResponse += '<dl>';
                tmdbContentResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                tmdbContentResponse += '<dd>';
                tmdbContentResponse += '<p>' + title + '</p>';
                tmdbContentResponse += '<p>' + desc + '';
                tmdbContentResponse += '<p>Date : ' + date + '</p>';
                tmdbContentResponse += '<p>Rating : ' + rating + '</p>';
                tmdbContentResponse += '</dd>';
                tmdbContentResponse += '</dl>';
                tmdbContentResponse += '</a>';
                tmdbContentResponse += '</div>';
            }

            
            if (tmdbContentResponse != '') {
                slidingContent.innerHTML = window.toStaticHTML(tmdbContentResponse);
                $('#slidingContent').jshowoff({
                    effect: 'fade',
                    //controlText:{play:'Reproducir',pause:'Pausar',previous:'Anterior',next:'Siguiente'},
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingContent.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            slidingContent.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}

function fetchDeals() {
    /*if (CONTRY_CODE.toLowerCase() == "in") {
        fetchTimesDeals();
    }
    else {
        fetchGroupOnDeals();
    }*/
    //fetchTimesDeals();
    fetchGroupOnDeals();
    
}

function fetchTimesDeals() {
    var slidingDeals = document.getElementById('slidingDeals');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingDeals.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    var timesdealResponse = "";
    url = "http://timesdeal.com/feeds/json-for-All-India.json";
    dataType = "json";

    $.ajax({
        url: url,
        type: 'GET',
        //dataType: dataType,
        timeout: 20000,

        beforeSend: function (xhr) {
            xhr.setRequestHeader("Cache-Control", "no-cache");
            xhr.setRequestHeader("pragma", "no-cache");
        },

        success: function (data, textStatus, xhr) {
            // console.log("data from timesdeal : " + data);
            data = jQuery.parseJSON(data);
            //  console.log("after parsing data from timesdeal : " + data);
            var totalObj = 0;
            try {
                totalObj = data.DealDetails.length;
            } catch (err) {
                totalObj = 0;
            }

            for (var itr = 0; itr < totalObj; itr++) {
                var title = "";
                var desc = "";
                var imgPath = "";
                var url = "";

                try {
                    title = data.DealDetails[itr].DealShortDescription;
                } catch (err) {
                    title = "";
                }

                try {
                    desc = data.DealDetails[itr].DealDescription;
                } catch (err) {
                    desc = "";
                }

                try {
                    imgPath = data.DealDetails[itr].DealImages.image_path[0];
                } catch (err) {
                    imgPath = "es_img/deal_discount_coupon.png";
                }

                try {
                    url = data.DealDetails[itr].DealUrl;
                } catch (err) {
                    url = "#";
                }

                timesdealResponse += '<div class="result slide">';
                timesdealResponse += '<a href="' + url + '" target="_blank">';
                timesdealResponse += '<dl>';
                timesdealResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                timesdealResponse += '<dd>';
                timesdealResponse += '<p>' + title + '</p>';
                timesdealResponse += '<p>' + desc + '</p>';
                timesdealResponse += '</dd>';
                timesdealResponse += '</dl>';
                timesdealResponse += '</a>';
                timesdealResponse += '</div>';

            }
            
            if (timesdealResponse != '') {
                slidingDeals.innerHTML = window.toStaticHTML(timesdealResponse);
                $('#slidingDeals').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingDeals.innerHTML = window.toStaticHTML('<p>else No Content to display </p>');
            }
        },

        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //console.log("Times Deal ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
           // var slidingDeals = document.getElementById('slidingDeals');
            slidingDeals.innerHTML = window.toStaticHTML('<p>errror No Content to display </p>');
        }
    });
}

function fetchGroupOnDealsxml() {

    var grouponResponse = "";
    
    url = "https://partner-int-api.groupon.com/deals.json?country_code=IN&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&division_id=Pune&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
    

    console.log("groupon url " + url);
    dataType = "xml";

    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'jsonp',
        timeout: 95000,
        success: function (data) {
            console.log("group on response");
            console.log(data); return;
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            console.log("Group on ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
           
        }
    });

}

function fetchGroupOnDeals() {
    var grouponResponse = "";
    //url = "https://api.groupon.com/v2/deals.json?client_id=aecf61e7e5838c617704afe1627f20a94a7f5d77&lat=41.8795&lng=-87.6243";
    //url = "https://api.groupon.com/v2/deals.json?client_id=aecf61e7e5838c617704afe1627f20a94a7f5d77&lat=" + LATITUDE + "&lng=" + LONGITUDE;
    /*if (CITY != '' || CITY != null) {
        url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE + "&tsToken=DE_AFF_0_200012_200245_0&CID=DE_AFF_5600_225_5383_1&nlp=&division_id=" + CITY;
    }
    else {
        url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE + "&tsToken=DE_AFF_0_200012_200175_0&CID=DE_AFF_5600_225_5383_1&nlp=";
    }*/

    if (CITY != '' || CITY != null) {
        url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&division_id=" + CITY + "&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
    }
    else {
        url = "https://partner-int-api.groupon.com/deals.json?country_code=" + CONTRY_CODE + "&tsToken=IN_AFF_0_201013_215943_0&CID=IN_AFF_5600_225_5383_1&nlp&utm_source=GPN&utm_medium=afl&utm_campaign=201013";
    }


    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'jsonp',
        timeout: 50000,
        beforeSend: function (xhr) {

        },
        success: function (data, textStatus, xhr) {
            //console.log("GROUP ON DATA : " + data); return;
            var totalObj = 0;
            try {
                totalObj = data.deals.length;
            } catch (err) {
                totalObj = 0;
            }

            for (var itr = 0; itr < totalObj; itr++) {
                var title = "";
                var location = "";
                var name = "";
                var value = "";
                var price = "";
                var discount = "";
                var imgPath = "";
                var url = "";

                try {
                    title = data.deals[itr].announcementTitle;
                    if (title.trim() == "") {
                        title = data.deals[itr].title;
                    }
                } catch (err) {
                    title = "";
                }

                try {
                    location = data.deals[itr].redemptionLocation;
                } catch (err) {
                    location = "";
                }

                try {
                    name = data.deals[itr].merchant.name;
                } catch (err) {
                    name = "";
                }

                var temp = data.deals[itr].options;
                try {
                    value = temp[temp.length - 1].value.formattedAmount;
                } catch (err) {
                    value = "";
                }

                try {
                    price = temp[temp.length - 1].price.formattedAmount;
                } catch (err) {
                    price = "";
                }

                try {
                    discount = temp[temp.length - 1].discount.formattedAmount;
                } catch (err) {
                    discount = "";
                }

                try {
                    imgPath = data.deals[itr].mediumImageUrl;
                } catch (err) {
                    imgPath = "es_img/deal_discount_coupon.png";
                }

                try {
                    url = data.deals[itr].dealUrl;
                } catch (err) {
                    url = "#";
                }

                //if (title.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
                /* var mytable = "";
                 mytable += '<table width="100%" style="margin:0;padding:0;">';
                 mytable += '<tr>';
                 mytable += '<td><a href="' + url + '" target="_blank"><h3>' + title + '</h3></a></td>';
                 mytable += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/groupon.png" /></td>';
                 mytable += '</tr>';

                 mytable += '<tr>';
                 mytable += '<td colspan="2"><p>' + name + " " + location + '</p></td>';
                 mytable += '</tr>';

                 mytable += '<tr>';
                 mytable += '<td colspan="2"><p>Discount : ' + discount + '</p></td>';
                 mytable += '</tr>';

                 mytable += '<tr>';
                 mytable += '<td colspan="2" style="text-align:left;"><p>MRP : ' + value + '  - Sell Price : ' + price + '</p></td>';
                 mytable += '</tr>';
                 mytable += '</table>';

                 grouponResponse += '<dl>';
                 grouponResponse += '<dt><img src="' + imgPath + '" class="imgResult" /></dt>';
                 grouponResponse += '<dd>' + mytable + '</dd>';
                 grouponResponse += '</dl>';*/


                grouponResponse += '<div class="result slide">';
                grouponResponse += '<a href="' + url + '" target="_blank">';
                grouponResponse += '<dl>';
                grouponResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                grouponResponse += '<dd>';
                grouponResponse += '<p>' + title + '</p>';
               // grouponResponse += '<p>MRP : ' + value + '  - Sell Price : ' + price + '</p>';
                grouponResponse += '</dd>';
                grouponResponse += '</dl>';
                grouponResponse += '</a>';
                grouponResponse += '</div>';

                //}
            }

            var slidingDeals = document.getElementById('slidingDeals');
            if (grouponResponse != '') {
                slidingDeals.innerHTML = window.toStaticHTML(grouponResponse);
                $('#slidingDeals').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingDeals.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            slidingDeals.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}

function getFacebookResults() {
    var slidingFb = document.getElementById('slidingFb');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingFb.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Facebook')) {
        slidingFb.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }
    
    var isLoadMoreClicked = false;
    var facebookPostResponse = "";

    /*if (facebookPostNext.trim() == "") {
        url = "https://graph.facebook.com/search?q=null&type=post&limit=20&access_token=" + encodeURIComponent("543040232424689|06kZI4pZvJMwEFdGyrXU4qez51I");
    } else {
        url = facebookPostNext;
    }
    dataType = "josn";*/

    url = "https://graph.facebook.com/search?q="+HOME_TILE_KEYWORD+"&type=post&limit=20&access_token=" + encodeURIComponent("543040232424689|06kZI4pZvJMwEFdGyrXU4qez51I");
    


    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'json',
        //jsonpCallback: 'cb',
        timeout: 20000,
        success: function (data1, textStatus, xhr) {
            console.log("Data from facebook service : " + data1);
            var totalObj = 0;
            try {
                totalObj = data1.data.length;
            } catch (err) {
                totalObj = 0;
            }

            for (var itr = 0; itr < totalObj; itr++) {
                var title = "";
                var profile_name = "";
                var desc = "";
                var message = "";
                var caption = "";
                var story = "";
                var source = "";
                var type = "";
                var link = "";
                var likes = "";
                var imgPath = "";
                var url = "";

                try {
                    title = data1.data[itr].name;
                } catch (err) {
                    title = "";
                }

                try {
                    profile_name = data1.data[itr].from.name;
                } catch (err) {
                    profile_name = "";
                }

                try {
                    desc = data1.data[itr].description;
                } catch (err) {
                    desc = "";
                }

                try {
                    message = data1.data[itr].message;
                } catch (err) {
                    message = "";
                }

                try {
                    caption = data1.data[itr].caption;
                } catch (err) {
                    caption = "";
                }

                try {
                    story = data1.data[itr].story;
                } catch (err) {
                    story = "";
                }

                try {
                    source = data1.data[itr].source;
                } catch (err) {
                    source = "#";
                }

                try {
                    type = data1.data[itr].type;
                } catch (err) {
                    type = "#";
                }

                try {
                    link = data1.data[itr].link;
                } catch (err) {
                    link = "#";
                }

                try {
                    likes = data1.data[itr].likes.count;
                } catch (err) {
                    likes = "";
                }

                try {
                    imgPath = "https://graph.facebook.com/" + data1.data[itr].from.id + "/picture";
                } catch (err) {
                    imgPath = "es_img/facebook.png";
                }

                try {
                    url = "http://www.facebook.com/" + data1.data[itr].id;
                } catch (err) {
                    url = "#";
                }

                var myTitle = "";
                var myDesc = "";
                var myMessage = "";
                var mySource = "";

                if (type.toLowerCase() == "video") {
                    myTitle = title;
                    myDesc = desc;
                    myMessage = "";
                    mySource = source;
                } else if (type.toLowerCase() == "photo") {
                    if (story != null && story.trim() != "") {
                        myTitle = story;
                    } else {
                        myTitle = profile_name;
                    }
                    myDesc = caption;
                    myMessage = message;
                    mySource = "";
                } else if (type.toLowerCase() == "link") {
                    myTitle = profile_name;
                    if (desc != null && desc.trim() != "") {
                        myDesc = desc;
                    } else {
                        myDesc = caption;
                    }
                    myMessage = message;
                    mySource = link;
                } else if (type.toLowerCase() == "status") {
                    myTitle = profile_name;
                    myDesc = message;
                    myMessage = "";
                    mySource = "";
                } else {
                    myTitle = profile_name;
                    myDesc = desc;
                }

                facebookPostResponse += '<div class="result slide">';
                facebookPostResponse += '<a href="' + url + '" target="_blank">';
                facebookPostResponse += '<dl>';
                facebookPostResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                facebookPostResponse += '<dd>';
                facebookPostResponse += '<p>' + myTitle + '</p>';
                facebookPostResponse += '<p>' + myDesc + '</p>';

                if (myMessage != null && myMessage.trim() != "") {
                    facebookPostResponse += '<p>' + myMessage + '</p>';
                }

                if (likes != null) {
                    facebookPostResponse += '<p>Likes :' + likes + '</p>';
                }

                facebookPostResponse += '</dd>';
                facebookPostResponse += '</dl>';
                facebookPostResponse += '</a>';
                facebookPostResponse += '</div>';

            }
            
            if (facebookPostResponse != '') {
                slidingFb.innerHTML = window.toStaticHTML(facebookPostResponse);
                $('#slidingFb').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingFb.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
        },

        error: function (XMLHttpRequest, textStatus, errorThrown) {
           // var slidingFb = document.getElementById('slidingFb');
            slidingFb.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
        }
    });
}

function getTwiiterSearch(twitterOAuthInstance, callback) {
    var queryParams,
        url = 'https://api.twitter.com/1.1/search/tweets.json';

        queryParams = {
            //'screen_name': 'microsoft'
            'q': HOME_TILE_KEYWORD,
            'count': '10',
            'lang': 'eu'
        };

    twitterOAuthInstance.sendAuthorizedRequestForUser(url, 'GET', queryParams)
        .then(function (response) {
            callback(response.results);
        })
        .done();
}

function getTwitterResults() {
    var slidingTwitter = document.getElementById('slidingTwitter');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingTwitter.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Twitter')) {
        slidingTwitter.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }

    isLoadMoreClicked = false;
    var twitterResponse = "";

    twitterOAuthInstance = new TwitterOAuth(Twitter.OAuth.Config.consumerKey, Twitter.OAuth.Config.consumerSecret,
                              Twitter.OAuth.Config.userOAuthToken, Twitter.OAuth.Config.userOAuthTokenSecret);

    getTwiiterSearch(twitterOAuthInstance, function (data) {
        // twitterResponseNode.innerHTML = JSON.stringify(profile);

        
        data = JSON.parse(data);
        //console.log(json.statuses.length);
        var total = 0;
        try{
            total = data.statuses.length;
        }
        catch (exception) {
            total = 0;
        }
        for (var i = 0; i < total; i++) {
            var title = "";
            var desc = "";
            var date = "";
            var imgPath = "";
            var url = "";

            try {
                title = data.statuses[i].user.name;
            } catch (err) {
                title = "";
            }

            try {
                desc = data.statuses[i].text;
            } catch (err) {
                desc = "";
            }

            try {
                date = data.statuses[i].created_at;
            } catch (err) {
                date = "";
            }

            try {
                imgPath = data.statuses[i].user.profile_image_url;
            } catch (err) {
                imgPath = "es_img/twitter.png";
            }

            try {
                url = 'http://twitter.com/' + data.statuses[i].user.screen_name + '/status/' + data.statuses[i].id_str;
            } catch (err) {
                url = "#";
            }


            twitterResponse += '<div class="result slide">';
            twitterResponse += '<a href="' + url + '" target="_blank">';
            twitterResponse += '<dl>';
            twitterResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
            twitterResponse += '<dd>';
            twitterResponse += '<p>' + title + '</p>';
            twitterResponse += '<p>' + desc + '</p>';
            twitterResponse += '<p>Date : ' + date + '</p>';;
            twitterResponse += '</dd>';
            twitterResponse += '</dl>';
            twitterResponse += '</a>';
            twitterResponse += '</div>';
        }


        if (twitterResponse != '') {
            slidingTwitter.innerHTML = window.toStaticHTML(twitterResponse);
            $('#slidingTwitter').jshowoff({
                effect: 'fade',
                hoverPause: true,
                controls: false,
                links: false,
                speed: 5000
            });
        }
        else {
            slidingTwitter.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }

        //totalObj = profile.statuses.count;
        //console.log("total Twitter results : " + totalObj);
    });
    
}


/*this function is not getting used*/
function getTwitterResultsOldOne() {
    var slidingTwitter = document.getElementById('slidingTwitter');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingTwitter.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Twitter')) {
        slidingTwitter.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }

    isLoadMoreClicked = false;
    var twitterResponse = "";
    /*url = "http://search.twitter.com/search.json?q=null&page=1";*/
    url = "https://api.twitter.com/1.1/search/tweets.json" ;

   

    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'json',
        timeout: 70000,
        beforeSend: function (xhr) {
            xhr.setRequestHeader("Bearer", "AAAAAAAAAAAAAAAAAAAAACt6KgAAAAAAVlZOEKI5DD3kH9Rx4q5KtYLEooI%3DsnWNUyxxBsjiCPKBC8pL2APZwRG5nomL2fHaRUHDHpTUG98Ewd");
        },

        

        success: function (data, textStatus, xhr) {
            var totalObj = 0;
            try {
                totalObj = data.results.length;
            } catch (err) {
                totalObj = 0;
            }

            try {
                twitterPageNext = data.next_page;
            } catch (err) {
                twitterPageNext = "";
            }

            for (var itr = 0; itr < totalObj; itr++) {
                var title = "";
                var desc = "";
                var date = "";
                var imgPath = "";
                var url = "";

                try {
                    title = data.results[itr].from_user;
                } catch (err) {
                    title = "";
                }

                try {
                    desc = data.results[itr].text;
                } catch (err) {
                    desc = "";
                }

                try {
                    date = data.results[itr].created_at;
                } catch (err) {
                    date = "";
                }

                try {
                    imgPath = data.results[itr].profile_image_url;
                } catch (err) {
                    imgPath = "es_img/twitter.png";
                }

                try {
                    url = "http://mobile.twitter.com/#!/" + title;
                } catch (err) {
                    url = "#";
                }


                twitterResponse += '<div class="result slide">';
                twitterResponse += '<a href="' + url + '" target="_blank">';
                twitterResponse += '<dl>';
                twitterResponse += '<dt><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                twitterResponse += '<dd>';
                twitterResponse += '<p>' + title + '</p>';
                twitterResponse += '<p>' + desc + '</p>';
                twitterResponse += '<p>Date : ' + date + '</p>';;
                twitterResponse += '</dd>';
                twitterResponse += '</dl>';
                twitterResponse += '</a>';
                twitterResponse += '</div>';

            }
           // var slidingTwitter = document.getElementById('slidingTwitter');
            if (twitterResponse != '') {
                slidingTwitter.innerHTML = window.toStaticHTML(twitterResponse);
                $('#slidingTwitter').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingTwitter.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }

        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            console.log("twitter error : " + textStatus.toString() + " - " + errorThrown.toString());
            
            slidingTwitter.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}

function getMusicResult() {

    var slidingMusic = document.getElementById('slidingMusic');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingMusic.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Music')) {
        slidingMusic.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }

    url = "http://ws.audioscrobbler.com/2.0/user/RJ/lovedtracks.rss";

    var dataType = "xml";
    var response = "";
    $.ajax({
        url: url,
        type: 'GET',
        dataType: dataType,
        timeout: 20000,
        
        success: function (data, textStatus, xhr) {
            //data = eval('('+data+')');
            //alert(data);
            $(data).find('item').each(function () {
                var title = "";
                var desc = "";
                var url = "";

                try {
                    title = $(this).find('title').text();
                } catch (err) {
                    title = "Not Found";
                }

                try {
                    desc = $(this).find('description').text();
                } catch (err) {
                    desc = "Not Found";
                }

                try {
                    url = $(this).find('link').text();
                } catch (err) {
                    url = "#";
                }

                response += '<div class="result slide">';
                response += '<a href="' + url + '" target="_blank">';
                response += '<dl>';
                response += '<dt><img alt="" src="es_img//music_icon.png"></dt>';
                response += '<dd>';
                response += '<p>' + title + '</p>';
                response += '</dd>';
                response += '</dl>';
                response += '</a>';
                response += '</div>';

            });
            if (response != '') {
                
                slidingMusic.innerHTML = window.toStaticHTML(response);
                $('#slidingMusic').jshowoff({
                    effect: 'fade',
                    //controlText:{play:'Reproducir',pause:'Pausar',previous:'Anterior',next:'Siguiente'},
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingMusic.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
            //}
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //var slidingMusic = document.getElementById('slidingMusic');
            slidingMusic.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });

}

function getNewsResult() {
    var slidingNewsElement = document.getElementById('slidingNews');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingNewsElement.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('News')) {
        slidingNewsElement.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }
    var keyword = "" ;
    var url = "http://api.feedzilla.com/v1/articles/search.json?order=date&count=20&culture_code=" + getCultureCode();;
   
    var dataType = "json";
    var response = "";
    $.ajax({
        url: url,
        type: 'GET',
        dataType: dataType,
        timeout: 20000,
        
        success: function (data, textStatus, xhr) {
            //data = eval('('+data+')');
            //data = jQuery.parseJSON(data);
            var totalObj = 0;
            try {
                totalObj = data.articles.length;
            } catch (err) {
                totalObj = 0;
            }

            for (var itr = 0; itr < totalObj; itr++) {
                var title = "";
                var desc = "";
                var url = "";

                try {
                    title = data.articles[itr].title;
                } catch (err) {
                    title = "";
                }

                try {
                    desc = data.articles[itr].summary;
                } catch (err) {
                    desc = "";
                }

                try {
                    url = data.articles[itr].url;
                } catch (err) {
                    url = "#";
                }

                response += '<div class="result slide">';
                response += '<a href="' + url + '" target="_blank"><p>' + title + '</p></a>';
                response += '<p>' + desc + '</p>';
                response += '</div>';

            }
            
            if (response != '') {
                slidingNewsElement.innerHTML = window.toStaticHTML(response);
                $('#slidingNews').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingNewsElement.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }

            //}
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //var slidingNewsElement = document.getElementById('slidingNews');
            slidingNewsElement.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });

}

function callYouTubeService() {

    var slidingVideo = document.getElementById('slidingVideo');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingVideo.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Youtube')) {
        slidingVideo.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }

    var keyword;
    if (getLocalStorageItem("SEARCHKEYWORD") != '') {
        keyword = getLocalStorageItem("SEARCHKEYWORD");
    }
    else {
        keyword = "null";
    }
    keyword = "";
    url = "http://gdata.youtube.com/feeds/api/videos?q=" + encodeURIComponent(keyword) + "&orderby=published&start-index=" + youtubePageNumber + "&max-results=10&v=2&alt=json";
    //url = "https://gdata.youtube.com/feeds/api/standardfeeds/most_popular";
    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'json',
        timeout: 20000,
        
        success: function (data, textStatus, xhr) {
            //alert(data);
            //parseNYoutubeData(data, keyword, 5);
            $.browser.chrome = /chrome/.test(navigator.userAgent.toLowerCase());

            if (!$.browser.chrome) {
                //data = eval('(' + data + ')');
            }


            var totalResults = 0;
            try {
                totalResults = data.feed.openSearch$totalResults.$t;
            } catch (err) {
                totalResults = 0;
            }

            var totalObj = 0;
            //alert(totalObj);
            try {
                totalObj = data.feed.openSearch$itemsPerPage.$t;
            } catch (err) {
                totalObj = 0;
            }
            var response = '';
            for (var itr = 0; itr < totalObj; itr++) {
                var imgPath = '';
                var title = '';
                var desc = '';
                var duration = '';
                var url = '';

                try {
                    imgPath = data.feed.entry[itr].media$group.media$thumbnail[0].url;
                } catch (err) {
                    imgPath = "es_img/youtube.png";
                }

                try {
                    title = data.feed.entry[itr].title.$t;
                } catch (err) {
                    title = "Video" + keyword;
                }

                try {
                    desc = data.feed.entry[itr].media$group.media$description.$t;
                } catch (err) {
                    desc = "Youtube Video";
                }

                try {
                    duration = data.feed.entry[itr].media$group.yt$duration.seconds;
                } catch (err) {
                    duration = "00";
                }

                try {
                    url = data.feed.entry[itr].link[0].href;
                } catch (err) {
                    url = "#";
                }

                var min1 = Math.floor(duration / 60);
                var min2 = (duration % 60);

                response += '<div class="result slide">';
                response += '<a href="' + url + '" target="_blank">';
                response += '<dl>';
                response += '<dt><img src="es_img/play_icon.png" class="play_icon" alt="" /><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                response += '<dd>';
                response += '<p>' + title + '</p>';
                response += '<p>' + desc + '</p>';
                response += '</dd>';
                response += '</dl>';
                response += '</a>';
                response += '</div>';
            }

            
            if (response != '') {
                slidingVideo.innerHTML = window.toStaticHTML(response);
                $('#slidingVideo').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingVideo.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
        },
        error: function (xhr, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //var slidingVideo = document.getElementById('slidingVideo');
            slidingVideo.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}


function getYouTubePopularVideos() {
    //$('#slidingVideo').html('inside function after ' + CONTRY_CODE); return;
    var slidingVideo = document.getElementById('slidingVideo');

    var autofeeds = getLocalStorageItem("AUTOFEEDS");
    if (autofeeds == "1") {
        slidingVideo.innerHTML = window.toStaticHTML(AUTOFEEDS_OFF);
        return;
    }

    if (!checkCategoryStatus('Youtube')) {
        slidingVideo.innerHTML = window.toStaticHTML(CHECK_SETTINGS);
        return;
    }

   
    
    url = "https://gdata.youtube.com/feeds/api/standardfeeds/" + CONTRY_CODE.toUpperCase() + "/most_popular?v=2";
    //$('#slidingVideo').html('inside function after ' + url); return;
    var response = '';
    $.ajax({
        url: url,
        type: 'GET',
        dataType: 'xml',
        timeout: 20000,

        success: function (data, textStatus, xhr) {
            //$('#slidingVideo').html('inside success after'); return;
            $(data).find('entry').each(function () {
                
                try {
                    imgPath = $(this).find('media\\:thumbnail').attr("url");
                } catch (err) {
                    imgPath = "es_img/youtube.png";
                }

                try {
                    title = $(this).find('title').text();
                } catch (err) {
                    title = "Video" + keyword;
                }

                try {
                    url = $(this).find('media\\:player').attr("url");
                } catch (err) {
                    url = "#";
                }

                try {
                    desc = $(this).find('media\\:description').text();
                } catch (err) {
                    desc = "Youtube Video";
                }

                response += '<div class="result slide">';
                response += '<a href="' + url + '" target="_blank">';
                response += '<dl>';
                response += '<dt><img src="es_img/play_icon.png" class="play_icon" alt="" /><img height="90" width="90" src="' + imgPath + '" alt="" /></dt>';
                response += '<dd>';
                response += '<p>' + title + '</p>';
                response += '<p>' + desc + '</p>';
                response += '</dd>';
                response += '</dl>';
                response += '</a>';
                response += '</div>';
            });
            
            

            if (response != '') {
                //slidingVideo.innerHTML = window.toStaticHTML(response);
                slidingVideo.innerHTML = response;
                $('#slidingVideo').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingVideo.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
        },
        error: function (xhr, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //var slidingVideo = document.getElementById('slidingVideo');
            slidingVideo.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}

function getFinanceResult() {
    
    url = "http://feeds.finance.yahoo.com/rss/2.0/headline?s=%5EDJI&region=US&lang=en-US";
    
    //console.log("URL : " + url);
    var dataType = "xml";
    var response = "";
    var slidingFinanceElement = document.getElementById('slidingFinance');
    $.ajax({
        url: url,
        type: 'GET',
        dataType: dataType,
        timeout: 20000,
        beforeSend: function (xhr) {

        },
        complete: function () {

        },
        success: function (data, textStatus, xhr) {
            
            $(data).find('channel').each(function () {
                $(data).find('item').each(function () {
                    var title = "";
                    var desc = "";
                    var pubdate = "";
                    var url = "";
                    var displayDate = "";

                    try {
                        title = ($(this).find('title').text());
                    } catch (err) {
                        title = "";
                    }

                    try {
                        desc = ($(this).find('description').text());
                    } catch (err) {
                        desc = "Not Found";
                    }

                    try {
                        pubdate = ($(this).find('pubDate').text());
                        var d = new Date(pubdate);
                        pubdate = d.toLocaleString();

                        var fmt = new DateFmt();
                        displayDate = fmt.format(new Date(pubdate), "(%n %d, %y - %H:%M:%S)");
                    } catch (err) {
                        pubdate = "";
                    }

                    try {
                        url = ($(this).find('link').text());
                    } catch (err) {
                        url = "#";
                    }

                    desc = desc.replace(/<\/?[a-z][a-z0-9]*[^<>]*>/ig, "");

                    /*response += '<li>';
                    response += '<h3><a href="' + url + '" target="_blank">' + title + '</a></h3>';
                    response += '<p>' + displayDate + '</p>';
                    response += '<p>' + desc + '</p>';
                    response += '<em>' + url + '</em>';
                    response += '</li>';*/
                    response += '<div class="result slide">';
                    response += '<a href="' + url + '" target="_blank"><p>' + title + '</p></a>';
                    //response += '<p>' + displayDate + '</p>';
                    response += '<p>' + desc + '</p>';
                    response += '</div>';



                });
            });

            
            //console.log("RESPONSE GENERATED : " + response);
            if (response != '') {


                slidingFinanceElement.innerHTML = window.toStaticHTML(response);
                $('#slidingFinance').jshowoff({
                    effect: 'fade',
                    //controlText:{play:'Reproducir',pause:'Pausar',previous:'Anterior',next:'Siguiente'},
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
            }
            else {
                slidingFinanceElement.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }
            //}
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //showConsoleLog("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //alert("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            slidingFinanceElement.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });
}

function showSmatoAds1() {
    var url = "http://soma.smaato.net/oapi/reqAd.jsp?adspace=65826709&pub=923874474&dimensionstrict=true&dimension=mma&beacon=true&device=Mozilla%2F5.0%20(compatible%3B%20MSIE%2010.0%3B%20Windows%20Phone%208.0%3B%20Trident%2F6.0%3B%20IEMobile%2F10.0%3B%20ARM%3B%20Touch%3B%20NOKIA%3B%20Lumia%20920)&format=IMG&response=HTML";
    $.ajax({
        url: url,
        timeout: 70000,
        cache:false,
        success: function (data, textStatus, xhr) {
            $('#smatowrap1').html(data);
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            $('#smatowrap1').html('<p>No Content to display</p>');
        }
    });
}

function showSmatoAds2() {
    var url = "http://soma.smaato.net/oapi/reqAd.jsp?adspace=65826709&pub=923874474&dimensionstrict=true&dimension=mma&beacon=true&device=Mozilla%2F5.0%20(compatible%3B%20MSIE%2010.0%3B%20Windows%20Phone%208.0%3B%20Trident%2F6.0%3B%20IEMobile%2F10.0%3B%20ARM%3B%20Touch%3B%20NOKIA%3B%20Lumia%20920)&format=IMG&response=HTML";
    $.ajax({
        url: url,
        timeout: 70000,
        cache: false,
        success: function (data, textStatus, xhr) {
            $('#smatowrap2').html(data);
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            $('#smatowrap2').html('<p>No Content to display</p>');
        }
    });
}

function showSmatoAds3() {
    var url = "http://soma.smaato.net/oapi/reqAd.jsp?adspace=65826709&pub=923874474&dimensionstrict=true&dimension=mma&beacon=true&device=Mozilla%2F5.0%20(compatible%3B%20MSIE%2010.0%3B%20Windows%20Phone%208.0%3B%20Trident%2F6.0%3B%20IEMobile%2F10.0%3B%20ARM%3B%20Touch%3B%20NOKIA%3B%20Lumia%20920)&format=IMG&response=HTML";

    $.ajax({
        url: url,
        timeout: 70000,
        cache: false,
        success: function (data, textStatus, xhr) {
            $('#smatowrap3').html(data);
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            $('#smatowrap3').html('<p>No Content to display</p>');
        }
    });
}

function showSmatoAds4() {
    var url = "http://soma.smaato.net/oapi/reqAd.jsp?adspace=65826709&pub=923874474&dimensionstrict=true&dimension=mma&beacon=true&device=Mozilla%2F5.0%20(compatible%3B%20MSIE%2010.0%3B%20Windows%20Phone%208.0%3B%20Trident%2F6.0%3B%20IEMobile%2F10.0%3B%20ARM%3B%20Touch%3B%20NOKIA%3B%20Lumia%20920)&format=IMG&response=HTML";
    $.ajax({
        url: url,
        timeout: 70000,
        cache: false,
        success: function (data, textStatus, xhr) {
            $('#smatowrap4').html(data);
        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {
            $('#smatowrap4').html('<p>No Content to display</p>');
        }
    });
}



function showAds1() {

    var adsResult = document.getElementById('sponsored1');
    /*adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
    return;*/
    
    isLoadMoreClicked = false;
    var hoopzInfoResponse = "";
    var loadmore = false;
    url = BASE_URL + "AdvertiserService/fetchAd";
    
    //var keyword = getLocalStorageItem("SEARCHKEYWORD");
    var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
    
    //alert(temp);
    var payload = "";
    payload += "<request>";
    //payload += "<keywords>" + encodeURIComponent(keyword) + "</keywords>"
    payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>"
    payload += "<modelName>" + MODEL_NAME + "</modelName>"
    payload += "<modelId>" + MODEL_ID + "</modelId>"
    payload += "<os>" + OS + "</os>"
    payload += "<deviceType>" + "phone" + "</deviceType>"
    payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
    payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
    payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
    payload += "<carrier>" + "" + "</carrier>"
    payload += "<adType>" + "100" + "</adType>"
    payload += "<imeiNumber>" + IMEI_NO + "</imeiNumber>"
    payload += "<mobileNo>" + "" + "</mobileNo>"
    payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
    payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
    payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
    payload += "<language>" + DEVICE_LANG + "</language>"
    payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
    payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
    payload += "<geoLocation>" + temp + "</geoLocation>"
    payload += "<pageNo>" + hoopzInfoPageNumber + "</pageNo>"
    payload += "<clientId>" + CLIENT_ID + "</clientId>"
    payload += "<noOfAdRequired>10</noOfAdRequired>";
    payload += "</request>";

    //console.log("HOOPZ INFO REQUEST ================= " + payload);
    //jAlert('Payload : ' + payload);
    
    $.ajax({
        url: url,
        type: "POST",
        data: payload,
        timeout: 70000,
        contentType: "application/xml",
        Cookie: "JSESSIONID=",

        beforeSend: function (xhr) {
            // xhr.setRequestHeader("Cache-Control", "no-cache");
            //  xhr.setRequestHeader("pragma", "no-cache");

            //$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
        },

        complete: function () {
            /*if(hoopzInfoResponse != "") {
                $.mobile.hidePageLoadingMsg();
            }

            if(isLoadMoreClicked == false) {
                fetch_Yelp_Result(keyword, searchtype);
            } else {
                if(yelpContentSeeMore == "YES") {
                    fetch_Yelp_Result(keyword, searchtype);
                } else {
                    fetchResultDone();
                }
            }*/
        },

        success: function (data) {
            return;
            var status = $(data).find('status').text();

            if (status == '1' || status == '3') {
                //loadmore = $(this).find('loadMore').text();

                $(data).find('ad').each(function () {

                    var title = '';
                    var dispUrl = '';
                    var clickUrl = '';
                    var url = '';
                    try {
                        title = $(this).find('data').text();
                    } catch (err) {
                        title = "";
                    }

                    try {
                        dispUrl = $(this).find('visibleURL').text();
                        clickUrl = $(this).find('clickURL').text();;
                        //jAlert(clickUrl);
                        clickUrl = decodeURIComponent(clickUrl);
                        //jAlert(decodeURIComponent(clickUrl));
                    } catch (err) {
                        // alert('exception');
                    }
                    var type;
                    var content = '';
                    if ($(this).find('type').text() == "1") {
                        // text ad
                        type = 1;
                        //content = '<h3>' + title + '</h3>';
                        content = '<p>'+title+'</p>';
                    }
                    if ($(this).find('type').text() == "2") {
                        // text + image
                        type = 2;
                        var split = title.split(":");
                        var imgPath = split[0];
                        imgPath = decodeURIComponent(imgPath);
                        imgPath = imgPath.replace("\"", "");
                        var textTitle = split[1];
                        textTitle = textTitle.replace("\"", "");
                        //content = '<div class="media-image"><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        //content += '<h3>' + textTitle + '</h3>';
                        //content +=  textTitle;
                        content = '<dl>';
                        content += '<dt><img height="32" width="32" src="' + imgPath + '" alt="" /></dt>';
                        content += '<dd>';
                        content += '<p>'+textTitle+'</p>';
                        content += '</dd>';
                        content += '</dl>';

                    }
                    if ($(this).find('type').text() == "3") {
                        // text +video
                        type = 3;
                        var split = title.split(":");
                        var imgPath = split[0];
                        imgPath = decodeURIComponent(imgPath);
                        imgPath = imgPath.replace("\"", "");
                        var textTitle = split[1];
                        textTitle = textTitle.replace("\"", "");
                        /*content = '<div class="media-image"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        //content += '<h3>' + textTitle + '</h3>';
                        content += textTitle ;*/

                        content = '<dl>';
                        content += '<dt><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="32" width="32" src="' + imgPath + '" alt="" /></dt>';
                        content += '<dd>';
                        content += '<p>' + textTitle + '</p>';
                        content += '</dd>';
                        content += '</dl>';

                    }
                    if ($(this).find('type').text() == "4") {
                        // image ad
                        type = 4;
                        var imgPath = decodeURIComponent(title);
                        //content = '<div class="img"><img height="180" width="190" src="' + imgPath + '" alt="" /></div>';
                        content += '<p><img src="' + imgPath + '" alt="" /></p>';
                        
                    }
                    if ($(this).find('type').text() == "5") {
                        // video ad
                        var imgPath = decodeURIComponent(title);
                        // content = '<div class="media-image"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        content += '<p><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img src="' + imgPath + '" alt="" /></p>';
                        type = 5;
                    }
                    //jAlert("Type : " + type);

                    /*<a href="#">
                <div class="tranparent-bg voilet"></div>
                <h3>Sponsored</h3>
                <img src="es_img/sponsor_sample_img_1.png" width="150" height="150" alt="" />
            </a>*/
                   /* hoopzInfoResponse += '<div>';
                    //hoopzInfoResponse += '<a  href="#" onclick="openBrowser(\'' + clickUrl + '\');">';  
                    hoopzInfoResponse += '<div class="tranparent-bg voilet"></div>';
                    hoopzInfoResponse += '<h3>Sponsored</h3>';
                    //hoopzInfoResponse += '<img src="es_img/sponsor_sample_img_1.png" width="150" height="150" alt="" />';
                    hoopzInfoResponse += '<div style="margin:50px 10px;">';
                    hoopzInfoResponse += content;
                    hoopzInfoResponse += '</div>';
                    //hoopzInfoResponse += '</a>';
                    hoopzInfoResponse += '</div>';
                    //hoopzInfoResponse += '</div>';
                    */

                 /*   hoopzInfoResponse += '<div class="result slide">';
                    hoopzInfoResponse += '<a href="' + clickUrl + '" target="_blank">';
                    hoopzInfoResponse += content;
                    hoopzInfoResponse += '</a>';
                    hoopzInfoResponse += '</div>';
                    */
                });
            }
            var hoopzAds = document.getElementById('adsResult');
            if (hoopzInfoResponse != '') {
                //adsResult.innerHTML = window.toStaticHTML(hoopzInfoResponse);
                /*adsResult.innerHTML = hoopzInfoResponse;
                //console.log(hoopzInfoResponse);
                $("#sponsored1").removeClass("result");
                $('#sponsored1').jshowoff({
                        effect: 'fade',
                        hoverPause: true,
                        controls: false,
                        links: false,
                        speed: 5000
                    });
                */
                
            }
            else {
                // adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
               // adsResult.innerHTML = '<p>No Content to display</p>';
            }


        },

        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            //adsResult.innerHTML = '<p>No Content to display</p>';
        }
    });

}

function showAds2() {

    var adsResult = document.getElementById('sponsored2');
    /*adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
    return;*/

    isLoadMoreClicked = false;
    var hoopzInfoResponse = "";
    var loadmore = false;
    url = BASE_URL + "AdvertiserService/fetchAd";
    //var keyword = getLocalStorageItem("SEARCHKEYWORD");
    var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
    //alert(temp);
    var payload = "";
    payload += "<request>";
    //payload += "<keywords>" + encodeURIComponent(keyword) + "</keywords>"
    payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>"
    payload += "<modelName>" + MODEL_NAME + "</modelName>"
    payload += "<modelId>" + MODEL_ID + "</modelId>"
    payload += "<os>" + OS + "</os>"
    payload += "<deviceType>" + "phone" + "</deviceType>"
    payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
    payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
    payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
    payload += "<carrier>" + "" + "</carrier>"
    payload += "<adType>" + "100" + "</adType>"
    payload += "<imeiNumber>" + IMEI_NO + "</imeiNumber>"
    payload += "<mobileNo>" + "" + "</mobileNo>"
    payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
    payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
    payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
    payload += "<language>" + DEVICE_LANG + "</language>"
    payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
    payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
    payload += "<geoLocation>" + temp + "</geoLocation>"
    payload += "<pageNo>" + hoopzInfoPageNumber + "</pageNo>"
    payload += "<clientId>" + CLIENT_ID + "</clientId>"
    payload += "<noOfAdRequired>10</noOfAdRequired>";
    payload += "</request>";

    //console.log("HOOPZ INFO REQUEST ================= " + payload);
    //jAlert('Payload : ' + payload);

    $.ajax({
        url: url,
        type: "POST",
        data: payload,
        timeout: 70000,
        contentType: "application/xml",
        Cookie: "JSESSIONID=",

        beforeSend: function (xhr) {
            // xhr.setRequestHeader("Cache-Control", "no-cache");
            //  xhr.setRequestHeader("pragma", "no-cache");

            //$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
        },

        complete: function () {
            /*if(hoopzInfoResponse != "") {
                $.mobile.hidePageLoadingMsg();
            }

            if(isLoadMoreClicked == false) {
                fetch_Yelp_Result(keyword, searchtype);
            } else {
                if(yelpContentSeeMore == "YES") {
                    fetch_Yelp_Result(keyword, searchtype);
                } else {
                    fetchResultDone();
                }
            }*/
        },

        success: function (data) {
            return;
            var status = $(data).find('status').text();

            if (status == '1' || status == '3') {
                //loadmore = $(this).find('loadMore').text();

                $(data).find('ad').each(function () {

                    var title = '';
                    var dispUrl = '';
                    var clickUrl = '';
                    var url = '';
                    try {
                        title = $(this).find('data').text();
                    } catch (err) {
                        title = "";
                    }

                    try {
                        dispUrl = $(this).find('visibleURL').text();
                        clickUrl = $(this).find('clickURL').text();;
                        //jAlert(clickUrl);
                        clickUrl = decodeURIComponent(clickUrl);
                        //jAlert(decodeURIComponent(clickUrl));
                    } catch (err) {
                        // alert('exception');
                    }
                    var type;
                    var content = '';
                    if ($(this).find('type').text() == "1") {
                        // text ad
                        type = 1;
                        //content = '<h3>' + title + '</h3>';
                        content = '<p>' + title + '</p>';
                    }
                    if ($(this).find('type').text() == "2") {
                        // text + image
                        type = 2;
                        var split = title.split(":");
                        var imgPath = split[0];
                        imgPath = decodeURIComponent(imgPath);
                        imgPath = imgPath.replace("\"", "");
                        var textTitle = split[1];
                        textTitle = textTitle.replace("\"", "");
                        //content = '<div class="media-image"><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        //content += '<h3>' + textTitle + '</h3>';
                        //content +=  textTitle;
                        content = '<dl>';
                        content += '<dt><img height="32" width="32" src="' + imgPath + '" alt="" /></dt>';
                        content += '<dd>';
                        content += '<p>' + textTitle + '</p>';
                        content += '</dd>';
                        content += '</dl>';

                    }
                    if ($(this).find('type').text() == "3") {
                        // text +video
                        type = 3;
                        var split = title.split(":");
                        var imgPath = split[0];
                        imgPath = decodeURIComponent(imgPath);
                        imgPath = imgPath.replace("\"", "");
                        var textTitle = split[1];
                        textTitle = textTitle.replace("\"", "");
                        /*content = '<div class="media-image"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        //content += '<h3>' + textTitle + '</h3>';
                        content += textTitle ;*/

                        content = '<dl>';
                        content += '<dt><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="32" width="32" src="' + imgPath + '" alt="" /></dt>';
                        content += '<dd>';
                        content += '<p>' + textTitle + '</p>';
                        content += '</dd>';
                        content += '</dl>';

                    }
                    if ($(this).find('type').text() == "4") {
                        // image ad
                        type = 4;
                        var imgPath = decodeURIComponent(title);
                        //content = '<div class="img"><img height="180" width="190" src="' + imgPath + '" alt="" /></div>';
                        content += '<p><img src="' + imgPath + '" alt="" /></p>';

                    }
                    if ($(this).find('type').text() == "5") {
                        // video ad
                        var imgPath = decodeURIComponent(title);
                        // content = '<div class="media-image"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img height="60" width="60" src="' + imgPath + '" alt="" /></div>';
                        content += '<p><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img src="' + imgPath + '" alt="" /></p>';
                        type = 5;
                    }
                    //jAlert("Type : " + type);

                    /*<a href="#">
                <div class="tranparent-bg voilet"></div>
                <h3>Sponsored</h3>
                <img src="es_img/sponsor_sample_img_1.png" width="150" height="150" alt="" />
            </a>*/
                    /*hoopzInfoResponse += '<div>';
                    //hoopzInfoResponse += '<a  href="#" onclick="openBrowser(\'' + clickUrl + '\');">';  
                    hoopzInfoResponse += '<div class="tranparent-bg voilet"></div>';
                    hoopzInfoResponse += '<h3>Sponsored</h3>';
                    //hoopzInfoResponse += '<img src="es_img/sponsor_sample_img_1.png" width="150" height="150" alt="" />';
                    hoopzInfoResponse += '<div style="margin:50px 10px;">';
                    hoopzInfoResponse += content;
                    hoopzInfoResponse += '</div>';
                    //hoopzInfoResponse += '</a>';
                    hoopzInfoResponse += '</div>';
                    //hoopzInfoResponse += '</div>';
                    */

                 /*   hoopzInfoResponse += '<div class="result slide">';
                    hoopzInfoResponse += '<a href="' + clickUrl + '" target="_blank">';
                    hoopzInfoResponse += content;
                    hoopzInfoResponse += '</a>';
                    hoopzInfoResponse += '</div>';*/

                });
            }
            var hoopzAds = document.getElementById('adsResult');
            if (hoopzInfoResponse != '') {
              /*  adsResult.innerHTML = window.toStaticHTML(hoopzInfoResponse);
                //console.log(hoopzInfoResponse);
                $("#sponsored2").removeClass("result");
                $('#sponsored2').jshowoff({
                    effect: 'fade',
                    hoverPause: true,
                    controls: false,
                    links: false,
                    speed: 5000
                });
                */

            }
            else {
                //adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
            }


        },

        error: function (XMLHttpRequest, textStatus, errorThrown) {
            //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
            //adsResult.innerHTML = window.toStaticHTML('<p>No Content to display</p>');
        }
    });

}