﻿function fetch_bingimage_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ IMAGE BING RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var bingImageResponse = "";
	var loadmore = false;

	var location = "";
	try {
		if(getLocalStorageItem("ESLATITUDE").trim() == "" || getLocalStorageItem("ESLONGITUDE").trim() == "") {
			location = "";
		} else {
			location = "&Latitude=" + encodeURIComponent(getLocalStorageItem("ESLATITUDE")) + "&Longitude=" + encodeURIComponent(getLocalStorageItem("ESLONGITUDE"));
		}
	} catch (err) {
		location = "";
	}
	url = "https://api.datamarket.azure.com/Bing/Search/Composite?Sources=%27image%27&Query=%27" + encodeURIComponent(keyword) + "%27&$format=JSON&$top=10&$skip=" + bingImagePageNumber + location;
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			xhr.setRequestHeader("Authorization", "Basic " + BING_KEY);
			$('.mobile-loading').show();
			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
		    //$.mobile.hidePageLoadingMsg();
		    $('.mobile-loading').hide();
		},

		success : function(data, textStatus, xhr) {
			var result = data.d.results[0].Image;

			var totalObj = 0;
			try {
				totalObj = result.length;
			} catch (err) {
				totalObj = 0;
			}

			if(totalObj >= 10) {
				loadmore = true;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var size = "";
				var thumburl = "";
				var mediaurl = "";
				var url = "";

				try {
					title = result[itr].Title;
				} catch (err) {
					title = "";
				}

				try {
					size = Math.round(result[itr].FileSize / 1024);
				} catch (err) {
					size = "0";
				}

				try {
					thumburl = result[itr].Thumbnail.MediaUrl;
				} catch (err) {
					thumburl = "#";
				}

				try {
					mediaurl = result[itr].MediaUrl;
				} catch (err) {
					mediaurl = "#";
				}

				try {
					url = result[itr].SourceUrl;
				} catch (err) {
					url = "#";
				}

				/*bingImageResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				bingImageResponse += '<a href="#" onclick="showImagePopup(\'' + mediaurl + '\',\'' + url + '\');">';

				/////////////////////////////////
				bingImageResponse += '<table width="100%" style="margin:0;padding:0;">';
				bingImageResponse += '<tr>';
				bingImageResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
				bingImageResponse += '<img src="' + thumburl + '" width="60px" height="60px">';
				bingImageResponse += '</td>';
				bingImageResponse += '<td style="vertical-align:top;">';
				bingImageResponse += '<div style="max-height:30px;overflow:hidden;color:blue;white-space:normal;">' + title + '</div>';
				bingImageResponse += '</td>'
				bingImageResponse += '</tr>'

				bingImageResponse += '<tr>';
				bingImageResponse += '<td style="vertical-align:top;">Size : ' + size + ' KB</td>';
				bingImageResponse += '</tr>'

				bingImageResponse += '</table>'
				/////////////////////////////////

				bingImageResponse += '</a>';
				bingImageResponse += '</li>';*/

				bingImageResponse += '<li class="with-padding">';
				bingImageResponse += '<a href="#" onclick="showImagePopup(\'' + mediaurl + '\',\'' + url + '\');">';
				bingImageResponse += '<div class="img"><img src="' + thumburl + '" class="preview" alt="" /></div>';
				bingImageResponse += '<h3>' + truncateText(title, TITLE_LENGTH_WITH_IMAGE) + '</h3>';
				bingImageResponse += '<p>Size : ' + size + '</p>';
				bingImageResponse += '</a>';
				bingImageResponse += '</li>';

				var bingImageArrElement = new BingImageResultClass();
				bingImageArrElement.title = truncateText(title, TITLE_LENGTH_WITH_IMAGE);
				bingImageArrElement.size = size;
				bingImageArrElement.thumburl = thumburl;
				bingImageArrElement.mediaurl = mediaurl;
				bingImageArrElement.url = url;

				try {
					bingImageResultArr.push(bingImageArrElement);
				} catch (err) {
				}
			}

			if(loadmore == true) {
				bingImagePageNumber = bingImageResultArr.length;
				bingImageSeeMore = "YES";
			} else {
				bingImageSeeMore = "NO";
			}

			if(selectedCategory == "24") {
				$('#result').append(bingImageResponse).listview("refresh");
				if(bingImageSeeMore == "YES") {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_bingimage_result(keyword, searchtype, true);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
		    //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		    $('.mobile-loading').hide();
		}
	});
}

function showOldBingImageData(keyword, searchtype) {
	var bingImageResponse = "";
	var len = bingImageResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = bingImageResultArr[itr].title;
		var size = bingImageResultArr[itr].size;
		var thumburl = bingImageResultArr[itr].thumburl;
		var mediaurl = bingImageResultArr[itr].mediaurl;
		var url = bingImageResultArr[itr].url;

		/*bingImageResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		bingImageResponse += '<a href="#" onclick="showImagePopup(\'' + mediaurl + '\',\'' + url + '\');">';

		/////////////////////////////////
		bingImageResponse += '<table width="100%" style="margin:0;padding:0;">';
		bingImageResponse += '<tr>';
		bingImageResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
		bingImageResponse += '<img src="' + thumburl + '" width="60px" height="60px">';
		bingImageResponse += '</td>';
		bingImageResponse += '<td style="vertical-align:top;">';
		bingImageResponse += '<div style="max-height:30px;overflow:hidden;color:blue;white-space:normal;">' + title + '</div>';
		bingImageResponse += '</td>'
		bingImageResponse += '</tr>'

		bingImageResponse += '<tr>';
		bingImageResponse += '<td style="vertical-align:top;">Size : ' + size + ' KB</td>';
		bingImageResponse += '</tr>'

		bingImageResponse += '</table>'
		/////////////////////////////////

		bingImageResponse += '</a>';
		bingImageResponse += '</li>';*/

		bingImageResponse += '<li class="with-padding">';
		bingImageResponse += '<a href="#" onclick="showImagePopup(\'' + mediaurl + '\',\'' + url + '\');">';
		bingImageResponse += '<div class="img"><img src="' + thumburl + '" class="preview" alt="" /></div>';
		bingImageResponse += '<h3>' + title + '</h3>';
		bingImageResponse += '<p>Size : ' + size + '</p>';
		bingImageResponse += '</a>';
		bingImageResponse += '</li>';
	}

	$('#result').append(bingImageResponse).listview("refresh");
	if(bingImageSeeMore == "YES") {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetch_bingimage_result(keyword, searchtype, true);
	});
}

function fetch_bingvideo_result(keyword, searchtype, isLoadMoreClicked) {
	//console.log("============ VIDEO BING RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var bingVideoResponse = "";
	var loadmore = false;

	var location = "";
	try {
		if(getLocalStorageItem("ESLATITUDE").trim() == "" || getLocalStorageItem("ESLONGITUDE").trim() == "") {
			location = "";
		} else {
			location = "&Latitude=" + encodeURIComponent(getLocalStorageItem("ESLATITUDE")) + "&Longitude=" + encodeURIComponent(getLocalStorageItem("ESLONGITUDE"));
		}
	} catch (err) {
		location = "";
	}
	url = "https://api.datamarket.azure.com/Bing/Search/Composite?Sources=%27video%27&Query=%27" + encodeURIComponent(keyword) + "%27&$format=JSON&$top=10&$skip=" + bingVideoPageNumber + location;
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			xhr.setRequestHeader("Authorization", "Basic " + BING_KEY);
			$('.mobile-loading').show();
			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
		    //$.mobile.hidePageLoadingMsg();
		    $('.mobile-loading').hide();
		},

		success : function(data, textStatus, xhr) {
			var result = data.d.results[0].Video;

			var totalObj = 0;
			try {
				totalObj = result.length;
			} catch (err) {
				totalObj = 0;
			}

			if(totalObj >= 10) {
				loadmore = true;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var duration = "";
				var thumburl = "";
				var url = "";

				try {
					title = result[itr].Title;
				} catch (err) {
					title = "";
				}

				try {
					duration = Math.round((result[itr].RunTime / 60000) * 100) / 100
				} catch (err) {
					duration = "0";
				}

				try {
					thumburl = result[itr].Thumbnail.MediaUrl;
				} catch (err) {
					thumburl = "#";
				}

				try {
					url = result[itr].MediaUrl;
				} catch (err) {
					url = "#";
				}

				


				bingVideoResponse += '<li class="with-padding">';
				bingVideoResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';
				bingVideoResponse += '<div class="img"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img src="' + thumburl + '" width="60" height="60" alt="" /></div>';
				bingVideoResponse += '<h3>' + truncateText(title, TITLE_LENGTH_WITH_IMAGE); + '</h3>';
				bingVideoResponse += '<p>Time : ' + duration + ' Mins</p>';
				bingVideoResponse += '</a>';
				bingVideoResponse += '</li>';

				var bingVideoArrElement = new BingVideoResultClass();
				bingVideoArrElement.title = truncateText(title, TITLE_LENGTH_WITH_IMAGE);;
				bingVideoArrElement.duration = duration;
				bingVideoArrElement.thumburl = thumburl;
				bingVideoArrElement.url = url;

				try {
					bingVideoResultArr.push(bingVideoArrElement);
				} catch (err) {
				}
			}

			if(loadmore == true) {
				bingVideoPageNumber = bingVideoResultArr.length;
				bingVideoSeeMore = "YES";
			} else {
				bingVideoSeeMore = "NO";
			}

			if(selectedCategory == "25") {
				$('#result').append(bingVideoResponse).listview("refresh");
				if(bingVideoSeeMore == "YES") {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_bingvideo_result(keyword, searchtype, true);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
		    //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		    $('.mobile-loading').hide();
		}
	});
}

function showOldBingVideoData(keyword, searchtype) {
	var bingVideoResponse = "";
	var len = bingVideoResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = bingVideoResultArr[itr].title;
		var duration = bingVideoResultArr[itr].duration;
		var thumburl = bingVideoResultArr[itr].thumburl;
		var url = bingVideoResultArr[itr].url;

		

		bingVideoResponse += '<li class="with-padding">';
		bingVideoResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';
		bingVideoResponse += '<div class="img"><img src="es_img/play_icon_small.png" class="play_icon_small" alt="" /><img src="' + thumburl + '" width="60" height="60" alt="" /></div>';
		bingVideoResponse += '<h3>' + title + '</h3>';
		bingVideoResponse += '<p>Time : ' + duration + ' Mins</p>';
		bingVideoResponse += '</a>';
		bingVideoResponse += '</li>';
	}

	$('#result').append(bingVideoResponse).listview("refresh");
	if(bingVideoSeeMore == "YES") {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetch_bingvideo_result(keyword, searchtype, true);
	});
}

function fetch_amazon_result(keyword, searchtype, isLoadMoreClicked) {
	isLoadMoreClicked = isLoadMoreClicked || false;
	var amazonResponse = "";
	var loadmore = false;
	var totalPages = 0;

	var url = "";
	url += "http://ecs.amazonaws."+getAmazonWSEndpoint()+"/onca/xml?";
	url += "Service=AWSECommerceService";
	url += "&Version=2011-08-01";
	url += "&Operation=ItemSearch";
	url += "&Keywords=" + encodeURIComponent(keyword);
	url += "&SearchIndex=All";
	url += "&AssociateTag=hoopz03-20";
	url += "&ResponseGroup=Small,OfferSummary,Images,ItemAttributes";
	url += "&ItemPage=1";
	url = signAmazonURL(url);
	dataType = "xml";

	console.log("AMAZON FINAL URL === " + url);

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			$('.mobile-loading').show();
			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
		    //$.mobile.hidePageLoadingMsg();
		    $('.mobile-loading').hide();
		},

		success : function(data, textStatus, xhr) {
			$(data).find('Items').each(function() {
				totalPages = $(this).find('TotalPages').text();

				var title = "";
				var price = "";
				var countleft = "";
				var imgPath = "";
				var url = "";

				$(this).find('Item').each(function() {
					try {
						$(this).find('ItemAttributes').each(function() {
							title = $(this).find('Title').text();
						});
					} catch (err) {
						title = keyword;
					}

					try {
						$(this).find('OfferSummary').each(function() {
							countleft = $(this).find('TotalNew').text();
							$(this).find('LowestNewPrice').each(function() {
								price = $(this).find('FormattedPrice').text();
							});
						});
					} catch (err) {
						price = "";
						countleft = "";
					}

					try {
						$(this).find('SmallImage').each(function() {
							imgPath = $(this).find('URL').text();
						});
					} catch (err) {
						imgPath = "es_img/amazon.png";
					}

					try {
						url = $(this).find('DetailPageURL').text();
					} catch (err) {
						url = "#";
					}

				
					amazonResponse += '<li class="with-padding">';
					amazonResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';
					amazonResponse += '<div class="img"><img src="' + imgPath + '" class="preview" alt="" /></div>';
					amazonResponse += '<h3>' + truncateText(title, TITLE_LENGTH_WITH_IMAGE) + '</h3>';
					amazonResponse += '<p>Price : ' + price + ' Mins</p>';
					amazonResponse += '<p>Count Left : ' + countleft + '</p>';
					amazonResponse += '</a>';
					amazonResponse += '</li>';

					var amazonArrElement = new AmazonResultClass();
					amazonArrElement.title = truncateText(title, TITLE_LENGTH_WITH_IMAGE);
					amazonArrElement.price = price;
					amazonArrElement.countleft = countleft;
					amazonArrElement.imgPath = imgPath;
					amazonArrElement.url = url;

					try {
						amazonResultArr.push(amazonArrElement);
					} catch (err) {
					}
				});
			});

			if(totalPages > amazonPageNumber) {
				amazonPageNumber = amazonPageNumber + 1;
				amazonSeeMore = "YES";
			} else {
				amazonSeeMore = "NO";
			}

			if(selectedCategory == "14") {
			    $('#result').append(amazonResponse).listview("refresh");
			    //$('#result').append(amazonResponse);
				if(amazonSeeMore == "YES") {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_amazon_result(keyword, searchtype, true);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
		    //console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		    $('.mobile-loading').hide();
		}
	});
}

function showOldAmazonData(keyword, searchtype) {
	var amazonResponse = "";
	var len = amazonResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = amazonResultArr[itr].title;
		var price = amazonResultArr[itr].price;
		var countleft = amazonResultArr[itr].countleft;
		var imgPath = amazonResultArr[itr].imgPath;
		var url = amazonResultArr[itr].url;

		/*amazonResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		amazonResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		amazonResponse += '<table width="100%" style="margin:0;padding:0;">';
		amazonResponse += '<tr>'
		amazonResponse += '<td width="100%" style="color:blue;">';
		amazonResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
		amazonResponse += '</td>';
		amazonResponse += '</tr>';
		amazonResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		amazonResponse += '<table width="100%" style="margin:0;padding:0;">';
		amazonResponse += '<tr>';
		amazonResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
		amazonResponse += '<img src="' + imgPath + '" width="60px" height="60px" />';
		amazonResponse += '</td>';
		amazonResponse += '<td style="vertical-align:top;">Price : ' + price + '</td>';
		amazonResponse += '</tr>'

		amazonResponse += '<tr>';
		amazonResponse += '<td style="vertical-align:top;">Count Left : ' + countleft + '</td>';
		amazonResponse += '</tr>'
		amazonResponse += '</table>';
		/////////////////////////////////

		amazonResponse += '</a>';
		amazonResponse += '</li>';*/

		amazonResponse += '<li class="with-padding">';
		amazonResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';
		amazonResponse += '<div class="img"><img src="' + imgPath + '" class="preview" alt="" /></div>';
		amazonResponse += '<h3>' + title + '</h3>';
		amazonResponse += '<p>Price : ' + price + ' Mins</p>';
		amazonResponse += '<p>Count Left : ' + countleft + '</p>';
		amazonResponse += '</a>';
		amazonResponse += '</li>';
	}

	$('#result').append(amazonResponse).listview("refresh");
	if(amazonSeeMore == "YES") {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetch_amazon_result(keyword, searchtype, true);
	});
}

/////////////////////AMAZON HELPER METHODS
Date.prototype.toISODate =
	new Function("with (this)\n    return " +
		"getFullYear()+'-'+addZero(getMonth()+1)+'-'" +
		"+addZero(getDate())+'T'+addZero(getHours())+':'" +
		"+addZero(getMinutes())+':'+addZero(getSeconds())+'.000Z'");

function signAmazonURL(unsignedUrl) {
    var lines = unsignedUrl.split("\n");
	unsignedUrl = "";
	for (var i in lines) {
		unsignedUrl += lines[i];
	}

	var urlregex = new RegExp("^http:\\/\\/(.*)\\/onca\\/xml\\?(.*)$");
	var matches = urlregex.exec(unsignedUrl);
	var host = matches[1].toLowerCase();
	var query = matches[2];

	var pairs = query.split("&");
	pairs = cleanupRequest(pairs);
	pairs = encodeNameValuePairs(pairs);
	pairs.sort();

	var canonicalQuery = pairs.join("&");
	var stringToSign = "GET\n" + host + "\n/onca/xml\n" + canonicalQuery;
	var signature = sign(AMAZON_SECRET_KEY, stringToSign);

	return "http://" + host + "/onca/xml?" + canonicalQuery + "&Signature=" + signature;
}

function encodeNameValuePairs(pairs) {
	for (var i = 0; i < pairs.length; i++) {
		var name = "";
		var value = "";

		var pair = pairs[i];
		var index = pair.indexOf("=");

		if (index == -1) {
			name = pair;
		} else if (index == 0) {
			value = pair;
		} else {
			name = pair.substring(0, index);
			if (index < pair.length - 1) {
				value = pair.substring(index + 1);
			}
		}

		name = encodeURIComponent(decodeURIComponent(name));
		value = value.replace(/\+/g, "%20");
		value = encodeURIComponent(decodeURIComponent(value));
		pairs[i] = name + "=" + value;
	}

	return pairs;
}

function cleanupRequest(pairs) {
	pairs.push("Timestamp=" + getNowTimeStamp());
	pairs.push("AWSAccessKeyId=" + AMAZON_ACCESS_KEY);

	return pairs;
}

function sign(secret, message) {
	var messageBytes = str2binb(message);
	var secretBytes = str2binb(secret);

	if (secretBytes.length > 16) {
		secretBytes = core_sha256(secretBytes, secret.length * chrsz);
	}

	var ipad = Array(16), opad = Array(16);
	for (var i = 0; i < 16; i++) {
		ipad[i] = secretBytes[i] ^ 0x36363636;
		opad[i] = secretBytes[i] ^ 0x5C5C5C5C;
	}

	var imsg = ipad.concat(messageBytes);
	var ihash = core_sha256(imsg, 512 + message.length * chrsz);
	var omsg = opad.concat(ihash);
	var ohash = core_sha256(omsg, 512 + 256);

	var b64hash = binb2b64(ohash);
	var urlhash = encodeURIComponent(b64hash);

	return urlhash;
}

function addZero(n) {
	return ( n < 0 || n > 9 ? "" : "0" ) + n;
}

function getNowTimeStamp() {
	var time = new Date();
	var gmtTime = new Date(time.getTime() + (time.getTimezoneOffset() * 60000));
	return gmtTime.toISODate() ;
}

