﻿function addContentIntoElement(id, content) {
    /*var element = document.getElementById(id);
    element.innerHTML = window.toStaticHTML(content);*/
    $('#' + id).html(content);
}

function truncateText(text, noOfCharachtersToExtract) {
    if (text.length > noOfCharachtersToExtract) {
        text=  text.substr(0, noOfCharachtersToExtract - 3) + '...';
        text = text.replace(/\w+$/, '');
        
    }

    return text;
}

function openUrlDeviceBrowser(url) {
	if(OS == "iOS"){
        url = url + "#phonegap=external";
    }
    if (typeof navigator !== "undefined" && navigator.app) {
        // Mobile device.
        navigator.app.loadUrl(url, { openExternal: true });
    } else {
        // Possible web browser
        window.open(url, "_system");
    }
}

function changePowerSettings() {
    if (getLocalStorageItem("powerStatus") == "off") {
        setLocalStorageItem("powerStatus", "on");
        $("#powerImage").attr("src", "es_img/logos/power.png");
        getResults();
    }
    else {
        setLocalStorageItem("powerStatus", "off");
        $("#powerImage").attr("src", "es_img/logos/power_off.png");
        show_Alert_Phonegap("Please power on to enable new feeds");
    }
}


function changePowerSettingResults() {
    if (getLocalStorageItem("powerStatus") == "off") {
        setLocalStorageItem("powerStatus", "on");
        $("#powerImage").attr("src", "es_img/logos/power.png");
        //getResults();
        startFunction();
    }
    else {
        setLocalStorageItem("powerStatus", "off");
        $("#powerImage").attr("src", "es_img/logos/power_off.png");
        show_Alert_Phonegap("Please power on to enable new feeds");
    }
}

function shareApplication() {
    window.plugins.socialsharing.share(APPLICATION_TITLE, "", null, APPLICATION_URL);
}

function redirectToTagPage(category) {
    setLocalStorageItem("tagCategory", category);
    window.location = 'tag.html';
}


function get_time_zone_offset() {
    var today = new Date();
    var offset = today.getTimezoneOffset();
    offset = ((offset < 0 ? '+' : '-') + pad(parseInt(Math.abs(offset / 60)), 2) + pad(Math.abs(offset % 60), 2));
    return offset;
}

function pad(number, length) {
    var str = "" + number;
    while (str.length < length) {
        str = '0' + str;
    }
    return str;
}

function showSearchPopup() {
    $("#keywordtext").val("");
    //$("#popupSearch").popup("open");
    $('#searchBox').toggle();
}

function startSearch() {
    var keyword = document.getElementById('keywordtext').value;
    if (keyword == null || keyword.trim() == "") {
        show_Alert_Phonegap("Please Enter Valid Keyword.");
        return;
    }
    setLocalStorageItem("CAT_FOR_SEARCH", 27);
    setLocalStorageItem("SEARCHKEYWORD", keyword);
    window.location = "menu.html";
}

function showResultsMessagingStyle(category) {
    resetResultsArray();
    for (var i = 1; i < 99999; i++)
        window.clearInterval(i);
    setLocalStorageItem("CAT_FOR_RESULTS", category);
    window.location = "results.html";
}


function showResultsFlipStyle(category) {
    resetResultsArray();
    for (var i = 1; i < 99999; i++)
        window.clearInterval(i);
    setLocalStorageItem("CAT_FOR_RESULTS", category);
    window.location = "categoryfeed.html";
}

function share(id, category) {
    var arrayName = "";

    switch (category) {
        case "news": arrayName = "newsResultsTiles"; break;
        case "restaurants": arrayName = "restaurantResultsTiles"; break;
        case "video": arrayName = "videoResultsTiles"; break;
        case "deals": arrayName = "dealsResultTiles"; break;
        case "music": arrayName = "musicResultTiles"; break;
        case "job": arrayName = "jobResultsTiles"; break;
        case "ebay": arrayName = "ebayResultsTiles"; break;
        case "sport": arrayName = "sportsResultsTiles"; break;
        case "hotel": arrayName = "hotelResultTiles"; break;
        case "content": arrayName = "contentResultTiles"; break;
        case "business": arrayName = "financeResults"; break;
        case "amazon": arrayName = "amazonResultsTiles"; break;
        case "info": arrayName = "infoResultTiles"; break;
        case "facebook": arrayName = "facebookPostResult"; break;
    }


    console.log("category : " + category);
    console.log("arrayName : " + arrayName);


    if (category == "music" || category == "hotel") {
        var title = window[arrayName][id].name;
    }
    else {
        var title = window[arrayName][id].title;
    }
    //var desc = window[arrayName][id].desc;
    var url = window[arrayName][id].url;
    var imgPath = window[arrayName][id].imgPath;
    console.log("TITLE : " + title);
    //console.log("Desc : " + desc);
    console.log("url : " + url);
    //console.log("imgpath : " + imgPath);
    window.plugins.socialsharing.share(title, "", null, url);

}

function setFooterYear() {
    /*var footerYear = document.getElementById('footerYear');
    footerYear.innerHTML = window.toStaticHTML(new Date().getFullYear());*/
    $('#footerYear').html(new Date().getFullYear());
}

var ARRAY_SLICE_SIZE = 10

// this method will reterive data for each category from cache
function getAllDataFromCache() {

    var categoriesTemp = ["news", "restaurants", "video","deals", "music", "job",
                                  "ebay", "sport","hotel", "content","business", "amazon", "info", "facebook"]; 

    for (var i = 0; i < categoriesTemp.length; i++) {
        var key = categoriesTemp[i] + "Data";
        
        var arrayName = "";
        switch (categoriesTemp[i]) {
            case "news": arrayName = "newsResultsTiles"; break;
            case "restaurants": arrayName = "restaurantResultsTiles"; break;
            case "video": arrayName = "videoResultsTiles"; break;
            case "deals": arrayName = "dealsResultTiles"; break;
            case "music": arrayName = "musicResultTiles"; break;
            case "job": arrayName = "jobResultsTiles"; break;
            case "ebay": arrayName = "ebayResultsTiles"; break;
            case "sport": arrayName = "sportsResultsTiles"; break;
            case "hotel": arrayName = "hotelResultTiles"; break;
            case "content": arrayName = "contentResultTiles"; break;
            case "business": arrayName = "financeResults"; break;
            case "amazon": arrayName = "amazonResultsTiles"; break;
            case "info": arrayName = "infoResultTiles"; break;
            case "facebook": arrayName = "facebookPostResult"; break;
        }

        var data = getLocalStorageItem(key);
        if (data == null || data == undefined || data == "") {
        }
        else {
            window[arrayName] = JSON.parse(data);
        }
    }
}

// this method will reterive data for a particular category
function getIndividualDataFromCache(category) {

    switch (category) {
        case "news":
            var data = getLocalStorageItem('newsData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                newsResultsTiles = JSON.parse(data);
            }
            break;
        case "restaurants":
            var data = getLocalStorageItem('restaurantsData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                restaurantResultsTiles = JSON.parse(data);
            }
            break;

        case "video":
            var data = getLocalStorageItem('videoData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                videoResultsTiles = JSON.parse(data);
            }
            break;

        case "deals":
            var data = getLocalStorageItem('dealsData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                dealsResultTiles = JSON.parse(data);
            }

            break;

        case "music":
            var data = getLocalStorageItem('musicData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                musicResultTiles = JSON.parse(data);
            }
            break;

        case "job":
            var data = getLocalStorageItem('jobData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                jobResultsTiles = JSON.parse(data);
            }

            break;

        case "ebay":
            var data = getLocalStorageItem('ebayData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                ebayResultsTiles = JSON.parse(data);
            }
            break;

        case "sport":
            var data = getLocalStorageItem('sportData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                sportsResultsTiles = JSON.parse(data);
            }

            break;

        case "hotel":
            var data = getLocalStorageItem('hotelData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                hotelResultTiles = JSON.parse(data);
            }
            break;

        case "content":
            var data = getLocalStorageItem('contentData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                contentResultTiles = JSON.parse(data);
            }
            break;

        case "business":
            var data = getLocalStorageItem('businessData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                financeResults = JSON.parse(data);
            }
            break;

        case "amazon":
            var data = getLocalStorageItem('amazonData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                amazonResultsTiles = JSON.parse(data);
            }
            break;

        case "info":
            var data = getLocalStorageItem('infoData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                infoResultTiles = JSON.parse(data);
            }
            break;

        case "facebook":
            var data = getLocalStorageItem('facebookData');
            if (data == null || data == undefined || data == "") {
            }
            else {
                facebookPostResult = JSON.parse(data);
            }
            break;
    }
}

// this method will save all category data into cache
function setAllDataIntoCache() {
    
    if (newsResultsTiles.length > 0) {
        newsResultsTiles = newsResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('newsData', JSON.stringify(newsResultsTiles));
    }

    if (restaurantResultsTiles.length > 0) {
        restaurantResultsTiles = restaurantResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('restaurantsData', JSON.stringify(restaurantResultsTiles));
    }

    if (videoResultsTiles.length > 0) {
        videoResultsTiles = videoResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('videoData', JSON.stringify(videoResultsTiles));
    }

    if (dealsResultTiles.length > 0) {
        dealsResultTiles = dealsResultTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('dealsData', JSON.stringify(dealsResultTiles));
    }
    
    if (musicResultTiles.length > 0) {
        musicResultTiles = musicResultTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('musicData', JSON.stringify(musicResultTiles));
    }

    if (jobResultsTiles.length > 0) {
        jobResultsTiles = jobResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('jobData', JSON.stringify(jobResultsTiles));
    }

    if (ebayResultsTiles.length > 0) {
        ebayResultsTiles = ebayResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('ebayData', JSON.stringify(ebayResultsTiles));
    }

    if (sportsResultsTiles.length > 0) {
        sportsResultsTiles = sportsResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('sportData', JSON.stringify(sportsResultsTiles));
    }

    if (hotelResultTiles.length > 0) {
        hotelResultTiles = hotelResultTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('hotelData', JSON.stringify(hotelResultTiles));
    }

    if (contentResultTiles.length > 0) {
        contentResultTiles = contentResultTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('contentData', JSON.stringify(contentResultTiles));
    }

    if (financeResults.length > 0) {
        financeResults = financeResults.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('businessData', JSON.stringify(financeResults));
    }

    if (amazonResultsTiles.length > 0) {
        amazonResultsTiles = amazonResultsTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('amazonData', JSON.stringify(amazonResultsTiles));
    }

    if (infoResultTiles.length > 0) {
        infoResultTiles = infoResultTiles.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('infoData', JSON.stringify(infoResultTiles));
    }

    if (facebookPostResult.length > 0) {
        facebookPostResult = facebookPostResult.slice(0, ARRAY_SLICE_SIZE);
        setLocalStorageItem('facebookData', JSON.stringify(facebookPostResult));
    }

}

// this method will save individual category data into cache
function setIndividualDataIntoCache(category) {
    switch (category) {
        case "news":
            if (newsResultsTiles.length > 0) {
                newsResultsTiles = newsResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('newsData', JSON.stringify(newsResultsTiles));
            }
            break;
        case "restaurants":
            if (restaurantResultsTiles.length > 0) {
                restaurantResultsTiles = restaurantResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('restaurantsData', JSON.stringify(restaurantResultsTiles));
            }
            break;

        case "video":
            if (videoResultsTiles.length > 0) {
                videoResultsTiles = videoResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('videoData', JSON.stringify(videoResultsTiles));
            }
            break;

        case "deals":
            if (dealsResultTiles.length > 0) {
                dealsResultTiles = dealsResultTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('dealsData', JSON.stringify(dealsResultTiles));
            }
            break;

        case "music":
            if (musicResultTiles.length > 0) {
                musicResultTiles = musicResultTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('musicData', JSON.stringify(musicResultTiles));
            }
            break;

        case "job":
            if (jobResultsTiles.length > 0) {
                jobResultsTiles = jobResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('jobData', JSON.stringify(jobResultsTiles));
            }
            break;

        case "ebay":
            if (ebayResultsTiles.length > 0) {
                ebayResultsTiles = ebayResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('ebayData', JSON.stringify(ebayResultsTiles));
            }
            break;

        case "sport":
            if (sportsResultsTiles.length > 0) {
                sportsResultsTiles = sportsResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('sportData', JSON.stringify(sportsResultsTiles));
            }

            break;

        case "hotel":
            if (hotelResultTiles.length > 0) {
                hotelResultTiles = hotelResultTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('hotelData', JSON.stringify(hotelResultTiles));
            }
            break;

        case "content":
            if (contentResultTiles.length > 0) {
                contentResultTiles = contentResultTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('contentData', JSON.stringify(contentResultTiles));
            }
            break;

        case "business":
            if (financeResults.length > 0) {
                financeResults = financeResults.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('businessData', JSON.stringify(financeResults));
            }
            break;

        case "amazon":
            if (amazonResultsTiles.length > 0) {
                amazonResultsTiles = amazonResultsTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('amazonData', JSON.stringify(amazonResultsTiles));
            }
            break;

        case "info":
            if (infoResultTiles.length > 0) {
                infoResultTiles = infoResultTiles.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('infoData', JSON.stringify(infoResultTiles));
            }
            break;

        case "facebook":
            if (facebookPostResult.length > 0) {
                facebookPostResult = facebookPostResult.slice(0, ARRAY_SLICE_SIZE);
                setLocalStorageItem('facebookData', JSON.stringify(facebookPostResult));
            }
            break;
    }
}

// this method will clear the cache : i.e. it will remove all category data 
function clearCache() {
    localStorage.removeItem('newsData');
    localStorage.removeItem('restaurantsData');
    localStorage.removeItem('videoData');
    localStorage.removeItem('dealsData');
    localStorage.removeItem('musicData');
    localStorage.removeItem('jobData');
    localStorage.removeItem('ebayData');
    localStorage.removeItem('sportData');
    localStorage.removeItem('hotelData');
    localStorage.removeItem('contentData');
    localStorage.removeItem('businessData');
    localStorage.removeItem('amazonData');
    localStorage.removeItem('infoData');
    localStorage.removeItem('facebookData');

}


function getUserKeyword(category) {

	var userKeyword ;

    switch (category) {
        case "news":
            try{
				var tags = getLocalStorageItem("newsTags");
				if (tags == null || tags == undefined || tags == "") {
					// no tags saved get default keyword
					userKeyword = getDefaultKeyword('news');
				}
				else {
					var tagsArray = JSON.parse(tags);
					userKeyword = tagsArray[0];
				}
			}
			catch (ex) {
				userKeyword = getDefaultKeyword('news');
			}
            break;
        case "restaurants":
            try {
				var tags = getLocalStorageItem("restaurantsTags");
				if (tags == null || tags == undefined || tags == "") {
					// no tags saved get default keyword
					userKeyword = getDefaultKeyword('restaurants');
				}
				else {
					var tagsArray = JSON.parse(tags);
					userKeyword = tagsArray[0];
				}
			}
			catch (ex) {
				userKeyword = getDefaultKeyword('restaurants');
			}
            break;

        case "video":
            try{
				var tags = getLocalStorageItem("videoTags");
				if (tags == null || tags == undefined || tags == "") {
					
					userKeyword = getDefaultKeyword('video');
					
				}
				else {
					var tagsArray = JSON.parse(tags);
					userKeyword = tagsArray[0];
				}
			}
			catch (ex) {
				userKeyword = getDefaultKeyword('video');
			}
            break;

        

        case "content":
            try {
				var tags = getLocalStorageItem("contentTags");
				if (tags == null || tags == undefined || tags == "") {
					// no tags saved get default keyword
					userKeyword = getDefaultKeyword('content');

				}
				else {
					var tagsArray = JSON.parse(tags);
					userKeyword = tagsArray[0];
				}
			}
			catch (ex) {
				userKeyword = getDefaultKeyword('content');
			}
            break;

        case "amazon":
			try {
				var tags = getLocalStorageItem("amazonTags");
				if (tags == null || tags == undefined || tags == "") {
					// no tags saved get default keyword
					userKeyword = getDefaultKeyword('amazon');

				}
				else {
					var tagsArray = JSON.parse(tags);
					userKeyword = tagsArray[amazonCounter];
				}
			}
			catch (ex) {
				userKeyword = getDefaultKeyword('amazon');
			}
            break;
			
			default: userKeyword = getDefaultKeyword(category);
    }
	return userKeyword;
}