function fetch_content_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ CONTENT RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var hoopzContentResponse = "";
	var loadmore = false;
	url = BASE_URL + "AdvertiserService/fetchContent";

	var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
	var payload = "";
	payload += "<request>";
	payload += "<keywords>" + encodeURIComponent(keyword) + "</keywords>"
	payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>"
	payload += "<modelName>" + MODEL_NAME + "</modelName>"
	payload += "<modelId>" + MODEL_ID + "</modelId>"
	payload += "<os>" + OS + "</os>"
	payload += "<deviceType>" + "phone" + "</deviceType>"
	payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
	payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
	payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
	payload += "<carrier>" + "" + "</carrier>"
	payload += "<adType>" + "2" + "</adType>"
	payload += "<imeiNumber>" + "" + "</imeiNumber>"
	payload += "<mobileNo>" + "" + "</mobileNo>"
	payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
	payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
	payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
	payload += "<language>" + DEVICE_LANG + "</language>"
	payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
	payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
	payload += "<geoLocation>" + temp + "</geoLocation>"
	payload += "<pageNo>" + hoopzContentPageNumber + "</pageNo>"
	payload += "<clientId>" + CLIENT_ID + "</clientId>"
	payload += "</request>";

	console.log("HOOPZ CONTENT REQUEST ================= " + payload);

	$.ajax({
		url : url,
		type : "POST",
		data : payload,
		timeout : 70000,
		contentType : "application/xml",
		Cookie : "JSESSIONID=",

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(hoopzContentResponse != "") {
				//$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				fetch_Tmdb_Result(keyword, searchtype);
			} else {
				if(tmdbContentSeeMore == "YES") {
					fetch_Tmdb_Result(keyword, searchtype, true)
				} else if(naverContentSeeMore == "YES") {
					fetch_NaverMovie_Result(keyword, searchtype, true)
				} else {
					fetchResultDone();
				}
			}
		},

		success: function(data) {
			$(data).find('response').each(function() {
				var status = $(this).find('status').text();

				if (status == '1' || status == '3') {
					loadmore = $(this).find('loadMore').text();

					$(this).find('content').each(function() {
						var title = '';
						var desc = '';
						var price = '';
						var imgPath = '';
						var url = '';

						try {
							title = $(this).find('title').text();
						} catch (err) {
							title = "";
						}
						try {
							desc = $(this).find('description').text();
						} catch (err) {
							desc = "";
						}
						try {
							price = $(this).find('price').text();
						} catch (err) {
							price = "";
						}
						try {
							imgPath = $(this).find('previewImage').text();
							imgPath = decodeURIComponent(imgPath);
						} catch (err) {
							imgPath = "es_img/content.png";
						}
						try {
							url = $(this).find('url').text();
							url = decodeURIComponent(url);
						} catch (err) {
							url = "#";
						}

						hoopzContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
						hoopzContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

						/////////////////////////////////
						hoopzContentResponse += '<table width="100%" style="margin:0;padding:0;">';
						hoopzContentResponse += '<tr>'
						hoopzContentResponse += '<td width="100%" style="color:blue;">';
						hoopzContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
						hoopzContentResponse += '</td>';
						hoopzContentResponse += '</tr>';
						hoopzContentResponse += '</table>';

						/////////////////////////////////
						hoopzContentResponse += '<table width="100%" style="margin:0;padding:0;">';
						hoopzContentResponse += '<tr>';
						hoopzContentResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
						hoopzContentResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
						hoopzContentResponse += '</td>';
						hoopzContentResponse += '<td style="vertical-align:top;">';
						hoopzContentResponse += '<div style="max-height:45px;overflow:hidden;white-space:normal;">' + desc + '</div>';
						hoopzContentResponse += '</td>'
						hoopzContentResponse += '</tr>'

						hoopzContentResponse += '<tr>';
						hoopzContentResponse += '<td style="vertical-align:top;">Price : ' + price + '</td>';
						hoopzContentResponse += '</tr>'

						hoopzContentResponse += '</table>'
						/////////////////////////////////

						hoopzContentResponse += '</a>';
						hoopzContentResponse += '</li>';

						var hoopzcontentArrElement = new HoopzContentResultClass();
						hoopzcontentArrElement.title = title;
						hoopzcontentArrElement.desc = desc;
						hoopzcontentArrElement.price = price;
						hoopzcontentArrElement.imgPath = imgPath;
						hoopzcontentArrElement.url = url;

						try {
							hoopzContentResultArr.push(hoopzcontentArrElement);
						} catch (err) {
						}
					});
				}
			});

			if(loadmore == "1") {
				hoopzContentPageNumber = hoopzContentPageNumber + 1;
				hoopzContentSeeMore = "YES";
				CONTENT_SEEMORE_FLAG = true;
			} else {
				hoopzContentSeeMore = "NO";
			}

			if(selectedCategory == "4") {
				$('#result').append(hoopzContentResponse).listview("refresh");

				if(CONTENT_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreContent(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_Tmdb_Result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ TMDB RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var tmdbContentResponse = "";
	var loadmore = false;

	var lang = DEVICE_LANG;

	if(lang == null || lang.trim() == "") {
		lang = "en";
	}
	lang = lang.replace("_","-");
	url = "http://api.themoviedb.org/2.1/Movie.browse/" + lang + "/json/775772da896aaae174da37dac04f01af?order_by=title&order=asc&page=" + tmdbContentPageNumber + "&per_page=10&query=" + encodeURIComponent(keyword);
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(tmdbContentResponse != "") {
				//$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				if(CONTRY_CODE.toLowerCase() == "kr" || CONTRY_CODE.toLowerCase() == "kp") {
					fetch_NaverMovie_Result(keyword, searchtype);
				} else {
					fetchResultDone();
				}
			} else {
				if(naverContentSeeMore == "YES") {
					fetch_NaverMovie_Result(keyword, searchtype, true)
				} else {
					fetchResultDone();
				}
			}
		},

		success : function(data, textStatus, xhr) {
			var totalObj = 0;
			try {
				totalObj = data.length;
			} catch (err) {
				totalObj = 0;
			}

			if(totalObj >= 10) {
				loadmore = true;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var desc = "";
				var date = "";
				var rating = "";
				var imgPath = "";
				var url = "";

				try {
					title = data[itr].name;
				} catch (err) {
					title = "";
				}

				try {
					desc = data[itr].overview;
				} catch (err) {
					desc = "";
				}

				try {
					date = data[itr].released;
				} catch (err) {
					date = "";
				}

				try {
					rating = data[itr].rating;
				} catch (err) {
					rating = "0.0";
				}

				try {
					imgPath = data[itr].posters[0].image.url;
				} catch (err) {
					imgPath = "es_img/content.png";
				}

				try {
					url = data[itr].url;
				} catch (err) {
					url = "#";
				}

				tmdbContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				tmdbContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				tmdbContentResponse += '<table width="100%" style="margin:0;padding:0;">';
				tmdbContentResponse += '<tr>'
				tmdbContentResponse += '<td width="100%" style="color:blue;">';
				tmdbContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
				tmdbContentResponse += '</td>';
				tmdbContentResponse += '</tr>';
				tmdbContentResponse += '</table>';
				/////////////////////////////////
				tmdbContentResponse += '<table width="100%" style="margin:0;padding:0;">';
				tmdbContentResponse += '<tr>';
				tmdbContentResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
				tmdbContentResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
				tmdbContentResponse += '</td>';
				tmdbContentResponse += '<td style="vertical-align:top;">';
				tmdbContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
				tmdbContentResponse += '</td>'
				tmdbContentResponse += '</tr>'

				tmdbContentResponse += '<tr>';
				tmdbContentResponse += '<td style="vertical-align:top;">';
				tmdbContentResponse += '<div style="overflow:hidden;white-space:normal;">Release Date : ' + date + '</div>';
				tmdbContentResponse += '</td>'
				tmdbContentResponse += '</tr>'

				tmdbContentResponse += '<tr>';
				tmdbContentResponse += '<td style="vertical-align:top;">';
				tmdbContentResponse += '<div style="overflow:hidden;white-space:normal;">Rating : ' + rating + '/10.0</div>';
				tmdbContentResponse += '</td>'
				tmdbContentResponse += '</tr>'
				tmdbContentResponse += '</table>'
				/////////////////////////////////
				tmdbContentResponse += '</a>';
				tmdbContentResponse += '</li>';

				var tmdbContentArrElement = new TmdbContentResultClass();
				tmdbContentArrElement.title = title;
				tmdbContentArrElement.desc = desc;
				tmdbContentArrElement.imgPath = imgPath;
				tmdbContentArrElement.url = url;

				try {
					tmdbContentResultArr.push(tmdbContentArrElement);
				} catch (err) {
				}
			}

			if(loadmore == true) {
				tmdbContentPageNumber = tmdbContentPageNumber + 1;
				tmdbContentSeeMore = "YES";
				CONTENT_SEEMORE_FLAG = true;
			} else {
				tmdbContentSeeMore = "NO";
			}

			if(selectedCategory == "4") {
				$('#result').append(tmdbContentResponse).listview("refresh");
				if(CONTENT_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreContent(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_NaverMovie_Result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ NAVER MOVIE RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var naverContentResponse = "";
	var loadmore = false;

	//CHAGNE EN-US to locale
	url = "http://openapi.naver.com/search?target=movie&query="+ encodeURIComponent(keyword) +"&key=bdd71b8cc20696bfd5003a42df949cfa&display=10&start=" + naverContentPageNumber;
	dataType = "xml";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(naverContentResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			fetchResultDone();
		},

		success : function(data, textStatus, xhr) {
			total = $(data).find('total').text();

			$(data).find('item').each(function() {
				var title = "";
				var date = "";
				var rating = "";
				var imgPath = "";
				var url = "";

				try {
					title = $(this).find('title').text();
				} catch (err) {
					title = "Not Found";
				}

				try {
					date = $(this).find('pubDate').text();
				} catch (err) {
					date = "Not Found";
				}

				try {
					rating = $(this).find('userRating').text();
				} catch (err) {
					rating = "0.0";
				}

				try {
					imgPath = $(this).find('image').text();
				} catch (err) {
					imgPath = "es_img/content.png";
				}

				try {
					url = $(this).find('link').text();
				} catch (err) {
					url = "#";
				}

				naverContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				naverContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				naverContentResponse += '<table width="100%" style="margin:0;padding:0;">';
				naverContentResponse += '<tr>'
				naverContentResponse += '<td width="100%" style="color:blue;">';
				naverContentResponse += '<div style="max-height:20px;overflow:hidden;white-space:normal;">' + title + '</div>';
				naverContentResponse += '</td>';
				naverContentResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/naver.png" /></td>';
				naverContentResponse += '</tr>';
				naverContentResponse += '</table>';
				/////////////////////////////////

				/////////////////////////////////
				naverContentResponse += '<table width="100%" style="margin:0;padding:0;">';
				naverContentResponse += '<tr>';
				naverContentResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
				naverContentResponse += '<img src="' + imgPath + '" width="60px" height="60px" />';
				naverContentResponse += '</td>';
				naverContentResponse += '<td style="vertical-align:top;">';
				naverContentResponse += 'Release Date : ' + date;
				naverContentResponse += '</td>'
				naverContentResponse += '</tr>'

				naverContentResponse += '<tr>';
				naverContentResponse += '<td style="vertical-align:top;">Rating : ' + rating + '/10.0</td>';
				naverContentResponse += '</tr>'
				naverContentResponse += '</table>';
				/////////////////////////////////

				naverContentResponse += '</a>';
				naverContentResponse += '</li>';

				var naverContentArrElement = new NaverContentResultClass();
				naverContentArrElement.title = title;
				naverContentArrElement.date = date;
				naverContentArrElement.rating = rating;
				naverContentArrElement.imgPath = imgPath;
				naverContentArrElement.url = url;

				try {
					naverContentResultArr.push(naverContentArrElement);
				} catch (err) {
				}
			});

			if(total > naverContentResultArr.length) {
				naverContentPageNumber = naverContentPageNumber + 10;
				naverContentSeeMore = "YES";
				CONTENT_SEEMORE_FLAG = true;
			} else {
				naverContentSeeMore = "NO";
			}

			if(selectedCategory == "4") {
				$('#result').append(naverContentResponse).listview("refresh");
				if(CONTENT_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreContent(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function showOldContentData(keyword, searchtype) {
	var hoopzContentResponse = "";
	var len = hoopzContentResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = hoopzContentResultArr[itr].title;
		var desc = hoopzContentResultArr[itr].desc;
		var price = hoopzContentResultArr[itr].price;
		var imgPath = hoopzContentResultArr[itr].imgPath;
		var url = hoopzContentResultArr[itr].url;

		hoopzContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		hoopzContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		hoopzContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		hoopzContentResponse += '<tr>'
		hoopzContentResponse += '<td width="100%" style="color:blue;">';
		hoopzContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		hoopzContentResponse += '</td>';
		hoopzContentResponse += '</tr>';
		hoopzContentResponse += '</table>';

		/////////////////////////////////
		hoopzContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		hoopzContentResponse += '<tr>';
		hoopzContentResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
		hoopzContentResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		hoopzContentResponse += '</td>';
		hoopzContentResponse += '<td style="vertical-align:top;">';
		hoopzContentResponse += '<div style="max-height:45px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		hoopzContentResponse += '</td>'
		hoopzContentResponse += '</tr>'

		hoopzContentResponse += '<tr>';
		hoopzContentResponse += '<td style="vertical-align:top;">Price : ' + price + '</td>';
		hoopzContentResponse += '</tr>'

		hoopzContentResponse += '</table>'
		/////////////////////////////////

		hoopzContentResponse += '</a>';
		hoopzContentResponse += '</li>';
	}

	var tmdbContentResponse = "";
	len = tmdbContentResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = tmdbContentResultArr[itr].title;
		var desc = tmdbContentResultArr[itr].desc;
		var date = tmdbContentResultArr[itr].date;
		var rating = tmdbContentResultArr[itr].rating;
		var imgPath = tmdbContentResultArr[itr].imgPath;
		var url = tmdbContentResultArr[itr].url;

		tmdbContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		tmdbContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		tmdbContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		tmdbContentResponse += '<tr>'
		tmdbContentResponse += '<td width="100%" style="color:blue;">';
		tmdbContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		tmdbContentResponse += '</td>';
		tmdbContentResponse += '</tr>';
		tmdbContentResponse += '</table>';
		/////////////////////////////////
		tmdbContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		tmdbContentResponse += '<tr>';
		tmdbContentResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
		tmdbContentResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		tmdbContentResponse += '</td>';
		tmdbContentResponse += '<td style="vertical-align:top;">';
		tmdbContentResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		tmdbContentResponse += '</td>'
		tmdbContentResponse += '</tr>'

		tmdbContentResponse += '<tr>';
		tmdbContentResponse += '<td style="vertical-align:top;">';
		tmdbContentResponse += '<div style="overflow:hidden;white-space:normal;">Release Date : ' + date + '</div>';
		tmdbContentResponse += '</td>'
		tmdbContentResponse += '</tr>'

		tmdbContentResponse += '<tr>';
		tmdbContentResponse += '<td style="vertical-align:top;">';
		tmdbContentResponse += '<div style="overflow:hidden;white-space:normal;">Rating : ' + rating + '/10.0</div>';
		tmdbContentResponse += '</td>'
		tmdbContentResponse += '</tr>'
		tmdbContentResponse += '</table>'
		/////////////////////////////////
		tmdbContentResponse += '</a>';
		tmdbContentResponse += '</li>';
	}

	var naverContentResponse = "";
	len = naverContentResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = naverContentResultArr[itr].title;
		var date = naverContentResultArr[itr].date;
		var rating = naverContentResultArr[itr].rating;
		var imgPath = naverContentResultArr[itr].imgPath;
		var url = naverContentResultArr[itr].url;

		naverContentResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		naverContentResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		naverContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		naverContentResponse += '<tr>'
		naverContentResponse += '<td width="100%" style="color:blue;">';
		naverContentResponse += '<div style="max-height:20px;overflow:hidden;white-space:normal;">' + title + '</div>';
		naverContentResponse += '</td>';
		naverContentResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/naver.png" /></td>';
		naverContentResponse += '</tr>';
		naverContentResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		naverContentResponse += '<table width="100%" style="margin:0;padding:0;">';
		naverContentResponse += '<tr>';
		naverContentResponse += '<td rowspan="2" width="60px" height="60px" style="vertical-align:top;">';
		naverContentResponse += '<img src="' + imgPath + '" width="60px" height="60px" />';
		naverContentResponse += '</td>';
		naverContentResponse += '<td style="vertical-align:top;">';
		naverContentResponse += 'Release Date : ' + date;
		naverContentResponse += '</td>'
		naverContentResponse += '</tr>'

		naverContentResponse += '<tr>';
		naverContentResponse += '<td style="vertical-align:top;">Rating : ' + rating + '/10.0</td>';
		naverContentResponse += '</tr>'
		naverContentResponse += '</table>';
		/////////////////////////////////

		naverContentResponse += '</a>';
		naverContentResponse += '</li>';
	}

	$('#result').append(hoopzContentResponse + tmdbContentResponse + naverContentResponse).listview("refresh");

	if(CONTENT_SEEMORE_FLAG == true) {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetchMoreContent(keyword, searchtype);
	});
}

function fetchMoreContent(keyword, searchtype) {
	console.log("CONTENT LOAD MORE = " + hoopzContentSeeMore + " = " + tmdbContentSeeMore + " = " + naverContentSeeMore);
	CONTENT_SEEMORE_FLAG = false;
	if(hoopzContentSeeMore == "YES") {
		fetch_content_result(keyword, searchtype, true);
	} else if(tmdbContentSeeMore == "YES") {
		fetch_Tmdb_Result(keyword, searchtype, true)
	} else if(naverContentSeeMore == "YES") {
		fetch_NaverMovie_Result(keyword, searchtype, true)
	} else {
		$('#SEEMORE').hide();
		$.mobile.hidePageLoadingMsg();
	}
}

function fetchResultDone() {
	$.mobile.hidePageLoadingMsg();
}