function fetch_ddc_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ DDC RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var hoopzddcResponse = "";
	var loadmore = false;
	url = BASE_URL + "AdvertiserService/fetchDdc";

	var temp = getLocalStorageItem("ESCITY") + "," + getLocalStorageItem("ESREGION") + "," + getLocalStorageItem("ESCOUNTRY");
	var payload = "";
	payload += "<request>";
	payload += "<keywords>" + encodeURIComponent(keyword) + "</keywords>"
	payload += "<timeZoneOffset>" + get_time_zone_offset() + "</timeZoneOffset>"
	payload += "<modelName>" + MODEL_NAME + "</modelName>"
	payload += "<modelId>" + MODEL_ID + "</modelId>"
	payload += "<os>" + OS + "</os>"
	payload += "<deviceType>" + "phone" + "</deviceType>"
	payload += "<screenWidth>" + document.body.offsetWidth + "</screenWidth>"
	payload += "<screenHeight>" + document.body.offsetHeight + "</screenHeight>"
	payload += "<oemOperatorKey>" + OEMOPERATOR_ID + "</oemOperatorKey>"
	payload += "<carrier>" + "" + "</carrier>"
	payload += "<adType>" + "5" + "</adType>"
	payload += "<imeiNumber>" + "" + "</imeiNumber>"
	payload += "<mobileNo>" + "" + "</mobileNo>"
	payload += "<simImsiNumber>" + "" + "</simImsiNumber>"
	payload += "<publisherKey>" + PUBLISHER_ID + "</publisherKey>"
	payload += "<oemOperatorName>" + OEMOPERATOR_NAME + "</oemOperatorName>"
	payload += "<language>" + DEVICE_LANG + "</language>"
	payload += "<latitude>" + getLocalStorageItem("ESLATITUDE") + "</latitude>"
	payload += "<longitude>" + getLocalStorageItem("ESLONGITUDE") + "</longitude>"
	payload += "<geoLocation>" + temp + "</geoLocation>"
	payload += "<pageNo>" + hoopzDDCPageNumber + "</pageNo>"
	payload += "<clientId>" + CLIENT_ID + "</clientId>"
	payload += "</request>";

	console.log("HOOPZ DDC REQUEST ================= " + payload);

	$.ajax({
		url : url,
		type : "POST",
		data : payload,
		timeout : 70000,
		contentType : "application/xml",
		Cookie : "JSESSIONID=",

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

			$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(hoopzddcResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				if (CONTRY_CODE.toLowerCase() == "in") {
					fetch_timesdeals_result(keyword, searchtype);
				} else {
					fetch_groupondeals_result(keyword, searchtype);
				}
			} else {
				if(yipitdealSeeMore == "YES") {
					fetch_yipitdeals_result(keyword, searchtype, true);
				} else {
					fetchResultDone();
				}
			}
		},

		success: function(data) {
			$(data).find('response').each(function() {
				var status = $(this).find('status').text();

				if (status == '1' || status == '3') {
					loadmore = $(this).find('loadMore').text();

					$(this).find('dealdiscountcoupon').each(function() {
						var title = '';
						var desc = '';
						var type = '';
						var value = '';
						var price = '';
						var discount = '';
						var imgPath = '';
						var url = '';

						try {
							title = $(this).find('title').text();
						} catch (err) {
							title = "";
						}
						try {
							desc = $(this).find('description').text();
						} catch (err) {
							desc = "";
						}
						try {
							type = $(this).find('type').text();
						} catch (err) {
							type = "";
						}
						try {
							value = $(this).find('mrp').text();
						} catch (err) {
							value = "";
						}
						try {
							price = $(this).find('sellingPrice').text();
						} catch (err) {
							price = "";
						}
						try {
							discount = $(this).find('percentageOff').text();
						} catch (err) {
							discount = "0";
						}
						try {
							imgPath = $(this).find('previewImage').text();
							imgPath = decodeURIComponent(imgPath);
						} catch (err) {
							imgPath = "es_img/deal_discount_coupon.png";
						}
						try {
							url = $(this).find('url').text();
							url = decodeURIComponent(url);
						} catch (err) {
							url = "#";
						}

						hoopzddcResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
						hoopzddcResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

						/////////////////////////////////
						hoopzddcResponse += '<table width="100%" style="margin:0;padding:0;">';
						hoopzddcResponse += '<tr>'
						hoopzddcResponse += '<td width="100%" style="color:blue;">';
						hoopzddcResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
						hoopzddcResponse += '</td>';

						if(type == 1) {
							hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Deal' + '</td>';
						} else if(type == 2) {
							hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Discount' + '</td>';
						} else if(type == 3) {
							hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Coupon' + '</td>';
						} else {
							hoopzddcResponse += '<td>' + '' + '</td>';
						}

						hoopzddcResponse += '</tr>';
						hoopzddcResponse += '</table>';

						/////////////////////////////////
						hoopzddcResponse += '<table width="100%" style="margin:0;padding:0;">';
						hoopzddcResponse += '<tr>';
						hoopzddcResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
						hoopzddcResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
						hoopzddcResponse += '</td>';
						hoopzddcResponse += '<td colspan="2" style="vertical-align:top;">';
						hoopzddcResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
						hoopzddcResponse += '</td>'
						hoopzddcResponse += '</tr>'

						hoopzddcResponse += '<tr>';
						hoopzddcResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '%</td>';
						hoopzddcResponse += '</tr>'

						hoopzddcResponse += '<tr>'
						hoopzddcResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
						hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
						hoopzddcResponse += '</tr>';
						hoopzddcResponse += '</table>'
						/////////////////////////////////

						hoopzddcResponse += '</a>';
						hoopzddcResponse += '</li>';

						var hoopzddcArrElement = new HoopzDDCResultClass();
						hoopzddcArrElement.title = title;
						hoopzddcArrElement.desc = desc;
						hoopzddcArrElement.type = type;
						hoopzddcArrElement.value = value;
						hoopzddcArrElement.price = price;
						hoopzddcArrElement.discount = discount;
						hoopzddcArrElement.imgPath = imgPath;
						hoopzddcArrElement.url = url;

						try {
							hoopzDDCResultArr.push(hoopzddcArrElement);
						} catch (err) {
						}
					});
				}
			});

			if(loadmore == "1") {
				hoopzDDCPageNumber = hoopzDDCPageNumber + 1;
				hoopzDDCSeeMore = "YES";
				DDC_SEEMORE_FLAG = true;
			} else {
				hoopzDDCSeeMore = "NO";
			}

			if(selectedCategory == "2") {
				$('#result').append(hoopzddcResponse).listview("refresh");

				if(DDC_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreDeals(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_timesdeals_result(keyword, searchtype) {
	console.log("============ TIMES DEAL RESULT START.");
	var timesdealResponse = "";
	url = "http://timesdeal.com/feeds/json-for-All-India.json";
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(timesdealResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			fetch_groupondeals_result(keyword, searchtype);
		},

		success : function(data, textStatus, xhr) {
			var totalObj = 0;
			try {
				totalObj = data.DealDetails.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var desc = "";
				var imgPath = "";
				var url = "";

				try {
					title = data.DealDetails[itr].DealShortDescription;
				} catch (err) {
					title = "";
				}

				try {
					desc = data.DealDetails[itr].DealDescription;
				} catch (err) {
					desc = "";
				}

				try {
					imgPath = data.DealDetails[itr].DealImages.image_path[0];
				} catch (err) {
					imgPath = "es_img/deal_discount_coupon.png";
				}

				try {
					url = data.DealDetails[itr].DealUrl;
				} catch (err) {
					url = "#";
				}

				if(title.toLowerCase().indexOf(keyword.toLowerCase()) >= 0 || desc.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
					timesdealResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
					timesdealResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

					timesdealResponse += '<table width="100%" style="margin:0;padding:0;">';
					/////////////////////////////////
					timesdealResponse += '<tr>'
					timesdealResponse += '<td width="100%" style="color:blue;">';
					timesdealResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
					timesdealResponse += '</td>';
					timesdealResponse += '<td style="vertical-align:top;text-align:right;"><img src="es_img/timesdeal.png" /></td>';
					timesdealResponse += '</tr>';
					timesdealResponse += '</table>';
					/////////////////////////////////
					timesdealResponse += '<table width="100%" style="margin:0;padding:0;">';
					timesdealResponse += '<tr>';
					timesdealResponse += '<td width="60px" height="60px" style="vertical-align:top;">';
					timesdealResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
					timesdealResponse += '</td>';
					timesdealResponse += '<td style="vertical-align:top;">';
					timesdealResponse += '<div style="max-height:60px;overflow:hidden;white-space:normal;">' + desc + '</div>';
					timesdealResponse += '</td>'
					timesdealResponse += '</tr>'
					timesdealResponse += '</table>'
					/////////////////////////////////
					timesdealResponse += '</a>';
					timesdealResponse += '</li>';

					var timesdealArrElement = new TimesDealResultClass();
					timesdealArrElement.title = title;
					timesdealArrElement.desc = desc;
					timesdealArrElement.imgPath = imgPath;
					timesdealArrElement.url = url;

					try {
						timesdealResultArr.push(timesdealArrElement);
					} catch (err) {
					}
				}
			}

			if(selectedCategory == "2") {
				$('#result').append(timesdealResponse).listview("refresh");
				if(DDC_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreDeals(keyword, searchtype)
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_groupondeals_result(keyword, searchtype) {
	console.log("============ GROUPON DEALS RESULT START.");
	var grouponResponse = "";
	url = "https://api.groupon.com/v2/deals.json?client_id=aecf61e7e5838c617704afe1627f20a94a7f5d77&lat=41.8795&lng=-87.6243";
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(grouponResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if (CONTRY_CODE.toLowerCase() == "us") {
				fetch_yipitdeals_result(keyword, searchtype);
			} else {
				fetchResultDone();
			}
		},

		success : function(data, textStatus, xhr) {
			var totalObj = 0;
			try {
				totalObj = data.deals.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var location = "";
				var name = "";
				var value = "";
				var price = "";
				var discount = "";
				var imgPath = "";
				var url = "";

				try {
					title = data.deals[itr].announcementTitle;
					if(title.trim() == "") {
						title = data.deals[itr].title;
					}
				} catch (err) {
					title = "";
				}

				try {
					location = data.deals[itr].redemptionLocation;
				} catch (err) {
					location = "";
				}

				try {
					name = data.deals[itr].merchant.name;
				} catch (err) {
					name = "";
				}

				var temp = data.deals[itr].options;
				try {
					value = temp[temp.length - 1].value.formattedAmount;
				} catch (err) {
					value = "";
				}

				try {
					price = temp[temp.length - 1].price.formattedAmount;
				} catch (err) {
					price = "";
				}

				try {
					discount = temp[temp.length - 1].discount.formattedAmount;
				} catch (err) {
					discount = "";
				}

				try {
					imgPath = data.deals[itr].mediumImageUrl;
				} catch (err) {
					imgPath = "es_img/deal_discount_coupon.png";
				}

				try {
					url = data.deals[itr].dealUrl;
				} catch (err) {
					url = "#";
				}

				if(title.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
					grouponResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
					grouponResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

					/////////////////////////////////
					grouponResponse += '<table width="100%" style="margin:0;padding:0;">';
					grouponResponse += '<tr>'
					grouponResponse += '<td width="100%" style="color:blue;">';
					grouponResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
					grouponResponse += '</td>';
					grouponResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/groupon.png" /></td>';
					grouponResponse += '</tr>';
					grouponResponse += '</table>';

					/////////////////////////////////
					grouponResponse += '<table width="100%" style="margin:0;padding:0;">';
					grouponResponse += '<tr>';
					grouponResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
					grouponResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
					grouponResponse += '</td>';
					grouponResponse += '<td colspan="2" style="vertical-align:top;">';
					grouponResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + name + " " + location + '</div>';
					grouponResponse += '</td>'
					grouponResponse += '</tr>'

					grouponResponse += '<tr>';
					grouponResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '</td>';
					grouponResponse += '</tr>'

					grouponResponse += '<tr>'
					grouponResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
					grouponResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
					grouponResponse += '</tr>';
					grouponResponse += '</table>'
					/////////////////////////////////

					grouponResponse += '</a>';
					grouponResponse += '</li>';

					var groupdealArrElement = new GroupDealOnResultClass();
					groupdealArrElement.title = title;
					groupdealArrElement.location = location;
					groupdealArrElement.name = name;
					groupdealArrElement.value = value;
					groupdealArrElement.price = price;
					groupdealArrElement.discount = discount;
					groupdealArrElement.imgPath = imgPath;
					groupdealArrElement.url = url;

					try {
						groupondealResultArr.push(groupdealArrElement);
					} catch (err) {
					}
				}
			}

			if(selectedCategory == "2") {
				$('#result').append(grouponResponse).listview("refresh");
				if(DDC_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreDeals(keyword, searchtype)
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_yipitdeals_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ YIPIT DEALS RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var yipitdealsResponse = "";
	var loadmore = false;
	url = "http://api.yipit.com/v1/deals/?key=kh4H7YPfH7aFjhSZ&lat=41.8795&lon=-87.6243&offset=" + yipitdealPageNumber + "&limit=20";
	console.log("URL ============= " + url);
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			fetchResultDone();
		},

		success : function(data, textStatus, xhr) {
			var totalObj = 0;
			try {
				totalObj = data.response.deals.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var location = "";
				var name = "";
				var value = "";
				var price = "";
				var discount = "";
				var imgPath = "";
				var url = "";

				try {
					title = data.response.deals[itr].title;
				} catch (err) {
					title = "";
				}

				try {
					location = data.response.deals[itr].business.locations[0].address + " "
					+ data.response.deals[itr].business.locations[0].locality;
				} catch (err) {
					location = "";
				}

				try {
					name = data.response.deals[itr].business.name;
				} catch (err) {
					name = "";
				}

				try {
					value = data.response.deals[itr].value.formatted;
				} catch (err) {
					value = "";
				}

				try {
					price = data.response.deals[itr].price.formatted;
				} catch (err) {
					price = "";
				}

				try {
					discount = data.response.deals[itr].discount.formatted;
				} catch (err) {
					discount = "";
				}

				try {
					imgPath =  data.response.deals[itr].images.image_small;
				} catch (err) {
					imgPath = "es_img/deal_discount_coupon.png";
				}

				try {
					url = data.response.deals[itr].url;
				} catch (err) {
					url = "#";
				}

				if(title.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
					loadmore = true;
					yipitdealsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
					yipitdealsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

					/////////////////////////////////
					yipitdealsResponse += '<table width="100%" style="margin:0;padding:0;">';
					yipitdealsResponse += '<tr>'
					yipitdealsResponse += '<td width="100%" style="color:blue;">';
					yipitdealsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
					yipitdealsResponse += '</td>';
					yipitdealsResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/yipit.png" /></td>';
					yipitdealsResponse += '</tr>';
					yipitdealsResponse += '</table>';

					/////////////////////////////////
					yipitdealsResponse += '<table width="100%" style="margin:0;padding:0;">';
					yipitdealsResponse += '<tr>';
					yipitdealsResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
					yipitdealsResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
					yipitdealsResponse += '</td>';
					yipitdealsResponse += '<td colspan="2" style="vertical-align:top;">';
					yipitdealsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + name + " " + location + '</div>';
					yipitdealsResponse += '</td>'
					yipitdealsResponse += '</tr>'

					yipitdealsResponse += '<tr>';
					yipitdealsResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '</td>';
					yipitdealsResponse += '</tr>'

					yipitdealsResponse += '<tr>'
					yipitdealsResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
					yipitdealsResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
					yipitdealsResponse += '</tr>';
					yipitdealsResponse += '</table>'
					/////////////////////////////////

					yipitdealsResponse += '</a>';
					yipitdealsResponse += '</li>';

					var yipitdealArrElement = new YipitDealResultClass();
					yipitdealArrElement.title = title;
					yipitdealArrElement.location = location;
					yipitdealArrElement.name = name;
					yipitdealArrElement.value = value;
					yipitdealArrElement.price = price;
					yipitdealArrElement.discount = discount;
					yipitdealArrElement.imgPath = imgPath;
					yipitdealArrElement.url = url;

					try {
						yipitdealResultArr.push(yipitdealArrElement);
					} catch (err) {
					}
				}
			}

			if(loadmore == true) {
				yipitdealPageNumber = yipitdealPageNumber + 20;
				yipitdealSeeMore = "YES";
				DDC_SEEMORE_FLAG = true;
			} else {
				yipitdealSeeMore = "NO";
			}

			if(selectedCategory == "2") {
				$('#result').append(yipitdealsResponse).listview("refresh");

				if(DDC_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreDeals(keyword, searchtype)
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function showOldDDCData(keyword, searchtype) {
	var hoopzddcResponse = "";
	var len = hoopzDDCResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = hoopzDDCResultArr[itr].title;
		var desc = hoopzDDCResultArr[itr].desc;
		var type = hoopzDDCResultArr[itr].type;
		var value = hoopzDDCResultArr[itr].value;
		var price = hoopzDDCResultArr[itr].price;
		var discount = hoopzDDCResultArr[itr].discount;
		var imgPath = hoopzDDCResultArr[itr].imgPath;
		var url = hoopzDDCResultArr[itr].url;

		hoopzddcResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		hoopzddcResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		hoopzddcResponse += '<table width="100%" style="margin:0;padding:0;">';
		hoopzddcResponse += '<tr>'
		hoopzddcResponse += '<td width="100%" style="color:blue;">';
		hoopzddcResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		hoopzddcResponse += '</td>';

		if(type == 1) {
			hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Deal' + '</td>';
		} else if(type == 2) {
			hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Discount' + '</td>';
		} else if(type == 3) {
			hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">' + 'Coupon' + '</td>';
		} else {
			hoopzddcResponse += '<td>' + '' + '</td>';
		}

		hoopzddcResponse += '</tr>';
		hoopzddcResponse += '</table>';

		/////////////////////////////////
		hoopzddcResponse += '<table width="100%" style="margin:0;padding:0;">';
		hoopzddcResponse += '<tr>';
		hoopzddcResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
		hoopzddcResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		hoopzddcResponse += '</td>';
		hoopzddcResponse += '<td colspan="2" style="vertical-align:top;">';
		hoopzddcResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		hoopzddcResponse += '</td>'
		hoopzddcResponse += '</tr>'

		hoopzddcResponse += '<tr>';
		hoopzddcResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '%</td>';
		hoopzddcResponse += '</tr>'

		hoopzddcResponse += '<tr>'
		hoopzddcResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
		hoopzddcResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
		hoopzddcResponse += '</tr>';
		hoopzddcResponse += '</table>'
		/////////////////////////////////

		hoopzddcResponse += '</a>';
		hoopzddcResponse += '</li>';
	}

	var timesdealResponse = "";
	len = timesdealResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = timesdealResultArr[itr].title;
		var desc = timesdealResultArr[itr].desc;
		var imgPath = timesdealResultArr[itr].imgPath;
		var url = timesdealResultArr[itr].url;

		timesdealResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		timesdealResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		timesdealResponse += '<table width="100%" style="margin:0;padding:0;">';
		/////////////////////////////////
		timesdealResponse += '<tr>'
		timesdealResponse += '<td width="100%" style="color:blue;">';
		timesdealResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		timesdealResponse += '</td>';
		timesdealResponse += '<td style="vertical-align:top;text-align:right;"><img src="es_img/timesdeal.png" /></td>';
		timesdealResponse += '</tr>';
		timesdealResponse += '</table>';
		/////////////////////////////////
		timesdealResponse += '<table width="100%" style="margin:0;padding:0;">';
		timesdealResponse += '<tr>';
		timesdealResponse += '<td width="60px" height="60px" style="vertical-align:top;">';
		timesdealResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		timesdealResponse += '</td>';
		timesdealResponse += '<td style="vertical-align:top;">';
		timesdealResponse += '<div style="max-height:60px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		timesdealResponse += '</td>'
		timesdealResponse += '</tr>'
		timesdealResponse += '</table>'
		/////////////////////////////////
		timesdealResponse += '</a>';
		timesdealResponse += '</li>';
	}

	var grouponResponse = "";
	len = groupondealResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = groupondealResultArr[itr].title;
		var location = groupondealResultArr[itr].location;
		var name = groupondealResultArr[itr].name;
		var value = groupondealResultArr[itr].value;
		var price = groupondealResultArr[itr].price;
		var discount = groupondealResultArr[itr].discount;
		var imgPath = groupondealResultArr[itr].imgPath;
		var url = groupondealResultArr[itr].url;

		grouponResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		grouponResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		grouponResponse += '<table width="100%" style="margin:0;padding:0;">';
		grouponResponse += '<tr>'
		grouponResponse += '<td width="100%" style="color:blue;">';
		grouponResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		grouponResponse += '</td>';
		grouponResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/groupon.png" /></td>';
		grouponResponse += '</tr>';
		grouponResponse += '</table>';

		/////////////////////////////////
		grouponResponse += '<table width="100%" style="margin:0;padding:0;">';
		grouponResponse += '<tr>';
		grouponResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
		grouponResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		grouponResponse += '</td>';
		grouponResponse += '<td colspan="2" style="vertical-align:top;">';
		grouponResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + name + " " + location + '</div>';
		grouponResponse += '</td>'
		grouponResponse += '</tr>'

		grouponResponse += '<tr>';
		grouponResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '</td>';
		grouponResponse += '</tr>'

		grouponResponse += '<tr>'
		grouponResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
		grouponResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
		grouponResponse += '</tr>';
		grouponResponse += '</table>'
		/////////////////////////////////

		grouponResponse += '</a>';
		grouponResponse += '</li>';
	}

	var yipitdealsResponse = "";
	len = yipitdealResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = yipitdealResultArr[itr].title;
		var location = yipitdealResultArr[itr].location;
		var name = yipitdealResultArr[itr].name;
		var value = yipitdealResultArr[itr].value;
		var price = yipitdealResultArr[itr].price;
		var discount = yipitdealResultArr[itr].discount;
		var imgPath = yipitdealResultArr[itr].imgPath;
		var url = yipitdealResultArr[itr].url;

		yipitdealsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		yipitdealsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		yipitdealsResponse += '<table width="100%" style="margin:0;padding:0;">';
		yipitdealsResponse += '<tr>'
		yipitdealsResponse += '<td width="100%" style="color:blue;">';
		yipitdealsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		yipitdealsResponse += '</td>';
		yipitdealsResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/yipit.png" /></td>';
		yipitdealsResponse += '</tr>';
		yipitdealsResponse += '</table>';

		/////////////////////////////////
		yipitdealsResponse += '<table width="100%" style="margin:0;padding:0;">';
		yipitdealsResponse += '<tr>';
		yipitdealsResponse += '<td rowspan="3" width="60px" height="60px" style="vertical-align:top;">';
		yipitdealsResponse += '<img src="' + imgPath + '" width="60px" height="60px">';
		yipitdealsResponse += '</td>';
		yipitdealsResponse += '<td colspan="2" style="vertical-align:top;">';
		yipitdealsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + name + " " + location + '</div>';
		yipitdealsResponse += '</td>'
		yipitdealsResponse += '</tr>'

		yipitdealsResponse += '<tr>';
		yipitdealsResponse += '<td colspan="2" style="vertical-align:top;">Discount : ' + discount + '</td>';
		yipitdealsResponse += '</tr>'

		yipitdealsResponse += '<tr>'
		yipitdealsResponse += '<td style="vertical-align:top;text-align:left;">MRP : ' + value + '</td>';
		yipitdealsResponse += '<td style="vertical-align:top;text-align:right;">Sell Price : ' + price + '</td>';
		yipitdealsResponse += '</tr>';
		yipitdealsResponse += '</table>'
		/////////////////////////////////

		yipitdealsResponse += '</a>';
		yipitdealsResponse += '</li>';
	}

	$('#result').append(hoopzddcResponse + timesdealResponse + grouponResponse + yipitdealsResponse).listview("refresh");

	if(DDC_SEEMORE_FLAG == true) {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetchMoreDeals(keyword, searchtype);
	});
}

function fetchMoreDeals(keyword, searchtype) {
	console.log("DEAL LOAD MORE = " + hoopzDDCSeeMore + " = " + yipitdealSeeMore);
	DDC_SEEMORE_FLAG = false;
	if(hoopzDDCSeeMore == "YES") {
		fetch_ddc_result(keyword, searchtype, true);
	} else if(yipitdealSeeMore == "YES") {
		fetch_yipitdeals_result(keyword, searchtype, true);
	} else {
		$('#SEEMORE').hide();
		$.mobile.hidePageLoadingMsg();
	}
}

function fetchResultDone() {
	$.mobile.hidePageLoadingMsg();
}