function fetch_news_result(keyword, searchtype, isLoadMoreClicked) {
	isLoadMoreClicked = isLoadMoreClicked || false;
	$.mobile.showPageLoadingMsg("a", "Please Wait...", true);

	if(CONTRY_CODE.toLowerCase() == "kr" || CONTRY_CODE.toLowerCase() == "kp") {
		fetch_naver_news_result(keyword, searchtype, isLoadMoreClicked);
	} else {
		fetch_feedzilla_news_result(keyword, searchtype, isLoadMoreClicked);
	}
}

function fetch_naver_news_result(keyword, searchtype, isLoadMoreClicked) {
	//console.log("============ NAVER NEWS RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var naverNewsResponse = "";
	var totalResult = "0";

	//CHAGNE EN-US to locale
	url = "http://openapi.naver.com/search?target=news&query="+ encodeURIComponent(keyword) +"&key=bdd71b8cc20696bfd5003a42df949cfa&display=10&start=" + naverNewsPageNumber;
	dataType = "xml";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(naverNewsResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				fetch_feedzilla_news_result(keyword, searchtype, isLoadMoreClicked);
			} else {
				fetchResultDone();
			}
		},

		success : function(data, textStatus, xhr) {
			totalResult = $(data).find('total').text();

			$(data).find('item').each(function() {
				var title = "";
				var desc = "";
				var url = "";

				try {
					title = $(this).find('title').text();
				} catch (err) {
					title = "";
				}

				try {
					desc = $(this).find('description').text();
				} catch (err) {
					desc = "";
				}

				try {
					url = $(this).find('link').text();
				} catch (err) {
					url = "#";
				}

				naverNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				naverNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				naverNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
				naverNewsResponse += '<tr>'
				naverNewsResponse += '<td width="100%" style="color:blue;">';
				naverNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
				naverNewsResponse += '</td>';
				naverNewsResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/naver.png" /></td>';
				naverNewsResponse += '</tr>';
				naverNewsResponse += '</table>';
				/////////////////////////////////

				/////////////////////////////////
				naverNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
				naverNewsResponse += '<tr>';
				naverNewsResponse += '<td style="vertical-align:top;">';
				naverNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
				naverNewsResponse += '</td>'
				naverNewsResponse += '</tr>'
				naverNewsResponse += '</table>';
				/////////////////////////////////

				naverNewsResponse += '</a>';
				naverNewsResponse += '</li>';

				var naverNewsArrElement = new NaverNewsResultClass();
				naverNewsArrElement.title = title;
				naverNewsArrElement.desc = desc;
				naverNewsArrElement.url = url;

				try {
					naverNewsResultArr.push(naverNewsArrElement);
				} catch (err) {
				}
			});

			if(totalResult > naverNewsResultArr.length) {
				naverNewsPageNumber = naverNewsResultArr.length + 1;
				naverNewsSeeMore = "YES";
				NEWS_SEEMORE_FLAG = true;
			} else {
				naverNewsSeeMore = "NO";
			}

			if(selectedCategory == "19") {
				$('#result').append(naverNewsResponse).listview("refresh");
				if(NEWS_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreNews(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_feedzilla_news_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ FEEDZILLA NEWS RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var feedzillaNewsResponse = "";
	var loadmore = false;

	url = "http://api.feedzilla.com/v1/articles/search.json?q="+ encodeURIComponent(keyword) +"&order=date&count=20&culture_code="+getCultureCode();
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(feedzillaNewsResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				if(CONTRY_CODE.toLowerCase() == "in") {
					fetch_sify_news_result(keyword, searchtype, isLoadMoreClicked);
				} else {
					fetchResultDone();
				}
			} else {
				fetchResultDone();
			}
		},

		success : function(data, textStatus, xhr) {
			var totalObj = 0;
			try {
				totalObj = data.articles.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var desc = "";
				var url = "";

				try {
					title = data.articles[itr].title;
				} catch (err) {
					title = "";
				}

				try {
					desc = data.articles[itr].summary;
				} catch (err) {
					desc = "";
				}

				try {
					url = data.articles[itr].url;
				} catch (err) {
					url = "#";
				}

				feedzillaNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				feedzillaNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				feedzillaNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
				feedzillaNewsResponse += '<tr>'
				feedzillaNewsResponse += '<td width="100%" style="color:blue;">';
				feedzillaNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
				feedzillaNewsResponse += '</td>';
				feedzillaNewsResponse += '</tr>';
				feedzillaNewsResponse += '</table>';
				/////////////////////////////////
				feedzillaNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
				feedzillaNewsResponse += '<td style="vertical-align:top;">';
				feedzillaNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
				feedzillaNewsResponse += '</td>'
				feedzillaNewsResponse += '</tr>'
				feedzillaNewsResponse += '</table>'
				/////////////////////////////////

				feedzillaNewsResponse += '</a>';
				feedzillaNewsResponse += '</li>';

				var feedzillaContentArrElement = new FeedzillaNewsResultClass();
				feedzillaContentArrElement.title = title;
				feedzillaContentArrElement.desc = desc;
				feedzillaContentArrElement.url = url;

				try {
					feedzillaNewsResultArr.push(feedzillaContentArrElement);
				} catch (err) {
				}
			}

			if(loadmore == true) {
				feedzillaNewsPageNumber = feedzillaNewsPageNumber + 1;
				feedzillaNewsSeeMore = "YES";
				NEWS_SEEMORE_FLAG = true;
			} else {
				feedzillaNewsSeeMore = "NO";
			}

			if(selectedCategory == "19") {
				$('#result').append(feedzillaNewsResponse).listview("refresh");
				if(NEWS_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetchMoreNews(keyword, searchtype);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_sify_news_result(keyword, searchtype, isLoadMoreClicked) {
	console.log("============ SIFY NEWS RESULT START.");
	$.when($.ajax(SAMACHAR_NEWS_URL), $.ajax(SAMACHAR_BUSINESS_URL), $.ajax(SAMACHAR_SPORTS_URL), $.ajax(SAMACHAR_MOVIES_URL)).then(function(data1, data2, data3, data4) {
		parseSifyData(data1, keyword);
		parseSifyData(data2, keyword);
		parseSifyData(data3, keyword);
		parseSifyData(data4, keyword);
		fetchResultDone();
	});
}

function parseSifyData(data, keyword) {
	var sifyNewsResponse = "";
	var loadmore = false;

	$(data).find('item').each(function() {
		var title = "";
		var desc = "";
		var url = "";

		try {
			title = $(this).find('title').text();
		} catch (err) {
			title = "";
		}

		try {
			desc = $(this).find('description').text();
		} catch (err) {
			desc = "";
		}

		try {
			url = $(this).find('link').text();
		} catch (err) {
			url = "#";
		}

		if(title.toLowerCase().indexOf(keyword.toLowerCase()) >= 0 || desc.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
			sifyNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
			sifyNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

			/////////////////////////////////
			sifyNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
			sifyNewsResponse += '<tr>'
			sifyNewsResponse += '<td width="100%" style="color:blue;">';
			sifyNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
			sifyNewsResponse += '</td>';
			sifyNewsResponse += '</tr>';
			sifyNewsResponse += '</table>';
			/////////////////////////////////

			/////////////////////////////////
			sifyNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
			sifyNewsResponse += '<tr>';
			sifyNewsResponse += '<td style="vertical-align:top;">';
			sifyNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
			sifyNewsResponse += '</td>'
			sifyNewsResponse += '</tr>'
			sifyNewsResponse += '</table>';
			/////////////////////////////////

			sifyNewsResponse += '</a>';
			sifyNewsResponse += '</li>';

			var sifyNewsArrElement = new SifyNewsResultClass();
			sifyNewsArrElement.title = title;
			sifyNewsArrElement.desc = desc;
			sifyNewsArrElement.url = url;

			try {
				sifyNewsResultArr.push(sifyNewsArrElement);
			} catch (err) {
			}
		}
	});

	if(loadmore == true) {
		sifyNewsPageNumber = sifyNewsPageNumber + 1;
		sifyNewsSeeMore = "YES";
		NEWS_SEEMORE_FLAG = true;
	} else {
		sifyNewsSeeMore = "NO";
	}

	if(selectedCategory == "19") {
		$('#result').append(sifyNewsResponse).listview("refresh");
		if(NEWS_SEEMORE_FLAG == true) {
			$('#SEEMORE').show();
		} else {
			$('#SEEMORE').hide();
		}

		$('#SEEMORE').unbind("click").bind("click", function() {
			$('#SEEMORE').hide();
			fetchMoreNews(keyword, searchtype);
		});
	}
}

function showOldNewsData(keyword, searchtype) {
	var naverNewsResponse = "";
	var len = naverNewsResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = naverNewsResultArr[itr].title;
		var desc = naverNewsResultArr[itr].desc;
		var url = naverNewsResultArr[itr].url;

		naverNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		naverNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		naverNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		naverNewsResponse += '<tr>'
		naverNewsResponse += '<td width="100%" style="color:blue;">';
		naverNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
		naverNewsResponse += '</td>';
		naverNewsResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/naver.png" /></td>';
		naverNewsResponse += '</tr>';
		naverNewsResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		naverNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		naverNewsResponse += '<tr>';
		naverNewsResponse += '<td style="vertical-align:top;">';
		naverNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		naverNewsResponse += '</td>'
		naverNewsResponse += '</tr>'
		naverNewsResponse += '</table>';
		/////////////////////////////////

		naverNewsResponse += '</a>';
		naverNewsResponse += '</li>';
	}

	var feedzillaNewsResponse = "";
	len = feedzillaNewsResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = feedzillaNewsResultArr[itr].title;
		var desc = feedzillaNewsResultArr[itr].desc;
		var url = feedzillaNewsResultArr[itr].url;

		feedzillaNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		feedzillaNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		feedzillaNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		feedzillaNewsResponse += '<tr>'
		feedzillaNewsResponse += '<td width="100%" style="color:blue;">';
		feedzillaNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
		feedzillaNewsResponse += '</td>';
		feedzillaNewsResponse += '</tr>';
		feedzillaNewsResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		feedzillaNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		feedzillaNewsResponse += '<td style="vertical-align:top;">';
		feedzillaNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		feedzillaNewsResponse += '</td>'
		feedzillaNewsResponse += '</tr>'
		feedzillaNewsResponse += '</table>'
		/////////////////////////////////

		feedzillaNewsResponse += '</a>';
		feedzillaNewsResponse += '</li>';
	}

	var sifyNewsResponse = "";
	len = sifyNewsResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = sifyNewsResultArr[itr].title;
		var desc = sifyNewsResultArr[itr].desc;
		var url = sifyNewsResultArr[itr].url;

		sifyNewsResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		sifyNewsResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		sifyNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		sifyNewsResponse += '<tr>'
		sifyNewsResponse += '<td width="100%" style="color:blue;">';
		sifyNewsResponse += '<div style="max-height:16px;overflow:hidden;white-space:normal;">' + title + '</div>';
		sifyNewsResponse += '</td>';
		sifyNewsResponse += '</tr>';
		sifyNewsResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		sifyNewsResponse += '<table width="100%" style="margin:0;padding:0;">';
		sifyNewsResponse += '<tr>';
		sifyNewsResponse += '<td style="vertical-align:top;">';
		sifyNewsResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + desc + '</div>';
		sifyNewsResponse += '</td>'
		sifyNewsResponse += '</tr>'
		sifyNewsResponse += '</table>';
		/////////////////////////////////

		sifyNewsResponse += '</a>';
		sifyNewsResponse += '</li>';
	}

	$('#result').append(naverNewsResponse + feedzillaNewsResponse + sifyNewsResponse).listview("refresh");

	if(NEWS_SEEMORE_FLAG == true) {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetchMoreNews(keyword, searchtype);
	});
}

function fetchMoreNews(keyword, searchtype) {
	console.log("NEWS LOAD MORE = " + naverNewsSeeMore + " = " + feedzillaNewsSeeMore + " = " + sifyNewsSeeMore);
	NEWS_SEEMORE_FLAG = false;
	if(naverNewsSeeMore == "YES") {
		fetch_naver_news_result(keyword, searchtype, true);
	} else if(feedzillaNewsSeeMore == "YES") {
		fetch_feedzilla_news_result(keyword, searchtype, true);
	} else if(sifyNewsSeeMore == "YES") {
		fetch_feedzilla_news_result(keyword, searchtype, true);
	} else {
		$('#SEEMORE').hide();
		$.mobile.hidePageLoadingMsg();
	}
}

function fetchResultDone() {
	$.mobile.hidePageLoadingMsg();
}