function fetch_restaurant_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);

	if (CONTRY_CODE.toLowerCase() == "in") {
		if (CITY.trim() == "") {
			fetch_zomato_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
		} else {
			if(zomatoCityArr != null && zomatoCityArr.length > 0) {
				fetch_zomato_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
			} else {
				fetch_zomato_city_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
			}
		}
	} else {
		fetch_yelp_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
	}
}

function fetch_zomato_city_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	console.log("============ ZOMATO CITY RESULT START.");
	url = "https://api.zomato.com/v1/cities.json";
	dataType = "json";

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			xhr.setRequestHeader("X-Zomato-API-Key", ZOMATO_KEY);
		},

		complete : function() {
			fetch_zomato_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
		},

		success : function(data, textStatus, xhr) {
			var result = data.cities;

			var totalObj = 0;
			try {
				totalObj = result.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var id = "";
				var title = "";

				try {
					id = result[itr].city.id;
				} catch (err) {
					id = "0";
				}

				try {
					title = result[itr].city.name;
				} catch (err) {
					title = "";
				}

				var zomatoCityArrElement = new ZomatoCityClass();
				zomatoCityArrElement.id = id;
				zomatoCityArrElement.title = title;

				try {
					zomatoCityArr.push(zomatoCityArrElement);
				} catch (err) {
				}
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_zomato_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	if(zomatoCityArr != null && zomatoCityArr.length > 0 && ZOMATO_CITY_ID.trim() != "") {
		var len = zomatoCityArr.length;
		for(var itr = 0; itr < len; itr++) {
			var temp = zomatoCityArr[itr].title;

			if(CITY.toLowerCase() == temp.toLowerCase()) {
				ZOMATO_CITY_ID = zomatoCityArr[itr].id;
			}
		}
	}

	console.log("============ ZOMATO REST RESULT START.");
	var zomatoRestResponse = "";
	var loadmore = false;

	if(isLocationSearch == true) {
		url = "https://api.zomato.com/v1/search.json/near?lat="+LATITUDE+"&lon="+LONGITUDE;
	} else {
		url = "https://api.zomato.com/v1/search.json?q=" + encodeURIComponent(keyword);
		if (ZOMATO_CITY_ID.trim() != "") {
			url += "&city_id=" + ZOMATO_CITY_ID;
		} else {
			url += "&lat="+LATITUDE+"&lon="+LONGITUDE;
		}
	}
	url += "&start=" + zomatoRestPageNumber;
	dataType = "json";

	console.log("ZOMATO REST URL = " + url);

	$.ajax({
		url : url,
		type : 'GET',
		dataType: dataType,
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			xhr.setRequestHeader("X-Zomato-API-Key", ZOMATO_KEY);
		},

		complete : function() {
			if(zomatoRestResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				fetch_yelp_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
			} else {
				if(yelpRestSeeMore == "YES") {
					fetch_yelp_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				} else if(tripadvRestSeeMore == "YES") {
					fetch_tripadv_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				} else {
					fetchResultDone();
				}
			}
		},

		success : function(data, textStatus, xhr) {
			var result = data.results;
			var totalResult = data.resultsFound;

			var totalObj = 0;
			try {
				totalObj = result.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var id = '';
				var title = '';
				var address = '';
				var cuisines = '';
				var rating = '';
				var costfortwo = '';

				try {
					id = result[itr].result.id;
				} catch (err) {
					id = "";
				}

				try {
					title = result[itr].result.name;
				} catch (err) {
					title = "";
				}

				try {
					address = result[itr].result.address;
				} catch (err) {
					address = "";
				}

				try {
					cuisines = result[itr].result.cuisines;
				} catch (err) {
					cuisines = "";
				}

				try {
					rating = result[itr].result.rating_editor_overall;
				} catch (err) {
					rating = "0";
				}

				try {
					costfortwo = result[itr].result.cost_for_two;
				} catch (err) {
					costfortwo = "";
				}

				var url = "https://api.zomato.com/v1/restaurant.json/" + id;

				zomatoRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				zomatoRestResponse += '<a href="#" onclick="showZomatoPopup(\'' + url + '\');">';

				/////////////////////////////////
				zomatoRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				zomatoRestResponse += '<tr>';
				zomatoRestResponse += '<td width="100%" style="color:blue;">';
				zomatoRestResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
				zomatoRestResponse += '</td>';
				zomatoRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/zomato.png" /></td>';
				zomatoRestResponse += '</tr>';
				zomatoRestResponse += '</table>';
				/////////////////////////////////

				/////////////////////////////////
				zomatoRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				zomatoRestResponse += '<tr>';
				zomatoRestResponse += '<td colspan="2" style="max-height:30px;overflow:hidden;white-space:normal;vertical-align:top;">Address : '+ address +'</td>';
				zomatoRestResponse += '</tr>';
				zomatoRestResponse += '<tr>';
				zomatoRestResponse += '<td colspan="2" style="vertical-align:top;">Cuisines : '+ cuisines +'</td>';
				zomatoRestResponse += '</tr>';
				zomatoRestResponse += '<tr>';
				zomatoRestResponse += '<td style="vertical-align:top;">Rating : '+ rating +'/5</td>';
				zomatoRestResponse += '<td style="vertical-align:top;text-align:right;">COST FOR 2 : RS '+ costfortwo +'</td>';
				zomatoRestResponse += '</tr>';
				zomatoRestResponse += '</table>';
				/////////////////////////////////

				zomatoRestResponse += '</a>';
				zomatoRestResponse += '</li>';

				var zomatoRestArrElement = new ZomatoRestResultClass();
				zomatoRestArrElement.id = id;
				zomatoRestArrElement.title = title;
				zomatoRestArrElement.address = address;
				zomatoRestArrElement.cuisines = cuisines;
				zomatoRestArrElement.rating = rating;
				zomatoRestArrElement.costfortwo = costfortwo;

				try {
					zomatoRestResultArr.push(zomatoRestArrElement);
				} catch (err) {
				}
			}

			if(totalResult > zomatoRestResultArr.length) {
				zomatoRestPageNumber = zomatoRestResultArr.length + 1;
				zomatoRestSeeMore = "YES";
				REST_SEEMORE_FLAG = true;
			} else {
				zomatoRestSeeMore = "NO";
			}

			if(selectedCategory == "16") {
				$('#result').append(zomatoRestResponse).listview("refresh");
				if(REST_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_morerest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_yelp_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	console.log("============ YELP REST RESULT START.");
	isLoadMoreClicked = isLoadMoreClicked || false;
	var yelpRestResponse = "";
	var loadmore = false;
	url = "http://api.yelp.com/v2/search";

	var auth = {
		consumerKey: "jLvHRs47MogGBBqW6Leemw",
		consumerSecret: "KowW_xtoc_8z5OfS_JbfqKrYyEE",
		accessToken: "oJ2E8dB4X7N-WeSkdQY8gfmItGdPEkdG",
		accessTokenSecret: "zfDIVgPUzcjgQFlE4GXu2TXXS-k",
		serviceProvider: {
			signatureMethod: "HMAC-SHA1"
		}
	};

	var terms = keyword;
	var near = CITY;

	var accessor = {
		consumerSecret: auth.consumerSecret,
		tokenSecret: auth.accessTokenSecret
	};

	parameters = [];
	parameters.push(['category_filter', 'restaurants']);

	if(isLocationSearch == true) {
		if(LATITUDE.trim() != "" && LONGITUDE.trim() != "") {
			parameters.push(['ll', LATITUDE + "," + LONGITUDE]);
		} else {
			parameters.push(['location', near]);
		}
	} else {
		parameters.push(['term', terms]);
		if(LATITUDE.trim() != "" && LONGITUDE.trim() != "") {
			parameters.push(['ll', LATITUDE + "," + LONGITUDE]);
		} else {
			parameters.push(['location', near]);
		}
	}

	parameters.push(['radius_filter', '8000']);
	parameters.push(['limit', '10']);
	parameters.push(['offset', yelpRestPageNumber]);
	parameters.push(['callback', 'cb']);
	parameters.push(['oauth_consumer_key', auth.consumerKey]);
	parameters.push(['oauth_consumer_secret', auth.consumerSecret]);
	parameters.push(['oauth_token', auth.accessToken]);
	parameters.push(['oauth_signature_method', 'HMAC-SHA1']);

	var message = {
		'action': url,
		'method': 'GET',
		'parameters': parameters
	};

	OAuth.setTimestampAndNonce(message);
	OAuth.SignatureMethod.sign(message, accessor);
	var parameterMap = OAuth.getParameterMap(message.parameters);
	parameterMap.oauth_signature = OAuth.percentEncode(parameterMap.oauth_signature)

	$.ajax({
		url : message.action,
		data: parameterMap,
		cache: true,
		dataType: 'jsonp',
		jsonpCallback: 'cb',
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");

		//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			if(yelpRestResponse != "") {
				$.mobile.hidePageLoadingMsg();
			}

			if(isLoadMoreClicked == false) {
				fetch_tripadv_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
			} else {
				if(tripadvRestSeeMore == "YES") {
					fetch_tripadv_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				} else {
					fetchResultDone();
				}
			}
		},

		success: function(data, textStats, XMLHttpRequest) {
			var totalResult = data.total;
			var totalObj = 0;
			try {
				totalObj = data.businesses.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var address = "";
				var phone = "";
				var reviewCnt = "";
				var ratingImg = "";
				var imgPath = "";
				var url = "";

				try {
					title = data.businesses[itr].name;
				} catch (err) {
					title = "";
				}

				try {
					address = data.businesses[itr].location.display_address[0];
				} catch (err) {
					address = "";
				}

				try {
					phone = data.businesses[itr].phone;
				} catch (err) {
					phone = "";
				}

				try {
					reviewCnt = data.businesses[itr].review_count;
				} catch (err) {
					reviewCnt = "0.0";
				}

				try {
					ratingImg = data.businesses[itr].rating_img_url;
				} catch (err) {
					ratingImg = "";
				}

				try {
					imgPath = data.businesses[itr].image_url;
				} catch (err) {
					imgPath = "es_img/info.png";
				}

				try {
					url = data.businesses[itr].url;
				} catch (err) {
					url = "#";
				}

				yelpRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				yelpRestResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				yelpRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				yelpRestResponse += '<tr>'
				yelpRestResponse += '<td width="100%" style="color:blue;">';
				yelpRestResponse += '<div style="max-height:20px;overflow:hidden;white-space:normal;">' + title + '</div>';
				yelpRestResponse += '</td>';
				yelpRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/yelp.png" /></td>';
				yelpRestResponse += '</tr>';
				yelpRestResponse += '</table>';
				/////////////////////////////////

				/////////////////////////////////
				yelpRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				yelpRestResponse += '<tr>';
				yelpRestResponse += '<td rowspan="4" width="60px" height="60px" style="vertical-align:top;">';
				yelpRestResponse += '<img src="' + imgPath + '" width="60px" height="60px" />';
				yelpRestResponse += '</td>';
				yelpRestResponse += '<td style="vertical-align:top;">Phone : ' + phone + '</td>';
				yelpRestResponse += '</tr>'

				yelpRestResponse += '<tr>';
				yelpRestResponse += '<td style="vertical-align:top;">Address : ' + address + '</td>';
				yelpRestResponse += '</tr>'

				yelpRestResponse += '<tr>';
				yelpRestResponse += '<td style="vertical-align:top;">' + reviewCnt + ' Reviews</td>';
				yelpRestResponse += '</tr>'

				yelpRestResponse += '<tr>';
				yelpRestResponse += '<td align="right" style="vertical-align:top;">';
				yelpRestResponse += '<img src="' + ratingImg + '" />';
				yelpRestResponse += '</td>';
				yelpRestResponse += '</tr>'

				yelpRestResponse += '</table>';
				/////////////////////////////////

				yelpRestResponse += '</a>';
				yelpRestResponse += '</li>';

				var yelpRestArrElement = new YelpRestResultClass();
				yelpRestArrElement.title = title;
				yelpRestArrElement.address = address;
				yelpRestArrElement.reviewCnt = reviewCnt;
				yelpRestArrElement.phone = phone;
				yelpRestArrElement.ratingImg = ratingImg;
				yelpRestArrElement.imgPath = imgPath;
				yelpRestArrElement.url = url;

				try {
					yelpRestResultArr.push(yelpRestArrElement);
				} catch (err) {
				}
			}

			if(totalResult > yelpRestResultArr.length) {
				yelpRestPageNumber = yelpRestPageNumber + 10;
				yelpRestSeeMore = "YES";
				REST_SEEMORE_FLAG = true;
			} else {
				yelpRestSeeMore = "NO";
			}

			if(selectedCategory == "16") {
				$('#result').append(yelpRestResponse).listview("refresh");
				if(REST_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_morerest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function fetch_tripadv_rest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	console.log("============ TRIPADV REST RESULT START.");
	var tripadvRestResponse = "";
	var loadmore = false;

	if(CITY.trim() != "") {
		keyword = keyword + "," + CITY;
	}

	if(isLocationSearch == true) {
		url = "http://api.tripadvisor.com/api/mobex/1.1/map/"+LATITUDE+","+LONGITUDE+"/restaurants?key=0878c63d-2021-4e25-a006-af7efce491ef&limit=10&offset=" + tripadvRestPageNumber;
	} else {
		url = "http://api.tripadvisor.com/api/mobex/1.1/search/"+ encodeURIComponent(keyword)+","+CITY+"+restaurants?key=0878c63d-2021-4e25-a006-af7efce491ef&limit=10&offset"+tripadvRestPageNumber;
	}

	console.log("TRIP REST URL = " + url);

	$.ajax({
		url : url,
		type : 'GET',
		dataType: "json",
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
		},

		complete : function() {
			fetchResultDone();
		},

		success : function(data, textStatus, xhr) {
			var result = null;
			var totalResult = data.metadata.total;

			try {
				result = data.items.restaurant;
				if(result == null || result.length == 0) {
					result = data.items;
				}
			} catch (err) {
			}

			var totalObj = 0;
			try {
				totalObj = result.length;
			} catch (err) {
				totalObj = 0;
			}

			for(var itr = 0; itr < totalObj; itr++) {
				var title = "";
				var address = "";
				var cuisines = '';
				var price = "";
				var reviewCnt = "";
				var rating = "";
				var url = "";

				try {
					title = result[itr].name;
				} catch (err) {
					title = "";
				}

				try {
					address = result[itr].locationString;
				} catch (err) {
					address = "";
				}

				try {
					cuisines = result[itr].cuisine;
				} catch (err) {
					cuisines = "";
				}

				try {
					price = result[itr].price;
				} catch (err) {
					price = "";
				}

				try {
					reviewCnt = result[itr].numReviews;
				} catch (err) {
					reviewCnt = "";
				}

				try {
					rating = result[itr].rating;
				} catch (err) {
					rating = "";
				}

				try {
					url = result[itr].webUrl
				} catch (err) {
					url = "";
				}

				tripadvRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
				tripadvRestResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

				/////////////////////////////////
				tripadvRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				tripadvRestResponse += '<tr>';
				tripadvRestResponse += '<td width="100%" style="color:blue;">';
				tripadvRestResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
				tripadvRestResponse += '</td>';
				tripadvRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/tripadvisor.png" /></td>';
				tripadvRestResponse += '</tr>';
				tripadvRestResponse += '</table>';
				/////////////////////////////////

				/////////////////////////////////
				tripadvRestResponse += '<table width="100%" style="margin:0;padding:0;">';
				tripadvRestResponse += '<tr>';
				tripadvRestResponse += '<td colspan="2" style="max-height:30px;overflow:hidden;white-space:normal;vertical-align:top;">Address : '+ address +'</td>';
				tripadvRestResponse += '</tr>';

				tripadvRestResponse += '<tr>';
				tripadvRestResponse += '<td colspan="2" style="max-height:16px;overflow:hidden;white-space:normal;vertical-align:top;">Cuisines : '+ cuisines +'</td>';
				tripadvRestResponse += '</tr>';

				tripadvRestResponse += '<tr>';
				tripadvRestResponse += '<td colspan="2" style="vertical-align:top;">'+ reviewCnt +' Reviews</td>';
				tripadvRestResponse += '</tr>';

				tripadvRestResponse += '<tr>';
				tripadvRestResponse += '<td style="vertical-align:top;">Rating : '+ rating +'/5</td>';
				if(price != null && price.trim().length > 0) {
					tripadvRestResponse += '<td style="vertical-align:top;text-align:right;">Price :'+ price +'</td>';
				} else {
					tripadvRestResponse += '<td> </td>';
				}
				tripadvRestResponse += '</tr>';
				tripadvRestResponse += '</table>';
				/////////////////////////////////

				tripadvRestResponse += '</a>';
				tripadvRestResponse += '</li>';

				var tripadvRestArrElement = new TripadvRestResultClass();
				tripadvRestArrElement.title = title;
				tripadvRestArrElement.address = address;
				tripadvRestArrElement.cuisines = cuisines;
				tripadvRestArrElement.reviewCnt = reviewCnt;
				tripadvRestArrElement.rating = rating;
				tripadvRestArrElement.price = price;
				tripadvRestArrElement.url = url;

				try {
					tripadvRestResultArr.push(tripadvRestArrElement);
				} catch (err) {
				}
			}

			if(totalResult > tripadvRestResultArr.length) {
				tripadvRestPageNumber = tripadvRestResultArr.length + 1;
				tripadvRestSeeMore = "YES";
				REST_SEEMORE_FLAG = true;
			} else {
				tripadvRestSeeMore = "NO";
			}

			if(selectedCategory == "16") {
				$('#result').append(tripadvRestResponse).listview("refresh");
				if(REST_SEEMORE_FLAG == true) {
					$('#SEEMORE').show();
				} else {
					$('#SEEMORE').hide();
				}

				$('#SEEMORE').unbind("click").bind("click", function() {
					$('#SEEMORE').hide();
					fetch_morerest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked);
				});
			}
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}

function showOldRestData(keyword, searchtype) {
	var zomatoRestResponse = "";
	var len = zomatoRestResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var id = zomatoRestResultArr[itr].id;
		var title = zomatoRestResultArr[itr].title;
		var address = zomatoRestResultArr[itr].address;
		var cuisines = zomatoRestResultArr[itr].cuisines;
		var rating = zomatoRestResultArr[itr].rating;
		var costfortwo = zomatoRestResultArr[itr].costfortwo;

		var url = "https://api.zomato.com/v1/restaurant.json/" + id;

		zomatoRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		zomatoRestResponse += '<a href="#" onclick="showZomatoPopup(\'' + url + '\');">';

		/////////////////////////////////
		zomatoRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		zomatoRestResponse += '<tr>';
		zomatoRestResponse += '<td width="100%" style="color:blue;">';
		zomatoRestResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		zomatoRestResponse += '</td>';
		zomatoRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/zomato.png" /></td>';
		zomatoRestResponse += '</tr>';
		zomatoRestResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		zomatoRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		zomatoRestResponse += '<tr>';
		zomatoRestResponse += '<td colspan="2" style="max-height:30px;overflow:hidden;white-space:normal;vertical-align:top;">Address : '+ address +'</td>';
		zomatoRestResponse += '</tr>';
		zomatoRestResponse += '<tr>';
		zomatoRestResponse += '<td colspan="2" style="vertical-align:top;">Cuisines : '+ cuisines +'</td>';
		zomatoRestResponse += '</tr>';
		zomatoRestResponse += '<tr>';
		zomatoRestResponse += '<td style="vertical-align:top;">Rating : '+ rating +'/5</td>';
		zomatoRestResponse += '<td style="vertical-align:top;text-align:right;">COST FOR 2 : RS '+ costfortwo +'</td>';
		zomatoRestResponse += '</tr>';
		zomatoRestResponse += '</table>';
		/////////////////////////////////

		zomatoRestResponse += '</a>';
		zomatoRestResponse += '</li>';
	}

	var yelpRestResponse = "";
	len = yelpRestResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = yelpRestResultArr[itr].title;
		var address = yelpRestResultArr[itr].address;
		var phone = yelpRestResultArr[itr].phone;
		var reviewCnt = yelpRestResultArr[itr].reviewCnt;
		var ratingImg = yelpRestResultArr[itr].ratingImg;
		var imgPath = yelpRestResultArr[itr].imgPath;
		var url = yelpRestResultArr[itr].url;

		yelpRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		yelpRestResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		yelpRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		yelpRestResponse += '<tr>'
		yelpRestResponse += '<td width="100%" style="color:blue;">';
		yelpRestResponse += '<div style="max-height:20px;overflow:hidden;white-space:normal;">' + title + '</div>';
		yelpRestResponse += '</td>';
		yelpRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/yelp.png" /></td>';
		yelpRestResponse += '</tr>';
		yelpRestResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		yelpRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		yelpRestResponse += '<tr>';
		yelpRestResponse += '<td rowspan="4" width="60px" height="60px" style="vertical-align:top;">';
		yelpRestResponse += '<img src="' + imgPath + '" width="60px" height="60px" />';
		yelpRestResponse += '</td>';
		yelpRestResponse += '<td style="vertical-align:top;">Phone : ' + phone + '</td>';
		yelpRestResponse += '</tr>'

		yelpRestResponse += '<tr>';
		yelpRestResponse += '<td style="vertical-align:top;">Address : ' + address + '</td>';
		yelpRestResponse += '</tr>'

		yelpRestResponse += '<tr>';
		yelpRestResponse += '<td style="vertical-align:top;">' + reviewCnt + ' Reviews</td>';
		yelpRestResponse += '</tr>'

		yelpRestResponse += '<tr>';
		yelpRestResponse += '<td align="right" style="vertical-align:top;">';
		yelpRestResponse += '<img src="' + ratingImg + '" />';
		yelpRestResponse += '</td>';
		yelpRestResponse += '</tr>'

		yelpRestResponse += '</table>';
		/////////////////////////////////

		yelpRestResponse += '</a>';
		yelpRestResponse += '</li>';
	}

	var tripadvRestResponse = "";
	len = tripadvRestResultArr.length;

	for(itr = 0; itr < len; itr++) {
		var title = tripadvRestResultArr[itr].title;
		var address = tripadvRestResultArr[itr].address;
		var cuisines = tripadvRestResultArr[itr].cuisines;
		var price = tripadvRestResultArr[itr].price;
		var reviewCnt = tripadvRestResultArr[itr].reviewCnt;
		var rating = tripadvRestResultArr[itr].rating;
		var url = tripadvRestResultArr[itr].url;

		tripadvRestResponse += '<li style="padding-top:0;margin-top:0;" data-icon="false">';
		tripadvRestResponse += '<a href="#" onclick="openBrowser(\'' + url + '\');">';

		/////////////////////////////////
		tripadvRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		tripadvRestResponse += '<tr>';
		tripadvRestResponse += '<td width="100%" style="color:blue;">';
		tripadvRestResponse += '<div style="max-height:30px;overflow:hidden;white-space:normal;">' + title + '</div>';
		tripadvRestResponse += '</td>';
		tripadvRestResponse += '<td width="20px" style="vertical-align:top;text-align:right;"><img src="es_img/tripadvisor.png" /></td>';
		tripadvRestResponse += '</tr>';
		tripadvRestResponse += '</table>';
		/////////////////////////////////

		/////////////////////////////////
		tripadvRestResponse += '<table width="100%" style="margin:0;padding:0;">';
		tripadvRestResponse += '<tr>';
		tripadvRestResponse += '<td colspan="2" style="max-height:30px;overflow:hidden;white-space:normal;vertical-align:top;">Address : '+ address +'</td>';
		tripadvRestResponse += '</tr>';

		tripadvRestResponse += '<tr>';
		tripadvRestResponse += '<td colspan="2" style="max-height:16px;overflow:hidden;white-space:normal;vertical-align:top;">Cuisines : '+ cuisines +'</td>';
		tripadvRestResponse += '</tr>';

		tripadvRestResponse += '<tr>';
		tripadvRestResponse += '<td colspan="2" style="vertical-align:top;">'+ reviewCnt +' Reviews</td>';
		tripadvRestResponse += '</tr>';

		tripadvRestResponse += '<tr>';
		tripadvRestResponse += '<td style="vertical-align:top;">Rating : '+ rating +'/5</td>';
		if(price != null && price.trim().length > 0) {
			tripadvRestResponse += '<td style="vertical-align:top;text-align:right;">Price :'+ price +'</td>';
		} else {
			tripadvRestResponse += '<td> </td>';
		}
		tripadvRestResponse += '</tr>';
		tripadvRestResponse += '</table>';
		/////////////////////////////////

		tripadvRestResponse += '</a>';
		tripadvRestResponse += '</li>';
	}

	$('#result').append(zomatoRestResponse + yelpRestResponse + tripadvRestResponse).listview("refresh");

	if(REST_SEEMORE_FLAG == true) {
		$('#SEEMORE').show();
	} else {
		$('#SEEMORE').hide();
	}

	$('#SEEMORE').unbind("click").bind("click", function() {
		$('#SEEMORE').hide();
		fetch_morerest_result(keyword, searchtype, false, true);
	});
}

function fetch_morerest_result(keyword, searchtype, isLocationSearch, isLoadMoreClicked) {
	console.log("REST LOAD MORE = " + zomatoRestSeeMore + " = " + yelpRestSeeMore + " = " + tripadvRestSeeMore);
	REST_SEEMORE_FLAG = false;
	if(zomatoRestSeeMore == "YES") {
		fetch_zomato_rest_result(keyword, searchtype, isLocationSearch, true);
	} else if(yelpRestSeeMore == "YES") {
		fetch_yelp_rest_result(keyword, searchtype, isLocationSearch, true);
	} else if(tripadvRestSeeMore == "YES") {
		fetch_tripadv_rest_result(keyword, searchtype, isLocationSearch, true);
	} else {
		$('#SEEMORE').hide();
		$.mobile.hidePageLoadingMsg();
	}
}

function fetchResultDone() {
	$.mobile.hidePageLoadingMsg();
}

function showZomatoPopup(url) {
	console.log("============ ZOMATO REST DETAILS START : " + url);
	var response1 = "";
	var response2 = "";
	$.ajax({
		url : url,
		type : 'GET',
		dataType: "json",
		timeout : 20000,

		beforeSend : function(xhr) {
			xhr.setRequestHeader("Cache-Control", "no-cache");
			xhr.setRequestHeader("pragma", "no-cache");
			xhr.setRequestHeader("X-Zomato-API-Key", ZOMATO_KEY);

			//$.mobile.showPageLoadingMsg("a", "Please Wait...", true);
		},

		complete : function() {
			//$.mobile.hidePageLoadingMsg();

			if(response1 == "" && response2 == "") {
				response1 = '<div style="padding:10px;"><b>No Details Found.</b></div>';
			}
			$("#detailsZomato").html(response1);
			$("#linkZomato").html(response2);

			$("#popupZomato").popup("open");
		},

		success : function(data, textStatus, xhr) {
			var title = '';
			var contactnumber = '';
			var address = '';
			var cuisines = '';
			var time = '';
			var costfortwo = '';
			var review = '';
			var cardaccepted = '';
			var rating = '';
			var url = '';

			try {
				title = data.name;
			} catch (err) {
				title = "";
			}

			try {
				contactnumber = data.phone;
			} catch (err) {
				contactnumber = "";
			}

			try {
				address = data.location.address;
			} catch (err) {
				address = "";
			}

			try {
				cuisines = data.cuisines;
			} catch (err) {
				cuisines = "";
			}

			try {
				time = data.timings;
			} catch (err) {
				time = "";
			}

			try {
				costfortwo = data.avgCostForTwo;
			} catch (err) {
				costfortwo = "";
			}

			try {
				review = data.userReviews.count;
			} catch (err) {
				review = "";
			}

			try {
				cardaccepted = data.acceptsCreditCards;
			} catch (err) {
				cardaccepted = "";
			}

			try {
				rating = data.editorRating.overall;
			} catch (err) {
				rating = "";
			}

			try {
				url = data.url;
			} catch (err) {
				url = "#";
			}

			/////////////////////////////////
			response1 += '<table width="100%" style="margin:0;padding:0;">';
			response1 += '<tr>';
			response1 += '<td width="100%" style="color:blue;">';
			response1 += '<div style="max-height:30px;overflow:hidden;white-space:normal;"><b>' + title + '</b></div>';
			response1 += '</table>';
			/////////////////////////////////

			/////////////////////////////////
			response1 += '<table width="100%" style="margin:0;padding:0;font-size:smaller;">';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/dial.png" /></td>';
			response1 += '<td style="vertical-align:middle;">'+ contactnumber +'</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/place.png" /></td>';
			response1 += '<td style="vertical-align:middle;">'+ address +'</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/cuisines.png" /></td>';
			response1 += '<td style="vertical-align:middle;">'+ cuisines +'</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/timings.png" /></td>';
			response1 += '<td style="vertical-align:middle;">'+ time +'</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/rupee.png" /></td>';
			response1 += '<td style="vertical-align:middle;">COST FOR 2 : RS '+ costfortwo +'</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/reviews.png" /></td>';
			response1 += '<td style="vertical-align:middle;">'+ review +' User Reviews</td>';
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td width="20px" style="vertical-align:middle;"><img src="es_img/credit_cards.png" /></td>';
			if(cardaccepted == "1"){
				response1 += '<td style="vertical-align:middle;">Accepted</td>';
			} else {
				response1 += '<td style="vertical-align:middle;">Not Accepted</td>';
			}
			response1 += '</tr>';
			response1 += '<tr>';
			response1 += '<td colspan="2" width="20px" style="vertical-align:middle;">Rating : '+ rating +'/5</td>';
			response1 += '</tr>';
			response1 += '</table>';
			/////////////////////////////////
			response2 += '<div style="font-size:smaller;max-height:30px;overflow:hidden;white-space:normal;">URL:' + '<a href="#" onclick="openBrowser(\'' + url + '\');">' + url + '</a></div>';
		},

		error: function(XMLHttpRequest, textStatus, errorThrown) {
			console.log("AUTO AD ERROR : " + textStatus.toString() + " - " + errorThrown.toString());
		}
	});
}