// JavaScript Document
var chave;

function criarBD(){
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    // Se não existe cria
    request.onupgradeneeded = function() {
        // mapeia banco de dados
        var db = request.result;

        // cria objeto
        var store = db.createObjectStore("tccs", { autoIncrement: true }); // Auto increment

        // cria indices para busca
        var codigoIndex = store.createIndex("indexCodigo", "codigo"); // Chave código
		var tituloIndex = store.createIndex("indexTitulo", "titulo"); // Chave título
		var autorIndex = store.createIndex("indexAutor", "autor"); // Chave autor 
		var dataIndex = store.createIndex("indexData", "data"); // Chave data       

        db.close();
    };

    request.onsuccess = function(){
        //alert("Iniciada a aplicação!");
        var db = request.result;
        db.close;
    }
}

function apagarBanco(){
    indexedDB.deleteDatabase('agenda');
    alert("Banco de dados apagado");
}

function cadastrarTCC(){
    var codigo = document.formCadastrarTCC.codigo.value;
    var titulo = document.formCadastrarTCC.titulo.value;
	var autor = document.formCadastrarTCC.autor.value;
	var data = document.formCadastrarTCC.data.value;
	var resumo = document.formCadastrarTCC.resumo.value;
	
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function(){
        // mapeia banco de dados
        var db = request.result;

        // Inicia uma transação de leitura e escrita
        var tx = db.transaction("tccs", "readwrite");
        // seleciona objeto
        var store = tx.objectStore("tccs");

        // Cadastra no banco
        store.put({codigo: codigo, titulo: titulo, autor: autor, data: data, resumo: resumo});
		
        tx.oncomplete = function() {
            alert("Dados gravados com sucesso!");
			document.formCadastrarTCC.reset();
        };

        db.close();
    }
}

function listarTCCs(){
    var divLista = document.getElementById("listaDeTCCs");
    divLista.innerHTML = "";

    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function() {
        // mapeia banco de dados
        db = request.result;

        // Inicia uma transação de leitura
        var tx = db.transaction("tccs", "readonly");
        // Seleciona objeto
        var store = tx.objectStore("tccs");

        // Consulta todos os objetos
        request2 = store.openCursor();
        request2.onsuccess = function() {
            // Armazena objeto
            var cursor = request2.result;
			
            if(cursor){
                divLista.innerHTML = divLista.innerHTML +
				" <p><img src='imagens/lista.png' width='20px' height='20px'><b> Chave:</b> " + cursor.key +
				" | <b>Título:</b> " + cursor.value.titulo +
				" | <b>Data:</b> " + cursor.value.data +
				" <input type='image' src='imagens/editar.png' width='20px' height='20px' title='Editar' onClick='javascript:alterarTCC(" + cursor.key + ")'> " + "	" +
				" <input type='image' src='imagens/mostrar.png' width='20px' height='20px' title='Mostrar' onClick='javascript:mostrarTCC(" + cursor.key + ")'> " + "	" +
				" <input type='image' src='imagens/excluir.png' width='20px' height='20px' title='Excluir' onClick='javascript:excluirTCC(" + cursor.key + ")'></p> ";
                cursor.continue(); // Anda com o ponteiro
            }
        };

        db.close();
    }

}

function excluirTCC(key){
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function() {
        // mapeia banco de dados
        var db = request.result;

        // Inicia uma transação de leitura e escrita
        var tx = db.transaction("tccs", "readwrite");
        // seleciona objeto
        var store = tx.objectStore("tccs");

        // Apaga objeto
        store.delete(key);

        tx.oncomplete = function() {
            alert("TCC excluído com sucesso!");
        };

        db.close();
    }
	window.location.href = "#menu";
}

function alterarTCC(key){
	var codigo = document.formAlterarTCC.codigo;
    var titulo = document.formAlterarTCC.titulo;
	var autor = document.formAlterarTCC.autor;
	var data = document.formAlterarTCC.data;
	var resumo = document.formAlterarTCC.resumo;
    chave = key;
	
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function() {
        // mapeia banco de dados
        db = request.result;

        // Inicia uma transação de leitura
        var tx = db.transaction("tccs", "readonly");
        // Seleciona objeto
        var store = tx.objectStore("tccs");
        // Consulta objetos a ser alterado
        request2 = store.get(key); // filtra pela chave
        request2.onsuccess = function() {
            // Armazena objeto
            var matching = request2.result;

            if (matching !== undefined) {
                // Registro encontrado
                codigo.value = matching.codigo;
                titulo.value = matching.titulo;
                autor.value = matching.autor;
				data.value = matching.data;
				resumo.value = matching.resumo;
            } else {
                // Registro nao encontrado
                alert("TCC não encontrado!");
            }
        };

        db.close();

        window.location.href = "#alterarTCC";
    }
}

function alterarTCCok(){
    var codigo = document.formAlterarTCC.codigo;
    var titulo = document.formAlterarTCC.titulo;
	var autor = document.formAlterarTCC.autor;
	var data = document.formAlterarTCC.data;
	var resumo = document.formAlterarTCC.resumo;
	var key = chave;
	
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function() {
        // mapeia banco de dados
        var db = request.result;

        // Inicia uma transação de leitura e escrita
        var tx = db.transaction("tccs", "readwrite");
        // seleciona objeto
        var store = tx.objectStore("tccs");

        // Consulta objetos a ser alterado
        request2 = store.get(key); // filtra pela chave
        request2.onsuccess = function () {
            var matching = request2.result;

            if (matching !== undefined) {

                //Alterando objeto
                matching.titulo = titulo.value;
                matching.autor = autor.value;
				matching.data = data.value;
				matching.resumo = resumo.value;
                console.log(matching);

                // Alterar no banco
                var requestUpdate = store.put(matching, key);
                requestUpdate.onerror = function () {
                    alert("Erro ao alterar o TCC!");
                };
                requestUpdate.onsuccess = function () {
                    alert("Dados alterados com sucesso!");
                };

            } else {
                alert("TCC não encontrado!");
            }
        }

        db.close();
    }
	window.location.href = "#menu";
}

function mostrarTCC(key){
	var codigo = document.formMostrarTCC.codigo;
    var titulo = document.formMostrarTCC.titulo;
	var autor = document.formMostrarTCC.autor;
	var data = document.formMostrarTCC.data;
	var resumo = document.formMostrarTCC.resumo;
    chave = key;
	
    // Abrir banco de dados
    var request = indexedDB.open("tcc");

    request.onsuccess = function() {
        // mapeia banco de dados
        db = request.result;

        // Inicia uma transação de leitura
        var tx = db.transaction("tccs", "readonly");
        // Seleciona objeto
        var store = tx.objectStore("tccs");
        // Consulta objetos a ser alterado
        request2 = store.get(key); // filtra pela chave
        request2.onsuccess = function() {
            // Armazena objeto
            var matching = request2.result;

            if (matching !== undefined) {
                // Registro encontrado
                codigo.value = matching.codigo;
                titulo.value = matching.titulo;
                autor.value = matching.autor;
				data.value = matching.data;
				resumo.value = matching.resumo;
            } else {
                // Registro nao encontrado
                alert("TCC não encontrado!");
            }
        };

        db.close();

        window.location.href = "#mostrarTCC";
    }
}

function mostrarTCCok(){
	var codigo = document.formMostrarTCC.codigo;
    var titulo = document.formMostrarTCC.titulo;
	var autor = document.formMostrarTCC.autor;
	var data = document.formMostrarTCC.data;
	var resumo = document.formMostrarTCC.resumo;
	var key = chave;
	
    // Abrir banco de dados
    var request = indexedDB.open('tcc');

    request.onsuccess = function() {
        // mapeia banco de dados
        var db = request.result;

        // Inicia uma transação de leitura e escrita
        var tx = db.transaction("tccs", "readwrite");
        // seleciona objeto
        var store = tx.objectStore("tccs");

        // Consulta objetos a ser alterado
        request2 = store.get(key); // filtra pela chave
        request2.onsuccess = function () {
            var matching = request2.result;

            if (matching !== undefined) {

                //Alterando objeto
                matching.titulo = titulo.value;
                matching.autor = autor.value;
				matching.data = data.value;
				matching.resumo = resumo.value;
                console.log(matching);
            } else {
                alert("TCC não encontrado!");
            }
        }

        db.close();
    }
}
