  var map;
  
  var locationMarker = null;
  var purpleMarker = new google.maps.MarkerImage("/res/pin_self.png");
  var greenMarker = new google.maps.MarkerImage("/res/green_pin.png");
  var redMarker = new google.maps.MarkerImage("/res/red_pin.png");
  var yellowMarker = new google.maps.MarkerImage("/res/yellow_pin.png");
  var blueMarker = new google.maps.MarkerImage("/res/blue_pin.png");
  purpleMarker.anchor = new google.maps.Point(10,10);
  greenMarker.anchor = new google.maps.Point(21,25);
  redMarker.anchor = new google.maps.Point(21,25);
  yellowMarker.anchor = new google.maps.Point(21,25);
  blueMarker.anchor = new google.maps.Point(21,25);

  var markersArray = [];

  var selected = false;
  var selectedIcon = false;
  
    var geocoder = new google.maps.Geocoder();
		
  var codeAddress = function( address , onComplete) {
	  if (geocoder) {
		  geocoder.geocode( { 'address': address}, function(results, status) {
			  if (status == google.maps.GeocoderStatus.OK) {
				  onComplete(results);
			  } else {
			  
			  }
		  });
	  }
  }
  
  var reload = function( system, center ){
      loadCity(map, system, center , function(){}, function(){$('update').addClass("loading");}, function(){$('update').removeClass("loading");});
  };



  var cleanMarkers = function(){
    if (markersArray) {
      markersArray.each(function(marker){
	marker.setMap(null);
      });
      markersArray.length = 0;
    }
  };

var loadCity = function(map, city_id, center, onFailure, onRequest, onComplete){
  loadJSON('http://api.citybik.es/'+city_id+'.json','get',null, function(){alert("ERROR");}, function(){ onRequest();}, 
	   function( response ){
	      var stations = response;
	      if (center){
		  map.setCenter(new google.maps.LatLng(stations[Math.floor(stations.length/4)].lat/1E6, stations[Math.floor(stations.length/4)].lng/1E6));
		map.setZoom(12);
	      }
	      cleanMarkers();
	      var tmpMarker;
	      stations.each(function(elem){
		if (elem.bikes == 0){
		  tmpMarker = redMarker;
		/*}else if (elem.free == 0){
		  tmpMarker = blueMarker;*/
		}else if (elem.bikes < 5){
		  tmpMarker = yellowMarker;  
		}else{
		  tmpMarker = greenMarker;
		}
		var marker = new google.maps.Marker({
		    'position':new google.maps.LatLng(elem.lat/1E6, elem.lng/1E6),
		    'title':elem.name,
		    'map':map,
		    'icon':tmpMarker});
		google.maps.event.addListener(marker, 'click', function() {
		    console.dir(this);
		    if (selected && selectedIcon){
			selected.setIcon(selectedIcon);
		    }
		    selectedIcon = this.getIcon();
		    selected = this;
		    this.setIcon(blueMarker);
		    populateInfoStation(elem.name, elem.bikes, elem.free, elem.timestamp);
		});
		markersArray.push(marker);
	      });
	      onComplete();
	   }
  );
}


  var populateInfoStation = function(name, bikes, free, update){
      $('station_name').set('html',name);
      $('station_bikes').set('html',"bicis: "+bikes);
      $('station_free').set('html',"espacios: "+free);
  };

var loadJSON = function(url, method, data, onFailure, onRequest, onComplete){
  var request = new Request.JSONP({
	async: true,
	method: method,
	url: url,
	data: data,
	onFailure: onFailure,
	onRequest: onRequest,
	onComplete: onComplete
  });
  request.send();
}

var getLocation = function( callback ){
    if ( navigator && navigator.geolocation)
      navigator.geolocation.getCurrentPosition( callback , function(){alert("Problemas localizandote"); });
    else
      alert("Tu navegador no soporta geolocalización");
}