var draw = (function() {
  'use strict';
  var section = document.getElementById('draw'),
      dessin,
      percent = 0,
      error = 0,
      current,
      errorColor = new jsDraw.Color({
        r: 250, g: 0, b: 0
      }),
      correctColor = new jsDraw.Color({
        r: 0, g: 0, b: 0
      }),
      score = function(canvasModel) {
        var ctxModel = canvasModel.getContext('2d');
        var datasModel = ctxModel.getImageData(0, 0, canvasModel.width, canvasModel.height).data;
        var ctxDessin = dessin.canvas.getContext('2d');
        var datasDessin = ctxDessin.getImageData(0, 0, canvasModel.width, canvasModel.height).data;
        var reste = 0;
        var total = 0;
        for (var i = 0; i < datasModel.length; i += 4) {
          if (datasModel[i] !== 0
              && datasModel[i + 1] !== 0
              && datasModel[i + 2] !== 0
              && datasModel[i + 3] !== 0) {
            total++;
          }
          if (datasDessin[i] === 0
              && datasDessin[i + 1] === 0
              && datasDessin[i + 2] === 0
              && datasDessin[i + 3] === 0
              && datasModel[i] !== 0
              && datasModel[i + 1] !== 0
              && datasModel[i + 2] !== 0
              && datasModel[i + 3] !== 0) {
            reste++;
          } else if (datasDessin[i] === errorColor.r
              && datasDessin[i + 1] === errorColor.g
              && datasDessin[i + 2] === errorColor.b
              && datasDessin[i + 3] === errorColor.a) {
            error++;
          }
        }
        if (reste === 0 || total === 0) {
          percent = 0;
        } else {
          percent = parseInt((1 - reste / total) * 100);
        }
        if (error === 0 || total === 0) {
          error = 0;
        } else {
          error = parseInt((error / total) * 100);
        }
        document.getElementById('percent').value = percent + '%';
        document.getElementById('error').value = error + '%';
      },
      resize = function(model) {
        dessin.lock(true);
        percent = 0;
        error = 0;
        document.getElementById('percent').value = percent + '%';
        document.getElementById('error').value = error + '%';
        dessin.canvas.style.position = 'absolute';
        dessin.fill(new jsDraw.Color({
          r: 0, g: 0, b: 0, a: 0
        }));
        section.style.display = 'block';
        //section.style.animation = 'show 0.5s';
        model.resize();
        var width = section.clientWidth;
        if (section.clientWidth > section.clientHeight) {
          width = section.clientHeight * 0.9;
        }
        var height = section.clientHeight * 0.9;
        dessin.resize(width, height);
        dessin.size(dessin.canvas.width / 15);
        dessin.canvas.style.top = model.canvas.offsetTop + 'px';
        dessin.canvas.style.left = model.canvas.offsetLeft + 'px';
        model.draw(function() {
          dessin.lock(false);
        });
      },
      init = function(model, callback) {
        dessin = new jsDraw.Dessin(section);
        dessin.setActivUndo(false);
        window.addEventListener('resize', function() {
          resize(model);
        });
        dessin.addEventListener('ondraw', function() {
          var pixel = new jsDraw.Pixel({
            x: this.x,
            y: this.y,
            canvas: model.canvas
          });
          if (pixel.color.r === 0 
              && pixel.color.g === 0
              && pixel.color.b === 0
              && pixel.color.a === 0) {
            // Not on model
            dessin.color(errorColor);
            navigator.vibrate(10);
          } else {
            dessin.color(correctColor);
          }
          setTimeout(function() {
            score(model.canvas);
          }, 0);
        });
        if (callback !== undefined) {
          callback.call({
            valide: document.getElementById('bOk')
          });
        }
      },
      submit = function(callback) {
        if (callback !== undefined) {
          callback.call({
            error: error,
            percent: percent,
            current: current
          });
        }
      },
      hide = function() {
        section.style.display = 'none';
        //section.style.animation = 'hide 0.5s';
      },
      show = function(elt, model) {
        current = elt;
        model.select(elt);
        resize(model);
      };
  return {
    init: init,
    hide: hide,
    show: show,
    submit: submit
  };
}());
