var home = (function() {
  'use strict';
  var section = document.getElementById('home'),
      bLetter = document.getElementById('bLetter'),
      bNumber = document.getElementById('bNumber'),
      resize = function() {
        var width = document.body.clientWidth * 0.5,
            height = document.body.clientHeight * 0.5;
        if (width < height) {
          height = width;
        } else {
          width = height;
        }
        bLetter.style.width = width + 'px';
        bLetter.style.height = height + 'px';
        bNumber.style.width = width + 'px';
        bNumber.style.height = height + 'px';
      },
      init = function(callback) {
        window.addEventListener('resize', function() {
          resize();
        });
        resize();
        if (callback !== undefined) {
          callback.call({
            button1: bLetter,
            button2: bNumber
          });
        }
      },
      hide = function() {
        section.style.display = 'none';
        try {
          section.style.animation = 'hide 0.5s';
        } catch(err) {
          console.error('CSS Animation not supported !', err);
        }
      },
      show = function() {
        section.style.display = 'block';
        try {
          section.style.animation = 'show 0.5s';
        } catch(err) {
          console.error('CSS Animation not supported !', err);
        }
      };
  return {
    init: init,
    hide: hide,
    show: show
  };
}());