var menu = (function() {
  'use strict';
  var section = document.getElementById('menu'),
      imagesLetters = ['A','B','C','D','E','F',
                       'G','H','I','J','K','L',
                       'M','N','O','P','Q','R',
                       'S','T','U','V','W','X',
                       'Y','Z'],
      imagesNumbers = ['0','1','2','3','4',
                       '5','6','7','8','9'],
      init = function(callback) {
        if (callback !== undefined) {
          callback.call({
            back: document.getElementById('bBack')
          });
        }
      },
      hide = function() {
        section.style.display = 'none';
        try {
          section.style.animation = 'hide 0.5s';
        } catch(err) {
          console.error('CSS Animation not supported !', err);
        }
        var divMenu = document.getElementById('menu_images');
        section.removeChild(divMenu);
      },
      star = function(etat) {
        var star = new Image();
        if (etat === 'on') {
          var star = new Image();
          star.src = 'img/score/star_on.png';
        } else {
          star.src = 'img/score/star_off.png';
        }
        star.width = '10';
        star.height = '10';
        return star;
      },
      lineStart = function(score, btn) {
        var elt = document.createElement('div');
        elt.style.display = 'inline-block';
        elt.style.width = '60px';
        elt.style.height = '70px';
        elt.style.margin = '10px 0px';
        elt.appendChild(btn);
        if (score > 200) {
          elt.appendChild(star('on'));
          if (score > 400) {
            elt.appendChild(star('on'));
            if (score > 600) {
              elt.appendChild(star('on'));
              if (score > 800) {
                elt.appendChild(star('on'));
                if (score > 980) {
                  elt.appendChild(star('on'));
                } else {
                  elt.appendChild(star('off'));
                }
              } else {
                elt.appendChild(star('off'));
                elt.appendChild(star('off'));
              }
            } else {
              elt.appendChild(star('off'));
              elt.appendChild(star('off'));
              elt.appendChild(star('off'));
            }
          } else {
            elt.appendChild(star('off'));
            elt.appendChild(star('off'));
            elt.appendChild(star('off'));
            elt.appendChild(star('off'));
          }
        } else {
          elt.appendChild(star('off'));
          elt.appendChild(star('off'));
          elt.appendChild(star('off'));
          elt.appendChild(star('off'));
          elt.appendChild(star('off'));
        }
        return elt;
      },
      show = function(id, datas, callback) {
        section.style.display = 'block';
        try {
          section.style.animation = 'show 0.5s';
        } catch(err) {
          console.error('CSS Animation not supported !', err);
        }
        var divMenu = document.createElement('div');
        divMenu.id = 'menu_images';
        section.appendChild(divMenu);
        var images = [];
        if (id === 'bLetter') {
          images = imagesLetters;
        } else if (id === 'bNumber') {
          images = imagesNumbers;
        }
        var buttons = [];
        images.forEach(function(elt) {
          var btn = document.createElement('button');
          btn.innerHTML = elt;
          btn.id = elt;
          btn.style.width = '50px';
          btn.style.height = '50px';
          btn.style.border = '1px solid #CCC';
          btn.style.borderRadius = '5px';
          btn.style.margin = '1px auto';
          btn.style.fontSize = '14pt';
          btn.style.fontWeightW = 'bold';
          btn.style.color = '#555';
          buttons.push(btn);
          var score = datas[elt];
          if (score === undefined) {
            score = 0;
          }
          divMenu.appendChild(lineStart(score, btn));
        });
        if (callback !== undefined) {
          callback.call({
            buttons: buttons
          });
        }
      };
  return {
    init: init,
    hide: hide,
    show: show
  };
}());