var model = (function() {
  'use strict';
  var section = document.getElementById('draw'),
      elements = [],
      ratio = 0.05,
      delai = 50,
      color = new jsDraw.Color({
        r: 150, g: 150, b: 150
      }),
      idx = 0,
      canvas = document.createElement('canvas'),
      x = 0, y = 0, rayon = 0, start = 0,
      delta = 0, deltaX = 0, deltaY = 0, max = 0,
      maxX = 0, maxY = 0, w = 0, h = 0,
      type, clock = false,
      init = function() {
        canvas.id = 'model';
        canvas.style.display = 'block';
        canvas.style.margin = 'auto';
        section.appendChild(canvas);
      },
      load = function(idx) {
        if (elements[idx] !== undefined) {
          type = elements[idx].type;
          if (type === 'line') {
            x = elements[idx].x1 * canvas.width;
            y = elements[idx].y1 * canvas.height;
            maxX = elements[idx].x2 * canvas.width;
            maxY = elements[idx].y2 * canvas.height;
            deltaX = (maxX - x) * ratio;
            deltaY = (maxY - y) * ratio;
          } else if (type === 'arc') {
            x = elements[idx].x * canvas.width;
            y = elements[idx].y * canvas.height;
            rayon = elements[idx].r * canvas.width;
            start = elements[idx].s;
            max = elements[idx].e;
            clock = elements[idx].reverse;
            delta = (max - elements[idx].s) * ratio;
            if (clock) {
              delta *= -1;
            }
          }
        }
      },
      resize = function() {
        if (section.clientWidth > section.clientHeight) {
          canvas.width = section.clientHeight * 0.9;
        } else {
          canvas.width = section.clientWidth;
        }
        canvas.height = section.clientHeight * 0.9;
      },
      increment = function() {
        if (type === 'line') {
          x += deltaX;
          y += deltaY;
        } else if (type === 'arc') {
          start += delta;
        }
      },
      draw = function(callback) {
        var inst = document.getElementById('instructions');
        inst.style.display = 'block';
        try {
          inst.style.animation = 'fondu 2.0s';
        } catch(err) {
          console.error('CSS Animation not supported !', err);
        }
        setTimeout(function() {
          inst.style.display = 'none';
        }, 1900);
        idx = 0;
        load(idx);
        setTimeout(function() {
          setTimeout(splitDraw, delai);
          setTimeout(callback, delai * elements.length / ratio);
        }, 500);
      },
      splitDraw = function() {
        var ctx = canvas.getContext('2d');
        ctx.strokeStyle = color.toRGBA();
        ctx.lineWidth = canvas.width / 15;
        ctx.lineJoin = 'round';
        ctx.lineCap = 'round';
        ctx.beginPath();
        if (type === 'line') {
          ctx.moveTo(x, y);
          ctx.lineTo(x + deltaX, y + deltaY);
        } else if (type === 'arc') {
          ctx.arc(x, y, rayon, start, start + delta, clock);
        }
        ctx.closePath();
        ctx.stroke();
        if ((Math.abs(maxX - x - deltaX) >= ratio 
             || Math.abs(maxY - y - deltaY) >= ratio) && type === 'line'
             || !clock && Math.abs(max - start - delta) >= ratio && type === 'arc'
             || clock && 2*Math.PI - Math.abs(max - start - delta) >= ratio && type === 'arc') {
          increment();
        } else {
          idx += 1;
          load(idx);
        }
        if (elements[idx] !== undefined) {
          setTimeout(splitDraw, delai);
        }
      },
      select = function(elt) {
        var ctx = canvas.getContext('2d');
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        elements = [];
        switch (elt) {
          case 'A': // OK
            elements.push({type: 'line',
                           x1: 0.1, y1: 0.9, x2: 0.5, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.1, x2: 0.9, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.8, y2: 0.5});
            break;
          case 'B': // OK
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.9, x2: 0.4, y2: 0.1});
            elements.push({type: 'arc',
                           x: 0.4, y: 0.3, r: 0.25, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            elements.push({type: 'arc',
                           x: 0.4, y: 0.7, r: 0.25, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            break;
          case 'C': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: -0.3*Math.PI, e: 0.3*Math.PI, reverse: true});
            break;
          case 'D': // OK
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.1, x2: 0.3, y2: 0.9});
            elements.push({type: 'arc',
                           x: 0.3, y: 0.5, r: 0.5, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            break;
          case 'E': // OK
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.2, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.8, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.5, y2: 0.5});
            break;
          case 'F': // OK
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.2, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.5, y2: 0.5});
            break;
          case 'G': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: -0.3*Math.PI, e: 0, reverse: true});
            elements.push({type: 'line',
                           x1: 0.9, y1: 0.5, x2: 0.55, y2: 0.5});
            break;
          case 'H': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.8, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.8, y2: 0.5});
            break;
          case 'I': // OK
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.1, x2: 0.5, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.1, x2: 0.6, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.9, x2: 0.6, y2: 0.9});
            break;
          case 'J': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.8, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.6, y1: 0.1, x2: 0.6, y2: 0.7});
            elements.push({type: 'arc',
                           x: 0.4, y: 0.7, r: 0.2, s: 0, e: Math.PI, reverse: false});
            break;
          case 'K': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.8, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.5, x2: 0.8, y2: 0.9});
            break;
          case 'L': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.8, y2: 0.9});
            break;
          case 'M': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.2, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.5, y2: 0.6});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.6, x2: 0.8, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.8, y2: 0.9});
            break;
          case 'N': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.2, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.8, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.9, x2: 0.8, y2: 0.1});
            break;
          case 'O': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: -0.5*Math.PI, e: 1.5*Math.PI, reverse: false});
            break;
          case 'P': // OK
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.9, x2: 0.4, y2: 0.1});
            elements.push({type: 'arc',
                           x: 0.4, y: 0.3, r: 0.25, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            break;
          case 'Q': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: -0.5*Math.PI, e: 1.5*Math.PI, reverse: false});
            elements.push({type: 'line',
                           x1: 0.7, y1: 0.7, x2: 0.9, y2: 0.9});
            break;
          case 'R': // OK
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.9, x2: 0.4, y2: 0.1});
            elements.push({type: 'arc',
                           x: 0.4, y: 0.3, r: 0.25, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.5, x2: 0.7, y2: 0.9});
            break;
          case 'S': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.25, s: -0.2*Math.PI, e: 0.5*Math.PI, reverse: true});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.25, s: -0.5*Math.PI, e: 0.8*Math.PI, reverse: false});
            break;
          case 'T': // OK
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.1, x2: 0.5, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.1, y1: 0.1, x2: 0.9, y2: 0.1});
            break;
          case 'U': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.2, y2: 0.7});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.3, s: -Math.PI, e: 0, reverse: true});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.7, x2: 0.8, y2: 0.1});
            break;
          case 'V': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.5, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.9, x2: 0.8, y2: 0.1});
            break;
          case 'W': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.35, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.35, y1: 0.9, x2: 0.5, y2: 0.5});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.5, x2: 0.65, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.65, y1: 0.9, x2: 0.8, y2: 0.1});
            break;
          case 'X': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.8, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.8, y2: 0.1});
            break;
          case 'Y': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.5, y2: 0.5});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.5, y2: 0.5});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.5, x2: 0.5, y2: 0.9});
            break;
          case 'Z': // OK
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.1, x2: 0.8, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.8, y1: 0.1, x2: 0.2, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.2, y1: 0.9, x2: 0.8, y2: 0.9});
            break;
          case '0': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: true});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.5, r: 0.4, s: 0.5*Math.PI, e: 1.5*Math.PI, reverse: true});
            break;
          case '1': // OK
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.3, x2: 0.5, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.1, x2: 0.5, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.4, y1: 0.9, x2: 0.6, y2: 0.9});
            break;
          case '2': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.4, r: 0.25, s: -0.8*Math.PI, e: 0.2*Math.PI, reverse: false});
            elements.push({type: 'line',
                           x1: 0.72, y1: 0.5, x2: 0.3, y2: 0.9});
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.9, x2: 0.8, y2: 0.9});
            break;
          case '3': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.25, s: -0.7*Math.PI, e: 0.5*Math.PI, reverse: false});
            elements.push({type: 'line',
                           x1: 0.5, y1: 0.5, x2: 0.4, y2: 0.5});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.25, s: -0.5*Math.PI, e: 0.7*Math.PI, reverse: false});
            break;
          case '4': // OK
            elements.push({type: 'line',
                           x1: 0.6, y1: 0.1, x2: 0.3, y2: 0.6});
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.6, x2: 0.8, y2: 0.6});
            elements.push({type: 'line',
                           x1: 0.6, y1: 0.1, x2: 0.6, y2: 0.9});
            break;
          case '5': // OK
            elements.push({type: 'line',
                           x1: 0.7, y1: 0.1, x2: 0.3, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.1, x2: 0.3, y2: 0.5});
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.5, x2: 0.55, y2: 0.5});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.25, s: -0.45*Math.PI, e: 0.7*Math.PI, reverse: false});
            break;
          case '6': // OK
            elements.push({type: 'line',
                           x1: 0.7, y1: 0.12, x2: 0.6, y2: 0.12});
            elements.push({type: 'arc',
                           x: 0.6, y: 0.4, r: 0.35, s: -0.5*Math.PI, e: Math.PI, reverse: true});
            elements.push({type: 'line',
                           x1: 0.25, y1: 0.4, x2: 0.25, y2: 0.6});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.6, r: 0.25, s: -1*Math.PI, e: -0.5*Math.PI, reverse: true});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.6, r: 0.25, s: -0.5*Math.PI, e: -1*Math.PI, reverse: true});  
            break;
          case '7': // OK
            elements.push({type: 'line',
                           x1: 0.3, y1: 0.1, x2: 0.7, y2: 0.1});
            elements.push({type: 'line',
                           x1: 0.7, y1: 0.1, x2: 0.3, y2: 0.9});
            break;
          case '8': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.22, s: 0.5*Math.PI, e: 1.5*Math.PI, reverse: false});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.22, s: -0.5*Math.PI, e: 0.5*Math.PI, reverse: false});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.27, s: -0.5*Math.PI, e: Math.PI, reverse: true});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.27, s: -Math.PI, e: -0.5*Math.PI, reverse: true});
            break;
          case '9': // OK
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.22, s: -2*Math.PI, e: -1*Math.PI, reverse: true});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.3, r: 0.22, s: -1*Math.PI, e: 0, reverse: true});
            elements.push({type: 'line',
                           x1: 0.72, y1: 0.3, x2: 0.72, y2: 0.7});
            elements.push({type: 'arc',
                           x: 0.5, y: 0.7, r: 0.22, s: -2*Math.PI, e: -1.2*Math.PI, reverse: false});
            break;
          default:
            console.warn('Element not found : ' + elt);
            break;
        }
      };

  return {
    resize: resize,
    select: select,
    init: init,
    canvas: canvas,
    draw: draw
  };
}());
