var score = (function() {
  'use strict';
  var sdcard, sLetters, sNumbers;
  if (window.MozActivity) {
    sdcard = navigator.getDeviceStorage('sdcard');
  } else {
    sLetters = ['A','B','C','D','E','F',
                'G','H','I','J','K','L',
                'M','N','O','P','Q','R',
                'S','T','U','V','W','X',
                'Y','Z'];
    sNumbers = ['0','1','2','3','4',
                '5','6','7','8','9'];
  }
  var name = 'writing.score',
      datas = [],
      read = function() {
        if (window.MozActivity) {
          var request = sdcard.get(name);
          request.onsuccess = function () {
            var file = this.result;
            //console.log(file);
            var reader = new FileReader();
            reader.readAsText(file, 'UTF-8');
            reader.onloadend = function(evt) {
              var content = evt.target.result;
              var images = content.split(';');
              for (var i = 0; i < images.length; i++) {
                var line = images[i].split(':');
                datas[line[0]] = line[1];
              }
            }
            reader.onerror = function() {
              console.warn('Unable to read the file: [' + this.error.name + '] ' + this.error.message);
            }
          }
          request.onerror = function () {
            console.warn('Unable to get the file: [' + this.error.name + '] ' + this.error.message);
          }
        } else if (sdcard) {
          for (var i = 0; i < sLetters.length; i++) {
            datas[sLetters[i]] = localStorage.getItem(sLetters[i]);      
          }
          for (var i = 0; i < sNumbers.length; i++) {
            datas[sNumbers[i]] = localStorage.getItem(sNumbers[i]);      
          }
        }
      },
      write = function(key, value) {
        if (datas[key] !== undefined && datas[key] > value) {
          // Meilleur score conservé
          value = datas[key];
        }
        datas[key] = value;
        if (window.MozActivity) {
          var ctblob = '';
          for (var data in datas) {
            ctblob += data + ':' + datas[data] + ';';
          }
          var file = new Blob([ctblob], {type: 'text/plain'});
          var req1 = sdcard.delete(name);
          req1.onsuccess = function () {
            console.log('File "' + name + '" deleted on the sdcard storage area');
          }
          req1.onerror = function () {
            console.log('Unable to delete the file: [' + this.error.name + '] ' + this.error.message);
          }
          var req2 = sdcard.addNamed(file, name);
          req2.onsuccess = function () {
            var name = this.result;
            console.log('File "' + name + '" successfully wrote on the sdcard storage area');
          }
          req2.onerror = function () {
            console.warn('Unable to write the file: [' + this.error.name + '] ' + this.error.message);
          }
        } else {
          localStorage.setItem(key, value);
        }
      }
  
  return {
    read: read,
    write: write,
    datas: datas
  };

}());