/* 
    Created on : 17-jul-2015, 17:55:04
    Author     : pauloalvarez
*/
var numeroA;
var numeroB;
var numeroC;

var resultadoA;
var resultadoB;

function iniciar() {
    numeroA = document.getElementById('valorNumeroA');
    numeroB = document.getElementById('valorNumeroB');
    numeroC = document.getElementById('valorNumeroC');
    
    var botonCalcular = document.getElementById('calcular');
    var botonLimpiar = document.getElementById('limpiar');
    
    botonLimpiar.addEventListener("click", limpiar , "false");
    botonCalcular.addEventListener("click", calcular, "false");
    
    resultadoA = document.getElementById('valorResultadoA');
    resultadoB = document.getElementById('valorResultadoB');
}

/*
 * @name limpiar
 * @returns {undefined}
 */
function limpiar() {
    numeroA.value = "";
    numeroB.value = "";
    numeroC.value = "";
    
    resultadoA.value = "";
    resultadoB.value = "";
}

function calcular() {
    
    /*
     * Variables que ayudan en las operaciones
     */
    var discriminante;
    var real;
    var imaginario;
    var total;
    
    try {
        var valorNumeroA = parseFloat(numeroA.value);
        var valorNumeroB = parseFloat(numeroB.value);
        var valorNumeroC = parseFloat(numeroC.value);
        
        if(isNaN(valorNumeroA)|| isNaN(valorNumeroB || isNaN(valorNumeroC))) {
            throw "Error";
        }
        
        if(valorNumeroA === 0 && valorNumeroB === 0) {
            resultadoA.value = "No se puede resolver";
            resultadoB.value = "A = 0 y B = 0";
        } else if(valorNumeroA === 0) {
            resultadoA.value = "La única raíz es";
            discriminante = (valorNumeroB * valorNumeroB) - (4 * valorNumeroA * valorNumeroC);
            total = (-valorNumeroC / discriminante);
            resultadoB.value = total.toFixed(3);
        } else {
            real = (-valorNumeroB) / (2 * valorNumeroA);
            discriminante = (valorNumeroB * valorNumeroB) - (4 * valorNumeroA * valorNumeroC);
            imaginario = Math.sqrt(Math.abs(discriminante)) / (2 * valorNumeroA);
            
            if(discriminante > 0) {
                //Respuesta A
                total = real + imaginario;
                resultadoA.value = total;
                
                //Respuesta B
                total = real - imaginario;
                resultadoB.value = total.toFixed(3);
            } else {
                //Respuesta A
                resultadoA.value = real.toFixed(3) + " + " + Math.abs(imaginario.toFixed(3)) + " j";
                
                //Respuesta B
                resultadoB.value = real.toFixed(3) + " - " + Math.abs(imaginario.toFixed(3)) + " j";   
            }
        }
    }
    catch(err) {
        alert(err + " debe ingresar todos los valores para poder calcular");
    }
}

window.addEventListener("load", iniciar, false);