var END = (function (){

  var root = this;
  // ENDConfig.configuration is on config.js
  root.configuration = ENDConfig.configuration;
  root.utils = ENDConfig.utils;

  var API = root.api = {
    baseUrl: "http://api.elnuevodiario.com.ni/",

    getSection: function(section, callback){
      var url = this.baseUrl + 'sections/' + section + '';
      this.makeAjaxCall(url, callback, 'json', section);
    },

    getArticles: function(callback){
      var url = this.baseUrl + 'articles/';
      this.makeAjaxCall(url, callback, 'json');
    },

    getArticlesMD5: function(callback){
      var url = this.baseUrl + 'articles/md5';
      console.log('get articles md5');
      this.makeAjaxCall(url, callback, 'text');
    },

    getSectionMD5: function(section, callback){
      var url = this.baseUrl + 'sections/' + section + '/md5';
      this.makeAjaxCall(url, callback, 'text', section);
    },

    makeAjaxCall: function(url, callback, datatype, section){
      var xhr = new XMLHttpRequest({mozSystem: true});
      xhr.open("GET", url, true);
      xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
          if (datatype==="text"){
            callback(xhr.responseText);
          } else {
            obj = JSON.parse(xhr.responseText);
            callback(obj);
          }
        } else {    
          console.log('ajax error: ' + url);
        }
      };
      xhr.send();
    }
  };

  var Data = root.data = {
    getArticlesFor: function(section) {
      var key = section + '_articles';
      var json_data = JSON.parse(endStorage.getItem(key));

      if ( json_data !== null ) {
        json_data = json_data.sort(function (a, b) {
            return new Date(b.publicationdate).getTime() - new Date(a.publicationdate).getTime();
        });
      }
      return json_data;
    },

    saveArticlesFor: function(section, data, callback) {
      var VALID_KEYS = ['id', 'title', 'url', 'publicationdate', 'section', 'image', 'content'];
      var section_data = [];

      for (var i=0; i < data.slice(0,40).length; i++) {
        var article = data[i],
            cleaned_article = {};

        for(var prop in article) {
          if (article.hasOwnProperty(prop) && (VALID_KEYS.indexOf(prop) > -1)) {
            cleaned_article[prop] = article[prop];
          }
        }

        section_data.push(cleaned_article);
      }

      var key = section + '_articles';
      endStorage.setItem(key, JSON.stringify(section_data));
      // endStorage.setItem(key, section_data);

      return callback();
    },

    // return news for all sections
    // NOTE: we need to improve this function
    // it is not good for performance issues
    getSectionsNews: function(){
      var data = {};
      var sections = root.configuration.availableSections();
      // append general articles section
      sections.push('articles');

      for (var i=0; i<sections.length; i++){
        var section_name = sections[i];
        data[section_name] = root.data.getArticlesFor(section_name);
      }

      return data;
    },
    getNewsByID: function(id){
      //temporal
      var data = root.data.getArticlesFor('articles');
      for (i=0; i<data.length; i++){
        if (data[i].id == id){
          return data[i];
        }
      }
      return false;
    }
  };

  return {
    api               :   API, 
    configuration     :   root.configuration,
    utils             :   root.utils,
    data              :   Data
  };

}).call(this);
