var endStorage = localStorage;

var ENDConfig = (function (){
  var root = this;
  var Utils = root.utils = {
    sectionHumanName: {
      nacionales      : "País",
      politica        : "Política",
      sucesos         : "Sucesos",
      economia        : "Dinero",
      especiales      : "Especiales",
      deportes        : "Pasión",
      variedades      : "Fama",
      turismo         : "Destinos",
      empresas        : "Empresas",
      internacionales : "Globo",
      managua         : "Managua",
      opinion         : "Opinión",
      desde_la_u      : "Desde la U"
    },

    getHumanName: function(section) {
      if (section === "desde-la-u" || section === 'desde-la-_u'){
        return this.sectionHumanName['desde_la_u'];
      } else{
        return this.sectionHumanName[section];
      }
    },
    
    getMachineName: function(section){
      for( var prop in this.sectionHumanName) {
        if( this.sectionHumanName.hasOwnProperty( prop ) ) {
             if( this.sectionHumanName[ prop ] === section)
                 return prop;
        }
      }
      return null;
    }
  };

  var Configuration = root.configuration = {
    availableSections: function(){
      return [
        'nacionales',
        'politica',
        'sucesos',
        'economia',
        'internacionales',
        'opinion',
        'especiales',
        'deportes',
        'variedades',
        'turismo',
        'empresas',
        'managua',
        'desde-la-_u'
      ];

      },

      getDefaultFor: function(configValue){
        switch (configValue){
          case "skin":
            return this.availableSkins[0];

          case "layout":
            return this.availableLayouts[0];

          case "notification":
            return true;

          case "sections":
            return this.availableSections();

          default:
            return null;
        }
      },
      
      setDefaults: function(){
        this.setSections(this.availableSections());

        this.setNotification(true);

        this.setSkin('skin-dark');
        
        this.setLayout('normal-photo');
      },

      getSections: function(){
        //console.log('calling getSections...');
        if (endStorage.getItem('sections') === null) {
          endStorage.setItem('sections', this.getDefaultFor('sections'));
        }

        var sections = endStorage.getItem('sections');
        return (sections === "undefined") ? [] : endStorage.getItem('sections').split(',');
      },

      setSections: function(sections) {
        endStorage.setItem('sections', sections);
      },

      removeSection: function(section) {
        var current_sections = this.getSections();
        var index = current_sections.indexOf(section);
        if ( index > -1){
          current_sections.splice(index, 1);
        }
        this.setSections(current_sections);
      },

      addSection: function(section) {
        var current_sections = this.getSections();
        if (current_sections.indexOf(section) == -1 &&
            this.availableSections().indexOf(section) != -1) {
            current_sections.push(section);
            this.setSections(current_sections);
        }
      },

      sectionEnabled: function(section){
        var current_sections = this.getSections();
        return current_sections.indexOf(section) >= 0;
      },

      getNotification: function() {
        var not = endStorage.getItem('notification');
        if (not === null){
          this.setNotification(this.getDefaultFor('notification'));
          return this.getDefaultFor('notification');
        } else {
          return parseInt(not) === 1;
        }
      },

      toggleNotification: function() {
        var current_value = endStorage.getItem('notification');
        this.setNotification(!(current_value === true));
      },

      setNotification: function(value) {
        endStorage.setItem('notification', (value) ? '1' : '0');
      },

      setSectionMD5: function(section, value) {
        var key = section + "_md5";
        endStorage.setItem(key, value);
      },

      getSectionMD5: function(section) {
        var key = section + "_md5";
        return endStorage.getItem(key);
      },
      
      setArticlesMD5: function(value) {
        var key = "articles_md5";
        endStorage.setItem(key, value);
      },

      getArticlesMD5: function() {
        var key = "articles_md5";
        return endStorage.getItem(key);
      },
      availableLayouts: ['normal-photo', 'big-photo'],

      getLayout: function(){
          var layout = endStorage.getItem('layout');
          if (layout){
            return layout;
          } else {
            layout = this.getDefaultFor('layout');
            this.setLayout(layout);
            return layout;
          }
      },

      setLayout: function(layout){
        if (this.availableLayouts.indexOf(layout) > -1){
          endStorage.setItem('layout', layout);
        } else {
          endStorage.setItem('layout', this.availableLayouts[0]);
        }
        this.reloadLayouts();
      },

      availableSkins: ['skin-dark', 'skin-light', 'skin-mix'],

      getSkin: function(){
        //console.log('calling getSkin....');
        var skin = endStorage.getItem('skin');
        if (!skin){
            skin = this.getDefaultFor('skin');
            this.setSkin(skin);
        }
        return skin;
      },
      
      setSkin: function(skin){
        if (this.availableSkins.indexOf(skin) > -1){
          endStorage.setItem('skin', skin);
        } else {
          endStorage.setItem('skin', this.availableSkins[0]);
        }
        this.reloadLayouts();
      },

      reloadLayouts: function(){
        $('body').removeClass(this.availableSkins.join(' '));
        $('body').removeClass(this.availableLayouts.join(' '));
        $('body').addClass(this.getSkin());
        $('body').addClass(this.getLayout());
      }

  };

  return {
      configuration :   Configuration,
      utils         :   Utils
  };
}).call(this);
