/*
 * Browser independent function to check if new functionality needs 
 * to be loaded. 
 * The callback will be executed when all the checks have been made.
 * callback accepts an object in this way
 * { generalArticle: True, sections: {foo: true, bar: false, foobar: true}}
 */
function checkForNewContent(callback) {
  // function scoped variables to store results from async callbacks
  var resultStore = {
    generalArticle: false,
    sections: {}
  };
  var loadedSections = [];
  var loadedArticles = false;

  var current_saved_sections = END.configuration.getSections();

  // function to trigger the callback call when everything ends...
  // worst function name ever!!!
  var canCallCallback = function(){
    if (current_saved_sections.length == loadedSections.length && loadedArticles) {
      return callback(resultStore);
    } else {
      return false;
    }
  };

  // General articles:
  var storedArticleMd5 = END.api.getArticlesMD5(function(data){
    if (data !== END.configuration.getArticlesMD5()){
      END.configuration.setArticlesMD5(data);
      resultStore.generalArticle = true;
    } else {
      resultStore.generalArticle = false;
    }
    loadedArticles = true;
    canCallCallback();
  });

  // Sections MD5
  var availableSections = END.configuration.getSections();
  for (var i=0; i < availableSections.length; i++){
    var section = availableSections[i];
    END.api.getSectionMD5(section, function(data){
      var section = this.sectionName;
      loadedSections.push(section);
      if (data !== END.configuration.getSectionMD5(section)){
        END.configuration.setSectionMD5(section, data);
        resultStore.sections[section] = true;
      } else {
        resultStore.sections[section] = false;
      }
      canCallCallback();
    });
  }
}

/* 
 * Function to load the content acordding to the user need
 * arguments;
 *  - contentToLoad: object returned by checkForNewContent function
 *  - callback: function that will be excecuted when all the content is loaded
 */
function loadContent(contentToLoad, callback){
  newContent = { articles: null, sections: {} };

  // extract only the keys that has new content to load
  // ugly but it works :P  
  sectionKeys = Object.keys(contentToLoad.sections).filter(function(key) {
    return (contentToLoad.sections[key]);
  });

  callCallbackIfYouCan = function(){
    var articlesLoaded = newContent.articles !== null;
    var loadedSectionKeys = Object.keys(newContent.sections);

    if (sectionKeys.length == loadedSectionKeys.length && articlesLoaded){
      return callback(newContent);
    } else {
      return false;
    }
  };

  // loads general article
  if (contentToLoad.generalArticle){
    END.api.getArticles(function(data){
      newContent.articles = data;
      callCallbackIfYouCan();
    });
  } else {
    newContent.articles = [];
  }

  for (var i=0; i < sectionKeys.length; i++){
    var section = sectionKeys[i];
    if (contentToLoad.sections[section]){
      END.api.getSection(section, function(data){
        var section = this.sectionName;
        newContent.sections[section] = data;
        callCallbackIfYouCan();
      });
    }
  }
}

/* 
 * Function to save the new content from END api
 * arguments;
 *  - contentToSave: object containing the data to be saved
 *  - callback: function that will be excecuted when all the content has been
 *    saved with local storage
 */
function saveContent(contentToSave, callback) {
  // save general articles if necessary
  var newArticlesCount = 0;
  
  if (contentToSave.articles.length > 0) {
    END.data.saveArticlesFor('articles', contentToSave.articles, function(){});
    
    // get the last pub date read to be able to count how many items are new
    // FIXME: probably need to move this code to other file, now it's here
    var last_pubdate;
    try {
      last_pubdate = new Date(localStorage.getItem('lastreadpubdate'));
    } catch(err){
      last_pubdate = new Date(year='1940');
    }

    // count how many items are new based on last_pudate
    for( var i=0; i<contentToSave.articles.length; i++ ) {
      var item_pubdate = new Date(contentToSave.articles[i].publicationdate);
      if (item_pubdate > last_pubdate) {
        newArticlesCount++;
      }
    }

  }

  // save other sections
  var sectionKeys = Object.keys(contentToSave.sections);
  for (var i=0; i < sectionKeys.length; i++) {
    var key = sectionKeys[i];

    if (contentToSave.sections[key] !== null ) {
      END.data.saveArticlesFor(key, contentToSave.sections[key], function(){
        
        // WARNING: non-crossbrowser code
        // set bagde to the extension browser
        if ( newArticlesCount > 0 ) {
          badgeMsg = (newArticlesCount > 30) ? "30+" : String(newArticlesCount);
        }

        // if last element in loop, return callback
        if ( (i+1) == sectionKeys.length ) {
          cbData = {
            new_count: newArticlesCount,
            article: END.data.getArticlesFor('articles')[0]
          };
          return callback(cbData);
        }
      });
    }
  }
  return callback();
}

/* 
 * Function intended to render a template given as parameter
 * arguments;
 *  - params must be an Object in this way: 
 *    { template: '#tmpl_selector', 'container': '#container_selector', 'data': 'json_object' }
 *  - callback: function that will be excecuted at render ending
 */
function renderTemplate(params, callback) {
  var opts = params;
  var templateToRender = (opts.template instanceof Object) ? opts.template : $('body '+opts.template).html();
  
  // render template with corresponding data
  var result = swig.render(templateToRender, { locals: { data: params.data } });

  // write content to container
  $('body '+params.container).html(result);

  if (callback) {
    callback();
  }
}
