var NOTICIAS_MAX = 29; // se muestran NOTICIAS_MAX + 1

current_news = {};

$(window).scroll(function() {
  if ($(this).scrollTop() > 1){  
      $('#header').addClass("sticky");
    }
    else{
      $('#header').removeClass("sticky");
    }
});

function notify(data) {
  console.log('notify');
}

function checkENDNews(callback){
  checkForNewContent(function(foo) {
    loadContent(foo, function(new_data) {
      // save the new content
      saveContent(new_data, callback);
    });
  });
}

// Settings events
function renderSidebar(){
  var container = $("#main-menu");
  var template = $("body #menu-item-template").html();
  var all_html = '<a href="#" class="active" data-section="articles">Todas</a>';
  var sections = ENDConfig.configuration.getSections();
  // var excluded_sections = ['managua', 'desde_la_u', 'desde-la-_u', 'turismo', 'empresas'];
  var excluded_sections = [];
  container.html('');
  container.html(all_html);

  // need to order sections
  // doing it right here fagot :P
  ordered_sections = [];

  // calling this only one, it is not neccesary to hit localStorage 
  // each loop
  var availableSections = ENDConfig.configuration.availableSections();
  for (var i = 0; i < sections.length; i++) {
    section = sections[i];
    index = availableSections.indexOf(section);

    if ( index != -1 ) {
      ordered_sections[index] = sections[i];
    }
  }

  // removing undefined elements because of ordering
  sections = ordered_sections.filter(function(elem){ return elem !== undefined; });

  for (var i = 0; i < sections.length; i++) {
    var section = {id: sections[i]};
    if (excluded_sections.indexOf(section.id) == -1){
      section.name = ENDConfig.utils.getHumanName(section.id);
        var result = Mustache.render(template, section);
      container.append(result);
    }
  }

  $('body').off('click', '#main-menu > a');
  $('#main-menu > a').on('click', function() {
    // disable current active section menu
    $(this).siblings('a.active').removeClass('active');

    // set this clicked menu as active
    $(this).addClass('active');

    // rendering only the section that was clicked
    var section_name = $(this).data('section');
    if (typeof current_news[section_name] === "undefined") {
      current_news[section_name] = END.data.getArticlesFor(section_name);
    }
    renderSection(current_news, section_name);
    switchBackground();

    $("#internal-content").animate({scrollTop:0}, '500', 'swing');
  });

  container.trigger("change"); // needed to re-render scrollbars
}

function renderSection(data, section) {
  var container = $('body #internal-content');
  var section_news = data[section];
  var template = $("body #article-template").html();

  // destroy custom scrollbars
  destroyScrollBar(container);

  // clean container
  container.html('');

  // pull current sections in localStorage once
  var current_saved_sections = ENDConfig.configuration.getSections();

  // limiting the news count
  var i = 0;
  while (i <= NOTICIAS_MAX){
    if (i >= section_news.length){
      break;
    }

    article = section_news[i];
    var image = false;
    if (section=='articles'){
      var section_name = ENDConfig.utils.getMachineName(article.section);

      if (current_saved_sections.indexOf(section_name) == -1){
        i++;
        continue;
      }
    }

    if (typeof article['image'] !== "undefined") {
      image = article['image'][0];
    }

    var result = Mustache.render(template, {
        "article" : article,
        "image"   : image,
        "timeago" : jQuery.timeago(article.publicationdate)
      });
    container.append(result);
    i++;
  }

  container.trigger("change"); // needed to re-render scrollbars
}

function renderSetting(setting){
  var container = $("body #settings-content");
  var template = null;

  // remove scrollbars 
  destroyScrollBar(container);

  if (setting == 'secciones'){
    var templateName = '#setting-' + setting+ '-template';
    template = $("body " + templateName).html();
    Mustache.parse(template);

    // calling available sections just once
    var availableSections = ENDConfig.configuration.availableSections();
    Mustache.parse(template);
    for (var i = 0; i < availableSections.length; i++) {
      var section = { id: availableSections[i] };
      section.name = ENDConfig.utils.getHumanName(section.id);
      section.checked =  ENDConfig.configuration.sectionEnabled(section.id);
      var data = {"section": section};
      if (i===0) {
          data["first"] = true;
          container.html('');
      }
      var result = Mustache.render(template, data);
      container.append(result);
     }
     setSettingEvents(setting);
  } else if (setting == 'acerca-de'){
    template = $("body #acerca-de").html();
    container.html(Mustache.render(template));
  } else if (setting == 'notificaciones'){
    template = $("body #setting-notificaciones").html();
    container.html(Mustache.render(template, {
      "active": ENDConfig.configuration.getNotification()
    }));
    setSettingEvents(setting);
  } else if (setting == 'apariencia'){
    template = $("body #setting-apariencia").html();
    container.html(Mustache.render(template));

    $('[data-name=' + ENDConfig.configuration.getSkin() + ']').addClass('active');
    $('[data-name=' + ENDConfig.configuration.getLayout() + ']').addClass('active');

    setSettingEvents(setting);
  }

  container.trigger("change"); // needed to re-render scrollbars
}

function setSettingEvents(setting){
  if (setting == 'secciones'){
    $('body').off('click', '.section-setting input[type=checkbox]');
    $('.section-setting input[type=checkbox]').on('click', function(){
      if (this.checked){
        ENDConfig.configuration.addSection($(this).data('section'));
      } else {
        ENDConfig.configuration.removeSection($(this).data('section'));
      }
      renderSection(current_news, 'articles');
      renderSidebar();
      switchBackground();
    });
  } else if (setting == 'notificaciones'){
    $('body').off('click', '.notificaciones input[type=checkbox]');
    $('.notificaciones input[type=checkbox]').on('click', function(){
      ENDConfig.configuration.toggleNotification();
    });
  } else if (setting == 'apariencia'){
    $('body').off('click', '.apariencia.skin button');
    $('body').off('click', '.apariencia.photos button');
    $('.apariencia.skin button').on('click', function(){
      ENDConfig.configuration.setSkin($(this).data('name'));
      $('.skin-button').removeClass('active');
      $('[data-name=' + ENDConfig.configuration.getSkin() + ']').addClass('active');
    });

    $('.apariencia.photos button').on('click', function(){
      ENDConfig.configuration.setLayout($(this).data('name'));
      $('.skin-photo').removeClass('active');
      $('[data-name=' + ENDConfig.configuration.getLayout() + ']').addClass('active');
    });
  }
}

function destroyScrollBar(elem){
  // $(elem).mCustomScrollbar('destroy');
}

function switchBackground(){
  $.each($('article.noticia > a'), function(index, value){
    background = value.getAttribute('data-background');
    if (background){
      value.setAttribute('style', background);
    }
  });
}

$(document).ready(function(){
  //setInterval(checkENDNews, 15000);
  $('.close').click(function(){
    window.close();
  });

  $('#settings-menu > a').click(function(){
    $('#settings-menu > a.active').removeClass('active');

    $(this).addClass('active');
    renderSetting($(this).data('section'));
  });

  ENDConfig.configuration.reloadLayouts();

  var config_open = false;
  $('.btn-configuracion').click(function(){
    // check if settings template hasn't been rendered
    if ($("body #settings-content").text().length === 0) {
      renderSetting('secciones');
    }

    if (config_open){
      $('.container').animate({'margin-left': '0'}, 500);
      config_open = false;
    } else{
      config_open = true;
      $('.container').animate({'margin-left': '-500px'}, 500);
    }
  });

  current_news['articles'] = END.data.getArticlesFor('articles'); 
  var render = function(data){
    current_news['articles'] = END.data.getArticlesFor('articles'); 
    renderSection(current_news, 'articles');
  }; 

  if (current_news['articles']){
    render();
  } else {
    var spinner = $(document.createElement('div')).addClass('spinner');
    $(document.createElement('div'))
      .addClass('double-bounce1')
      .appendTo(spinner);
    
    $(document.createElement('div'))
      .addClass('double-bounce2')
      .appendTo(spinner)

    $(document.createElement('span'))
      .addClass('loading-text')
      .html('Cargando Noticias')
      .appendTo(spinner)

    $("#internal-content").html(spinner.html()); 
  } 
  checkENDNews(render);
  renderSidebar();
  //renderSection(current_news, 'articles');
});

$(document).ready(function(){
  console.log('asdfasdfasdf');
});
