//VARIABLES

var adOptions = {
    TYPE: "Banner",
    REFRESH_RATE: 18,
    APP_ID: "Test_App_ID"
};

var peliculas;
var pelicula;
var usuario="";
var aciertos= 0;
var pistas= 10;
inicializarJson();

//EVENTOS

//Añade el evento click al boton OK
$(document).on("click", "#btn-ok", function(){
	   comprobar();
	});

//Añade el evento click al boton Pista
$(document).on("click", "#btn-pista", function(){
		pista();	
	});

//Simula la pulsación del boton ok al dar a intro
$(document).keypress(function(event) {
    var keycode = (event.keyCode ? event.keyCode : event.which);
    if (keycode == '13') {
        $('#btn-ok').focus();
    }
});

//INICIALIZACIÓN



//Inicializa el juego para un jugador
$(document).on('pagebeforeshow', '#solo', function(){
	aciertos=0;
	$("#aciertos").html(aciertos);
	pistas= 10;
	$("#numero-pistas").html(pistas);
	pintarJeroglifico();
});


//Inicializa la pagina de records
$(document).on('pagebeforeshow', '#records', function(){
	//create the Ad object based on the above options
	/*var ad = Inneractive.createAd(adOptions);
	ad
		.placement("bottom", "center")
		.addTo(document.getElementById("anuncioRecords"));*/
	mostrarRecords();
});

//Inicializa la pagina de menu
$(document).on('pagebeforeshow', '#menu', function(){
	//create the Ad object based on the above options
	/*var ad = Inneractive.createAd(adOptions);
	ad
		.placement("bottom", "center")
		.addTo(document.getElementById("anuncioMenu"));*/
	mostrarRecords();
});


//Inicializa el JSON de las peliculas
function inicializarJson(){
	peliculas = [
	{ "titulo":"9 reinas" , "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"},
	{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"},
	{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"},{"ruta":"Smiley/073.png"}
	] },
	{ "titulo":"Con la muerte en los talones" , "acierto": "false" , "iconos": [
	{"ruta":"Smiley/088.png"},{"ruta":"Smiley/149.png"},{"ruta":"Smiley/149.png"}
	] },
	{ "titulo":"Desayuno con diamantes","acierto": "false" , "iconos": [
	{"ruta":"Objetos/172.png"}, {"ruta":"Smiley/184.png"},{"ruta":"Smiley/184.png"}
	] },
	{ "titulo":"Sonrisas y lágrimas","acierto": "false" , "iconos": [
	{"ruta":"Smiley/001.png"},{"ruta":"Smiley/001.png"},{"ruta":"Smiley/022.png"},{"ruta":"Smiley/022.png"}
	] },
	{ "titulo":"4 bodas y un funeral","acierto": "false" , "iconos": [
	{"ruta":"Smiley/183.png"},{"ruta":"Smiley/183.png"},{"ruta":"Smiley/183.png"},{"ruta":"Smiley/183.png"},{"ruta":"Smiley/088.png"}
	] },
	{ "titulo":"Eduardo manostijeras","acierto": "false" , "iconos": [
	{"ruta":"Smiley/065.png"},{"ruta":"Smiley/114.png"},{"ruta":"Objetos/113.png"}, {"ruta":"Objetos/113.png"}
	] },
	{ "titulo":"Cantando bajo la lluvia","acierto": "false" , "iconos": [
	{"ruta":"Objetos/136.png"}, {"ruta":"Naturaleza/110.png"}
	] },
	{ "titulo":"Abre los ojos","acierto": "false" , "iconos": [
	{"ruta":"Objetos/051.png"}, {"ruta":"Smiley/102.png"}
	] },
	{ "titulo":"Diamantes de sangre","acierto": "false" , "iconos": [
	{"ruta":"Smiley/184.png"},{"ruta":"Smiley/184.png"}, {"ruta":"Objetos/077.png"}
	] },
	{ "titulo":"21 vestidos", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},
	{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"},{"ruta":"Smiley/156.png"}
	] },
	{ "titulo":"El hombre que susurraba a los caballos", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/124.png"},{"ruta":"Smiley/099.png"},{"ruta":"Naturaleza/048.png"},
	{"ruta":"Naturaleza/048.png"}
	] },
	{ "titulo":"Balada triste de trompeta", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/018.png"}, {"ruta":"Smiley/022.png"}, {"ruta":"Objetos/143.png"}
	] },
	{ "titulo":"Un tranvía llamado deseo", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/053.png"}, {"ruta":"Objetos/033.png"},{"ruta":"Smiley/007.png"}
	] },
	{ "titulo":"Bailando con lobos", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/126.png"}, {"ruta":"Naturaleza/002.png"},{"ruta":"Naturaleza/002.png"}
	] },
	{ "titulo":"Sangre, sudor y lágrimas", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/077.png"},{"ruta":"Smiley/027.png"},{"ruta":"Smiley/022.png"},
	{"ruta":"Smiley/022.png"}
	] },
	{ "titulo":"El señor de los anillos", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/069.png"}, {"ruta":"Smiley/118.png"},{"ruta":"Smiley/183.png"},
	{"ruta":"Smiley/183.png"}
	] },
	{ "titulo":"Liberad a Willy", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/051.png"},{"ruta":"Naturaleza/039.png"}
	] },
	{ "titulo":"El oro de moscú", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/098.png"},{"ruta":"Objetos/078.png"},{"ruta":"Objetos/078.png"},
	{"ruta":"Objetos/078.png"},{"ruta":"Lugares/100.png"}
	] },
	{ "titulo":"Dirty dancing", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/090.png"},{"ruta":"Smiley/126.png"}
	] },
	{ "titulo":"El silencio de los corderos" , "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/040.png"},{"ruta":"Naturaleza/018.png"},{"ruta":"Naturaleza/018.png"}
	] },
	{ "titulo":"Gorilas en la niebla", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/108.png"},{"ruta":"Naturaleza/108.png"}, {"ruta":"Naturaleza/015.png"},
	{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/108.png"},{"ruta":"Naturaleza/108.png"}
	] },
	{ "titulo":"El libro de la selva", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/128.png"},{"ruta":"Naturaleza/078.png"}
	] },
	{ "titulo":"American beauty", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/096.png"}, {"ruta":"Naturaleza/068.png"}, {"ruta":"Naturaleza/068.png"},
	{"ruta":"Naturaleza/068.png"}, {"ruta":"Objetos/065.png"}
	] },
	{ "titulo":"El fantasma de la opera", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/012.png"},{"ruta":"Objetos/140.png"}
	] },
	{ "titulo":"American pie", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/096.png"}, {"ruta":"Objetos/208.png"}
	] },
	{ "titulo":"Brokeback mountain", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/067.png"},{"ruta":"Smiley/180.png"},{"ruta":"Smiley/067.png"},
	{"ruta":"Lugares/023.png"}
	] },
	{ "titulo":"Alien, el octavo pasajero", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/089.png"}, {"ruta":"Simbolos/008.png"},{"ruta":"Lugares/040.png"},
	{"ruta":"Lugares/038.png"}
	] },
	{ "titulo":"Una boda de muerte", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/183.png"},{"ruta":"Smiley/088.png"}
	] },
	{ "titulo":"Tienes un email", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/090.png"}, {"ruta":"Objetos/030.png"}
	] },
	{ "titulo":"Tiana y el sapo", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/073.png"}, {"ruta":"Naturaleza/007.png"}
	] },
	{ "titulo":"Agua para elefantes", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/097.png"},{"ruta":"Naturaleza/019.png"}
	] },
	{ "titulo":"ET", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/070.png"},{"ruta":"Smiley/089.png"}, {"ruta":"Lugares/001.png"}, {"ruta":"Objetos/032.png"}
	] },
	{ "titulo":"El diablo viste de Prada", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/049.png"},{"ruta":"Smiley/151.png"}
	] },
	{ "titulo":"Náufrago", "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/039.png"},{"ruta":"Naturaleza/078.png"}, {"ruta":"Objetos/156.png"}
	] },
	{ "titulo":"Serpientes en el avion", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/027.png"}, {"ruta":"Naturaleza/027.png"}, {"ruta":"Lugares/039.png"},
	{"ruta":"Naturaleza/027.png"},{"ruta":"Naturaleza/027.png"}
	] },
	{ "titulo":"Entre copas", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/178.png"},{"ruta":"Smiley/065.png"},{"ruta":"Objetos/178.png"}
	] },
	{ "titulo":"La dama y el vagabundo", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/001.png"},{"ruta":"Objetos/187.png"}, {"ruta":"Naturaleza/001.png"}
	] },
	{ "titulo":"Las trece rosas", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},
	{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},
	{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},
	{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},{"ruta":"Naturaleza/068.png"},
	{"ruta":"Naturaleza/068.png"}
	] },
	{ "titulo":"Ángeles y demonios", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/072.png"},{"ruta":"Smiley/072.png"},{"ruta":"Smiley/048.png"},
	{"ruta":"Smiley/048.png"}
	] },
	{ "titulo":"Los tres cerditos", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/011.png"},{"ruta":"Naturaleza/011.png"},{"ruta":"Naturaleza/011.png"}
	] },
	{ "titulo":"Los girasoles ciegos", "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/069.png"},{"ruta":"Naturaleza/069.png"}, {"ruta":"Smiley/020.png"}
	] },
	{ "titulo":"The ring", "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/025.png"},{"ruta":"Objetos/037.png"},{"ruta":"Smiley/033.png"},
	{"ruta":"Smiley/088.png"}
	] },
	{ "titulo":"El gato con botas", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/074.png"},{"ruta":"Smiley/152.png"},{"ruta":"Smiley/152.png"}
	] },
	{ "titulo":"Mary Poppins", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/068.png"}, {"ruta":"Smiley/167.png"}, {"ruta":"Objetos/140.png"}
	] },
	{ "titulo":"El peque se va de marcha", "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/064.png"},{"ruta":"Lugares/055.png"},{"ruta":"Objetos/017.png"}
	] },
	{ "titulo":"Up" , "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/019.png"},{"ruta":"Objetos/019.png"},{"ruta":"Lugares/001.png"},
	{"ruta":"Objetos/019.png"},{"ruta":"Objetos/019.png"}
	] },
	{ "titulo":"Doce monos" , "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},
	{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},
	{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},
	{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"},{"ruta":"Naturaleza/015.png"}
	] },
	{ "titulo":"Tras el corazón verde" , "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/172.png"}, {"ruta":"Smiley/118.png"},
	] },
	{ "titulo":"Toma el dinero y corre" , "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/078.png"},{"ruta":"Smiley/125.png"}
	] },
	{ "titulo":"Abierto hasta el amanecer" , "acierto": "false" ,"iconos": [
	{"ruta":"Objetos/051.png"}, {"ruta":"Lugares/024.png"}
	] },
	{ "titulo":"Sombrero de copa" , "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/147.png"}, {"ruta":"Objetos/178.png"}
	] },
	{ "titulo":"Flores en el atico" , "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/064.png"}, {"ruta":"Smiley/117.png"}, {"ruta":"Lugares/004.png"}, 
	] },
	{ "titulo":"Leones por corderos" , "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/008.png"},{"ruta":"Naturaleza/008.png"},{"ruta":"Simbolos/099.png"},
	{"ruta":"Naturaleza/018.png"},{"ruta":"Naturaleza/018.png"}
	] },
	{ "titulo":"Las biciletas son para el verano" , "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/070.png"}, {"ruta":"Lugares/070.png"}, {"ruta":"Naturaleza/106.png"}
	] },
	{ "titulo":"Cerdos y diamantes" , "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/011.png"},{"ruta":"Naturaleza/011.png"}, {"ruta":"Smiley/184.png"}, {"ruta":"Smiley/184.png"}
	] },
	{ "titulo":"Mar adentro" , "acierto": "false" ,"iconos": [
	{"ruta":"Naturaleza/116.png"},{"ruta":"Smiley/118.png"}
	] },
	{ "titulo":"El bueno, el feo y el malo" , "acierto": "false" ,"iconos": [
	{"ruta":"Smiley/018.png"},{"ruta":"Smiley/083.png"},{"ruta":"Smiley/049.png"}
	] },
	{ "titulo":"El barco fantasma" , "acierto": "false" ,"iconos": [
	{"ruta":"Lugares/033.png"}, {"ruta":"Objetos/012.png"}
	] }
];
};

//Pinta el jeroglifico en función de la película seleccionada
function pintarJeroglifico(){
	do{
		pelicula=peliculas[Math.floor((Math.random()*44)+1)];
	}while (pelicula.acierto == "true");

	$("#jeroglifico").empty();
	$("#pistas").empty();
	$("#usuario").val("");
	var ancho = 14;
	if (pelicula.iconos.length > 20){
		ancho = 7;
	} else if (pelicula.iconos.length > 13){
		ancho= 8;
	} else if (pelicula.iconos.length > 7){
		ancho=10;
	}

	pintarLineas();

	$.each(pelicula.iconos, function(index, icono){
		$("#jeroglifico").append("<img style='width:" + ancho + "vw' src='./images/emoji/" + icono.ruta + "' />");
	});
	$("#jeroglifico").append("<br/>");
};

//Pinta una línea por cada letra del título
function pintarLineas(){
	var str= pelicula.titulo;
	var lineas="";
	for (var i = 0, len = str.length; i < len; i++) {
  		if (isLetter(str[i])){
  			lineas += "_";
  		} else {
  			lineas += pelicula.titulo[i];
  		}
	}
	$("#usuario").val(lineas);
	usuario=lineas;
};


//JUEGO

//Selecciona aleatoriamente caracteres para mostrar como pista
function pista(){
	if (pistas > 0){
		var numero_letras= Math.floor((pelicula.titulo.length)/3);
		var cadena= usuario;
		var longitud= pelicula.titulo.length-1;
		var indice;
		for (var i = 0; i < numero_letras; i++) {
			do{
				indice= Math.floor((Math.random()*(longitud))+1);
			}while (!isLetter(pelicula.titulo[indice]) && pelicula.titulo[indice] != " ");
			cadena= cadena.replaceAt(indice, pelicula.titulo[indice]);
		};
		$("#usuario").val(cadena);
		usuario=cadena;
		pistas--;
		$("#numero-pistas").html(pistas);
	} else {
    		alert("¡Has agotado tus pistas!");
    }
};

//Comprueba si el texto introducido es igual que el titulo de la pelicula
function comprobar(){
	var pelicula_usuario = limpiarAcentos($("#usuario").val().toLowerCase());
	var pelicula_juego = limpiarAcentos(pelicula.titulo.toLowerCase());
	if (pelicula_usuario == pelicula_juego){
		aciertos++;
		pelicula.acierto = "true";
		$("#aciertos").html(aciertos);
		pintarJeroglifico();
		alert("¡Correcto!");
	} else {
		if (pistas > 0){
			alert("¡Incorrecto!");
			pistas--;
			$("#numero-pistas").html(pistas);
		} else{
			var nombre = prompt("Introduce tu nombre: ", "");
	   		guardarRecord(nombre, aciertos);
	   		window.location.href = "./app.html#records";
   		}
	}
};

//RECORDS Y BBDD

//Recibe un string (nombre del jugador) y un numero de aciertos
//y guarda el registro en la BBDD para mostrarlo en Records
function guardarRecord(n, a){
	if (window.localStorage) {
		localStorage.setItem(n,a);
	}
};

function mostrarRecords(){

	$("#listaRecords").empty();
	var array= [];
	for (i=0; i<=localStorage.length-1; i++)  
	{  
		key = localStorage.key(i);  
		val = localStorage.getItem(key);
		array[i]=[key, val];
	}
	array.sort(function(a, b) { return (a[1] > b[1] ? -1 : (a[1] < b[1] ? 1 : 0)); });
	var mostrar = array.length-1;
	if (mostrar > 10){
		mostrar= 10;
	}
	for (i=0; i<=mostrar; i++)  
	{ 
		var nombre= array[i][0];
		if (nombre.length > 7){

			nombre= nombre.substr(0,6) + "...";
		}
		var record = "<div><pre class='solida'>" + (i+1) + ":\t" + nombre + "<span class='tiza'>\t\t\t" + array[i][1] + " aciertos</span></pre> </div>";
		$("#listaRecords").append(record);
	}
}
 
//FUNCIONES SOPORTE

//Quita los acentos a los strings
function limpiarAcentos(str)
{
    str = str.replace(/[ÀÁÂÄ]/,"A");
    str = str.replace(/[àáâä]/,"a");
    str = str.replace(/[ÈÉÊË]/,"E");
    str = str.replace(/[èéêë]/,"e");
    str = str.replace(/[ÍÌÎÏ]/,"I");
    str = str.replace(/[ìíîï]/,"i");
    str = str.replace(/[ÒÓÔÖ]/,"O");
    str = str.replace(/[òóôö]/,"o");
    str = str.replace(/[ÙÚÛÜ]/,"U");
    str = str.replace(/[ùúûü]/,"u");

    return str.replace(/[^a-z0-9]/gi,'');
};

//Devuelve true si el char pasado es una letra o un numero
function isLetter(str) {
	return str.length === 1 && str.match(/[aábcdeéfghiíjklmnñoópqrstuúüvwxyzAÁBCDEÉFGHIÍJKLMNÑOÓPQRSTUÚÜVWXYZ0123456789]/i);
};

//añade la funcionalidad de sustituir por posicion
String.prototype.replaceAt = function(index, character) {
      return this.substr(0, index) + character + this.substr(index+character.length);
};