var items=new Array();
var usedItems=new Array();

var imageFolder="imgs_jpeg/";
var currentItem=null;

var currentPoints=0;

var stopped=false;

var hiddeLang=false;

var useTimer=true;
var timerCounter=100;
var timerTime=50;

function runTimer(){
	if(useTimer && !stopped){
		timerCounter--;
		if(timerCounter>=0){
			fillElement("timerField",timerCounter);
			window.setTimeout("runTimer()",timerTime);
		}
		else{
			stop(false);
		}
	}
}

function QuizItem(){
	this.language="";
	this.word="";
	
	this.image="";
	this.otherImages=new Array();
	
	this.imagePosition=1;
	
	this.points=1;
}

function fillElement(elementId,text){
	var children=document.getElementById(elementId).childNodes;
	for(var i=0;i<children.length;i++){
		children[i].parentNode.removeChild(children[i]);
	}
	
	document.getElementById(elementId).appendChild(document.createTextNode(text));	
}

function fillElementAsLink(elementId,text,url,onclick,className){
	var children=document.getElementById(elementId).childNodes;
	for(var i=0;i<children.length;i++){
		children[i].parentNode.removeChild(children[i]);
	}
	
	if(url==null || url==""){
		url="#";
	}
	
	var a=document.createElement("a");
	a.href=url;
	if(onclick!=null && onclick!=""){
		a.setAttribute("onclick",onclick);
	}	
	
	if(className!=null && className!=""){
		a.setAttribute("class",className);
	}
	
	a.appendChild(document.createTextNode(text))
	
	document.getElementById(elementId).appendChild(a);	
}

function getRandomImagePosition(){
	return Math.floor((Math.random()*4)+1); 
}

function addItem(lang,word,imageName,image1Name,image2Name,image3Name,makeMD5Names){
	//later with build-tools make names to md5 to avoid cheating
	var item1=new QuizItem();
	item1.language=lang;
	item1.word=word;
	item1.image=imageName;
	var images1=new Array();
	images1[0]=image1Name;
	images1[1]=image2Name;
	images1[2]=image3Name;
	item1.otherImages=images1;			
	addItemToList(item1);
}

function addItemToList(item){
	item.imagePosition=getRandomImagePosition();
	items[items.length]=item;
}

function noFreeItems(){
	var count=0;
	for(var i=0;i<usedItems.length;i++){
		if(usedItems[i] && usedItems[i]=="used"){
			count++;
		}
	}
	return count==items.length;
}

function usedItemsCount(){
	var count=0;
	for(var i=0;i<usedItems.length;i++){
		if(usedItems[i] && usedItems[i]=="used"){
			count++;
		}
	}
	return count;
}

function getItem(){
	if(noFreeItems()){
		stopped=true;
		stop(true);
		useTimer=false;
	}
	else{
		var i=Math.floor((Math.random()*items.length)+0);
		while(usedItems[i]){
			i=Math.floor((Math.random()*items.length)+0);
		}
		currentItem=items[i];
		
		usedItems[i]="used";
		
		timerCounter=100;
	}
}

function refreshView(){
	if(currentItem!=null){
		fillElement("theword",currentItem.word);
		fillElement("thelanguage","("+currentItem.language+")");
		
		fillElement("points",currentPoints);
		fillElement("itemCount",usedItemsCount()+"/"+items.length);
		
		var otherImagesI=0;
		for(var i=1;i<=4;i++){
			if(currentItem.imagePosition==i){
				document.getElementById("img_"+i).src=imageFolder+currentItem.image;
			}
			else{
				document.getElementById("img_"+i).src=imageFolder+currentItem.otherImages[otherImagesI++];
			}
		}
	}
	else{
		alert("ERROR: no item!");
	}
}

function init(){
	fillElement("timerField","-");
	if(hiddeLang){
		document.getElementById("thelanguage").style.display="none";
	}
	else{
		document.getElementById("thelanguage").style.display="block";
	}	
	document.getElementById("images").style.display="block";
	
	usedItems=new Array();
	currentPoints=0;
	stopped=false;
	timerCounter=100;
}

function start(){	
	init();
	getItem();
	refreshView();
	runTimer();
}

function stop(win){
	if(win){
		fillElement("theword","WIN :-)");	
	}
	else{
		fillElement("theword","Game Over!");
	}
	fillElementAsLink("thelanguage","restart the game","","start()","restart");
	document.getElementById("thelanguage").style.display="block";
	document.getElementById("images").style.display="none";
	fillElement("timerField","-");
}

function vote(imageName){
	var imageNameParts=imageName.split("/");
	imageName=imageNameParts[imageNameParts.length-1];
	if(!stopped){
		if(currentItem!=null && currentItem.image==imageName){
			currentPoints=currentPoints+currentItem.points;
			getItem();
			refreshView();
		}
		else{
			stopped=true;
			stop(false);
		}
	}	
}