
$(document).ready(function(){
	var degrees = 0;
	var maxWidth = 300;
	var maxHeight = 300;
	var ratio = 0;
	window.setTimeout(function(){
		$("#loading").hide(500);
	},500);
	var canvas,context;
	canvas=document.getElementById("canvasEditor");
	var imgSet=false;
	var originalSRC="";
	var orgImg='';
	var lastImage='';
	var lastSrc='';
	var arrEffects=[
		{'class':'img-fx-normal','fx':'normal','text':'Reset'},
		{'class':'img-fx-sepia','fx':'sepia','text':'Sepia'},
		{'class':'img-fx-solarize','fx':'solarize','text':'Solarize'},
		{'class':'img-fx-desaturate','fx':'desaturate','text':'Desaturate'},
		{'class':'img-fx-emboss','fx':'emboss','text':'Emboss'},
		{'class':'img-fx-invert','fx':'invert','text':'Invert'}
	];
	var arrBorders=[];
	function detect(obj){
		if(obj.height>obj.width){
			$("#canvasContainer").removeClass("canvasBox");
			$("#canvasContainer").removeClass("canvasHorizontal");
			$("#canvasContainer").addClass("canvasVertical");
		}else if(obj.width>obj.height){
			$("#canvasContainer").removeClass("canvasVertical");
			$("#canvasContainer").removeClass("canvasBox");
			$("#canvasContainer").addClass("canvasHorizontal");
		}else if(obj.height==obj.width){
			$("#canvasContainer").removeClass("canvasHorizontal");
			$("#canvasContainer").removeClass("canvasVertical");
			$("#canvasContainer").addClass("canvasBox");
		}
	}
	function getLastImage(){
		if(imgSet){
			var img = new Image();
			img.onload=function(){
				lastImage = this;
			}
			lastSrc = canvas.toDataURL("image/png");
			img.src = lastSrc;
		}
	}
	function drawRotated(rot,image){
		var cw = canvas.width;
		var ch = canvas.height;
		canvas.width = ch;
		canvas.height = cw;
		context.clearRect(0,0,canvas.width,canvas.height);
		context.save();
		if(rot=="clock"){
			context.translate(canvas.width,0);
			context.rotate(Math.PI/2);
		}else{
			context.translate(0,canvas.height);
			context.rotate(-(Math.PI/2));
		}
// 		context.translate(-canvas.width/2,-image.width/2);
		context.drawImage(image,0,0,cw,ch);
		context.restore();
	}
	function imgChange(str){
		if(imgSet){
			var img = new Image();
			img.onload = function(){
				switch(str){
					case "flipH": 
						context.save()
						context.translate(canvas.width, 0);
						context.scale(-1,1);
						context.drawImage(this, 0, 0, canvas.width, canvas.height);
						context.restore();
						break;
					case "flipV": 
						context.save();
						context.translate(0, canvas.height);
						context.scale(1, -1);
						context.drawImage(this, 0, 0, canvas.width, canvas.height);
						context.restore();
						break;
					case "rotCW": 
						drawRotated("clock",this);
						break;
					case "rotCCW": 
						drawRotated("counter",this);
						break;
				}
				originalSRC = canvas.toDataURL("image/png");
				var img1 = new Image();
				img1.onload = function(){
					detect(this);
				}
				img1.src = originalSRC;
			}
			img.src = canvas.toDataURL("image/png");
		}
	}
	function showFXCollection(arr){
		getLastImage();
		divEnhancesHide();
		$("#fxInner").html("");
		for(var i=0;i<arr.length;i++){
			var img='<div class="img-fx '+arr[i].class+'"></div>';
			var label='<label>'+arr[i].text+'</label>';
			$("<div/>",{
				class:"fx",
				html:img+label,
				data:{
					fx:arr[i].fx
				},click:fxClickEvent
			}).appendTo("#fxInner");
		}
	}
	function fxClickEvent(e){
		if(imgSet){
			var fx=$(this).data("fx");
			var imgObj=new Image();
			imgObj.onload=function(){
				if(fx!="normal"){
					context.drawImage(myScript.process(this, fx),0,0,canvas.width,canvas.height);
				}else{
					context.drawImage(this,0,0,canvas.width,canvas.height);
				}
				getLastImage();
				$(".divEnhances input").val(0).slider("refresh");
			}
			if(fx=="normal"){
				imgObj.src=orgImg;
				originalSRC = orgImg;
				var img1 = new Image();
				img1.onload = function(){
					detect(this);
				}
				img1.src = orgImg;
			}else{
				imgObj.src=originalSRC;
			}
		}
	}
	function showBorderCollection(arr){}
	function borderClickEvent(e){}
	function divEnhancesHide(){ $(".divEnhances").hide(); }
	function showEnhance(div){
		getLastImage();
		$("#fxInner").html("");
		divEnhancesHide();
		switch(div){
			case "brightness": $("#divBrightNess").show();
			break;
			case "saturation": $("#divSaturation").show();
			break;
			case "rgb": $("#divRGB").show();
			break;
		}
	}
	function randomString(length){
			var text = "";
			var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
			for( var i=0; i < length; i++ ){
					text += possible.charAt(Math.floor(Math.random() * possible.length));
			}
			return text;
	}
	showFXCollection(arrEffects);
	$(".btnFlipH").on("click",function(){ imgChange("flipH"); });
	$(".btnFlipV").on("click",function(){ imgChange("flipV"); });
	$(".btnRotCCW").on("click",function(){ imgChange("rotCCW"); });
	$(".btnRotCW").on("click",function(){ imgChange("rotCW"); });
	$(".btnFX1").on("click",function(e){
		e.preventDefault();
		showFXCollection(arrEffects);
	});
	$("#btnBorder").on("click",function(){
		showBorderCollection(arrBorders);
	});
	$(".btnBrightness").on("click",function(e){
		e.preventDefault();
		showEnhance("brightness");
	});
	$(".btnSatu").on("click",function(e){
		e.preventDefault();
		showEnhance("saturation");
	});
	$(".btnRGB").on("click",function(e){
		e.preventDefault();
		showEnhance("rgb");
	});
	$(".divEnhances input").on("keyup change",function(){
		if(imgSet){
			$("#loading").show();
			var brightness=$("#slider-Brightness").val();
			var contrast=$("#slider-Contrast").val();
			var hue=$("#slider-Hue").val();
			var saturation=$("#slider-Saturation").val();
			var red=$("#slider-Red").val();
			var green=$("#slider-Green").val();
			var blue=$("#slider-Blue").val();
			context.drawImage(myScript.process(lastImage, "brightness", {brightness: brightness, contrast: contrast}),0, 0, canvas.width, canvas.height);
			var img = new Image();
			img.onload=function(){
				context.drawImage(myScript.process(this, "hsl", {hue: hue, saturation: saturation}),0, 0, canvas.width, canvas.height);
				var img1 = new Image();
				img1.onload=function(){
					context.drawImage(myScript.process(this, "coloradjust", {red: red, green: green, blue: blue}),0, 0, canvas.width, canvas.height);
					$("#loading").hide();
				}
				img1.src = canvas.toDataURL("image/png");
			}
			img.src = canvas.toDataURL("image/png");
		}
	});
	$("#btnSave").on("click",function(){
		var folder="ePhoto/";
		var fname=randomString(12);
		canvas.toBlob(function (blob) {
			//var sdcard = navigator.getDeviceStorage("pictures");
			var sdcard = navigator.getDeviceStorage("sdcard");
			var request = sdcard.delete(folder+fname+".png");
			//try to delete in case it exists
			request.onsuccess = function () {
				saveAndSend(blob,folder,fname);
			}
			request.onerror = function () {
				saveAndSend(blob,folder,fname);
			}
		});
	});
	$("#btnAddPicture").on("click",function(){
			var pickImageActivity = new MozActivity({
					name: "pick",
					data: {
						type: ["image/png", "image/jpg", "image/jpeg"]
					}
				});

			pickImageActivity.onsuccess = function() {
				var imageObject=new Image();
				imageObject.onload=function(){
					$(".divEnhances input").val(0).slider("refresh");
					$(".divEnhances").hide();
					showFXCollection(arrEffects);
					if(this.width > maxWidth){
						ratio = maxWidth / this.width;
						this.width = maxWidth;
						this.height = this.height * ratio;
					}
					if(this.height > maxHeight){
						ratio = maxHeight / this.height;
						this.height = maxHeight;
						this.width = this.width * ratio;
					}
					detect(this);
					canvas.width=this.width;
					canvas.height=this.height;
					context=canvas.getContext("2d");
					context.drawImage(this,0,0,canvas.width,canvas.height);
					originalSRC=this.src;
					orgImg = this.src;
					imgSet=true;
// 					getLastImage();
					lastImage = this;
					lastSrc = this.src;
				}
				imageObject.src=window.URL.createObjectURL(this.result.blob);
			};

			pickImageActivity.onerror = function() {
				alert("Cannot pick the image");
			}; 
	});
	function saveAndSend(blob,folder,fname) {
		var sdcard = navigator.getDeviceStorage("sdcard");
		var request = sdcard.addNamed(blob, folder+fname+".png");

		//could just share the blob instead of saving
		request.onsuccess = function () {
			var sharingImage = new MozActivity({
				name: "share",
				data: {
					type: "image/*",
					number: 1,
					blobs: [blob],
					filenames: [fname+".png"],
					filepaths: [folder+fname+".png"]
				}
			});
			alert("Image Saved");
		}

		// An error could occur if a file with the same name already exist
		request.onerror = function () {
			alert('Unable to write the file: ' + this.error.name);
		}

	}
});